/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.stack.GossipData;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Util;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class GossipRouter {
    public static final int GET = -10;
    public static final int REGISTER = -11;
    public static final int DUMP = -21;
    public static final int SHUTDOWN = -1;
    public static final int SHUTDOWN_OK = -2;
    public static final int PORT = 8980;
    public static final long EXPIRY_TIME = 30000L;
    public static final long GOSSIP_REQUEST_TIMEOUT = 1000L;
    public static final long ROUTING_CLIENT_REPLY_TIMEOUT = 120000L;
    private static final int MARK_BUFFER_SIZE = 2048;
    protected static final Object GOSSIP_REQUEST = new Object();
    protected static final Object GOSSIP_FAILURE = new Object();
    private int port;
    private String bindAddressString;
    private long expiryTime;
    private long gossipRequestTimeout;
    private long routingClientReplyTimeout;
    private final Hashtable routingTable = new Hashtable();
    private final Map gossipTable = new HashMap();
    private ServerSocket srvSock = null;
    private InetAddress bindAddress = null;
    Timer timer = null;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    static int threadCounter = 0;

    public GossipRouter() {
        this(8980);
    }

    public GossipRouter(int port) {
        this(port, null);
    }

    public GossipRouter(int port, String bindAddressString) {
        this(port, bindAddressString, 30000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime) {
        this(port, bindAddressString, expiryTime, 1000L, 120000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime, long gossipRequestTimeout, long routingClientReplyTimeout) {
        SystemFailure.loadEmergencyClasses();
        this.port = port;
        this.bindAddressString = bindAddressString;
        this.expiryTime = expiryTime;
        this.gossipRequestTimeout = gossipRequestTimeout;
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddressString = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddressString;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setGossipRequestTimeout(long gossipRequestTimeout) {
        this.gossipRequestTimeout = gossipRequestTimeout;
    }

    public long getGossipRequestTimeout() {
        return this.gossipRequestTimeout;
    }

    public void setRoutingClientReplyTimeout(long routingClientReplyTimeout) {
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public long getRoutingClientReplyTimeout() {
        return this.routingClientReplyTimeout;
    }

    public boolean isStarted() {
        return this.srvSock != null;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        if (this.srvSock != null) {
            throw new Exception("Router already started.");
        }
        if (this.bindAddressString != null) {
            this.bindAddress = InetAddress.getByName(this.bindAddressString);
            this.srvSock = new ServerSocket(this.port, 50, this.bindAddress);
        } else {
            this.srvSock = new ServerSocket(this.port, 50);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                GossipRouter.this.mainLoop();
                GossipRouter.this.cleanup();
            }
        }, "JGroups Router Main Thread").start();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                GossipRouter.this.sweep();
            }
        }, this.expiryTime, this.expiryTime);
    }

    public void stop() {
        block5: {
            if (this.srvSock == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("Router already stopped");
                }
                return;
            }
            this.timer.cancel();
            this.shutdown();
            try {
                this.srvSock.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error(JGroupsStrings.GossipRouter_FAILED_TO_CLOSE_SERVER_SOCKET__0, (Throwable)e);
            }
        }
        this.srvSock = null;
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.GossipRouter_ROUTER_STOPPED);
        }
    }

    public void destroy() {
    }

    public String dumpRoutingTable() {
        return this.dumpTable(this.routingTable);
    }

    public String dumpGossipTable() {
        return this.dumpTable(this.gossipTable);
    }

    public static String requestTypeToString(int type) {
        return type == -10 ? "GET" : (type == -11 ? "REGISTER" : (type == -21 ? "DUMP" : (type == -1 ? "SHUTDOWN" : "UNKNOWN REQUEST: " + type)));
    }

    protected void mainLoop() {
        Socket sock = null;
        DataInputStream input = null;
        DataOutputStream output = null;
        IpAddress peer_addr = null;
        int type = -1;
        String gname = null;
        boolean up = true;
        if (this.bindAddress == null) {
            this.bindAddress = this.srvSock.getInetAddress();
        }
        Date d = new Date();
        System.out.println("GossipRouter started at " + d + "\nListening on port " + this.port + " bound on address " + this.bindAddress + '\n');
        d = null;
        block14: while (up) {
            if (SystemFailure.getFailure() != null) {
                ServerSocket s = this.srvSock;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                SystemFailure.checkFailure();
            }
            try {
                sock = this.srvSock.accept();
                sock.setSoLinger(true, 500);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("router accepted connection from " + sock);
                }
                final BufferedInputStream bis = new BufferedInputStream(sock.getInputStream());
                final Promise waitArea = new Promise();
                final Socket s = sock;
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        FilterInputStream ois = null;
                        try {
                            bis.mark(2048);
                            ois = new DataInputStream(bis);
                            GossipData gossip_req = (GossipData)DataSerializer.readObject((DataInput)((Object)ois));
                            waitArea.setResult(GOSSIP_REQUEST);
                            GossipData gresp = GossipRouter.this.processGossip(gossip_req);
                            if (gresp != null) {
                                DataOutputStream oos = new DataOutputStream(s.getOutputStream());
                                DataSerializer.writeObject(gresp, oos);
                                oos.close();
                            }
                            bis.close();
                            s.close();
                        }
                        catch (Exception e) {
                            if (GossipRouter.this.log.isDebugEnabled()) {
                                GossipRouter.this.log.debug("gossip thread exception :" + e);
                            }
                            waitArea.setResult(GOSSIP_FAILURE);
                        }
                        finally {
                            try {
                                ois.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }, "Gossip Request Thread");
                t.start();
                Object waitResult = waitArea.getResult(this.gossipRequestTimeout);
                waitArea.reset();
                if (waitResult != null) continue;
                peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                output = new DataOutputStream(sock.getOutputStream());
                byte[] buf = Util.objectToByteBuffer(peer_addr);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
                waitResult = waitArea.getResult(this.routingClientReplyTimeout);
                if (waitResult == null) {
                    throw new Exception("Timeout waiting for router client answer");
                }
                if (waitResult == GOSSIP_REQUEST) {
                    output.close();
                    continue;
                }
                bis.reset();
                input = new DataInputStream(bis);
                type = input.readInt();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("request of type " + GossipRouter.requestTypeToString(type));
                }
                gname = input.readUTF();
                switch (type) {
                    case -10: {
                        this.processGetRequest(sock, output, gname);
                        continue block14;
                    }
                    case -21: {
                        this.processDumpRequest(sock, output);
                        continue block14;
                    }
                    case -11: {
                        int len = input.readInt();
                        buf = new byte[len];
                        input.readFully(buf, 0, buf.length);
                        Address addr = (Address)Util.objectFromByteBuffer(buf);
                        SocketThread st = new SocketThread(sock, input, addr);
                        this.addEntry(gname, new AddressEntry(addr, sock, st, output));
                        st.start();
                        continue block14;
                    }
                    case -1: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info(JGroupsStrings.GossipRouter_ROUTER_SHUTTING_DOWN);
                        }
                        output.writeInt(-2);
                        output.flush();
                        try {
                            sock.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        up = false;
                        continue block14;
                    }
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.GossipRouter_REQUEST_OF_TYPE__0__NOT_RECOGNIZED, type);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.GossipRouter_FAILURE_HANDLING_A_CLIENT_CONNECTION__0, e.getMessage(), (Throwable)e);
                }
                try {
                    sock.close();
                }
                catch (IOException e2) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("failed to close socket " + sock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Map map = this.routingTable;
        synchronized (map) {
            for (String gname : this.routingTable.keySet()) {
                List l = (List)this.routingTable.get(gname);
                if (l == null) continue;
                for (AddressEntry e : l) {
                    e.destroy();
                }
            }
            this.routingTable.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.GossipRouter_ROUTING_TABLE_CLEARED);
            }
        }
        map = this.gossipTable;
        synchronized (map) {
            this.gossipTable.clear();
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.GossipRouter_GOSSIP_TABLE_CLEARED);
            }
        }
    }

    private void shutdown() {
        block2: {
            try {
                Socket s = new Socket(this.srvSock.getInetAddress(), this.srvSock.getLocalPort());
                DataInputStream dis = new DataInputStream(s.getInputStream());
                int len = dis.readInt();
                byte[] buf = new byte[len];
                dis.readFully(buf, 0, buf.length);
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeInt(-1);
                dos.writeUTF("");
                dis.readInt();
                dos.flush();
                dos.close();
                s.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error(JGroupsStrings.GossipRouter_SHUTDOWN_FAILED__0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GossipData processGossip(GossipData gossip) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("gossip is " + gossip);
        }
        if (gossip == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("null gossip request");
            }
            return null;
        }
        String group = gossip.getGroup();
        Address mbr = null;
        Map map = this.gossipTable;
        synchronized (map) {
            switch (gossip.getType()) {
                case 1: {
                    mbr = gossip.getMbr();
                    if (group == null || mbr == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(JGroupsStrings.GossipRouter_GROUP_OR_MEMBER_IS_NULL_CANNOT_REGISTER_MEMBER);
                        }
                        return null;
                    }
                    this.addGossipEntry(group, new AddressEntry(mbr));
                    return null;
                }
                case 2: {
                    if (group == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(JGroupsStrings.GossipRouter_GROUP_IS_NULL_CANNOT_GET_MEMBERSHIP);
                        }
                        return null;
                    }
                    ArrayList<Address> mbrs = null;
                    List l = (List)this.gossipTable.get(group);
                    if (l != null) {
                        mbrs = new ArrayList<Address>();
                        for (AddressEntry e : l) {
                            mbrs.add(e.addr);
                        }
                    }
                    return new GossipData(3, group, null, mbrs, null);
                }
                case 3: {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("received a GET_RSP. Should not be received by server");
                    }
                    return null;
                }
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn("received unkown gossip request (gossip=" + gossip + ')');
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGossipEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipRouter_GROUPNAME_WAS_NULL_NOT_ADDED_);
            }
            return;
        }
        Map map = this.gossipTable;
        synchronized (map) {
            int index2;
            List<AddressEntry> val = (List<AddressEntry>)this.gossipTable.get(groupname);
            if (val == null) {
                val = Collections.synchronizedList(new ArrayList());
                this.gossipTable.put(groupname, val);
            }
            if ((index2 = val.indexOf(e)) == -1) {
                val.add(e);
                return;
            }
            ((AddressEntry)val.get(index2)).update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep() {
        long currentTime = System.currentTimeMillis();
        int num_entries_removed = 0;
        String key2 = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("running sweep");
        }
        Map map = this.gossipTable;
        synchronized (map) {
            Iterator i = this.gossipTable.keySet().iterator();
            while (i.hasNext()) {
                key2 = (String)i.next();
                List val = (List)this.gossipTable.get(key2);
                if (val != null) {
                    Iterator j = val.iterator();
                    while (j.hasNext()) {
                        AddressEntry ae = (AddressEntry)j.next();
                        long diff = currentTime - ae.timestamp;
                        if (diff <= this.expiryTime) continue;
                        j.remove();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Removed member " + ae + " from group " + key2 + '(' + diff + " msecs old)");
                        }
                        ++num_entries_removed;
                    }
                }
                if (val.size() != 0) continue;
                i.remove();
            }
        }
        if (num_entries_removed > 0 && this.log.isTraceEnabled()) {
            this.log.trace("done (removed " + num_entries_removed + " entries)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetRequest(Socket sock, DataOutputStream output, String groupname) {
        List grpmbrs = (List)this.routingTable.get(groupname);
        com.gemstone.org.jgroups.util.List ret = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("groupname=" + groupname + ", result=" + grpmbrs);
        }
        if (grpmbrs != null && grpmbrs.size() > 0) {
            ret = new com.gemstone.org.jgroups.util.List();
            for (AddressEntry entry : grpmbrs) {
                ret.add(entry.addr);
            }
        }
        try {
            if (ret == null || ret.size() == 0) {
                output.writeInt(0);
            } else {
                byte[] buf = Util.objectToByteBuffer(ret);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipRouter_EXCEPTION_0, e, null);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                sock.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDumpRequest(Socket sock, DataOutputStream output) {
        try {
            output.writeUTF(this.dumpRoutingTable());
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipRouter_ERROR_SENDING_THE_ANSWER_BACK_TO_THE_CLIENT__0, (Throwable)e);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block20;
                        this.log.error(JGroupsStrings.GossipRouter_ERROR_CLOSING_THE_OUTPUT_STREAM__0, (Throwable)e);
                    }
                }
                try {
                    sock.close();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block21;
                    this.log.error(JGroupsStrings.GossipRouter_ERROR_CLOSING_THE_SOCKET__0, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpTable(Map map) {
        String label = map instanceof Hashtable ? "routing" : "gossip";
        StringBuffer sb = new StringBuffer();
        Map map2 = map;
        synchronized (map2) {
            if (map.size() == 0) {
                sb.append("empty ");
                sb.append(label);
                sb.append(" table");
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    String gname = (String)entry.getKey();
                    sb.append("GROUP: '" + gname + "'\n");
                    List l = (List)entry.getValue();
                    if (l == null) {
                        sb.append("\tnull list of addresses\n");
                        continue;
                    }
                    if (l.size() == 0) {
                        sb.append("\tempty list of addresses\n");
                        continue;
                    }
                    for (AddressEntry ae : l) {
                        sb.append('\t');
                        sb.append(ae.toString());
                        sb.append('\n');
                    }
                }
            }
        }
        return sb.toString();
    }

    protected void route(Address dest, String dest_group, byte[] msg, Address sender) {
        if (this.log.isTraceEnabled()) {
            int len = msg != null ? msg.length : 0;
            this.log.trace("routing request from " + sender + " for " + dest_group + " to " + (dest == null ? "ALL" : dest.toString()) + ", " + len + " bytes");
        }
        if (dest == null) {
            if (dest_group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.GossipRouter_BOTH_DEST_ADDRESS_AND_GROUP_ARE_NULL);
                }
                return;
            }
            this.sendToAllMembersInGroup(dest_group, msg, sender);
        } else {
            AddressEntry ae = this.findAddressEntry(dest);
            if (ae == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.GossipRouter_CANNOT_FIND__0__IN_THE_ROUTING_TABLE, dest);
                }
                return;
            }
            if (ae.output == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.GossipRouter_0__IS_ASSOCIATED_WITH_A_NULL_OUTPUT_STREAM, dest);
                }
                return;
            }
            try {
                this.sendToMember(dest, ae.output, msg);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.GossipRouter_FAILED_SENDING_MESSAGE_TO__0___1, new Object[]{dest, e.getMessage()});
                }
                this.removeEntry(ae.sock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipRouter_GROUPNAME_WAS_NULL_NOT_ADDED_);
            }
            return;
        }
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            int index2;
            List<AddressEntry> val = (List<AddressEntry>)this.routingTable.get(groupname);
            if (val == null) {
                val = Collections.synchronizedList(new ArrayList());
                this.routingTable.put(groupname, val);
            }
            if ((index2 = val.indexOf(e)) == -1) {
                val.add(e);
                return;
            }
            ((AddressEntry)val.remove(index2)).destroy();
            val.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(Socket sock) {
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            Enumeration e = this.routingTable.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.routingTable.get(e.nextElement());
                Iterator i = val.iterator();
                while (i.hasNext()) {
                    AddressEntry entry = (AddressEntry)i.next();
                    if (entry.sock != sock) continue;
                    entry.destroy();
                    i.remove();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressEntry findAddressEntry(Address addr) {
        Hashtable hashtable = this.routingTable;
        synchronized (hashtable) {
            Enumeration e = this.routingTable.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.routingTable.get(e.nextElement());
                for (AddressEntry entry : val) {
                    if (!addr.equals(entry.addr)) continue;
                    return entry;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAllMembersInGroup(String groupname, byte[] msg, Address sender) {
        List val = (List)this.routingTable.get(groupname);
        if (val == null || val.size() == 0) {
            return;
        }
        List list = val;
        synchronized (list) {
            Iterator i = val.iterator();
            while (i.hasNext()) {
                DataOutputStream dos;
                AddressEntry ae = (AddressEntry)i.next();
                if (ae.addr != null && ae.addr.equals(sender) || (dos = ae.output) == null) continue;
                try {
                    this.sendToMember(null, dos, msg);
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("cannot send to " + ae.addr + ": " + e.getMessage());
                    }
                    ae.destroy();
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToMember(Address dest, DataOutputStream out, byte[] msg) throws IOException {
        if (out == null) {
            return;
        }
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            Util.writeAddress(dest, out);
            out.writeInt(msg.length);
            out.write(msg, 0, msg.length);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8080;
        long expiry = 30000L;
        long timeout = 1000L;
        long routingTimeout = 120000L;
        GossipRouter router = null;
        String address = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg)) {
                address = args[++i];
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-timeout".equals(arg)) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-rtimeout".equals(arg)) {
                routingTimeout = Long.parseLong(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        System.out.println("GossipRouter is starting...");
        try {
            router = new GossipRouter(port, address, expiry, timeout, routingTimeout);
            router.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bindaddress <address>] [options]");
        System.out.println("Options: ");
        System.out.println("        -expiry <msecs>   - Time until a gossip cache entry expires.");
        System.out.println("        -timeout <msecs>  - Number of millisecs the router waits to receive");
        System.out.println("                            a gossip request after connection was established;");
        System.out.println("                            upon expiration, the router initiates the routing");
        System.out.println("                            protocol on the connection.");
    }

    class SocketThread
    extends Thread {
        private volatile boolean active;
        Socket sock;
        DataInputStream input;
        Address addr;

        public SocketThread(Socket sock, DataInputStream ois, Address addr) {
            super("SocketThread " + threadCounter++);
            this.active = true;
            this.sock = null;
            this.input = null;
            this.addr = null;
            this.sock = sock;
            this.input = ois;
            this.addr = addr;
        }

        void closeSocket() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void finish() {
            if (GossipRouter.this.log.isTraceEnabled()) {
                GossipRouter.this.log.trace("terminating the SocketThread for " + this.sock);
            }
            this.active = false;
        }

        @Override
        public void run() {
            Address dst_addr = null;
            while (this.active) {
                SystemFailure.checkFailure();
                try {
                    int len;
                    String gname = this.input.readUTF();
                    dst_addr = Util.readAddress(this.input);
                    if (GossipRouter.this.log.isTraceEnabled()) {
                        GossipRouter.this.log.trace("group " + gname + ", routing request to " + (dst_addr == null ? "all" : dst_addr.toString()));
                    }
                    if ((len = this.input.readInt()) == 0) {
                        if (!GossipRouter.this.log.isWarnEnabled()) continue;
                        GossipRouter.this.log.warn("received null message");
                        continue;
                    }
                    byte[] buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                    GossipRouter.this.route(dst_addr, gname, buf, this.addr);
                }
                catch (EOFException io_ex) {
                    if (GossipRouter.this.log.isTraceEnabled()) {
                        GossipRouter.this.log.trace("client " + this.sock.getInetAddress().getHostName() + ':' + this.sock.getPort() + " closed connection; removing it from routing table");
                    }
                    GossipRouter.this.removeEntry(this.sock);
                    return;
                }
                catch (Exception e) {
                    if (!GossipRouter.this.log.isErrorEnabled()) break;
                    GossipRouter.this.log.error(JGroupsStrings.GossipRouter_EXCEPTION_0, (Throwable)e);
                    break;
                }
            }
            this.closeSocket();
        }
    }

    static class AddressEntry {
        Address addr = null;
        Socket sock = null;
        DataOutputStream output = null;
        long timestamp = 0L;
        final SocketThread thread;

        public AddressEntry(Address addr) {
            this(addr, null, null, null);
        }

        public AddressEntry(Address addr, Socket sock, SocketThread thread, DataOutputStream output) {
            this.addr = addr;
            this.sock = sock;
            this.thread = thread;
            this.output = output;
            this.timestamp = System.currentTimeMillis();
        }

        void destroy() {
            if (this.thread != null) {
                this.thread.finish();
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.output = null;
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
            this.timestamp = 0L;
        }

        public void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof AddressEntry)) {
                return false;
            }
            return this.addr.equals(((AddressEntry)other).addr);
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("addr=");
            sb.append(this.addr);
            if (this.sock == null) {
                sb.append(", timestamp=");
                sb.append(this.timestamp);
            } else {
                sb.append(", sock=");
                sb.append(this.sock);
            }
            return sb.toString();
        }
    }
}

