/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.stack.GossipData;
import com.gemstone.org.jgroups.stack.GossipServer;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.stack.tcpserver.TcpServer;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.SSLException;

public class GossipClient {
    Timer timer = new Timer(true);
    Timer connectionTimer;
    final Hashtable groups = new Hashtable();
    Refresher refresher_task = new Refresher();
    final Vector gossip_servers = new Vector();
    Set<Address> serverAddresses;
    boolean timer_running = false;
    long EXPIRY_TIME = 20000L;
    int responsiveServerCount;
    int serversWithDistributedSystem;
    boolean floatingCoordinatorDisabled;
    private boolean networkPartitionDetectionEnabled;
    private Address coordinator;
    ProtocolStack stack;
    int timeout = 5000;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    private final Map<IpAddress, Integer> serverVersions = new HashMap<IpAddress, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getGossip_servers() {
        Vector vector = this.gossip_servers;
        synchronized (vector) {
            return new Vector(this.gossip_servers);
        }
    }

    public Set<Address> getServerAddresses() {
        if (this.serverAddresses == null) {
            return Collections.EMPTY_SET;
        }
        return this.serverAddresses;
    }

    public GossipClient(IpAddress gossip_host, long expiry) {
        this.init(gossip_host, expiry);
    }

    public GossipClient(Vector gossip_hosts, long expiry, ProtocolStack stack) {
        if (gossip_hosts == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipClient_EMPTY_SET_OF_GOSSIPSERVERS_GIVEN);
            }
            return;
        }
        this.stack = stack;
        for (int i = 0; i < gossip_hosts.size(); ++i) {
            this.init((IpAddress)gossip_hosts.elementAt(i), expiry);
        }
        if (stack.jgmm == null) {
            this.log.warn("BRUCE: jgroup membership manager is null!");
        }
        if (stack.jgmm != null) {
            this.connectionTimer = stack.jgmm.getTimer();
        }
    }

    public void stop() {
        this.destroy();
        this.timer = new Timer(true);
        this.refresher_task = new Refresher();
    }

    public void destroy() {
        this.timer_running = false;
        this.timer.cancel();
        this.groups.clear();
        this.connectionTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGossipServer(IpAddress gossip_host) {
        Vector vector = this.gossip_servers;
        synchronized (vector) {
            if (!this.gossip_servers.contains(gossip_host)) {
                this.gossip_servers.addElement(gossip_host);
            }
        }
    }

    public void setTimeout(int ms) {
        this.timeout = ms;
    }

    public void setEnableNetworkPartitionDetection(boolean flag) {
        this.networkPartitionDetectionEnabled = flag;
    }

    public void register(String group, Address mbr, long connectTimeout, boolean inhibitRegistration) {
        if (group == null || mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipClient_GROUP_OR_MBR_IS_NULL);
            }
            return;
        }
        Vector<Address> mbrs = (Vector<Address>)this.groups.get(group);
        if (mbrs == null) {
            mbrs = new Vector<Address>();
            mbrs.addElement(mbr);
            this.groups.put(group, mbrs);
        } else if (!mbrs.contains(mbr)) {
            mbrs.addElement(mbr);
        }
        if (connectTimeout > 0L) {
            this.timeout = (int)connectTimeout;
        }
        if (!inhibitRegistration) {
            this._register(group, mbr);
        }
        if (this.stack != null) {
            this.refresher_task.stack = this.stack;
        }
        if (!this.timer_running) {
            try {
                this.timer.schedule((TimerTask)this.refresher_task, this.EXPIRY_TIME, this.EXPIRY_TIME);
                this.timer_running = true;
            }
            catch (IllegalStateException ise) {
                return;
            }
        }
    }

    public Vector getMembers(String group, Address localAddress, boolean logErrors, long connectTimeout) {
        if (group == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.GossipClient_GROUP_IS_NULL);
            }
            return null;
        }
        this.timeout = (int)Math.min(Integer.MAX_VALUE, connectTimeout);
        return this._getMembers(group, localAddress, logErrors);
    }

    public int getResponsiveServerCount() {
        return this.responsiveServerCount;
    }

    void init(IpAddress gossip_host, long expiry) {
        this.EXPIRY_TIME = expiry;
        this.addGossipServer(gossip_host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _register(String group, Address mbr) {
        HashSet<Address> serverAddresses = new HashSet<Address>();
        int count = 0;
        Vector vector = this.gossip_servers;
        synchronized (vector) {
            Vector newServers = new Vector();
            Iterator it = this.gossip_servers.iterator();
            while (it.hasNext()) {
                IpAddress entry = (IpAddress)it.next();
                if (entry.getIpAddress() == null || entry.getPort() == 0) {
                    it.remove();
                    continue;
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("REGISTER_REQ --> " + entry.getIpAddress() + ':' + entry.getPort());
                    }
                    if (!SocketCreator.getDefaultInstance().isHostReachable(entry.getIpAddress())) continue;
                    this._getVersionForAddress(entry);
                    ConnectTimerTask timeoutTask = new ConnectTimerTask();
                    Socket sock = SocketCreator.getDefaultInstance().connect(entry.getIpAddress(), entry.getPort(), 2 * this.timeout, timeoutTask, false);
                    DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                    GossipData gossip_req = new GossipData(1, group, mbr, null, this.gossip_servers);
                    int gossipVersion = GossipServer.GOSSIPVERSION;
                    short serverOrdinal = Version.CURRENT_ORDINAL;
                    if (entry.getVersionOrdinal() <= Version.CURRENT_ORDINAL) {
                        serverOrdinal = entry.getVersionOrdinal();
                        gossipVersion = TcpServer.getGossipVersionForOrdinal(serverOrdinal);
                        out = new VersionedDataOutputStream(out, Version.fromOrdinal(serverOrdinal, false));
                    }
                    out.writeInt(gossipVersion);
                    out.writeShort(serverOrdinal);
                    DataSerializer.writeObject(gossip_req, out);
                    out.flush();
                    DataInputStream in = new DataInputStream(sock.getInputStream());
                    GossipData gossip_rsp = (GossipData)DataSerializer.readObject(in);
                    sock.close();
                    if (gossip_rsp.locators != null) {
                        newServers.addAll(gossip_rsp.locators);
                    }
                    if (gossip_rsp.localAddress != null) {
                        if (this.log.getInternalLogWriter().fineEnabled() && !this.stack.getChannel().isConnected()) {
                            this.log.getInternalLogWriter().fine("locator " + entry + " member address is " + gossip_rsp.localAddress);
                        }
                        serverAddresses.add(gossip_rsp.localAddress);
                    }
                    ++count;
                }
                catch (SocketTimeoutException se) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.GossipClient_ATTEMPT_TO_CONNECT_TO_DISTRIBUTION_LOCATOR_0_TIMED_OUT, entry);
                }
                catch (InterruptedIOException ie) {
                    Thread.currentThread().interrupt();
                    throw new DistributedSystemDisconnectedException(ie);
                }
                catch (SSLException ex) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.GossipClient_SSL_FAILURE_WHILE_CONNECTING_TO_DISTRIBUTION_LOCATOR_0, entry);
                    throw new AuthenticationFailedException(JGroupsStrings.GossipClient_SSL_FAILURE_WHILE_CONNECTING_TO_DISTRIBUTION_LOCATOR_0.toLocalizedString(entry), ex);
                }
                catch (Exception ex) {
                    Channel c = null;
                    if (this.stack != null) {
                        c = this.stack.getChannel();
                    }
                    if (c != null && c.closing()) {
                        this.destroy();
                        continue;
                    }
                    if (!this.log.getInternalLogWriter().fineEnabled()) continue;
                    this.log.getInternalLogWriter().info(JGroupsStrings.GossipClient_COULD_NOT_CONNECT_TO_DISTRIBUTION_LOCATOR__0, entry + ": " + ex);
                }
            }
            if (!newServers.isEmpty()) {
                GossipServer.processLocators(this.log, this.gossip_servers, newServers);
                Vector vector2 = this.gossip_servers;
                synchronized (vector2) {
                    for (int i = 0; i < newServers.size(); ++i) {
                        if (this.gossip_servers.contains(newServers.get(i))) continue;
                        this.gossip_servers.add(newServers.get(i));
                    }
                }
            }
            this.serverAddresses = serverAddresses;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector _getMembers(String group, Address localAddress, boolean logErrors) {
        Vector<Address> ret = new Vector<Address>();
        HashSet<Address> serverAddresses = new HashSet<Address>();
        int count = 0;
        logErrors |= this.log.isTraceEnabled();
        this.serversWithDistributedSystem = 0;
        Vector vector = this.gossip_servers;
        synchronized (vector) {
            Vector newServers = new Vector();
            Iterator it = this.gossip_servers.iterator();
            while (it.hasNext()) {
                IpAddress entry = (IpAddress)it.next();
                entry.setBirthViewId(0L);
                if (entry.getIpAddress() == null || entry.getPort() == 0) {
                    it.remove();
                    continue;
                }
                try {
                    GossipData gossip_rsp;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("GET_REQ --> " + entry.getIpAddress() + ':' + entry.getPort());
                    }
                    this._getVersionForAddress(entry);
                    ConnectTimerTask timeoutTask = new ConnectTimerTask();
                    Socket sock = SocketCreator.getDefaultInstance().connect(entry.getIpAddress(), entry.getPort(), this.timeout, timeoutTask, false);
                    if (this.timeout > 0) {
                        sock.setSoTimeout(3 * this.timeout);
                    }
                    DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                    GossipData gossip_req = new GossipData(2, group, localAddress, null, this.gossip_servers);
                    int gossipVersion = GossipServer.GOSSIPVERSION;
                    short serverOrdinal = Version.CURRENT_ORDINAL;
                    if (entry.getVersionOrdinal() <= Version.CURRENT_ORDINAL) {
                        serverOrdinal = entry.getVersionOrdinal();
                        gossipVersion = TcpServer.getGossipVersionForOrdinal(serverOrdinal);
                        out = new VersionedDataOutputStream(out, Version.fromOrdinal(serverOrdinal, false));
                    }
                    out.writeInt(gossipVersion);
                    out.writeShort(serverOrdinal);
                    DataSerializer.writeObject(gossip_req, out);
                    out.flush();
                    DataInputStream in = new DataInputStream(sock.getInputStream());
                    if (serverOrdinal < Version.CURRENT_ORDINAL) {
                        in = new VersionedDataInputStream(in, Version.fromOrdinal(serverOrdinal, false));
                    }
                    if ((gossip_rsp = (GossipData)DataSerializer.readObject(in)).getHasDistributedSystem()) {
                        ++this.serversWithDistributedSystem;
                    }
                    if (gossip_rsp.getFloatingCoordinatorDisabled()) {
                        this.floatingCoordinatorDisabled = true;
                    }
                    if (gossip_rsp.getNetworkPartitionDetectionEnabled()) {
                        this.networkPartitionDetectionEnabled = true;
                    }
                    if (gossip_rsp.locators != null && !gossip_rsp.locators.isEmpty()) {
                        newServers.addAll(gossip_rsp.locators);
                    }
                    if (gossip_rsp.mbrs != null) {
                        for (int j = 0; j < gossip_rsp.mbrs.size(); ++j) {
                            Address mbr = (Address)gossip_rsp.mbrs.get(j);
                            if (ret.contains(mbr)) continue;
                            ret.addElement(mbr);
                        }
                    }
                    if (gossip_rsp.mbr != null) {
                        this.coordinator = gossip_rsp.mbr;
                    }
                    if (gossip_rsp.localAddress != null) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "locator " + entry + " member address is " + gossip_rsp.localAddress);
                        serverAddresses.add(gossip_rsp.localAddress);
                        if (!ret.contains(gossip_rsp.localAddress)) {
                            ret.addElement(gossip_rsp.localAddress);
                        }
                    }
                    ++count;
                    sock.close();
                }
                catch (Exception ex) {
                    if (DistributionManager.getDistributionManagerType() == 11 || !logErrors) continue;
                    if (SocketCreator.getDefaultInstance().useSSL()) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.GossipClient_UNABLE_TO_CONNECT_TO_LOCATOR__0, entry, (Throwable)ex);
                        continue;
                    }
                    this.log.getInternalLogWriter().info(JGroupsStrings.GossipClient_UNABLE_TO_CONNECT_TO_LOCATOR__0, entry);
                }
            }
            if (!newServers.isEmpty()) {
                GossipServer.processLocators(this.log, this.gossip_servers, newServers);
                Vector vector2 = this.gossip_servers;
                synchronized (vector2) {
                    for (int i = 0; i < newServers.size(); ++i) {
                        if (this.gossip_servers.contains(newServers.get(i))) continue;
                        this.gossip_servers.add(newServers.get(i));
                    }
                }
            }
            this.serverAddresses = serverAddresses;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getMbrs returning results from " + count + " locators");
        }
        this.responsiveServerCount = count;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpAddress _getVersionForAddress(Address addr) throws ClassNotFoundException, IOException {
        Integer versionOrdinal;
        IpAddress entry = (IpAddress)addr;
        Map<IpAddress, Integer> map = this.serverVersions;
        synchronized (map) {
            versionOrdinal = this.serverVersions.get(addr);
        }
        if (versionOrdinal == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("GEMFIRE_VERSION --> " + entry.getIpAddress() + ':' + entry.getPort());
            }
            if (SocketCreator.getDefaultInstance().isHostReachable(entry.getIpAddress())) {
                ConnectTimerTask timeoutTask = new ConnectTimerTask();
                Socket socket = SocketCreator.getDefaultInstance().connect(entry.getIpAddress(), entry.getPort(), 2 * this.timeout, timeoutTask, false);
                if (this.timeout > 0) {
                    socket.setSoTimeout(3 * this.timeout);
                }
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                GossipData version_req = new GossipData(4, null, null, null, null);
                int prevGossipVersion = GossipServer.OLDGOSSIPVERSION;
                out.writeInt(prevGossipVersion);
                DataSerializer.writeObject(version_req, out);
                out.flush();
                DataInputStream in = new DataInputStream(socket.getInputStream());
                GossipData gossip_rsp = (GossipData)DataSerializer.readObject(in);
                if (this.log.isTraceEnabled() && gossip_rsp.versionOrdinal != Version.CURRENT_ORDINAL) {
                    this.log.trace("Gossip response with version " + gossip_rsp);
                }
                versionOrdinal = gossip_rsp.versionOrdinal;
                Map<IpAddress, Integer> map2 = this.serverVersions;
                synchronized (map2) {
                    this.serverVersions.put(entry, versionOrdinal);
                }
                socket.close();
            }
        }
        entry.setVersionOrdinal((short)versionOrdinal.intValue());
        return entry;
    }

    public int getServerDistributedSystemCount() {
        return this.serversWithDistributedSystem;
    }

    public boolean getFloatingCoordinatorDisabled() {
        return this.floatingCoordinatorDisabled;
    }

    public boolean getNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public static void main(String[] args) {
        Vector<IpAddress> gossip_hosts = new Vector<IpAddress>();
        boolean get2 = false;
        boolean register = false;
        boolean keep_running = false;
        String register_host = null;
        int register_port = 0;
        String get_group = null;
        String register_group = null;
        GossipClient gossip_client = null;
        long expiry = 20000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                GossipClient.usage();
                return;
            }
            if ("-expiry".equals(args[i])) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-host".equals(args[i])) {
                String host = args[++i];
                int port = Integer.parseInt(args[++i]);
                try {
                    InetAddress ip_addr = InetAddress.getByName(host);
                    gossip_hosts.addElement(new IpAddress(ip_addr, port));
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            if ("-keep_running".equals(args[i])) {
                keep_running = true;
                continue;
            }
            if ("-get".equals(args[i])) {
                get2 = true;
                get_group = args[++i];
                continue;
            }
            if ("-register".equals(args[i])) {
                register_group = args[++i];
                register_host = args[++i];
                register_port = Integer.parseInt(args[++i]);
                register = true;
                continue;
            }
            GossipClient.usage();
            return;
        }
        if (gossip_hosts.size() == 0) {
            System.err.println("At least 1 GossipServer has to be given");
            return;
        }
        if (!register && !get2) {
            System.err.println("Neither get nor register command given, will not do anything");
            return;
        }
        try {
            gossip_client = new GossipClient(gossip_hosts, expiry, null);
            if (register) {
                System.out.println("Registering " + register_group + " --> " + register_host + ':' + register_port);
                gossip_client.register(register_group, new IpAddress(register_host, register_port), 0L, false);
            }
            if (get2) {
                System.out.println("Getting members for group " + get_group);
                Vector mbrs = gossip_client.getMembers(get_group, null, true, 0L);
                System.out.println("Members for group " + get_group + " are " + mbrs);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (!keep_running) {
            gossip_client.stop();
        }
    }

    static void usage() {
        System.out.println("GossipClient [-help] [-host <hostname> <port>]+  [-get <groupname>] [-register <groupname hostname port>] [-expiry <msecs>] [-keep_running]]");
    }

    public Address getCoordinator() {
        return this.coordinator;
    }

    class ConnectTimerTask
    extends TimerTask
    implements SocketCreator.ConnectionWatcher {
        Socket watchedSocket;
        volatile boolean cancelled;

        ConnectTimerTask() {
        }

        @Override
        public void beforeConnect(Socket sock) {
            this.watchedSocket = sock;
            if (GossipClient.this.connectionTimer != null) {
                GossipClient.this.connectionTimer.schedule((TimerTask)this, GossipClient.this.timeout);
            } else {
                GossipClient.this.timer.schedule((TimerTask)this, GossipClient.this.timeout);
            }
        }

        @Override
        public void afterConnect(Socket sock) {
            this.cancelled = true;
            this.cancel();
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.cancel();
                try {
                    GossipClient.this.log.getInternalLogWriter().fine("Timing out attempted connection to locator");
                    this.watchedSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class Refresher
    extends TimerTask {
        public ProtocolStack stack;

        Refresher() {
        }

        @Override
        public void run() {
            int num_items = 0;
            if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace("refresher task starting");
            }
            if (this.stack == null || this.stack.getChannel().isConnected()) {
                Enumeration e = GossipClient.this.groups.keys();
                while (e.hasMoreElements()) {
                    String group = (String)e.nextElement();
                    Vector mbrs = (Vector)GossipClient.this.groups.get(group);
                    if (mbrs == null) continue;
                    for (int i = 0; i < mbrs.size(); ++i) {
                        Address mbr = (Address)mbrs.elementAt(i);
                        if (GossipClient.this.log.isTraceEnabled()) {
                            GossipClient.this.log.trace("registering " + group + " : " + mbr);
                        }
                        try {
                            GossipClient.this.register(group, mbr, 0L, false);
                        }
                        catch (CancelException ex) {
                            GossipClient.this.timer.cancel();
                            return;
                        }
                        ++num_items;
                    }
                }
                if (GossipClient.this.log.isTraceEnabled()) {
                    GossipClient.this.log.trace("refresher task done. Registered " + num_items + " items");
                }
            } else if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace("refresher task done.  Not connected so no registration performed");
            }
        }
    }
}

