/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.protocols.AUTH;
import com.gemstone.org.jgroups.protocols.FC;
import com.gemstone.org.jgroups.protocols.FD;
import com.gemstone.org.jgroups.protocols.FD_SOCK;
import com.gemstone.org.jgroups.protocols.FRAG2;
import com.gemstone.org.jgroups.protocols.FRAG3;
import com.gemstone.org.jgroups.protocols.GemFireTimeSync;
import com.gemstone.org.jgroups.protocols.TCPGOSSIP;
import com.gemstone.org.jgroups.protocols.UDP;
import com.gemstone.org.jgroups.protocols.UNICAST;
import com.gemstone.org.jgroups.protocols.VERIFY_SUSPECT;
import com.gemstone.org.jgroups.protocols.VIEW_SYNC;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.NAKACK;
import com.gemstone.org.jgroups.protocols.pbcast.STABLE;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Configurator {
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public Protocol setupProtocolStack(String configuration, ProtocolStack st) throws Exception {
        Protocol protocol_stack = null;
        Vector protocol_configs = this.parseConfigurations(configuration);
        Vector protocols = this.createProtocols(protocol_configs, st);
        if (protocols == null) {
            return null;
        }
        protocol_stack = this.connectProtocols(protocols);
        return protocol_stack;
    }

    public void startProtocolStack(Protocol bottom_prot) {
        while (bottom_prot != null) {
            bottom_prot.startDownHandler();
            bottom_prot.startUpHandler();
            bottom_prot = bottom_prot.getUpProtocol();
        }
    }

    public void stopProtocolStack(Protocol start_prot) {
        while (start_prot != null) {
            start_prot.stopInternal();
            start_prot.destroy();
            start_prot = start_prot.getDownProtocol();
        }
    }

    public Protocol findProtocol(Protocol prot_stack, String name) {
        Protocol curr_prot = prot_stack;
        while (true) {
            String s;
            if ((s = curr_prot.getName()) == null) {
                continue;
            }
            if (s.equals(name)) {
                return curr_prot;
            }
            if ((curr_prot = curr_prot.getDownProtocol()) == null) break;
        }
        return null;
    }

    public Protocol getBottommostProtocol(Protocol prot_stack) {
        Protocol tmp = null;
        Protocol curr_prot = prot_stack;
        while ((tmp = curr_prot.getDownProtocol()) != null) {
            curr_prot = tmp;
        }
        return curr_prot;
    }

    public Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = config.createLayer(stack);
        prot.startDownHandler();
        prot.startUpHandler();
        return prot;
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot, ProtocolStack stack) throws Exception {
        if (neighbor_prot == null) {
            throw new Exception("Configurator.insertProtocol(): neighbor_prot is null");
        }
        if (position != 1 && position != 2) {
            throw new Exception("Configurator.insertProtocol(): position has to be ABOVE or BELOW");
        }
    }

    public void removeProtocol(String prot_name) throws Exception {
    }

    private Protocol connectProtocols(Vector protocol_list) {
        Protocol current_layer = null;
        Protocol next_layer = null;
        for (int i = 0; i < protocol_list.size(); ++i) {
            current_layer = (Protocol)protocol_list.elementAt(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = (Protocol)protocol_list.elementAt(i + 1);
            current_layer.setUpProtocol(next_layer);
            next_layer.setDownProtocol(current_layer);
        }
        return current_layer;
    }

    public Vector parseComponentStrings(String config_str, String delimiter) {
        Vector<String> retval = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(config_str, delimiter, false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            while (token.endsWith("\\")) {
                token = token.substring(0, token.length() - 1) + delimiter + tok.nextToken();
            }
            retval.addElement(token);
        }
        return retval;
    }

    public Vector parseConfigurations(String configuration) throws Exception {
        Vector<ProtocolConfiguration> retval = new Vector<ProtocolConfiguration>();
        Vector component_strings = this.parseComponentStrings(configuration, "?");
        if (component_strings == null) {
            return null;
        }
        for (int i = 0; i < component_strings.size(); ++i) {
            String component_string = (String)component_strings.elementAt(i);
            ProtocolConfiguration protocol_config = new ProtocolConfiguration(component_string);
            retval.addElement(protocol_config);
        }
        return retval;
    }

    private Vector createProtocols(Vector protocol_configs, ProtocolStack stack) throws Exception {
        Vector<Protocol> retval = new Vector<Protocol>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = (ProtocolConfiguration)protocol_configs.elementAt(i);
            Protocol layer = protocol_config.createLayer(stack);
            if (layer == null) {
                return null;
            }
            retval.addElement(layer);
        }
        this.sanityCheck(retval);
        return retval;
    }

    public void sanityCheck(Vector protocols) throws Exception {
        ProtocolReq req;
        int j;
        Protocol prot;
        int i;
        Vector<String> names = new Vector<String>();
        Vector<ProtocolReq> req_list = new Vector<ProtocolReq>();
        for (i = 0; i < protocols.size(); ++i) {
            prot = (Protocol)protocols.elementAt(i);
            String name = prot.getName();
            for (j = 0; j < names.size(); ++j) {
                if (!name.equals(names.elementAt(j))) continue;
                throw new Exception("Configurator.sanityCheck(): protocol name " + name + " has been used more than once; protocol names have to be unique !");
            }
            names.addElement(name);
        }
        for (i = 0; i < protocols.size(); ++i) {
            prot = (Protocol)protocols.elementAt(i);
            req = new ProtocolReq(prot.getName());
            req.up_reqs = prot.requiredUpServices();
            req.down_reqs = prot.requiredDownServices();
            req.up_provides = prot.providedUpServices();
            req.down_provides = prot.providedDownServices();
            req_list.addElement(req);
        }
        for (i = 0; i < req_list.size(); ++i) {
            int evt_type;
            req = (ProtocolReq)req_list.elementAt(i);
            if (req.up_reqs != null) {
                for (j = 0; j < req.up_reqs.size(); ++j) {
                    evt_type = (Integer)req.up_reqs.elementAt(j);
                    if (this.providesDownServices(i, req_list, evt_type)) continue;
                    throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers above");
                }
            }
            if (req.down_reqs == null) continue;
            for (j = 0; j < req.down_reqs.size(); ++j) {
                evt_type = (Integer)req.down_reqs.elementAt(j);
                if (this.providesUpServices(i, req_list, evt_type)) continue;
                throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers below");
            }
        }
    }

    boolean providesUpServices(int end_index, Vector req_list, int evt_type) {
        for (int i = 0; i < end_index; ++i) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (!req.providesUpService(evt_type)) continue;
            return true;
        }
        return false;
    }

    boolean providesDownServices(int start_index, Vector req_list, int evt_type) {
        for (int i = start_index; i < req_list.size(); ++i) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (!req.providesDownService(evt_type)) continue;
            return true;
        }
        return false;
    }

    public class ProtocolConfiguration {
        private String protocol_name = null;
        private String properties_str = null;
        private final Properties properties = new Properties();
        private static final String protocol_prefix = "org.jgroups.protocols";
        private static final String UDP = "com.gemstone.org.jgroups.protocols.UDP";
        private static final String TCPGOSSIP = "com.gemstone.org.jgroups.protocols.TCPGOSSIP";
        private static final String FD_SOCK = "com.gemstone.org.jgroups.protocols.FD_SOCK";
        private static final String FD = "com.gemstone.org.jgroups.protocols.FD";
        private static final String VERIFY_SUSPECT = "com.gemstone.org.jgroups.protocols.VERIFY_SUSPECT";
        private static final String STABLE = "com.gemstone.org.jgroups.protocols.pbcast.STABLE";
        private static final String NAKACK = "com.gemstone.org.jgroups.protocols.pbcast.NAKACK";
        private static final String UNICAST = "com.gemstone.org.jgroups.protocols.UNICAST";
        private static final String FRAG2 = "com.gemstone.org.jgroups.protocols.FRAG2";
        private static final String FRAG3 = "com.gemstone.org.jgroups.protocols.FRAG3";
        private static final String AUTH = "com.gemstone.org.jgroups.protocols.AUTH";
        private static final String GMS = "com.gemstone.org.jgroups.protocols.pbcast.GMS";
        private static final String VIEW_SYNC = "com.gemstone.org.jgroups.protocols.VIEW_SYNC";
        private static final String FC = "com.gemstone.org.jgroups.protocols.FC";
        private static final String GemFireTimeSync = "com.gemstone.org.jgroups.protocols.GemFireTimeSync";

        public ProtocolConfiguration(String config_str) throws Exception {
            this.setContents(config_str);
        }

        public String getProtocolName() {
            return this.protocol_name;
        }

        public Properties getProperties() {
            return this.properties;
        }

        void setContents(String config_str) throws Exception {
            Vector components;
            int index2 = config_str.indexOf(40);
            int end_index = config_str.lastIndexOf(41);
            if (index2 == -1) {
                this.protocol_name = config_str;
            } else {
                if (end_index == -1) {
                    throw new Exception("Configurator.ProtocolConfiguration.setContents(): closing ')' not found in " + config_str + ": properties cannot be set !");
                }
                this.properties_str = config_str.substring(index2 + 1, end_index);
                this.protocol_name = config_str.substring(0, index2);
            }
            if (this.properties_str != null && (components = Configurator.this.parseComponentStrings(this.properties_str, ";")).size() > 0) {
                for (int i = 0; i < components.size(); ++i) {
                    String comp = (String)components.elementAt(i);
                    index2 = comp.indexOf(61);
                    if (index2 == -1) {
                        throw new Exception("Configurator.ProtocolConfiguration.setContents(): '=' not found in " + comp);
                    }
                    String name = comp.substring(0, index2);
                    String value2 = comp.substring(index2 + 1, comp.length());
                    this.properties.put(name, value2);
                }
            }
        }

        Protocol createLayer(ProtocolStack prot_stack) throws Exception {
            Protocol retval = null;
            if (this.protocol_name == null) {
                return null;
            }
            if (this.protocol_name.equals(UDP)) {
                retval = new UDP();
            } else if (this.protocol_name.equals(TCPGOSSIP)) {
                retval = new TCPGOSSIP();
            } else if (this.protocol_name.equals(FD_SOCK)) {
                retval = new FD_SOCK();
            } else if (this.protocol_name.equals(FD)) {
                retval = new FD();
            } else if (this.protocol_name.equals(VERIFY_SUSPECT)) {
                retval = new VERIFY_SUSPECT();
            } else if (this.protocol_name.equals(STABLE)) {
                retval = new STABLE();
            } else if (this.protocol_name.equals(NAKACK)) {
                retval = new NAKACK();
            } else if (this.protocol_name.equals(UNICAST)) {
                retval = new UNICAST();
            } else if (this.protocol_name.equals(FRAG2)) {
                retval = new FRAG2();
            } else if (this.protocol_name.equals(FRAG3)) {
                retval = new FRAG3();
            } else if (this.protocol_name.equals(AUTH)) {
                retval = new AUTH();
            } else if (this.protocol_name.equals(GMS)) {
                retval = new GMS();
            } else if (this.protocol_name.equals(VIEW_SYNC)) {
                retval = new VIEW_SYNC();
            } else if (this.protocol_name.equals(FC)) {
                retval = new FC();
            } else if (this.protocol_name.equals(GemFireTimeSync)) {
                retval = new GemFireTimeSync();
            }
            if (retval == null) {
                String defaultProtocolName = "org.jgroups.protocols." + this.protocol_name;
                Class clazz = null;
                try {
                    clazz = Util.loadClass(defaultProtocolName, this.getClass());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (clazz == null) {
                    try {
                        clazz = Util.loadClass(this.protocol_name, this.getClass());
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        throw new Exception("unable to load class for protocol " + this.protocol_name + " (either as an absolute - " + this.protocol_name + " - or relative - " + defaultProtocolName + " - package name)!");
                    }
                }
                try {
                    retval = (Protocol)clazz.newInstance();
                    if (retval == null) {
                        throw new Exception("creation of instance for protocol " + this.protocol_name + "failed !");
                    }
                    retval.setProtocolStack(prot_stack);
                    if (this.properties != null && !retval.setPropertiesInternal(this.properties)) {
                        return null;
                    }
                    retval.init();
                }
                catch (InstantiationException inst_ex) {
                    Configurator.this.log.error("an instance of " + this.protocol_name + " could not be created. Please check that it implements" + " interface Protocol and that is has a public empty constructor !");
                    throw inst_ex;
                }
            }
            retval.setProtocolStack(prot_stack);
            if (this.properties != null && !retval.setPropertiesInternal(this.properties)) {
                return null;
            }
            retval.init();
            return retval;
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("Protocol: ");
            if (this.protocol_name == null) {
                retval.append("<unknown>");
            } else {
                retval.append(this.protocol_name);
            }
            if (this.properties != null) {
                retval.append("(" + this.properties + ')');
            }
            return retval.toString();
        }
    }

    private static class ProtocolReq {
        Vector up_reqs = null;
        Vector down_reqs = null;
        Vector up_provides = null;
        Vector down_provides = null;
        String name = null;

        ProtocolReq(String name) {
            this.name = name;
        }

        boolean providesUpService(int evt_type) {
            if (this.up_provides != null) {
                for (int i = 0; i < this.up_provides.size(); ++i) {
                    int type = (Integer)this.up_provides.elementAt(i);
                    if (type != evt_type) continue;
                    return true;
                }
            }
            return false;
        }

        boolean providesDownService(int evt_type) {
            if (this.down_provides != null) {
                for (int i = 0; i < this.down_provides.size(); ++i) {
                    int type = (Integer)this.down_provides.elementAt(i);
                    if (type != evt_type) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append('\n' + this.name + ':');
            if (this.up_reqs != null) {
                ret.append("\nRequires from above: " + this.printUpReqs());
            }
            if (this.down_reqs != null) {
                ret.append("\nRequires from below: " + this.printDownReqs());
            }
            if (this.up_provides != null) {
                ret.append("\nProvides to above: " + this.printUpProvides());
            }
            if (this.down_provides != null) {
                ret.append("\nProvides to below: ").append(this.printDownProvides());
            }
            return ret.toString();
        }

        String printUpReqs() {
            StringBuffer ret = new StringBuffer("[");
            if (this.up_reqs != null) {
                for (int i = 0; i < this.up_reqs.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.up_reqs.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printDownReqs() {
            StringBuffer ret = new StringBuffer("[");
            if (this.down_reqs != null) {
                for (int i = 0; i < this.down_reqs.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.down_reqs.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printUpProvides() {
            StringBuffer ret = new StringBuffer("[");
            if (this.up_provides != null) {
                for (int i = 0; i < this.up_provides.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.up_provides.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }

        String printDownProvides() {
            StringBuffer ret = new StringBuffer("[");
            if (this.down_provides != null) {
                for (int i = 0; i < this.down_provides.size(); ++i) {
                    ret.append(Event.type2String((Integer)this.down_provides.elementAt(i)) + ' ');
                }
            }
            return ret.toString() + ']';
        }
    }
}

