/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.util.HashMap;
import java.util.TreeSet;

public class AckReceiverWindow {
    long next_to_remove = 0L;
    final HashMap msgs = new HashMap();
    static final GemFireTracer log = GemFireTracer.getLog(AckReceiverWindow.class);
    long highest_released_seqno;

    public synchronized void releasedMessage(long seqno) {
        if (seqno > this.highest_released_seqno) {
            this.highest_released_seqno = seqno;
        }
    }

    public long getHighestReleasedSeqno() {
        return this.highest_released_seqno;
    }

    public AckReceiverWindow(long initial_seqno) {
        this.next_to_remove = initial_seqno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add2(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            if (seqno < this.next_to_remove) {
                if (log.isTraceEnabled()) {
                    log.trace("discarded msg with seqno=" + seqno + " (next msg to dispatch is " + this.next_to_remove + ')');
                }
                return false;
            }
            Long seq = seqno;
            if (!this.msgs.containsKey(seq)) {
                this.msgs.put(seq, msg);
                if (log.isTraceEnabled()) {
                    log.trace("seqno " + seqno + " added to receiver window (next" + " msg to dispatch is " + this.next_to_remove + ')');
                }
            } else if (log.isTraceEnabled()) {
                log.trace("seqno " + seqno + " already received and awaiting" + " dispatch (next msg to dispatch is " + this.next_to_remove + ')');
            }
            return true;
        }
    }

    public long nextToRemove() {
        return this.next_to_remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            if (seqno < this.next_to_remove) {
                if (log.isTraceEnabled()) {
                    log.trace("discarded msg with seqno=" + seqno + " (next msg to receive is " + this.next_to_remove + ')');
                }
                return false;
            }
            Long seq = seqno;
            if (!this.msgs.containsKey(seq)) {
                this.msgs.put(seq, msg);
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace("seqno " + seqno + " already received - dropping it");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval;
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            Long key2 = this.next_to_remove;
            retval = (Message)this.msgs.remove(key2);
            if (retval != null) {
                if (log.isTraceEnabled()) {
                    log.trace("removed seqno=" + this.next_to_remove + ": " + retval);
                }
                ++this.next_to_remove;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextToRemove(long seqno) {
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            return seqno == this.next_to_remove;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            this.msgs.clear();
        }
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")");
        TreeSet s = new TreeSet(this.msgs.keySet());
        if (s.size() > 0) {
            sb.append(" [").append(s.first()).append(" - ").append(s.last()).append("]");
            sb.append(": ").append(s);
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")").append(", msgs=").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }
}

