/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class STABLE
extends Protocol {
    Address local_addr = null;
    final Vector mbrs = new Vector();
    final Digest digest = new Digest(10);
    final Digest latest_local_digest = new Digest(10);
    final Vector heard_from = new Vector();
    long desired_avg_gossip = 20000L;
    long stability_delay = 6000L;
    StabilitySendTask stability_task = null;
    final Object stability_mutex = new Object();
    volatile StableTask stable_task = null;
    final Object stable_task_mutex = new Object();
    TimeScheduler timer = null;
    static final String name = "STABLE";
    long max_bytes = 0L;
    long num_bytes_received = 0L;
    boolean suspended = false;
    boolean initialized = false;
    ResumeTask resume_task = null;
    final Object resume_task_mutex = new Object();
    private long suspendStartTime = 0L;
    int num_gossips = 0;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 5;
    }

    public long getDesiredAverageGossip() {
        return this.desired_avg_gossip;
    }

    public void setDesiredAverageGossip(long gossip_interval) {
        this.desired_avg_gossip = gossip_interval;
    }

    public long getMaxBytes() {
        return this.max_bytes;
    }

    public void setMaxBytes(long max_bytes) {
        this.max_bytes = max_bytes;
    }

    public int getNumberOfGossipMessages() {
        return this.num_gossips;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_gossips = 0;
    }

    @Override
    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(57);
        return retval;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("digest_timeout");
        if (str != null) {
            props.remove("digest_timeout");
            this.log.error(JGroupsStrings.STABLE_DIGEST_TIMEOUT_HAS_BEEN_DEPRECATED_IT_WILL_BE_IGNORED);
        }
        if ((str = props.getProperty("desired_avg_gossip")) != null) {
            this.desired_avg_gossip = Long.parseLong(str);
            props.remove("desired_avg_gossip");
        }
        if ((str = props.getProperty("stability_delay")) != null) {
            this.stability_delay = Long.parseLong(str);
            props.remove("stability_delay");
        }
        if ((str = props.getProperty("max_gossip_runs")) != null) {
            props.remove("max_gossip_runs");
            this.log.error(JGroupsStrings.STABLE_MAX_GOSSIP_RUNS_HAS_BEEN_DEPRECATED_AND_WILL_BE_IGNORED);
        }
        if ((str = props.getProperty("max_bytes")) != null) {
            this.max_bytes = Long.parseLong(str);
            props.remove("max_bytes");
        }
        if ((str = props.getProperty("max_suspend_time")) != null) {
            this.log.error(JGroupsStrings.STABLE_MAX_SUSPEND_TIME_IS_NOT_SUPPORTED_ANY_LONGER_PLEASE_REMOVE_IT_IGNORING_IT);
            props.remove("max_suspend_time");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.STABLE_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    private void suspend(long timeout) {
        if (!this.suspended) {
            this.suspended = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("suspending message garbage collection");
            }
            if (this.stack.enableClockStats) {
                this.suspendStartTime = this.nanoTime();
            }
        }
        this.startResumeTask(timeout);
    }

    protected void resume() {
        this.suspended = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("resuming message garbage collection");
        }
        this.stopResumeTask();
    }

    @Override
    public void start() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
        if (this.desired_avg_gossip > 0L) {
            this.startStableTask();
        }
    }

    @Override
    public void stop() {
        this.stopStableTask();
        this.clearDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 1: {
                StableHeader hdr;
                Message msg = (Message)evt.getArg();
                if (this.max_bytes > 0L) {
                    long size2 = Math.max(msg.getLength(), 24);
                    this.num_bytes_received += size2;
                    if (this.num_bytes_received >= this.max_bytes) {
                        if (trace) {
                            this.log.trace(new StringBuffer("max_bytes has been reached (").append(this.max_bytes).append(", bytes received=").append(this.num_bytes_received).append("): triggers stable msg"));
                        }
                        this.num_bytes_received = 0L;
                        this.passDown(new Event(57));
                    }
                }
                if ((hdr = (StableHeader)msg.removeHeader(name)) == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStableMessage(msg.getSrc(), hdr.stableDigest);
                        break;
                    }
                    case 2: {
                        this.handleStabilityMessage(hdr.stableDigest, msg.getSrc());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(JGroupsStrings.STABLE_STABLEHEADER_TYPE__0__NOT_KNOWN, hdr.type);
                    }
                }
                return;
            }
            case 58: {
                Digest d = (Digest)evt.getArg();
                Digest digest = this.latest_local_digest;
                synchronized (digest) {
                    this.latest_local_digest.replace(d);
                }
                if (trace) {
                    this.log.trace("setting latest_local_digest from NAKACK: " + d.printHighSeqnos());
                }
                this.sendStableMessage(d);
                break;
            }
            case 6: {
                View view = (View)evt.getArg();
                this.handleViewChange(view);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                break;
            }
            case 65: {
                long timeout = 0L;
                Object t = evt.getArg();
                if (t != null && t instanceof Long) {
                    timeout = (Long)t;
                }
                this.suspend(timeout);
                break;
            }
            case 66: {
                this.resume();
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMessageGarbageCollection() {
        Digest copy;
        Digest digest = this.digest;
        synchronized (digest) {
            copy = this.digest.copy();
        }
        this.sendStableMessage(copy);
    }

    private void handleViewChange(View v) {
        Vector tmp = v.getMembers();
        this.mbrs.clear();
        this.mbrs.addAll(tmp);
        this.adjustSenders(this.digest, tmp);
        this.adjustSenders(this.latest_local_digest, tmp);
        this.resetDigest(tmp);
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSenders(Digest d, Vector members) {
        Digest digest = d;
        synchronized (digest) {
            Address mbr;
            Iterator it = d.senders.keySet().iterator();
            while (it.hasNext()) {
                mbr = (Address)it.next();
                if (members.contains(mbr)) continue;
                it.remove();
            }
            for (int i = 0; i < members.size(); ++i) {
                mbr = (Address)members.get(i);
                if (d.contains(mbr)) continue;
                d.add(mbr, -1L, -1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDigest() {
        Digest digest = this.digest;
        synchronized (digest) {
            this.digest.clear();
        }
    }

    private boolean updateLocalDigest(Digest d, Address sender) {
        if (d == null || d.size() == 0) {
            return false;
        }
        if (!this.initialized) {
            if (trace) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return false;
        }
        if (!this.digest.sameSenders(d)) {
            if (trace) {
                this.log.trace(new StringBuffer("received a digest ").append(d.printHighSeqnos()).append(" from ").append(sender).append(" which has different members than mine (").append(this.digest.printHighSeqnos()).append("), discarding it and resetting heard_from list"));
            }
            this.resetDigest(this.mbrs);
            return false;
        }
        StringBuffer sb = null;
        if (trace) {
            sb = new StringBuffer("my [").append(this.local_addr).append("] digest before: ").append(this.digest).append("\ndigest from ").append(sender).append(": ").append(d);
        }
        for (Map.Entry entry : d.senders.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            long highest_seqno = val.high_seqno;
            long highest_seen_seqno = val.high_seqno_seen;
            long my_highest_seqno = this.digest.highSeqnoAt(mbr);
            long my_highest_seen_seqno = this.digest.highSeqnoSeenAt(mbr);
            long new_highest_seqno = Math.min(my_highest_seqno, highest_seqno);
            long new_highest_seen_seqno = Math.max(my_highest_seen_seqno, highest_seen_seqno);
            this.digest.setHighestDeliveredAndSeenSeqnos(mbr, new_highest_seqno, new_highest_seen_seqno);
        }
        if (trace) {
            sb.append("\nmy [").append(this.local_addr).append("] digest after: ").append(this.digest).append("\n");
            this.log.trace(sb);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDigest(Vector new_members) {
        Digest copy_of_latest;
        if (new_members == null || new_members.size() == 0) {
            return;
        }
        Vector vector = this.heard_from;
        synchronized (vector) {
            this.heard_from.clear();
            this.heard_from.addAll(new_members);
        }
        Digest digest = this.latest_local_digest;
        synchronized (digest) {
            copy_of_latest = this.latest_local_digest.copy();
        }
        digest = this.digest;
        synchronized (digest) {
            this.digest.replace(copy_of_latest);
            if (trace) {
                this.log.trace("resetting digest from NAKACK: " + copy_of_latest.printHighSeqnos());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromHeardFromList(Address mbr) {
        Vector vector = this.heard_from;
        synchronized (vector) {
            this.heard_from.remove(mbr);
            if (this.heard_from.size() == 0) {
                this.resetDigest(this.mbrs);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStableTask() {
        if (this.stable_task != null) {
            return;
        }
        Object object = this.stable_task_mutex;
        synchronized (object) {
            if (this.stable_task != null && this.stable_task.running()) {
                return;
            }
            this.stable_task = new StableTask();
            this.timer.add(this.stable_task, true);
        }
        if (trace) {
            this.log.trace("stable task started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopStableTask() {
        Object object = this.stable_task_mutex;
        synchronized (object) {
            if (this.stable_task != null) {
                this.stable_task.stop();
                this.stable_task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startResumeTask(long max_suspend_time) {
        max_suspend_time = (long)((double)max_suspend_time * 1.1);
        Object object = this.resume_task_mutex;
        synchronized (object) {
            if (this.resume_task != null && this.resume_task.running()) {
                return;
            }
            this.resume_task = new ResumeTask(max_suspend_time);
            this.timer.add(this.resume_task, true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resume task started, max_suspend_time=" + max_suspend_time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopResumeTask() {
        Object object = this.resume_task_mutex;
        synchronized (object) {
            if (this.resume_task != null) {
                this.resume_task.stop();
                this.resume_task = null;
                if (this.stack.enableClockStats) {
                    this.stack.gemfireStats.incJgSTABLEsuspendTime(this.nanoTime() - this.suspendStartTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStabilityTask(Digest d, long delay) {
        Object object = this.stability_mutex;
        synchronized (object) {
            if (this.stability_task == null || !this.stability_task.running()) {
                this.stability_task = new StabilitySendTask(d, delay);
                this.timer.add(this.stability_task, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopStabilityTask() {
        Object object = this.stability_mutex;
        synchronized (object) {
            if (this.stability_task != null) {
                this.stability_task.stop();
                this.stability_task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStableMessage(Address sender, Digest d) {
        Digest copy;
        if (d == null || sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.STABLE_DIGEST_OR_SENDER_IS_NULL);
            }
            return;
        }
        if (!this.initialized) {
            if (trace) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return;
        }
        if (this.suspended) {
            if (trace) {
                this.log.trace("STABLE message will not be handled as I'm suspended");
            }
            return;
        }
        if (trace) {
            this.log.trace(new StringBuffer("received stable msg from ").append(sender).append(": ").append(d.printHighSeqnos()));
        }
        if (!this.heard_from.contains(sender)) {
            if (trace) {
                this.log.trace("already received stable msg from " + sender);
            }
            return;
        }
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incJgSTABLEmessages(1L);
        }
        Digest digest = this.digest;
        synchronized (digest) {
            boolean success = this.updateLocalDigest(d, sender);
            if (!success) {
                return;
            }
            copy = this.digest.copy();
        }
        boolean was_last = this.removeFromHeardFromList(sender);
        if (was_last) {
            this.sendStabilityMessage(copy);
        }
    }

    private void sendStableMessage(Digest d) {
        if (this.suspended) {
            if (trace) {
                this.log.trace("will not send STABLE message as I'm suspended");
            }
            return;
        }
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incJgSTABLEmessagesSent(1L);
        }
        if (d != null && d.size() > 0) {
            if (trace) {
                this.log.trace("sending stable msg " + d.printHighSeqnos());
            }
            Message msg = new Message();
            StableHeader hdr = new StableHeader(1, d);
            msg.putHeader(name, hdr);
            ++this.num_gossips;
            this.passDown(new Event(1, msg));
        }
    }

    void sendStabilityMessage(Digest tmp) {
        long delay = Util.random(this.stability_delay);
        this.startStabilityTask(tmp, delay);
    }

    void handleStabilityMessage(Digest d, Address sender) {
        if (d == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.STABLE_STABILITY_DIGEST_IS_NULL);
            }
            return;
        }
        if (!this.initialized) {
            if (trace) {
                this.log.trace("STABLE message will not be handled as I'm not yet initialized");
            }
            return;
        }
        if (this.suspended) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stability message will not be handled as I'm suspended");
            }
            return;
        }
        if (trace) {
            this.log.trace(new StringBuffer("received stability msg from ").append(sender).append(": ").append(d.printHighSeqnos()));
        }
        this.stopStabilityTask();
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incJgSTABILITYmessages(1L);
        }
        if (!this.digest.sameSenders(d)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("received digest (digest=" + d + ") which does not match my own digest (" + this.digest + "): ignoring digest and re-initializing own digest");
            }
            return;
        }
        this.resetDigest(this.mbrs);
        this.passDown(new Event(30, d));
    }

    private class ResumeTask
    implements TimeScheduler.Task {
        boolean running = true;
        long max_suspend_time = 0L;

        ResumeTask(long max_suspend_time) {
            this.max_suspend_time = max_suspend_time;
        }

        void stop() {
            this.running = false;
        }

        public boolean running() {
            return this.running;
        }

        @Override
        public boolean cancelled() {
            return !this.running;
        }

        @Override
        public long nextInterval() {
            return this.max_suspend_time;
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                STABLE.this.log.warn("ResumeTask resumed message garbage collection - this should be done by a RESUME_STABLE event; check why this event was not received (or increase max_suspend_time for large state transfers)");
            }
            STABLE.this.resume();
        }
    }

    private class StabilitySendTask
    implements TimeScheduler.Task {
        Digest d = null;
        boolean stopped = false;
        long delay = 2000L;

        StabilitySendTask(Digest d, long delay) {
            this.d = d;
            this.delay = delay;
        }

        public boolean running() {
            return !this.stopped;
        }

        public void stop() {
            this.stopped = true;
        }

        @Override
        public boolean cancelled() {
            return this.stopped;
        }

        @Override
        public long nextInterval() {
            return this.delay;
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                if (STABLE.this.log.isDebugEnabled()) {
                    STABLE.this.log.debug("STABILITY message will not be sent as suspended=" + STABLE.this.suspended);
                }
                this.stopped = true;
                return;
            }
            if (this.d != null && !this.stopped) {
                Message msg = new Message();
                StableHeader hdr = new StableHeader(2, this.d);
                msg.putHeader(STABLE.name, hdr);
                if (Protocol.trace) {
                    STABLE.this.log.trace("sending stability msg " + this.d.printHighSeqnos());
                }
                STABLE.this.passDown(new Event(1, msg));
                this.d = null;
            }
            this.stopped = true;
        }
    }

    protected class StableTask
    implements TimeScheduler.Task {
        boolean stopped = false;

        protected StableTask() {
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean running() {
            return !this.stopped;
        }

        @Override
        public boolean cancelled() {
            return this.stopped;
        }

        @Override
        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        @Override
        public void run() {
            if (STABLE.this.suspended) {
                if (Protocol.trace) {
                    STABLE.this.log.trace("stable task will not run as suspended=" + STABLE.this.suspended);
                }
                return;
            }
            STABLE.this.passDown(new Event(57));
        }

        long computeSleepTime() {
            return this.getRandom((long)STABLE.this.mbrs.size() * STABLE.this.desired_avg_gossip * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }
    }

    public static class StableHeader
    extends Header
    implements Streamable {
        public static final int STABLE_GOSSIP = 1;
        public static final int STABILITY = 2;
        int type = 0;
        Digest stableDigest = null;

        public StableHeader() {
        }

        public StableHeader(int type, Digest digest) {
            this.type = type;
            this.stableDigest = digest;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "STABLE_GOSSIP";
                }
                case 2: {
                    return "STABILITY";
                }
            }
            return "<unknown>";
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(StableHeader.type2String(this.type));
            sb.append("]: digest is ");
            sb.append(this.stableDigest);
            return sb.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.stableDigest == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            this.stableDigest.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            boolean digest_not_null = in.readBoolean();
            if (digest_not_null) {
                this.stableDigest = new Digest();
                this.stableDigest.readExternal(in);
            }
        }

        @Override
        public long size(short version) {
            long retval = 5L;
            if (this.stableDigest != null) {
                retval += this.stableDigest.serializedSize(version);
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
            Util.writeStreamable(this.stableDigest, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
            this.stableDigest = (Digest)Util.readStreamable(Digest.class, in);
        }
    }
}

