/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.MergeView;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.ShunnedAddressException;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.FD_SOCK;
import com.gemstone.org.jgroups.protocols.pbcast.ClientGmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.CoordGmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.protocols.pbcast.MergeData;
import com.gemstone.org.jgroups.protocols.pbcast.ParticipantGmsImpl;
import com.gemstone.org.jgroups.stack.GossipServer;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.AckCollector;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GMS
extends Protocol {
    protected GmsImpl impl = null;
    Address local_addr = null;
    final Membership members = new Membership();
    private final Membership tmp_members = new Membership();
    static final String FAILED_TO_ACK_MEMBER_VERIFY_THREAD = "Failed to ACK member verify Thread";
    private final Vector joining = new Vector(7);
    private final Vector leaving = new Vector(7);
    View view = null;
    ViewId view_id = null;
    private long ltime = 0L;
    long join_timeout = 5000L;
    long join_retry_timeout = 2000L;
    long leave_timeout = 5000L;
    private long digest_timeout = 0L;
    long merge_timeout = 10000L;
    private final Object impl_mutex = new Object();
    private final Object digest_mutex = new Object();
    private final Promise digest_promise = new Promise();
    private final Hashtable impls = new Hashtable(3);
    private boolean shun = true;
    boolean merge_leader = false;
    private boolean print_local_addr = true;
    boolean disable_initial_coord = false;
    boolean handle_concurrent_startup = true;
    static final String CLIENT = "Client";
    static final String COORD = "Coordinator";
    static final String PART = "Participant";
    TimeScheduler timer = null;
    private volatile boolean joined;
    private volatile boolean disconnected;
    volatile Address leader;
    boolean floatingCoordinatorDisabled;
    boolean splitBrainDetectionEnabled;
    protected boolean networkPartitionDetected = false;
    protected int num_prev_mbrs = 50;
    BoundedList prev_members = null;
    int num_views = 0;
    BoundedList prev_views = new BoundedList(20);
    public final ViewHandler view_handler = new ViewHandler();
    final AckCollector ack_collector = new AckCollector();
    final AckCollector prepare_collector = new AckCollector();
    long view_ack_collection_timeout = 12437L;
    long resume_task_timeout = 17439L;
    private int partitionThreshold = 51;
    private int memberWeight;
    private volatile View preparedView;
    private View previousPreparedView;
    private volatile Address coordinator;
    public static final String name = "GMS";
    public static int TEST_HOOK_SLOW_VIEW_CASTING;
    static final long BUNDLE_WAITTIME;
    private Object installViewLock = new Object();

    public GMS() {
        this.initState();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 7;
    }

    public String getView() {
        return this.view_id != null ? this.view_id.toString() : "null";
    }

    public int getNumberOfViews() {
        return this.num_views;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    public int getNumMembers() {
        return this.members != null ? this.members.size() : 0;
    }

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public void setJoinTimeout(long t) {
        this.join_timeout = t;
    }

    public long getJoinRetryTimeout() {
        return this.join_retry_timeout;
    }

    public void setJoinRetryTimeout(long t) {
        this.join_retry_timeout = t;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean s) {
        this.shun = s;
    }

    public String printPreviousMembers() {
        StringBuffer sb = new StringBuffer();
        if (this.prev_members != null) {
            Enumeration en = this.prev_members.elements();
            while (en.hasMoreElements()) {
                sb.append(en.nextElement()).append("\n");
            }
        }
        return sb.toString();
    }

    public int viewHandlerSize() {
        return this.view_handler.size();
    }

    public boolean isViewHandlerSuspended() {
        return this.view_handler.suspended();
    }

    public String dumpViewHandlerQueue() {
        return this.view_handler.dumpQueue();
    }

    public String dumpViewHandlerHistory() {
        return this.view_handler.dumpHistory();
    }

    public void suspendViewHandler() {
        this.view_handler.suspend(null);
    }

    public void resumeViewHandler() {
        this.view_handler.resumeForce();
    }

    GemFireTracer getLog() {
        return this.log;
    }

    public String printPreviousViews() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.prev_views.elements();
        while (en.hasMoreElements()) {
            sb.append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    public boolean isCoordinator() {
        Address coord = this.determineCoordinator();
        return coord != null && this.local_addr != null && this.local_addr.equals(coord);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views = 0;
        this.prev_views.removeAll();
    }

    @Override
    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(3);
        retval.addElement(39);
        retval.addElement(41);
        retval.addElement(12);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            if (this.impl == new_impl) {
                return;
            }
            this.impl = new_impl;
            if (this.log.isDebugEnabled()) {
                String msg = (this.local_addr != null ? this.local_addr.toString() + " " : "") + "changed role to " + new_impl.getClass().getName();
                this.log.debug(msg);
            }
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    @Override
    public void init() throws Exception {
        this.prev_members = new BoundedList(this.num_prev_mbrs);
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("GMS.init(): timer is null");
        }
        if (this.impl != null) {
            this.impl.init();
        }
    }

    @Override
    public void start() throws Exception {
        this.disconnected = false;
        if (this.impl != null) {
            this.impl.start();
        }
    }

    @Override
    public void stop() {
        this.view_handler.stop(true);
        if (this.impl != null) {
            this.impl.stop();
        }
        if (this.prev_members != null) {
            this.prev_members.removeAll();
        }
    }

    public synchronized void becomeCoordinator(Vector suspects) {
        if (!(this.impl instanceof CoordGmsImpl)) {
            this.log.getInternalLogWriter().info(JGroupsStrings.GMS_THIS_MEMBER_0_IS_BECOMING_GROUP_COORDINATOR, this.local_addr);
            CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get(COORD);
            if (tmp == null) {
                tmp = new CoordGmsImpl(this);
                this.impls.put(COORD, tmp);
            }
            try {
                tmp.init();
            }
            catch (Exception e) {
                this.log.error(JGroupsStrings.GMS_EXCEPTION_SWITCHING_TO_COORDINATOR_ROLE, (Throwable)e);
            }
            if (((IpAddress)this.local_addr).getBirthViewId() < 0) {
                ((IpAddress)this.local_addr).setBirthViewId(this.view_id == null ? 0L : this.view_id.getId());
            }
            this.setImpl(tmp);
            if (suspects != null && suspects.size() > 0) {
                LinkedList suspectList = new LinkedList(suspects);
                this.impl.handleLeave(suspectList, true, Collections.singletonList("Member was suspected of being dead prior to " + this.local_addr + " becoming group coordinator"), false);
            }
        }
    }

    protected synchronized void incrementLtime(int amount) {
        this.ltime += (long)amount;
    }

    public void becomeParticipant() {
        if (this.stack.getChannel().closing()) {
            return;
        }
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get(PART);
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put(PART, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error(JGroupsStrings.GMS_EXCEPTION_SWITCHING_TO_PARTICIPANT, (Throwable)e);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get(CLIENT);
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put(CLIENT, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error(JGroupsStrings.GMS_EXCEPTION_SWITCHING_TO_CLIENT_ROLE, (Throwable)e);
        }
        this.setImpl(tmp);
    }

    boolean haveCoordinatorRole() {
        return this.impl != null && this.impl instanceof CoordGmsImpl;
    }

    boolean haveParticipantRole() {
        return this.impl != null && this.impl instanceof ParticipantGmsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getNextView(Vector added_mbrs, Vector left_mbrs, Vector suspected_mbrs) {
        Membership membership = this.members;
        synchronized (membership) {
            long vid = this.view_id == null ? 0L : Math.max(this.view_id.getId(), this.ltime) + 1L;
            this.ltime = vid;
            Membership tmp_mbrs = this.tmp_members.copy();
            if (suspected_mbrs != null) {
                if (left_mbrs == null) {
                    left_mbrs = new Vector<IpAddress>();
                }
                Iterator it = suspected_mbrs.iterator();
                while (it.hasNext()) {
                    Address addr = (IpAddress)it.next();
                    if (!this.stack.jgmm.isShuttingDown((IpAddress)addr)) continue;
                    it.remove();
                    left_mbrs.add((IpAddress)addr);
                }
            }
            tmp_mbrs.remove(suspected_mbrs);
            tmp_mbrs.remove(left_mbrs);
            tmp_mbrs.add(added_mbrs);
            Vector mbrs = tmp_mbrs.getMembers();
            View v = new View(this.local_addr, vid, mbrs, suspected_mbrs);
            this.tmp_members.set(mbrs);
            if (added_mbrs != null) {
                for (int i = 0; i < added_mbrs.size(); ++i) {
                    Address tmp_mbr = (Address)added_mbrs.elementAt(i);
                    if (this.joining.contains(tmp_mbr)) continue;
                    this.joining.addElement(tmp_mbr);
                }
            }
            if (left_mbrs != null) {
                for (Address addr : left_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            if (suspected_mbrs != null) {
                for (Address addr : suspected_mbrs) {
                    if (this.leaving.contains(addr)) continue;
                    this.leaving.add(addr);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("new view is " + v);
            }
            return v;
        }
    }

    public void castViewChange(Vector new_mbrs, Vector left_mbrs, Vector suspected_mbrs, boolean mcast) {
        View new_view = this.getNextView(new_mbrs, left_mbrs, suspected_mbrs);
        this.castViewChange(new_view, null, true);
    }

    public void castViewChange(View new_view, Digest digest, boolean mcast) {
        this.castViewChangeWithDest(new_view, digest, null, true);
    }

    protected void ucastViewChange(View new_view) {
        this.castViewChangeWithDest(new_view, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void castViewChangeWithDest(View new_view, Digest digest, List newMbrs_p, boolean mcast_p) {
        Object it;
        ViewId vid = new_view.getVid();
        int size2 = -1;
        if (this.disconnected) {
            return;
        }
        if (TEST_HOOK_SLOW_VIEW_CASTING > 0) {
            try {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Delaying view casting by " + TEST_HOOK_SLOW_VIEW_CASTING + " seconds for testing");
                Thread.sleep(TEST_HOOK_SLOW_VIEW_CASTING * 1000);
            }
            catch (InterruptedException e) {
                this.log.getInternalLogWriter().fine("Test hook interrupted while sleeping");
                Thread.currentThread().interrupt();
            }
            finally {
                TEST_HOOK_SLOW_VIEW_CASTING = 0;
            }
        }
        this.passDown(new Event(15, new_view));
        boolean mcast = mcast_p && this.stack.jgmm.getDistributionConfig().getMcastPort() > 0;
        LinkedList newMbrs = newMbrs_p;
        if (newMbrs == null || newMbrs.size() == 0) {
            newMbrs = new LinkedList(new_view.getMembers());
        }
        HashSet suspects = new HashSet(new_view.getSuspectedMembers());
        for (IpAddress addr : suspects) {
            if (!this.stack.jgmm.isShuttingDown(addr)) continue;
            new_view.notSuspect(addr);
        }
        this.log.getInternalLogWriter().info(JGroupsStrings.GMS_MEMBERSHIP_SENDING_NEW_VIEW_0_1_MBRS, new Object[]{new_view, new_view.size()});
        long start = System.currentTimeMillis();
        GmsHeader hdr = new GmsHeader(5);
        new_view.setMessageDigest(digest);
        try {
            Message msg;
            if (!this.prepareView(new_view, mcast, newMbrs)) {
                return;
            }
            it = this.ack_collector;
            synchronized (it) {
                this.ack_collector.reset(vid, newMbrs);
                size2 = this.ack_collector.size();
            }
            if (mcast) {
                Message view_change_msg = new Message();
                view_change_msg.isHighPriority = true;
                view_change_msg.putHeader(name, hdr);
                view_change_msg.setObject(new_view);
                this.passDown(new Event(1, view_change_msg));
            } else {
                for (int i = 0; i < newMbrs.size(); ++i) {
                    msg = new Message();
                    msg.isHighPriority = true;
                    msg.putHeader(name, hdr);
                    msg.setObject(new_view);
                    msg.setDest((Address)newMbrs.get(i));
                    this.passDown(new Event(1, msg));
                }
            }
            if (new_view.getSuspectedMembers() != null) {
                Iterator it2 = new_view.getSuspectedMembers().iterator();
                while (it2.hasNext()) {
                    msg = new Message();
                    msg.isHighPriority = true;
                    msg.putHeader(name, hdr);
                    msg.putHeader("NO_UCAST", hdr);
                    msg.setDest((Address)it2.next());
                    this.passDown(new Event(1, msg));
                }
            }
            try {
                this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                if (trace) {
                    long stop = System.currentTimeMillis();
                    this.log.trace("received all ACKs (" + size2 + ") for " + vid + " in " + (stop - start) + "ms");
                }
            }
            catch (TimeoutException e) {
                String missingStr;
                AckCollector ackCollector = this.ack_collector;
                synchronized (ackCollector) {
                    missingStr = this.ack_collector.getMissingAcks().toString();
                    String receivedStr = this.ack_collector.getReceived().toString();
                }
                if (!this.stack.getChannel().closing()) {
                    this.log.getInternalLogWriter().warning(JGroupsStrings.GMS_FAILED_TO_COLLECT_ALL_ACKS_0_FOR_VIEW_1_AFTER_2_MS_MISSING_ACKS_FROM_3_RECEIVED_4_LOCAL_ADDR_5, new Object[]{size2, vid, this.view_ack_collection_timeout, missingStr});
                    this.checkFailedToAckMembers(new_view, this.ack_collector.getMissingAcks());
                }
            }
        }
        finally {
            it = this.ack_collector;
            synchronized (it) {
                this.ack_collector.fullyReset();
            }
            it = this.prepare_collector;
            synchronized (it) {
                this.prepare_collector.fullyReset();
            }
            this.previousPreparedView = null;
        }
    }

    boolean prepareView(View new_view, boolean mcast, List newMbrs) {
        HashSet failures = new HashSet(new_view.getSuspectedMembers());
        int failedWeight = GMS.processFailuresAndGetWeight(this.view, this.leader, failures);
        if (!this.processPreparedView(this.preparedView, new_view, newMbrs, false)) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("processPreparedView failed; aborting view " + new_view.getVid());
            }
            return false;
        }
        List<IpAddress> failedToAck = this.sendPrepareForViewChange(new_view, newMbrs, false);
        if (!this.processPreparedView(this.preparedView, new_view, newMbrs, false)) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("processPreparedView failed; aborting view " + new_view.getVid());
            }
            return false;
        }
        if (failedToAck.size() > 0 && !this.stack.getChannel().closing() && !this.checkFailedToAckMembers(new_view, failedToAck)) {
            return false;
        }
        if (this.joined) {
            String str;
            int oldWeight = 0;
            boolean leadProcessed = false;
            boolean displayWeights = failedWeight > 0 && !Boolean.getBoolean("gemfire.hide-member-weights");
            StringBuffer sb = displayWeights ? new StringBuffer(1000) : null;
            for (IpAddress a : this.view.getMembers()) {
                int thisWeight = a.getMemberWeight();
                if (a.getVmKind() == 10) {
                    thisWeight += 10;
                    if (!leadProcessed) {
                        thisWeight += 5;
                        leadProcessed = true;
                    }
                } else if (a.preferredForCoordinator()) {
                    thisWeight += 3;
                }
                oldWeight += thisWeight;
                if (!displayWeights) continue;
                sb.append("\n").append(JGroupsStrings.GMS_MEMBER_0_HAS_WEIGHT_1.toLocalizedString(a, thisWeight));
            }
            if (sb != null && (str = sb.toString()).length() > 0) {
                this.log.getInternalLogWriter().info(StringId.LITERAL, str);
            }
            int lossThreshold = (int)Math.round((double)(oldWeight * this.partitionThreshold) / 100.0);
            if (failedWeight > 0) {
                this.log.getInternalLogWriter().info(JGroupsStrings.NetworkPartitionDetectionWeightCalculation, new Object[]{oldWeight, failedWeight, this.partitionThreshold, lossThreshold});
                if (failedWeight >= lossThreshold && this.splitBrainDetectionEnabled) {
                    this.networkPartitionDetected = true;
                    this.sendNetworkPartitionWarning(new_view.getMembers());
                    this.quorumLost(failures, this.view);
                    this.forceDisconnect(new Event(46, new ForcedDisconnectException(JGroupsStrings.GMS_EXITING_DUE_TO_POSSIBLE_NETWORK_PARTITION_EVENT_DUE_TO_LOSS_OF_MEMBER_0.toLocalizedString(failures.size(), failures))));
                    return false;
                }
            }
        }
        if (this.log.getInternalLogWriter().fineEnabled()) {
            this.log.getInternalLogWriter().fine("done successfully preparing view " + new_view.getVid());
        }
        return true;
    }

    private boolean checkFailedToAckMembers(View new_view, List<IpAddress> failedToAck) {
        if (failedToAck.size() == 0) {
            return true;
        }
        if (this.log.getInternalLogWriter().infoEnabled()) {
            this.log.getInternalLogWriter().info(JGroupsStrings.CHECKING_UNRESPONSIVE_MEMBERS, new Object[]{failedToAck});
        }
        final FD_SOCK fdSock = (FD_SOCK)this.stack.findProtocol("FD_SOCK");
        if (this.stack.getChannel().closing() && fdSock == null) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("FD_SOCK not found for liveness checks - aborting view " + new_view.getVid());
            }
            return false;
        }
        assert (fdSock != null);
        ExecutorService es = Executors.newFixedThreadPool(failedToAck.size(), new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(LoggingThreadGroup.createThreadGroup(GMS.FAILED_TO_ACK_MEMBER_VERIFY_THREAD, GMS.this.log.getInternalLogWriter()), r, "Failed to ACK member verify Thread-" + this.threadCount.getAndIncrement());
                return th;
            }
        });
        ArrayList<2> al = new ArrayList<2>();
        for (final IpAddress failedAddress : failedToAck) {
            al.add(new Callable<IpAddress>(){
                IpAddress sockAddress;
                {
                    this.sockAddress = fdSock.fetchPingAddress(failedAddress, 0L);
                }

                @Override
                public IpAddress call() throws Exception {
                    if (GMS.this.log.getInternalLogWriter().configEnabled()) {
                        GMS.this.log.getInternalLogWriter().config(JGroupsStrings.SUSPECTING_MEMBER_WHICH_DIDNT_ACK, new Object[]{failedAddress.toString()});
                    }
                    if (this.sockAddress == null) {
                        if (GMS.this.log.getInternalLogWriter().fineEnabled()) {
                            GMS.this.log.getInternalLogWriter().fine("unable to find ping address for " + failedAddress + " - using direct port to verify if it's there");
                        }
                        this.sockAddress = new IpAddress(failedAddress.getIpAddress(), failedAddress.getDirectPort());
                        if (this.sockAddress.getPort() != 0 && fdSock.checkSuspect(failedAddress, this.sockAddress, JGroupsStrings.MEMBER_DID_NOT_ACKNOWLEDGE_VIEW.toLocalizedString(), false, false)) {
                            if (GMS.this.log.getInternalLogWriter().infoEnabled()) {
                                GMS.this.log.getInternalLogWriter().info(JGroupsStrings.ABLE_TO_CONNECT_TO_DC_PORT, new Object[]{failedAddress, this.sockAddress.getPort()});
                            }
                            return failedAddress;
                        }
                    } else if (fdSock.checkSuspect(failedAddress, this.sockAddress, JGroupsStrings.MEMBER_DID_NOT_ACKNOWLEDGE_VIEW.toLocalizedString(), true, false)) {
                        if (GMS.this.log.getInternalLogWriter().infoEnabled()) {
                            GMS.this.log.getInternalLogWriter().info(JGroupsStrings.ABLE_TO_CONNECT_TO_FD_PORT, new Object[]{failedAddress, this.sockAddress.getPort()});
                        }
                        return failedAddress;
                    }
                    return null;
                }
            });
        }
        try {
            if (this.log.getInternalLogWriter().configEnabled()) {
                this.log.getInternalLogWriter().config(JGroupsStrings.CHECKING_FAILED_TO_ACK_MEMBERS, new Object[]{failedToAck.toString()});
            }
            List futures = es.invokeAll(al);
            for (Future future : futures) {
                try {
                    IpAddress ipAddr = (IpAddress)future.get(this.view_ack_collection_timeout + 100L, TimeUnit.MILLISECONDS);
                    if (ipAddr == null) continue;
                    failedToAck.remove(ipAddr);
                }
                catch (ExecutionException e) {
                }
                catch (java.util.concurrent.TimeoutException e) {}
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            es.shutdown();
            es.awaitTermination(this.view_ack_collection_timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!failedToAck.isEmpty()) {
            failedToAck.addAll(new_view.getSuspectedMembers());
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("invoking handleLeave with " + failedToAck + ".  My membership is " + this.members.getMembers());
            }
            this.impl.handleLeave(failedToAck, true, Collections.singletonList(JGroupsStrings.MEMBER_DID_NOT_ACKNOWLEDGE_VIEW.toLocalizedString()), true);
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("done casting view " + new_view.getVid());
            }
            return false;
        }
        return true;
    }

    public static int processFailuresAndGetWeight(View lastView, Address leader, Collection failures) {
        int failedWeight = 0;
        Iterator it = failures.iterator();
        while (it.hasNext()) {
            IpAddress addr = (IpAddress)it.next();
            if (!lastView.getMembers().contains(addr)) continue;
            failedWeight += addr.getMemberWeight();
            if (addr.getVmKind() != 10) {
                if (addr.preferredForCoordinator()) {
                    failedWeight += 3;
                }
                it.remove();
                continue;
            }
            failedWeight += 10;
        }
        if (leader != null && failures.contains(leader)) {
            failedWeight += 5;
        }
        return failedWeight;
    }

    private void quorumLost(final Set failures, final View currentView) {
        Thread notificationThread = new Thread(GemFireTracer.GROUP, "Quorum Lost Notification"){

            @Override
            public void run() {
                ArrayList remaining = new ArrayList(currentView.getMembers().size());
                remaining.addAll(currentView.getMembers());
                remaining.removeAll(failures);
                try {
                    GMS.this.stack.jgmm.quorumLost(failures, remaining);
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        };
        notificationThread.setDaemon(true);
        notificationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processPreparedView(View pView, View new_view, List newMbrs, boolean mcast) {
        View prevView = this.previousPreparedView;
        if (!(pView == null || pView.getCreator().equals(this.local_addr) || pView.getVid().compare(this.view.getVid()) <= 0 || prevView != null && pView.getVid().compare(prevView.getVid()) <= 0)) {
            this.previousPreparedView = pView;
            Vector<Address> newMembersFromPView = new Vector<Address>();
            Vector<Address> newFailuresFromPView = new Vector<Address>();
            Vector<Address> newLeavingFromPView = new Vector<Address>();
            Object object = this.members;
            synchronized (object) {
                if (this.log.getInternalLogWriter().infoEnabled()) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.RECEIVED_PREVIOUSLY_PREPARED_VIEW, pView);
                }
                HashSet allFailures = new HashSet(this.leaving);
                for (Address a : pView.getMembers()) {
                    if (allFailures.contains(a)) continue;
                    newMembersFromPView.add(a);
                }
                for (Address a : pView.getSuspectedMembers()) {
                    if (allFailures.contains(a)) continue;
                    newFailuresFromPView.add(a);
                }
                for (Address a : newMbrs) {
                    if (pView.containsMember(a)) continue;
                    newLeavingFromPView.add(a);
                }
            }
            if (!(newMembersFromPView.isEmpty() && newFailuresFromPView.isEmpty() && newLeavingFromPView.isEmpty())) {
                newFailuresFromPView.addAll(new_view.getSuspectedMembers());
                object = this.prepare_collector;
                synchronized (object) {
                    this.prepare_collector.fullyReset();
                }
                this.castViewChange(newMembersFromPView, newLeavingFromPView, newFailuresFromPView, mcast);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IpAddress> sendPrepareForViewChange(View newView, Collection<IpAddress> mbrs, boolean mcast) {
        List missing;
        int size2 = -1;
        ViewId vid = newView.getVid();
        AckCollector ackCollector = this.prepare_collector;
        synchronized (ackCollector) {
            this.prepare_collector.reset(vid, mbrs);
            size2 = this.prepare_collector.size();
        }
        boolean timedout = false;
        GmsHeader hdr = new GmsHeader(14);
        if (mcast) {
            Message view_change_msg = new Message();
            view_change_msg.setObject(newView);
            view_change_msg.isHighPriority = true;
            view_change_msg.putHeader(name, hdr);
            this.passDown(new Event(1, view_change_msg));
        } else {
            for (IpAddress dest : mbrs) {
                if (dest.equals(this.local_addr)) {
                    AckCollector ackCollector2 = this.prepare_collector;
                    synchronized (ackCollector2) {
                        this.prepare_collector.ack(dest, null);
                        continue;
                    }
                }
                Message msg = new Message();
                msg.isHighPriority = true;
                msg.putHeader(name, hdr);
                msg.setObject(newView);
                msg.setDest(dest);
                this.passDown(new Event(1, msg));
            }
        }
        try {
            this.prepare_collector.waitForAllAcks(this.view_ack_collection_timeout);
        }
        catch (TimeoutException e) {
            timedout = true;
        }
        String receivedStr = null;
        boolean logMissing = false;
        AckCollector ackCollector3 = this.prepare_collector;
        synchronized (ackCollector3) {
            missing = this.prepare_collector.getMissingAcks();
            missing.addAll(this.prepare_collector.getSuspectedMembers());
            missing.removeAll(newView.getSuspectedMembers());
            missing.remove(this.local_addr);
            Iterator it = missing.iterator();
            while (it.hasNext()) {
                IpAddress addr = (IpAddress)it.next();
                if (newView.containsMember(addr) && !this.stack.jgmm.isShuttingDown(addr)) continue;
                it.remove();
            }
            boolean bl = logMissing = missing.size() > 0;
            if (logMissing) {
                receivedStr = this.prepare_collector.getReceived().toString();
            }
        }
        if (logMissing && !this.stack.getChannel().closing()) {
            String missingStr = missing.toString();
            this.log.getInternalLogWriter().warning(JGroupsStrings.GMS_FAILED_TO_COLLECT_ALL_ACKS_0_FOR_VIEW_PREPARATION_1_AFTER_2_MS_MISSING_ACKS_FROM_3_RECEIVED_4_LOCAL_ADDR_5, new Object[]{size2, newView, this.view_ack_collection_timeout, missingStr, receivedStr, this.local_addr});
        }
        return missing;
    }

    void sendNetworkPartitionWarning(Collection<IpAddress> mbrs) {
        GmsHeader hdr = new GmsHeader(16);
        for (IpAddress dest : mbrs) {
            Message msg = new Message();
            msg.isHighPriority = true;
            msg.putHeader(name, hdr);
            msg.setDest(dest);
            this.passDown(new Event(1, msg));
        }
        try {
            Thread.sleep(this.leave_timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void suspect(List suspects) {
        this.passDown(new Event(1005, suspects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuspectToCollectors(Address addr) {
        AckCollector ackCollector = this.ack_collector;
        synchronized (ackCollector) {
            this.ack_collector.suspect(addr);
        }
        ackCollector = this.prepare_collector;
        synchronized (ackCollector) {
            this.prepare_collector.suspect(addr);
        }
    }

    public void installView(View new_view, Digest digest) {
        if (digest != null) {
            this.mergeDigest(digest);
        }
        this.installView(new_view);
    }

    public static int getWeight(Collection ids, Address leader) {
        int weight = 0;
        for (IpAddress addr : ids) {
            int thisWeight = addr.getMemberWeight();
            if (addr.getVmKind() == 10) {
                thisWeight += 10;
                if (leader != null && addr.equals(leader)) {
                    thisWeight += 5;
                }
            } else if (addr.preferredForCoordinator()) {
                thisWeight += 3;
            }
            weight += thisWeight;
        }
        return weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installView(View new_view) {
        int rc;
        ViewId vid = new_view.getVid();
        Vector mbrs = new_view.getMembers();
        if (this.networkPartitionDetected) {
            return;
        }
        this.preparedView = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("[local_addr=" + this.local_addr + "] view is " + new_view);
        }
        if (this.stats) {
            ++this.num_views;
            this.prev_views.add(new_view);
        }
        if (this.view_id != null && (rc = vid.compareTo(this.view_id)) <= 0) {
            if (this.log.isTraceEnabled() && rc < 0) {
                this.log.trace("[" + this.local_addr + "] received view < current view;" + " discarding it (current vid: " + this.view_id + ", new vid: " + vid + ')');
            }
            return;
        }
        this.ltime = Math.max(vid.getId(), this.ltime);
        if (!this.checkSelfInclusion(mbrs)) {
            if (this.shun && this.local_addr != null && this.prev_members.contains(this.local_addr)) {
                if (this.warn) {
                    this.log.warn("I (" + this.local_addr + ") am not a member of view " + new_view + ", shunning myself and leaving the group (prev_members are " + this.prev_members + ", current view is " + this.view + ")");
                }
                if (this.impl != null) {
                    this.impl.handleExit();
                }
                this.networkPartitionDetected = true;
                this.passUp(new Event(46, new ForcedDisconnectException("This member has been forced out of the distributed system by " + new_view.getCreator() + ".  Please consult GemFire logs to find the reason. (GMS shun)")));
            } else if (this.warn) {
                this.log.warn("I (" + this.local_addr + ") am not a member of view " + new_view + "; discarding view");
            }
            return;
        }
        Object object = this.installViewLock;
        synchronized (object) {
            Membership membership = this.members;
            synchronized (membership) {
                if (this.view != null) {
                    int lossThreshold;
                    int oldWeight = GMS.getWeight(this.view.getMembers(), this.leader);
                    int failedWeight = GMS.getWeight(new_view.getSuspectedMembers(), this.leader);
                    if (failedWeight >= (lossThreshold = (int)Math.round((double)(oldWeight * this.partitionThreshold) / 100.0))) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "old membership weight=" + oldWeight + ", loss threshold=" + lossThreshold + " and failed weight=" + failedWeight);
                        this.quorumLost(new_view.getSuspectedMembers(), this.view);
                    }
                }
                this.view = new_view instanceof MergeView ? new View(new_view.getVid(), new_view.getMembers()) : new_view;
                this.view_id = vid.copy();
                Address oldLead = this.leader;
                this.leader = this.view.getLeadMember();
                if (!(this.leader == null || oldLead != null && oldLead.equals(this.leader))) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.GMS_MEMBERSHIP_LEADER_MEMBER_IS_NOW_0, this.leader);
                }
                if (mbrs != null && mbrs.size() > 0) {
                    this.members.set(mbrs);
                    this.coordinator = this.members.getCoordinator();
                    this.tmp_members.set(this.members);
                    this.joining.removeAll(mbrs);
                    this.leaving.retainAll(mbrs);
                    this.tmp_members.add(this.joining);
                    this.tmp_members.remove(this.leaving);
                    for (Address addr : mbrs) {
                        if (this.prev_members.contains(addr)) continue;
                        this.prev_members.add(addr);
                    }
                }
                Event view_event = new Event(6, new_view.clone());
                this.passDown(view_event);
                this.passUp(view_event);
            }
            Address coord = this.determineCoordinator();
            if (coord != null && coord.equals(this.local_addr) && !this.haveCoordinatorRole()) {
                Vector suspects = this.haveParticipantRole() ? ((ParticipantGmsImpl)this.impl).getSuspects() : new Vector();
                this.becomeCoordinator(suspects);
                coord = this.local_addr;
            } else if (this.haveCoordinatorRole() && !this.local_addr.equals(coord)) {
                this.becomeParticipant();
            }
            if (coord != null) {
                this.notifyOfCoordinator(coord);
            }
        }
    }

    void forceDisconnect(final Event exitEvent) {
        this.networkPartitionDetected = true;
        Thread tilt = new Thread(Thread.currentThread().getThreadGroup(), "GMS Network Partition Event"){

            @Override
            public void run() {
                GMS.this.passDown(exitEvent);
                GMS.this.passUp(exitEvent);
            }
        };
        tilt.start();
    }

    public Address determineCoordinator() {
        return this.coordinator;
    }

    public Address getLeadMember() {
        return this.leader;
    }

    public int getPartitionThreshold() {
        return this.partitionThreshold;
    }

    public View getLastView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        if (potential_new_coord == null) {
            return false;
        }
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members.size() < 2) {
                return false;
            }
            return this.members.wouldBeNewCoordinator(potential_new_coord);
        }
    }

    protected boolean checkSelfInclusion(Vector mbrs) {
        if (mbrs == null) {
            return false;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Object mbr = mbrs.elementAt(i);
            if (mbr == null || !this.local_addr.equals(mbr)) continue;
            return true;
        }
        return false;
    }

    public void setDigest(Digest d) {
        this.passDown(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.passDown(new Event(53, d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Digest getDigest() {
        Digest ret = null;
        Object object = this.digest_mutex;
        synchronized (object) {
            block5: {
                this.digest_promise.reset();
                this.passDown(Event.GET_DIGEST_EVT);
                try {
                    ret = (Digest)this.digest_promise.getResultWithTimeout(this.digest_timeout);
                }
                catch (TimeoutException e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error(JGroupsStrings.GMS_DIGEST_COULD_NOT_BE_FETCHED_FROM_BELOW);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Object obj = msg.getHeader(name);
                if (obj == null || !(obj instanceof GmsHeader)) break;
                GmsHeader hdr = (GmsHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        if (this.haveCoordinatorRole()) {
                            IpAddress iaddr = (IpAddress)hdr.mbr;
                            if (iaddr.getBirthViewId() >= 0 && this.stack.jgmm.isShunnedMemberNoSync(iaddr)) {
                                this.log.getInternalLogWriter().info(JGroupsStrings.COORDGMSIMPL_REJECTING_0_DUE_TO_REUSED_IDENTITY, hdr.mbr);
                                ((CoordGmsImpl)this.getImpl()).sendJoinResponse(new JoinRsp("[internal]Your address is shunned"), hdr.mbr, false);
                                return;
                            }
                            if (this.members.contains(hdr.mbr)) {
                                IpAddress hmbr = (IpAddress)hdr.mbr;
                                for (IpAddress addr : this.members.getMembers()) {
                                    if (!addr.equals(hdr.mbr)) continue;
                                    if (addr.getUniqueID() == hmbr.getUniqueID()) break;
                                    this.log.getInternalLogWriter().info(JGroupsStrings.COORDGMSIMPL_REJECTING_0_DUE_TO_REUSED_IDENTITY, hdr.mbr);
                                    ((CoordGmsImpl)this.getImpl()).sendJoinResponse(new JoinRsp("[internal]Your address is shunned"), hdr.mbr, false);
                                    return;
                                }
                                this.getImpl().handleAlreadyJoined(hdr.mbr);
                                return;
                            }
                        }
                        if (hdr.mbr.getVersionOrdinal() > 0 && hdr.mbr.getVersionObject().compareTo(Version.CURRENT) < 0) {
                            this.log.getInternalLogWriter().warning(JGroupsStrings.COORD_REJECTING_OLD_MEMBER_BECAUSE_UPGRADE_HAS_BEGUN, new Object[]{hdr.mbr});
                            ((CoordGmsImpl)this.getImpl()).sendJoinResponse(new JoinRsp(JGroupsStrings.COORD_REJECTING_OLD_MEMBER_BECAUSE_UPGRADE_HAS_BEGUN.toLocalizedString(hdr.mbr)), hdr.mbr, false);
                            return;
                        }
                        this.view_handler.add(new Request(1, hdr.mbr, false, null));
                        break;
                    }
                    case 2: {
                        this.impl.handleJoinResponse((JoinRsp)msg.getObject());
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("received LEAVE_REQ for " + hdr.mbr + " from " + msg.getSrc());
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.GMS_LEAVE_REQS_MBR_FIELD_IS_NULL);
                            }
                            return;
                        }
                        AckCollector iaddr = this.ack_collector;
                        synchronized (iaddr) {
                            this.ack_collector.ack(hdr.mbr, null);
                        }
                        iaddr = this.prepare_collector;
                        synchronized (iaddr) {
                            this.prepare_collector.ack(hdr.mbr, null);
                        }
                        this.view_handler.add(new Request(2, hdr.mbr, false, null));
                        break;
                    }
                    case 4: {
                        if (hdr.arg != null && hdr.mbr != null && !hdr.mbr.equals(this.local_addr)) break;
                        this.impl.handleLeaveResponse(hdr.arg);
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("REMOVE_REQ's mbr field is null");
                            }
                            return;
                        }
                        if (!this.members.contains(msg.getSrc())) break;
                        if (msg.getSrc().equals(hdr.mbr) && this.log.isDebugEnabled()) {
                            this.log.debug("received REMOVE_REQ for " + hdr.mbr + " from " + msg.getSrc() + (hdr.arg == null ? "" : " Reason=" + hdr.arg));
                        } else {
                            this.log.getInternalLogWriter().warning(JGroupsStrings.GMS_MEMBERSHIP_RECEIVED_REQUEST_TO_REMOVE_0_FROM_1_2, new Object[]{hdr.mbr, msg.getSrc(), hdr.arg == null ? "" : " Reason=" + hdr.arg});
                        }
                        this.view_handler.add(new Request(2, hdr.mbr, true, null, hdr.arg));
                        break;
                    }
                    case 5: {
                        Address coord = msg.getSrc();
                        Message view_ack = new Message(coord, null, null);
                        view_ack.isHighPriority = true;
                        View v = (View)msg.getObject();
                        GmsHeader tmphdr = new GmsHeader(10);
                        view_ack.putHeader(name, tmphdr);
                        view_ack.setObject(v);
                        if (this.local_addr.getBirthViewId() < 0) {
                            view_ack.putHeader("NO_UCAST", tmphdr);
                        }
                        this.passDown(new Event(1, view_ack));
                        if (v == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.GMS_VIEW_VIEW__NULL);
                            }
                            return;
                        }
                        if (this.impl == null || this.impl instanceof ClientGmsImpl || v.getVid().compareTo(this.view_id) <= 0 || this.stack.getChannel().closing()) break;
                        this.log.getInternalLogWriter().info(JGroupsStrings.GMS_MEMBERSHIP_RECEIVED_NEW_VIEW__0, v);
                        this.impl.handleViewChange(v, v.getMessageDigest());
                        break;
                    }
                    case 10: {
                        View v;
                        Address sender = msg.getSrc();
                        if (trace) {
                            this.log.trace("Received VIEW_ACK from " + sender);
                        }
                        ViewId vid = (v = (View)msg.getObject()) == null ? null : v.getVid();
                        AckCollector ackCollector = this.ack_collector;
                        synchronized (ackCollector) {
                            this.ack_collector.ack(sender, vid);
                        }
                        return;
                    }
                    case 14: {
                        View v = (View)msg.getObject();
                        if (trace) {
                            this.log.trace("Received PREPARE_FOR_VIEW from " + msg.getSrc() + " for view " + v);
                        }
                        GmsHeader responseHeader = new GmsHeader(15);
                        View responseView = null;
                        if (!msg.getSrc().equals(this.local_addr)) {
                            if (this.preparedView != null && !v.getCreator().equals(this.preparedView.getCreator())) {
                                responseView = this.preparedView;
                                this.preparedView = null;
                            } else {
                                this.preparedView = v;
                            }
                        }
                        Message m = new Message(true);
                        m.putHeader(name, responseHeader);
                        m.setDest(msg.getSrc());
                        m.setObject(responseView);
                        this.passDown(new Event(1, m));
                        return;
                    }
                    case 15: {
                        Object preparedViewString;
                        Address sender = msg.getSrc();
                        View v = (View)msg.getObject();
                        if (trace) {
                            preparedViewString = v == null ? "" : " with conflicting view " + v;
                            this.log.trace("Received PREPARE_FOR_VIEW_ACK from " + sender + (String)preparedViewString);
                        }
                        ViewId vid = null;
                        if (v != null) {
                            this.preparedView = v;
                            vid = v.getVid();
                        }
                        preparedViewString = this.prepare_collector;
                        synchronized (preparedViewString) {
                            this.prepare_collector.ack(sender, vid);
                        }
                        return;
                    }
                    case 16: {
                        this.forceDisconnect(new Event(46, new ForcedDisconnectException(JGroupsStrings.COORDINATOR_DECLARED_NETWORK_PARTITION_EVENT.toLocalizedString(msg.getSrc()))));
                        return;
                    }
                    case 11: {
                        View msgView = this.view;
                        if (msgView == null) break;
                        Message viewRsp = new Message();
                        JoinRsp vrsp = new JoinRsp(msgView, this.getDigest());
                        GmsHeader ghdr = new GmsHeader(12);
                        viewRsp.putHeader(name, ghdr);
                        viewRsp.setDest(msg.getSrc());
                        viewRsp.setObject(vrsp);
                        this.passDown(new Event(1, viewRsp));
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Sending membership view to " + viewRsp.getDest() + ": " + msgView);
                        break;
                    }
                    case 12: {
                        this.impl.handleGetViewResponse((JoinRsp)msg.getObject());
                        break;
                    }
                    case 6: {
                        this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id);
                        break;
                    }
                    case 7: {
                        View theView = (View)msg.getObject();
                        MergeData merge_data = new MergeData(msg.getSrc(), theView, theView.getMessageDigest());
                        merge_data.merge_rejected = hdr.merge_rejected;
                        this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                        break;
                    }
                    case 8: {
                        View theView = (View)msg.getObject();
                        this.impl.handleMergeView(new MergeData(msg.getSrc(), theView, theView.getMessageDigest()), hdr.merge_id);
                        break;
                    }
                    case 9: {
                        this.impl.handleMergeCancelled(hdr.merge_id);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(JGroupsStrings.GMS_GMSHEADER_WITH_TYPE_0__NOT_KNOWN, hdr.type);
                    }
                }
                return;
            }
            case 3: 
            case 5: {
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (this.local_addr instanceof IpAddress) {
                    ((IpAddress)this.local_addr).splitBrainEnabled(this.splitBrainDetectionEnabled);
                    ((IpAddress)this.local_addr).setMemberWeight(this.memberWeight);
                }
                this.notifyOfLocalAddress(this.local_addr);
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                break;
            }
            case 9: {
                SuspectMember sm = (SuspectMember)evt.getArg();
                Address suspected = sm.suspectedMember;
                if (!this.members.containsExt(suspected)) break;
                this.view_handler.add(new Request(2, suspected, true, null, "did not respond to are-you-dead messages"));
                this.addSuspectToCollectors(suspected);
                break;
            }
            case 1009: {
                Address addr = (Address)evt.getArg();
                this.view_handler.add(new Request(2, addr, false, null, "closed connection to FD_SOCK watcher"));
                this.addSuspectToCollectors(addr);
                break;
            }
            case 51: {
                Address suspected = (Address)evt.getArg();
                this.impl.unsuspect(suspected);
                this.addSuspectToCollectors(suspected);
                return;
            }
            case 14: {
                this.view_handler.add(new Request(4, null, false, (Vector)evt.getArg()));
                return;
            }
            case 1002: {
                this.disable_initial_coord = false;
                return;
            }
            case 1004: {
                boolean warning = true;
                if (!this.floatingCoordinatorDisabled) {
                    this.floatingCoordinatorDisabled = true;
                    this.log.getInternalLogWriter().info(JGroupsStrings.GMS_LOCATOR_HAS_DISABLED_FLOATING_MEMBERSHIP_COORDINATION);
                } else {
                    warning = false;
                }
                if (!Locator.hasLocator()) {
                    if (warning) {
                        this.log.getInternalLogWriter().fine("This member of the distributed system will only be a coordinator if there are no locators available");
                    }
                    ((IpAddress)this.local_addr).shouldntBeCoordinator(true);
                    Event newaddr = new Event(8, this.local_addr);
                    this.passUp(newaddr);
                    this.passDown(newaddr);
                } else if (warning && this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("This VM hosts a locator and is preferred as membership coordinator.  Locators=" + Locator.getLocators());
                }
                return;
            }
            case 1010: {
                this.splitBrainDetectionEnabled = true;
                this.stack.jgmm.enableNetworkPartitionDetection();
                return;
            }
            case 40: {
                this.digest_promise.setResult(evt.getArg());
                return;
            }
        }
        if (this.impl.handleUpEvent(evt)) {
            this.passUp(evt);
        }
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 2: {
                RuntimeException joinException = null;
                this.passDown(evt);
                if (this.local_addr == null && this.log.isFatalEnabled()) {
                    this.log.fatal("[CONNECT] local_addr is null");
                }
                this.joined = false;
                try {
                    this.joined = this.impl.join(this.local_addr);
                }
                catch (ShunnedAddressException e) {
                    joinException = e;
                }
                catch (SystemConnectException e) {
                    joinException = e;
                }
                catch (AuthenticationFailedException e) {
                    joinException = e;
                }
                catch (GemFireConfigException e) {
                    joinException = e;
                }
                if (trace) {
                    this.log.trace("GMS join returned " + this.joined);
                }
                if (this.joined) {
                    Event OK = new Event(3);
                    this.passUp(OK);
                    this.passDown(OK);
                } else {
                    if (joinException == null) {
                        joinException = new SystemConnectException("Attempt to connect to distributed system timed out");
                    }
                    if (this.log.getInternalLogWriter().fineEnabled()) {
                        this.log.getInternalLogWriter().fine("Startup is throwing " + joinException);
                    }
                    if (Boolean.getBoolean("debugSystemConnectException")) {
                        this.log.getInternalLogWriter().warning(JGroupsStrings.DEBUG, "Startup is throwing an exception and has logged thread dumps", (Throwable)joinException);
                        OSProcess.printStacks(0);
                    }
                    this.passUp(new Event(46, joinException));
                }
                if (trace) {
                    this.log.trace("GMS connect completed");
                }
                return;
            }
            case 4: {
                Event disconnecting = new Event(1007);
                this.passUp(disconnecting);
                this.passDown(disconnecting);
                this.impl.leave((Address)evt.getArg());
                this.disconnected = true;
                this.passUp(new Event(5));
            }
        }
        this.passDown(evt);
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("shun");
        if (str != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("merge_leader")) != null) {
            this.merge_leader = Boolean.valueOf(str);
            props.remove("merge_leader");
        }
        if ((str = props.getProperty("print_local_addr")) != null) {
            this.print_local_addr = Boolean.valueOf(str);
            props.remove("print_local_addr");
        }
        if ((str = props.getProperty("join_timeout")) != null) {
            this.join_timeout = Long.parseLong(str);
            props.remove("join_timeout");
        }
        if ((str = props.getProperty("join_retry_timeout")) != null) {
            this.join_retry_timeout = Long.parseLong(str);
            props.remove("join_retry_timeout");
        }
        if ((str = props.getProperty("leave_timeout")) != null) {
            this.leave_timeout = Long.parseLong(str);
            props.remove("leave_timeout");
        }
        if ((str = props.getProperty("merge_timeout")) != null) {
            this.merge_timeout = Long.parseLong(str);
            props.remove("merge_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.digest_timeout = Long.parseLong(str);
            props.remove("digest_timeout");
        }
        if ((str = props.getProperty("view_ack_collection_timeout")) != null) {
            this.view_ack_collection_timeout = Long.parseLong(str);
            props.remove("view_ack_collection_timeout");
        }
        if ((str = props.getProperty("resume_task_timeout")) != null) {
            this.resume_task_timeout = Long.parseLong(str);
            props.remove("resume_task_timeout");
        }
        if ((str = props.getProperty("disable_initial_coord")) != null) {
            this.disable_initial_coord = Boolean.valueOf(str);
            props.remove("disable_initial_coord");
        }
        if (Boolean.getBoolean("p2p.enableInitialCoordinator")) {
            this.disable_initial_coord = false;
        }
        if ((str = props.getProperty("split-brain-detection")) != null) {
            this.splitBrainDetectionEnabled = Boolean.valueOf(str);
            props.remove("split-brain-detection");
        }
        str = props.getProperty("partition-threshold");
        int l = 51;
        if (str != null) {
            l = Integer.parseInt(str);
            props.remove("partition-threshold");
        }
        this.partitionThreshold = l;
        str = props.getProperty("member-weight");
        l = 0;
        if (str != null) {
            l = Integer.parseInt(str);
            props.remove("member-weight");
        }
        this.memberWeight = l;
        str = props.getProperty("handle_concurrent_startup");
        if (str != null) {
            this.handle_concurrent_startup = Boolean.valueOf(str);
            props.remove("handle_concurrent_startup");
        }
        if ((str = props.getProperty("num_prev_mbrs")) != null) {
            this.num_prev_mbrs = Integer.parseInt(str);
            props.remove("num_prev_mbrs");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.GMS_GMSSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    void initState() {
        this.becomeClient();
        this.view_id = null;
        this.view = null;
        this.leader = null;
    }

    protected void notifyOfCoordinator(Address coord) {
        List<Locator> locators = Locator.getLocators();
        for (Locator locator : locators) {
            GossipServer gs = ((InternalLocator)locator).getGossipServer();
            if (gs == null) continue;
            gs.setCoordinator(coord);
        }
    }

    protected void notifyOfLocalAddress(Address localAddress) {
        List<Locator> locators = Locator.getLocators();
        for (Locator locator : locators) {
            GossipServer gs = ((InternalLocator)locator).getGossipServer();
            if (gs == null) continue;
            gs.setLocalAddress(localAddress);
        }
    }

    static {
        BUNDLE_WAITTIME = Integer.getInteger("gemfire.VIEW_BUNDLING_WAIT_TIME", 150).intValue();
    }

    static class Resumer
    implements TimeScheduler.CancellableTask {
        boolean cancelled = false;
        long interval;
        final Object token;
        final Map tasks;
        final ViewHandler handler;

        public Resumer(long interval, Object token, Map t, ViewHandler handler) {
            this.interval = interval;
            this.token = token;
            this.tasks = t;
            this.handler = handler;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }

        @Override
        public long nextInterval() {
            return this.interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean execute = true;
            Map map = this.tasks;
            synchronized (map) {
                TimeScheduler.CancellableTask t = (TimeScheduler.CancellableTask)this.tasks.get(this.token);
                if (t != null) {
                    t.cancel();
                    execute = true;
                } else {
                    execute = false;
                }
                this.tasks.remove(this.token);
            }
            if (execute) {
                this.handler.resume(this.token);
            }
        }
    }

    class ViewHandler
    implements Runnable {
        Thread viewThread;
        Queue q = new Queue();
        boolean suspended = false;
        static final long INTERVAL = 5000L;
        private static final long MAX_COMPLETION_TIME = 10000L;
        private final BoundedList history = new BoundedList(20);
        private final Map resume_tasks = new HashMap();
        private Object merge_id = null;

        ViewHandler() {
        }

        void add(Request req) {
            this.add(req, false, false);
        }

        synchronized void add(Request req, boolean at_head, boolean unsuspend) {
            block5: {
                if (this.suspended && !unsuspend) {
                    GMS.this.log.warn("queue is suspended; request " + req + " is discarded");
                    return;
                }
                this.start(unsuspend);
                try {
                    if (at_head) {
                        this.q.addAtHead(req);
                    } else {
                        this.q.add(req);
                    }
                    this.history.add(new Date() + ": " + req.toString());
                }
                catch (QueueClosedException e) {
                    if (!Protocol.trace) break block5;
                    GMS.this.log.trace("queue is closed; request " + req + " is discarded");
                }
            }
        }

        synchronized void waitUntilCompleted(long timeout) {
            if (this.viewThread != null) {
                try {
                    this.viewThread.join(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public synchronized void suspend(Object m_id) {
            if (this.suspended) {
                return;
            }
            this.suspended = true;
            this.merge_id = m_id;
            this.q.clear();
            this.waitUntilCompleted(10000L);
            this.q.close(true);
            if (Protocol.trace) {
                GMS.this.log.trace("suspended ViewHandler");
            }
            Resumer r = new Resumer(GMS.this.resume_task_timeout, m_id, this.resume_tasks, this);
            this.resume_tasks.put(m_id, r);
            GMS.this.timer.add(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void resume(Object m_id) {
            if (!this.suspended) {
                return;
            }
            boolean same_merge_id = this.merge_id != null && m_id != null && this.merge_id.equals(m_id);
            boolean bl = same_merge_id = same_merge_id || this.merge_id == null && m_id == null;
            if (!same_merge_id) {
                if (GMS.this.warn) {
                    GMS.this.log.warn("resume(" + m_id + ") does not match " + this.merge_id + ", ignoring resume()");
                }
                return;
            }
            Map map = this.resume_tasks;
            synchronized (map) {
                TimeScheduler.CancellableTask task = (TimeScheduler.CancellableTask)this.resume_tasks.get(m_id);
                if (task != null) {
                    task.cancel();
                    this.resume_tasks.remove(m_id);
                }
            }
            this.resumeForce();
        }

        public synchronized void resumeForce() {
            if (this.q.closed()) {
                this.q.reset();
            }
            this.suspended = false;
            if (Protocol.trace) {
                GMS.this.log.trace("resumed ViewHandler");
            }
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (this.q.closed() || Thread.currentThread().isInterrupted()) break;
                try {
                    Request req = (Request)this.q.remove(5000L);
                    this.process(req);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    return;
                }
                catch (QueueClosedException e) {
                }
                catch (TimeoutException e) {
                    continue;
                }
                break;
            }
            if (Protocol.trace) {
                GMS.this.log.trace("ViewHandler is exiting");
            }
        }

        public int size() {
            return this.q.size();
        }

        public boolean suspended() {
            return this.suspended;
        }

        public String dumpQueue() {
            StringBuffer sb = new StringBuffer();
            LinkedList v = this.q.values();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + "\n");
            }
            return sb.toString();
        }

        public String dumpHistory() {
            StringBuffer sb = new StringBuffer();
            Enumeration en = this.history.elements();
            while (en.hasMoreElements()) {
                sb.append(en.nextElement() + "\n");
            }
            return sb.toString();
        }

        private void process(Request reqp) {
            ArrayList<Address> joinReqs = new ArrayList<Address>();
            ArrayList<Address> leaveReqs = new ArrayList<Address>();
            ArrayList<Address> suspectReqs = new ArrayList<Address>();
            ArrayList<String> suspectReasons = new ArrayList<String>();
            boolean loop = true;
            long waittime = BUNDLE_WAITTIME;
            long starttime = System.currentTimeMillis();
            Request req = reqp;
            while (loop) {
                if (Protocol.trace) {
                    GMS.this.log.trace("processing " + req);
                }
                switch (req.type) {
                    case 1: {
                        if (joinReqs.contains(req.mbr)) break;
                        joinReqs.add(req.mbr);
                        break;
                    }
                    case 2: {
                        if (req.suspected) {
                            if (suspectReqs.contains(req.mbr)) break;
                            suspectReqs.add(req.mbr);
                            suspectReasons.add(req.reason);
                            break;
                        }
                        if (leaveReqs.contains(req.mbr)) break;
                        leaveReqs.add(req.mbr);
                        break;
                    }
                    case 4: {
                        GMS.this.impl.merge(req.coordinators);
                        loop = false;
                        break;
                    }
                    case 5: {
                        boolean mcast = GMS.this.stack.jgmm.getDistributionConfig().getMcastPort() > 0;
                        GMS.this.castViewChangeWithDest(req.view, req.digest, req.target_members, mcast);
                        loop = false;
                        break;
                    }
                    default: {
                        GMS.this.log.error(JGroupsStrings.GMS_REQUEST__0__IS_UNKNOWN_DISCARDED, req.type);
                        loop = false;
                    }
                }
                if (waittime <= 0L) {
                    loop = false;
                }
                if (!loop) continue;
                boolean ignoreTimeout = false;
                try {
                    Request addl = (Request)this.q.peek(waittime);
                    if (addl.type == 1 || addl.type == 2) {
                        try {
                            req = (Request)this.q.remove();
                            ignoreTimeout = true;
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (TimeoutException e) {
                    loop = ignoreTimeout;
                }
                catch (QueueClosedException e) {
                    loop = ignoreTimeout;
                }
                if (ignoreTimeout || (waittime -= System.currentTimeMillis() - starttime) > 0L) continue;
                loop = false;
            }
            if (!(joinReqs.isEmpty() && leaveReqs.isEmpty() && suspectReqs.isEmpty())) {
                GMS.this.impl.handleJoinsAndLeaves(joinReqs, leaveReqs, suspectReqs, suspectReasons, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start(boolean unsuspend) {
            if (this.q.closed()) {
                this.q.reset();
            }
            if (unsuspend) {
                this.suspended = false;
                Map map = this.resume_tasks;
                synchronized (map) {
                    TimeScheduler.CancellableTask task = (TimeScheduler.CancellableTask)this.resume_tasks.get(this.merge_id);
                    if (task != null) {
                        task.cancel();
                        this.resume_tasks.remove(this.merge_id);
                    }
                }
            }
            this.merge_id = null;
            if (this.viewThread == null || !this.viewThread.isAlive()) {
                this.viewThread = new Thread(GemFireTracer.GROUP, this, "ViewHandler");
                this.viewThread.setDaemon(true);
                this.viewThread.start();
                if (Protocol.trace) {
                    GMS.this.log.trace("ViewHandler started");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop(boolean flush) {
            this.q.close(flush);
            if (this.viewThread != null && this.viewThread.isAlive()) {
                this.viewThread.interrupt();
            }
            this.viewThread = null;
            Map map = this.resume_tasks;
            synchronized (map) {
                for (TimeScheduler.CancellableTask task : this.resume_tasks.values()) {
                    task.cancel();
                }
                this.resume_tasks.clear();
            }
            this.merge_id = null;
            this.resumeForce();
        }
    }

    public static class Request {
        static final int JOIN = 1;
        static final int LEAVE = 2;
        static final int SUSPECT = 3;
        static final int MERGE = 4;
        static final int VIEW = 5;
        int type = -1;
        Address mbr = null;
        boolean suspected;
        Vector coordinators = null;
        View view = null;
        Digest digest = null;
        List target_members = null;
        String reason;

        Request(int type) {
            this.type = type;
        }

        Request(int type, Address mbr, boolean suspected, Vector coordinators) {
            this.type = type;
            this.mbr = mbr;
            this.suspected = suspected;
            this.coordinators = coordinators;
        }

        Request(int type, Address mbr, boolean suspected, Vector coordinators, String reason) {
            this.type = type;
            this.mbr = mbr;
            this.suspected = suspected;
            this.coordinators = coordinators;
            this.reason = reason;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "JOIN(" + this.mbr + ")";
                }
                case 2: {
                    return "LEAVE(" + this.mbr + ", " + this.suspected + ")";
                }
                case 3: {
                    return "SUSPECT(" + this.mbr + ")";
                }
                case 4: {
                    return "MERGE(" + this.coordinators + ")";
                }
                case 5: {
                    return "VIEW (" + this.view.getVid() + ")";
                }
            }
            return "<invalid (type=" + this.type + ")";
        }
    }

    public static class GmsHeader
    extends Header
    implements Streamable {
        public static final byte JOIN_REQ = 1;
        public static final byte JOIN_RSP = 2;
        public static final byte LEAVE_REQ = 3;
        public static final byte LEAVE_RSP = 4;
        public static final byte VIEW = 5;
        public static final byte MERGE_REQ = 6;
        public static final byte MERGE_RSP = 7;
        public static final byte INSTALL_MERGE_VIEW = 8;
        public static final byte CANCEL_MERGE = 9;
        public static final byte VIEW_ACK = 10;
        public static final byte GET_VIEW = 11;
        public static final byte GET_VIEW_RSP = 12;
        public static final byte REMOVE_REQ = 13;
        public static final byte PREPARE_FOR_VIEW = 14;
        public static final byte PREPARE_FOR_VIEW_ACK = 15;
        public static final byte NETWORK_PARTITION_DETECTED = 16;
        byte type = 0;
        Address mbr = null;
        ViewId merge_id = null;
        boolean merge_rejected = false;
        String arg = "";
        boolean forcedOut;

        public GmsHeader() {
        }

        public GmsHeader(byte type) {
            this.type = type;
        }

        public GmsHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public GmsHeader(byte type, Address mbr, String reason) {
            this.type = type;
            this.mbr = mbr;
            this.arg = reason;
        }

        public GmsHeader(byte type, boolean forcedOut, String reason, Address mbr) {
            this.type = type;
            this.forcedOut = forcedOut;
            this.arg = reason;
            this.mbr = mbr;
        }

        public byte getType() {
            return this.type;
        }

        public Address getMember() {
            return this.mbr;
        }

        public String getArg() {
            return this.arg;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("GmsHeader");
            sb.append('[' + GmsHeader.type2String(this.type) + ']');
            switch (this.type) {
                case 1: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 2: 
                case 12: {
                    break;
                }
                case 3: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 4: {
                    if (!this.forcedOut) break;
                    sb.append(": forced removal because ").append(this.arg);
                    break;
                }
                case 5: 
                case 10: {
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id);
                    break;
                }
                case 7: {
                    sb.append(", merge_rejected=" + this.merge_rejected + ", merge_id=" + this.merge_id);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    sb.append(", <merge cancelled>, merge_id=" + this.merge_id);
                    break;
                }
                case 13: {
                    sb.append(": mbr=" + this.mbr + ", arg=" + this.arg);
                }
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
                case 10: {
                    return "VIEW_ACK";
                }
                case 13: {
                    return "REMOVE_REQ";
                }
                case 11: {
                    return "GET_VIEW";
                }
                case 12: {
                    return "GET_VIEW_RSP";
                }
                case 14: {
                    return "PREPARE_FOR_VIEW";
                }
                case 15: {
                    return "PREPARE_FOR_VIEW_ACK";
                }
                case 16: {
                    return "NETWORK_PARTITION_DETECTED";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.merge_id);
            out.writeBoolean(this.merge_rejected);
            out.writeBoolean(this.forcedOut);
            out.writeObject(this.arg);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.mbr = (Address)in.readObject();
            this.merge_id = (ViewId)in.readObject();
            this.merge_rejected = in.readBoolean();
            this.forcedOut = in.readBoolean();
            this.arg = (String)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.merge_id, out);
            out.writeBoolean(this.merge_rejected);
            out.writeBoolean(this.forcedOut);
            if (this.arg == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.arg);
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.merge_id = (ViewId)Util.readStreamable(ViewId.class, in);
            this.merge_rejected = in.readBoolean();
            this.forcedOut = in.readBoolean();
            boolean hasArg = in.readBoolean();
            if (hasArg) {
                this.arg = in.readUTF();
            }
        }

        @Override
        public long size(short version) {
            long retval = 2L;
            ++retval;
            ++retval;
            retval += (long)Util.size(this.mbr, version);
            ++retval;
            if (this.merge_id != null) {
                retval += (long)this.merge_id.serializedSize(version);
            }
            if (this.arg != null) {
                retval += (long)this.arg.length();
            }
            return ++retval;
        }
    }
}

