/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FD
extends Protocol
implements Runnable {
    Address local_addr = null;
    Thread checker = null;
    final Object checker_lock = new Object();
    long timeout = 6000L;
    final Hashtable members = new Hashtable(11);
    final Vector suspected_mbrs = new Vector(11);

    @Override
    public String getName() {
        return "FD";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FD_FDSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        this.stopChecker();
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.updateSender(sender);
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                Vector mbrs = v.getMembers();
                this.passDown(evt);
                Hashtable hashtable = this.members;
                synchronized (hashtable) {
                    Enumeration e = this.members.keys();
                    while (e.hasMoreElements()) {
                        Address mbr = (Address)e.nextElement();
                        if (mbrs.contains(mbr)) continue;
                        this.members.remove(mbr);
                    }
                    this.members.remove(this.local_addr);
                    if (this.members.size() > 0) {
                        this.startChecker();
                    }
                }
                return;
            }
            case 50: {
                this.updateSenders((Vector)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            object = this.members;
            synchronized (object) {
                if (this.members.size() == 0) {
                    break;
                }
                Enumeration e = this.members.keys();
                while (e.hasMoreElements()) {
                    Address mbr = (Address)e.nextElement();
                    long timestamp = ((Entry)this.members.get((Object)mbr)).timestamp;
                    long diff = System.currentTimeMillis() - timestamp;
                    if (diff < this.timeout) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.FD_SUSPECTING__0, mbr);
                    }
                    this.passUp(new Event(9, new SuspectMember(this.local_addr, mbr)));
                    if (this.suspected_mbrs.contains(mbr)) continue;
                    this.suspected_mbrs.addElement(mbr);
                }
            }
            try {
                Util.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        object = this.checker_lock;
        synchronized (object) {
            this.checker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startChecker() {
        Object object = this.checker_lock;
        synchronized (object) {
            if (this.checker == null) {
                this.checker = new Thread(GemFireTracer.GROUP, this, "FD.CheckerThread");
                this.checker.setDaemon(true);
                this.checker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopChecker() {
        Object object = this.checker_lock;
        synchronized (object) {
            if (this.checker != null && this.checker.isAlive()) {
                Thread tmp = this.checker;
                this.checker = null;
                tmp.interrupt();
                try {
                    tmp.join(this.timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (tmp.isAlive() && this.warn) {
                    this.log.warn("interrupted checker thread is still alive !");
                }
            }
            this.checker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSender(Address mbr) {
        if (mbr == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("member " + mbr + " not found");
            }
            return;
        }
        if (this.suspected_mbrs.size() > 0 && this.suspected_mbrs.contains(mbr)) {
            this.passUp(new Event(51, mbr));
            this.suspected_mbrs.remove(mbr);
        }
        if (mbr.equals(this.local_addr)) {
            return;
        }
        long curr_time = System.currentTimeMillis();
        Hashtable hashtable = this.members;
        synchronized (hashtable) {
            Entry entry = (Entry)this.members.get(mbr);
            if (entry != null) {
                entry.timestamp = curr_time;
            } else {
                this.members.put(mbr, new Entry(curr_time));
            }
        }
    }

    void updateSenders(Vector v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Address mbr = (Address)v.elementAt(i);
            this.updateSender(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String printTimestamps() {
        StringBuffer sb = new StringBuffer();
        Hashtable hashtable = this.members;
        synchronized (hashtable) {
            Enumeration e = this.members.keys();
            while (e.hasMoreElements()) {
                Address mbr = (Address)e.nextElement();
                sb.append("\n" + mbr + ": " + (System.currentTimeMillis() - ((Entry)this.members.get((Object)mbr)).timestamp));
            }
        }
        return sb.toString();
    }

    static class Entry {
        long timestamp;

        Entry(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return Long.toString(this.timestamp);
        }
    }
}

