/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.MergeView;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.GmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.protocols.pbcast.MergeData;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CoordGmsImpl
extends GmsImpl {
    protected boolean merging = false;
    private final MergeTask merge_task = new MergeTask();
    protected final Vector merge_rsps = new Vector(11);
    protected ViewId merge_id = null;
    protected Address merge_leader = null;
    private MergeCanceller merge_canceller = null;
    private final Object merge_canceller_mutex = new Object();
    private final Object view_mutex = new Object();

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMergeId(ViewId merge_id) {
        this.merge_id = merge_id;
        Object object = this.merge_canceller_mutex;
        synchronized (object) {
            if (this.merge_id != null) {
                this.stopMergeCanceller();
                this.merge_canceller = new MergeCanceller(this.merge_id, this.gms.merge_timeout);
                this.gms.timer.add(this.merge_canceller);
            } else {
                this.stopMergeCanceller();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopMergeCanceller() {
        Object object = this.merge_canceller_mutex;
        synchronized (object) {
            if (this.merge_canceller != null) {
                this.merge_canceller.cancel();
                this.merge_canceller = null;
            }
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.cancelMerge();
    }

    @Override
    public boolean join(Address mbr) {
        this.wrongMethod("join");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave(Address mbr) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (mbr == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_MEMBERS_ADDRESS_IS_NULL_);
                }
                return;
            }
            if (mbr.equals(this.gms.local_addr)) {
                this.leaving = true;
                this.handleLeave(mbr, false, "");
            } else {
                this.gms.view_handler.add(new GMS.Request(2, mbr, false, null));
                this.gms.view_handler.stop(true);
                this.gms.view_handler.waitUntilCompleted(this.gms.leave_timeout);
            }
        }
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.wrongMethod("handleJoinResponse");
    }

    @Override
    public void handleLeaveResponse(String reason) {
    }

    @Override
    public void unsuspect(Address mbr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Vector other_coords) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (this.merging) {
                if (this.warn) {
                    this.log.warn("merge already in progress, discarded MERGE event (I am " + this.gms.local_addr + ")");
                }
                return;
            }
            this.merge_leader = null;
            if (other_coords == null) {
                if (this.warn) {
                    this.log.warn("list of other coordinators is null. Will not start merge.");
                }
                return;
            }
            if (other_coords.size() <= 1) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_NUMBER_OF_COORDINATORS_FOUND_IS__0__WILL_NOT_PERFORM_MERGE, other_coords.size());
                }
                return;
            }
            Membership tmp = new Membership(other_coords);
            tmp.sort();
            this.merge_leader = (Address)tmp.elementAt(0);
            if (this.merge_leader.equals(this.gms.local_addr) || this.gms.merge_leader) {
                if (this.trace) {
                    this.log.trace("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task");
                }
                this.startMergeTask(other_coords);
            } else if (this.trace) {
                this.log.trace("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + this.merge_leader + ")to initiate merge");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeRequest(Address sender, ViewId merge_id) {
        Object object = this.view_mutex;
        synchronized (object) {
            View view;
            if (sender == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_SENDER__NULL_CANNOT_SEND_BACK_A_RESPONSE);
                }
                return;
            }
            if (this.merging) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_MERGE_ALREADY_IN_PROGRESS);
                }
                this.sendMergeRejectedResponse(sender, merge_id);
                return;
            }
            this.merging = true;
            this.gms.view_handler.suspend(merge_id);
            this.setMergeId(merge_id);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sender=" + sender + ", merge_id=" + merge_id);
            }
            Digest digest = this.gms.getDigest();
            Membership membership = this.gms.members;
            synchronized (membership) {
                view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
            }
            this.gms.passDown(new Event(67, sender));
            this.sendMergeResponse(sender, view, digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeData getMergeResponse(Address sender, ViewId merge_id) {
        MergeData retval;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_SENDER__NULL_CANNOT_SEND_BACK_A_RESPONSE);
            }
            return null;
        }
        if (this.merging) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_MERGE_ALREADY_IN_PROGRESS);
            }
            MergeData retval2 = new MergeData(sender, null, null);
            retval2.merge_rejected = true;
            return retval2;
        }
        this.merging = true;
        this.setMergeId(merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sender=" + sender + ", merge_id=" + merge_id);
        }
        try {
            View view;
            Digest digest = this.gms.getDigest();
            Membership membership = this.gms.members;
            synchronized (membership) {
                view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
            }
            retval = new MergeData(sender, view, digest);
            retval.view = view;
            retval.digest = digest;
        }
        catch (NullPointerException null_ex) {
            return null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeResponse(MergeData data, ViewId merge_id) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (data == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_MERGE_DATA_IS_NULL);
                }
                return;
            }
            if (merge_id == null || this.merge_id == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("merge_id (" + merge_id + ") or this.merge_id (" + this.merge_id + ") is null (sender=" + data.getSender() + ").");
                }
                return;
            }
            if (!this.merge_id.equals(merge_id)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')');
                }
                return;
            }
            Vector vector = this.merge_rsps;
            synchronized (vector) {
                if (!this.merge_rsps.contains(data)) {
                    this.merge_rsps.addElement(data);
                    this.merge_rsps.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeView(MergeData data, ViewId merge_id) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (merge_id == null || this.merge_id == null || !this.merge_id.equals(merge_id)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_MERGE_IDS_DONT_MATCH_OR_ARE_NULL_MERGE_VIEW_DISCARDED);
                }
                return;
            }
            Vector my_members = this.gms.view != null ? this.gms.view.getMembers() : null;
            GMS.Request req = new GMS.Request(5);
            req.view = data.view;
            req.digest = data.digest;
            req.target_members = my_members;
            this.gms.view_handler.add(req, true, true);
            this.merging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeCancelled(ViewId merge_id) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (merge_id != null && this.merge_id != null && this.merge_id.equals(merge_id)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("merge was cancelled (merge_id=" + merge_id + ", local_addr=" + this.gms.local_addr + ")");
                }
                this.setMergeId(null);
                this.merge_leader = null;
                this.merging = false;
                this.gms.view_handler.resume(merge_id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelMerge() {
        Object object = this.view_mutex;
        synchronized (object) {
            ViewId tmp = this.merge_id;
            if (this.merge_id != null && this.log.isDebugEnabled()) {
                this.log.debug("cancelling merge (merge_id=" + this.merge_id + ')');
            }
            this.setMergeId(null);
            this.merge_leader = null;
            this.stopMergeTask();
            this.merging = false;
            Vector vector = this.merge_rsps;
            synchronized (vector) {
                this.merge_rsps.clear();
            }
            this.gms.view_handler.resume(tmp);
        }
    }

    @Override
    public void handleJoinsAndLeaves(List joins, List leaves, List suspects, List suspectReasons, boolean forceInclusion) {
        Vector s;
        Vector left = this._handleLeave(leaves, false, Collections.EMPTY_LIST, forceInclusion);
        View joinView = this.handleJoin(joins, left, s = this._handleLeave(suspects, true, suspectReasons, forceInclusion));
        if (joinView == null) {
            this.gms.castViewChange(null, left, s, true);
        } else {
            this.gms.castViewChange(joinView, null, true);
        }
    }

    @Override
    public synchronized void handleJoin(Address mbr) {
        throw new UnsupportedOperationException("This version of the method is no longer used");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized View handleJoin(List members, Vector left, Vector suspect) {
        Object object = this.view_mutex;
        synchronized (object) {
            if (this.leaving) {
                return null;
            }
            Vector<IpAddress> new_mbrs = new Vector<IpAddress>(1);
            Digest tmp = this.gms.getDigest();
            if (tmp == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.CoordGmsImpl_RECEIVED_NULL_DIGEST_FROM_GET_DIGEST_WILL_CAUSE_JOIN_TO_FAIL);
                }
                return null;
            }
            Digest d = new Digest(tmp.size() + new_mbrs.size());
            d.add(tmp);
            Membership mbrs = new Membership();
            Membership membership = this.gms.members;
            synchronized (membership) {
                mbrs.set(this.gms.members);
            }
            boolean needNewView = false;
            for (IpAddress mbr : members) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("mbr joining=" + mbr);
                }
                if (mbr.getBirthViewId() >= 0 && this.gms.stack.jgmm.isShunnedMemberNoSync(mbr)) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.COORDGMSIMPL_REJECTING_0_DUE_TO_REUSED_IDENTITY, mbr);
                    this.sendJoinResponse(new JoinRsp("[internal]Your address is shunned"), mbr, false);
                    continue;
                }
                boolean found = false;
                boolean shunned = false;
                Iterator mit = mbrs.getMembers().iterator();
                while (!found && !shunned && mit.hasNext()) {
                    Address m = (Address)mit.next();
                    if (!m.equals(mbr)) continue;
                    if (((IpAddress)m).getUniqueID() != mbr.getUniqueID()) {
                        this.sendJoinResponse(new JoinRsp("[internal]Your address is shunned"), mbr, false);
                        shunned = true;
                        continue;
                    }
                    found = true;
                }
                if (shunned) continue;
                if (found) {
                    this.handleAlreadyJoined(mbr);
                    continue;
                }
                needNewView = true;
                new_mbrs.addElement(mbr);
                d.add(mbr, 0L, 0L);
            }
            if (needNewView) {
                JoinRsp join_rsp;
                View v = this.gms.getNextView(new_mbrs, left, suspect);
                for (IpAddress mbr : new_mbrs) {
                    mbr.setBirthViewId(v.getVid().getId());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("joined members " + new_mbrs + ", view is " + v);
                }
                if ((join_rsp = new JoinRsp(v, d)).getView() != null) {
                    this.gms.passDown(new Event(15, join_rsp.getView()));
                }
                Iterator it = new_mbrs.iterator();
                while (it.hasNext()) {
                    this.sendJoinResponse(join_rsp, (Address)it.next(), true);
                }
                return join_rsp.getView();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlreadyJoined(Address mbr) {
        Digest digest;
        ViewId vid;
        View view;
        Membership mbrs = new Membership();
        Membership membership = this.gms.members;
        synchronized (membership) {
            mbrs.set(this.gms.members);
            view = this.gms.view;
            vid = this.gms.view_id;
            digest = this.gms.getDigest();
        }
        if (this.log.getInternalLogWriter().warningEnabled()) {
            this.log.getInternalLogWriter().warning(JGroupsStrings.COORDGMSIMPL_0_ALREADY_PRESENT_RETURNING_EXISTING_VIEW_1, new Object[]{mbr, view});
        }
        JoinRsp join_rsp = new JoinRsp(new View(vid, mbrs.getMembers()), digest);
        this.sendJoinResponse(join_rsp, mbr, true);
    }

    public void handleLeave(Address mbr, boolean suspected, String reason) {
        List<Address> mbrs = Collections.singletonList(mbr);
        List<String> reasons = Collections.singletonList(reason);
        this.handleLeave(mbrs, suspected, reasons, false);
    }

    @Override
    public void handleLeave(List mbrs, boolean suspected, List reasons, boolean forceInclusion) {
        if (suspected) {
            this.handleJoinsAndLeaves(Collections.EMPTY_LIST, Collections.EMPTY_LIST, mbrs, reasons, forceInclusion);
        } else {
            this.handleJoinsAndLeaves(Collections.EMPTY_LIST, mbrs, Collections.EMPTY_LIST, Collections.EMPTY_LIST, forceInclusion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector _handleLeave(List mbrs, boolean suspected, List reasons, boolean forceInclusion) {
        Channel channel = this.gms.stack.getChannel();
        synchronized (channel) {
            Object object = this.view_mutex;
            synchronized (object) {
                Vector members;
                if (this.leaving && (mbrs.size() != 1 || !mbrs.contains(this.gms.local_addr))) {
                    return null;
                }
                Vector<Address> v = new Vector<Address>(mbrs.size());
                if (this.gms.view_id == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("gms.view_id is null, I'm not the coordinator anymore (leaving=" + this.leaving + "); the new coordinator will handle the leave request");
                    }
                    return null;
                }
                HashMap realAddresses = new HashMap();
                Vector vector = members = this.gms.members.getMembers();
                synchronized (vector) {
                    for (Object addr : members) {
                        realAddresses.put(addr, addr);
                    }
                }
                Iterator reasonIterator = reasons.iterator();
                String reason = "";
                for (Address mbr : mbrs) {
                    Address realMbr = (Address)realAddresses.get(mbr);
                    if (realMbr != null) {
                        mbr = realMbr;
                    }
                    if (suspected && reasonIterator.hasNext()) {
                        reason = (String)reasonIterator.next();
                    }
                    if (suspected && mbr.equals(this.gms.local_addr)) {
                        if (reason.length() > 0) {
                            this.log.getInternalLogWriter().info(JGroupsStrings.COORDGMSIMPL_I_AM_BEING_REMOVED_FROM_MEMBERSHIP_0, reason);
                        }
                        this.gms.passUp(new Event(46, new ForcedDisconnectException(JGroupsStrings.COORDGMSIMPL_THIS_MEMBER_HAS_BEEN_FORCED_OUT_OF_THE_DISTRIBUTED_SYSTEM_0_CGMS.toLocalizedString(reason != null && reason.length() > 0 ? "Reason='" + reason + "'" : JGroupsStrings.COORDGMSIMPL_PLEASE_CONSULT_GEMFIRE_LOGS_TO_FIND_THE_REASON.toLocalizedString()))));
                        return null;
                    }
                    this.sendLeaveResponse(mbr, reason);
                    if (realMbr != null) {
                        v.addElement(realMbr);
                        continue;
                    }
                    if (!forceInclusion) continue;
                    v.add(mbr);
                }
                return v;
            }
        }
    }

    void sendLeaveResponse(Address mbr, String reason) {
        Message msg = new Message(mbr, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(4, true, reason, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        msg.putHeader("NO_UCAST", hdr);
        this.gms.passDown(new Event(1, msg));
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            if (digest != null) {
                this.log.debug("view=" + new_view + ", digest=" + digest);
            } else {
                this.log.debug("view=" + new_view);
            }
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void handleExit() {
        this.cancelMerge();
    }

    @Override
    public void stop() {
        super.stop();
        this.stopMergeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMergeTask(Vector coords) {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.start(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMergeTask() {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.stop();
        }
    }

    void sendJoinResponse(JoinRsp rsp, Address dest, boolean isJoined) {
        Message m = new Message(dest, null, null);
        m.isHighPriority = true;
        m.isJoinResponse = true;
        GMS.GmsHeader hdr = new GMS.GmsHeader(2);
        m.putHeader(this.gms.getName(), hdr);
        m.setObject(rsp);
        if (!isJoined) {
            m.putHeader("NO_UCAST", new GMS.GmsHeader(2));
            this.gms.passDown(new Event(1008, dest));
        }
        this.gms.passDown(new Event(1, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMergeDataFromSubgroupCoordinators(Vector coords, long timeout) {
        if (coords == null || coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_COORDS__NULL_OR_SIZE__1);
            }
            return;
        }
        long start = System.currentTimeMillis();
        Vector vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.removeAllElements();
            if (this.log.isDebugEnabled()) {
                this.log.debug("sending MERGE_REQ to " + coords);
            }
            for (int i = 0; i < coords.size(); ++i) {
                Address coord = (Address)coords.elementAt(i);
                if (this.gms.local_addr != null && this.gms.local_addr.equals(coord)) {
                    MergeData tmp = this.getMergeResponse(this.gms.local_addr, this.merge_id);
                    if (tmp == null) continue;
                    this.merge_rsps.add(tmp);
                    continue;
                }
                this.gms.passDown(new Event(67, coord));
                Message msg = new Message(coord, null, null);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6);
                hdr.mbr = this.gms.local_addr;
                hdr.merge_id = this.merge_id;
                msg.putHeader(this.gms.getName(), hdr);
                this.gms.passDown(new Event(1, msg));
            }
            int num_rsps_expected = coords.size();
            long curr_time = System.currentTimeMillis();
            long end_time = curr_time + timeout;
            while (end_time > curr_time) {
                long time_to_wait = end_time - curr_time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("waiting " + time_to_wait + " msecs for merge responses");
                }
                if (this.merge_rsps.size() < num_rsps_expected) {
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.merge_rsps.wait(time_to_wait);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (interrupted) break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("num_rsps_expected=" + num_rsps_expected + ", actual responses=" + this.merge_rsps.size());
                }
                if (this.merge_rsps.size() >= num_rsps_expected) break;
                curr_time = System.currentTimeMillis();
            }
            long stop = System.currentTimeMillis();
            if (this.trace) {
                this.log.trace("collected " + this.merge_rsps.size() + " merge response(s) in " + (stop - start) + "ms");
            }
        }
    }

    protected ViewId generateMergeId() {
        return new ViewId(this.gms.local_addr, System.currentTimeMillis());
    }

    protected MergeData consolidateMergeData(Vector v) {
        Digest new_digest;
        Address new_coord;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        Vector<Object> subgroups = new Vector<Object>(11);
        for (int i = 0; i < v.size(); ++i) {
            View tmp_view;
            MergeData tmp_data = (MergeData)v.elementAt(i);
            if (this.log.isDebugEnabled()) {
                this.log.debug("merge data is " + tmp_data);
            }
            if ((tmp_view = tmp_data.getView()) == null) continue;
            ViewId tmp_vid = tmp_view.getVid();
            if (tmp_vid != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement(tmp_view.clone());
        }
        new_mbrs.sort();
        int num_mbrs = new_mbrs.size();
        Address address = new_coord = num_mbrs > 0 ? (Address)new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_NEW_COORD__NULL);
            }
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug("new merged view will be " + new_view);
        }
        if ((new_digest = this.consolidateDigests(v, num_mbrs)) == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_DIGEST_COULD_NOT_BE_CONSOLIDATED);
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("consolidated digest=" + new_digest);
        }
        MergeData ret = new MergeData(this.gms.local_addr, new_view, new_digest);
        return ret;
    }

    private Digest consolidateDigests(Vector v, int num_mbrs) {
        Digest retval = new Digest(num_mbrs);
        for (int i = 0; i < v.size(); ++i) {
            MergeData data = (MergeData)v.elementAt(i);
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.CoordGmsImpl_TMP_DIGEST__NULL_SKIPPING);
                continue;
            }
            retval.merge(tmp_digest);
        }
        return retval;
    }

    protected void sendMergeView(Vector coords, MergeData combined_merge_data) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View v = combined_merge_data.view;
        Digest d = combined_merge_data.digest;
        if (v == null || d == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_VIEW_OR_DIGEST_IS_NULL_CANNOT_SEND_CONSOLIDATED_MERGE_VIEWDIGEST);
            }
            return;
        }
        if (this.trace) {
            this.log.trace("sending merge view " + v.getVid() + " to coordinators " + coords);
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.merge_id = this.merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            v.setMessageDigest(d);
            msg.setObject(v);
            this.gms.passDown(new Event(1, msg));
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest) {
        Message msg = new Message(sender, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = this.merge_id;
        msg.putHeader(this.gms.getName(), hdr);
        view.setMessageDigest(digest);
        msg.setObject(view);
        if (this.log.isDebugEnabled()) {
            this.log.debug("response=" + hdr);
        }
        this.gms.passDown(new Event(1, msg));
    }

    protected void sendMergeCancelledMessage(Vector coords, ViewId merge_id) {
        if (coords == null || merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.CoordGmsImpl_COORDS_OR_MERGE_ID__NULL);
            }
            return;
        }
        for (int i = 0; i < coords.size(); ++i) {
            Address coord = (Address)coords.elementAt(i);
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.passDown(new Event(1, msg));
        }
    }

    protected void removeRejectedMergeRequests(Vector coords) {
        Iterator it = this.merge_rsps.iterator();
        while (it.hasNext()) {
            MergeData data = (MergeData)it.next();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null && coords != null) {
                coords.removeElement(data.getSender());
            }
            it.remove();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("removed element " + data);
        }
    }

    private class MergeCanceller
    implements TimeScheduler.Task {
        private Object my_merge_id = null;
        private long timeout;
        private boolean cancelled = false;

        MergeCanceller(Object my_merge_id, long timeout) {
            this.my_merge_id = my_merge_id;
            this.timeout = timeout;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public long nextInterval() {
            return this.timeout;
        }

        @Override
        public void run() {
            if (CoordGmsImpl.this.merge_id != null && this.my_merge_id.equals(CoordGmsImpl.this.merge_id)) {
                if (CoordGmsImpl.this.trace) {
                    CoordGmsImpl.this.log.trace("cancelling merge due to timer timeout (" + this.timeout + " ms)");
                }
                CoordGmsImpl.this.cancelMerge();
                this.cancelled = true;
            } else if (CoordGmsImpl.this.trace) {
                CoordGmsImpl.this.log.trace("timer kicked in after " + this.timeout + " ms, but no (or different) merge was in progress: " + "merge_id=" + CoordGmsImpl.this.merge_id + ", my_merge_id=" + this.my_merge_id);
            }
        }
    }

    protected class MergeTask
    implements Runnable {
        Thread t = null;
        Vector coords = null;

        protected MergeTask() {
        }

        public synchronized void start(Vector coords) {
            if (this.t == null || !this.t.isAlive()) {
                this.coords = (Vector)(coords != null ? coords.clone() : null);
                this.t = new Thread(GemFireTracer.GROUP, this, "MergeTask");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public synchronized void stop() {
            Thread tmp = this.t;
            if (this.isRunning()) {
                this.t = null;
                tmp.interrupt();
            }
            this.t = null;
            this.coords = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            MergeTask mergeTask = this;
            synchronized (mergeTask) {
                return this.t != null && this.t.isAlive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CoordGmsImpl.this.merging) {
                if (CoordGmsImpl.this.warn) {
                    CoordGmsImpl.this.log.warn("merge is already in progress, terminating");
                }
                return;
            }
            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                CoordGmsImpl.this.log.debug("merge task started, coordinators are " + this.coords);
            }
            try {
                CoordGmsImpl.this.setMergeId(CoordGmsImpl.this.generateMergeId());
                CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, CoordGmsImpl.this.gms.merge_timeout);
                CoordGmsImpl.this.removeRejectedMergeRequests(this.coords);
                if (CoordGmsImpl.this.merge_rsps.size() <= 1) {
                    if (CoordGmsImpl.this.warn) {
                        CoordGmsImpl.this.log.warn("merge responses from subgroup coordinators <= 1 (" + CoordGmsImpl.this.merge_rsps + "). Cancelling merge");
                    }
                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                    return;
                }
                MergeData combined_merge_data = CoordGmsImpl.this.consolidateMergeData(CoordGmsImpl.this.merge_rsps);
                if (combined_merge_data == null) {
                    if (CoordGmsImpl.this.log.isErrorEnabled()) {
                        CoordGmsImpl.this.log.error(JGroupsStrings.CoordGmsImpl_COMBINED_MERGE_DATA__NULL);
                    }
                    CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                    return;
                }
                CoordGmsImpl.this.gms.view_handler.suspend(CoordGmsImpl.this.merge_id);
                CoordGmsImpl.this.sendMergeView(this.coords, combined_merge_data);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (CoordGmsImpl.this.log.isErrorEnabled()) {
                    CoordGmsImpl.this.log.error(JGroupsStrings.CoordGmsImpl_EXCEPTION_WHILE_MERGING, ex);
                }
            }
            finally {
                CoordGmsImpl.this.sendMergeCancelledMessage(this.coords, CoordGmsImpl.this.merge_id);
                CoordGmsImpl.this.stopMergeCanceller();
                CoordGmsImpl.this.merging = false;
                CoordGmsImpl.this.merge_leader = null;
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug("merge task terminated");
                }
            }
        }
    }
}

