/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols.pbcast;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.ShunnedAddressException;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.GmsImpl;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Util;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ClientGmsImpl
extends GmsImpl {
    public static volatile boolean SLOW_JOIN;
    public static volatile Object SLOW_JOIN_LOCK;
    private final Vector initial_mbrs = new Vector(11);
    private volatile boolean initial_mbrs_received = false;
    private final Promise join_promise = new Promise();
    private volatile JoinRsp getViewResponse;
    private volatile int getViewResponses;
    private final Object getViewLock = new Object();
    private Set missing_mbrs = null;
    private int findInitialMbrsAttempts = 0;
    Address lastAttempt;

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        super.init();
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.clear();
            this.initial_mbrs_received = false;
        }
        this.join_promise.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join(Address myAddr) {
        Object coord = null;
        Object coordSentJoin = null;
        View tmp_view = null;
        this.leaving = false;
        long starttime = System.currentTimeMillis();
        int maxRetries = 6;
        int joinRetries = 6;
        this.join_promise.reset();
        boolean debugFailFirst = Boolean.getBoolean("p2p.DEBUG_FAIL_FIRST");
        while (!this.leaving) {
            block74: {
                if (--joinRetries < 0) {
                    if (coord != null && this.gms.floatingCoordinatorDisabled && !this.gms.splitBrainDetectionEnabled && myAddr.preferredForCoordinator()) {
                        Object failedCoord = coord;
                        if (!myAddr.equals(failedCoord)) {
                            this.gms.log.getInternalLogWriter().warning(JGroupsStrings.ClientGmsImpl_COULD_NOT_JOIN_DISTRIBUTED_SYSTEM_0, failedCoord);
                            if (this.becomeGroupCoordinator(myAddr, (Address)failedCoord)) {
                                return true;
                            }
                        }
                        coord = null;
                    } else if (!this.join_promise.hasResult()) {
                        this.log.warn("Could not join distributed system using member " + coord + ".  gms.floatingCoordinatorDisabled=" + this.gms.floatingCoordinatorDisabled + ", mbr.canBeCoordinator()=" + myAddr.preferredForCoordinator());
                        return false;
                    }
                }
                this.missing_mbrs = null;
                this.findInitialMembers();
                if (debugFailFirst) {
                    this.log.getInternalLogWriter().severe(JGroupsStrings.ClientGmsImpl_IGNORING_FIRST_MEMBERSHIP_SET_FOR_DEBUGGING);
                    debugFailFirst = false;
                    continue;
                }
                if (!this.join_promise.hasResult()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("CGMS: initial_mbrs are " + this.initial_mbrs + "; missing_mbrs are " + this.missing_mbrs);
                    }
                    if (this.initial_mbrs.size() == 0) {
                        if (this.missing_mbrs == null || this.missing_mbrs.isEmpty()) {
                            if (this.gms.disable_initial_coord) {
                                this.checkForTimeout(starttime);
                                this.log.warn("received an initial membership of 0, but cannot become coordinator (disable_initial_coord=true), will retry fetching the initial membership");
                            } else if (joinRetries <= 4) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("no initial members discovered: creating group as first member");
                                }
                                this.becomeSingletonMember(myAddr);
                                return true;
                            }
                        }
                        if (joinRetries <= 0) continue;
                        try {
                            Util.sleep(this.gms.join_retry_timeout);
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("interrupted; creating group as first member");
                            }
                            this.becomeSingletonMember(myAddr);
                            Thread.currentThread().interrupt();
                            return true;
                        }
                    }
                    coord = this.determineCoord(this.initial_mbrs);
                    if (coord == null) {
                        if (joinRetries < 5) {
                            Address new_coord;
                            if (!this.gms.handle_concurrent_startup) {
                                if (this.trace) {
                                    this.log.trace("handle_concurrent_startup is false; ignoring responses of initial clients");
                                }
                                this.becomeSingletonMember(myAddr);
                                return true;
                            }
                            if (this.trace) {
                                this.log.trace("could not determine coordinator from responses " + this.initial_mbrs);
                            }
                            TreeSet<Address> clients = new TreeSet<Address>();
                            clients.add(myAddr);
                            for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                                PingRsp pingRsp = (PingRsp)this.initial_mbrs.elementAt(i);
                                Address client_addr = pingRsp.getCoordAddress();
                                if (client_addr == null) continue;
                                clients.add(client_addr);
                            }
                            if (this.trace) {
                                this.log.trace("Choosing coordinator from these servers: " + clients + ".\nJoin retries remaining: " + joinRetries);
                            }
                            if ((new_coord = (Address)clients.iterator().next()).equals(myAddr)) {
                                if (!this.gms.disable_initial_coord) {
                                    if (this.trace) {
                                        this.log.trace("I (" + myAddr + ") am the first of the clients, and will become coordinator");
                                    }
                                    this.becomeSingletonMember(myAddr);
                                    return true;
                                }
                            } else {
                                this.log.getInternalLogWriter().convertToLogWriter().info("Waiting for " + new_coord + " to possibly become coordinator during concurrent startup.  " + "My address is " + this.gms.local_addr);
                                if (joinRetries < 2) {
                                    this.checkForTimeout(starttime);
                                    ++joinRetries;
                                }
                            }
                        } else if (this.trace) {
                            this.log.trace("I (" + myAddr + ") am not the coordinator and it is too" + " soon for an election");
                        }
                        if (joinRetries <= 0) continue;
                        try {
                            Util.sleep(this.gms.join_retry_timeout);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return false;
                        }
                    }
                    if (!coord.splitBrainEnabled() && this.gms.splitBrainDetectionEnabled) {
                        throw new GemFireConfigException("Group membership coordinator, " + coord + " does not have " + "network partition detection enabled, but this DistributedSystem has it enabled");
                    }
                    boolean c6 = ((IpAddress)coord).getIpAddress() instanceof Inet6Address;
                    boolean m6 = ((IpAddress)myAddr).getIpAddress() instanceof Inet6Address;
                    if (c6 && !m6) {
                        throw new GemFireConfigException("Group membership coordinator, " + coord + ", is using IPv6 but this " + "process is using IPv4");
                    }
                    if (m6 && !c6) {
                        throw new GemFireConfigException("Group membership coordinator, " + coord + ", is using IPv4 but this " + "process is using IPv6");
                    }
                } else {
                    coord = coordSentJoin;
                }
                if (coord == null) {
                    this.join_promise.reset();
                    continue;
                }
                try {
                    if (coord.equals(this.gms.local_addr) && this.gms.local_addr.preferredForCoordinator()) {
                        if (((IpAddress)coord).getUniqueID() != ((IpAddress)this.gms.local_addr).getUniqueID()) {
                            throw new ShunnedAddressException();
                        }
                        if (this.becomeGroupCoordinator(this.gms.local_addr, null)) {
                            return true;
                        }
                        coord = null;
                        continue;
                    }
                    if (!this.join_promise.hasResult()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("sending join_req(" + myAddr + ") to " + coord);
                        }
                        coordSentJoin = coord;
                        this.sendJoinMessage((Address)coord, myAddr);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Waiting for join response");
                    }
                    if (SLOW_JOIN) {
                        Object c6 = SLOW_JOIN_LOCK;
                        synchronized (c6) {
                            try {
                                SLOW_JOIN_LOCK.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    JoinRsp rsp = (JoinRsp)this.join_promise.getResult(this.gms.join_timeout);
                    if (Thread.currentThread().isInterrupted()) {
                        throw new SystemConnectException(JGroupsStrings.ClientGmsImpl_JOIN_INTERRUPTED.toLocalizedString());
                    }
                    if (rsp == null) {
                        if (this.warn && !this.leaving) {
                            this.log.getInternalLogWriter().warning(JGroupsStrings.ClientGmsImpl_JOIN_0__SENT_TO__1__TIMED_OUT_RETRYING, new Object[]{myAddr, coord});
                        }
                        break block74;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Got join response: " + rsp);
                    }
                    if (rsp.view != null && rsp.view.getVid() != null) {
                        ((IpAddress)this.gms.local_addr).setBirthViewId(rsp.view.getVid().getId());
                    }
                    if (rsp.getFailReason() != null) {
                        if (rsp.getFailReason().equals("[internal]Your address is shunned")) {
                            throw new ShunnedAddressException();
                        }
                        if (rsp.getFailReason().contains("Rejecting the attempt of a member using an older version") || rsp.getFailReason().contains("15806")) {
                            throw new SystemConnectException(rsp.getFailReason());
                        }
                        throw new AuthenticationFailedException(rsp.getFailReason());
                    }
                    coord = rsp.getView().getCreator();
                    this.gms.notifyOfCoordinator((Address)coord);
                    Digest tmp_digest = rsp.getDigest();
                    tmp_view = rsp.getView();
                    if (tmp_digest == null || tmp_view == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(JGroupsStrings.ClientGmsImpl_DIGEST_OR_VIEW_OF_JOIN_RESPONSE_IS_NULL);
                        }
                        break block74;
                    }
                    tmp_digest.incrementHighSeqno((Address)coord);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("digest is " + tmp_digest);
                    }
                    this.gms.setDigest(tmp_digest);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("[" + this.gms.local_addr + "]: JoinRsp=" + rsp.getView() + " [size=" + rsp.getView().size() + "]\n\n");
                    }
                    if (!this.installView(tmp_view)) {
                        if (!this.log.isErrorEnabled()) continue;
                        this.log.error(JGroupsStrings.ClientGmsImpl_VIEW_INSTALLATION_FAILED_RETRYING_TO_JOIN_GROUP);
                        continue;
                    }
                    Message view_ack = new Message((Address)coord, null, null);
                    GMS.GmsHeader tmphdr = new GMS.GmsHeader(10);
                    view_ack.putHeader("GMS", tmphdr);
                    view_ack.setObject(null);
                    this.gms.passDown(new Event(1, view_ack));
                    this.gms.passUp(new Event(16));
                    this.gms.passDown(new Event(16));
                    return true;
                }
                catch (AuthenticationFailedException afe) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("AuthenticationFailedException=" + afe.toString());
                    }
                    throw afe;
                }
                catch (ShunnedAddressException e) {
                    System.setProperty("gemfire.jg-bind-port", "0");
                    throw e;
                }
                catch (SystemConnectException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!this.log.getInternalLogWriter().infoEnabled()) break block74;
                    this.log.getInternalLogWriter().info(JGroupsStrings.UnexpectedException, (Throwable)e);
                }
            }
            if (joinRetries <= 0) continue;
            try {
                Util.sleep(this.gms.join_retry_timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (this.missing_mbrs != null && this.missing_mbrs.size() > 0) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "missing ping responses from " + this.missing_mbrs);
            return false;
        }
        return true;
    }

    private void checkForTimeout(long starttime) {
        if (starttime + 2L * this.gms.join_timeout < System.currentTimeMillis()) {
            if (!this.gms.stack.getChannel().closing()) {
                this.log.getInternalLogWriter().fine("GMS client is timing out and forcing an exit");
            }
            throw new GemFireConfigException("Unable to contact a Locator service.  Operation either timed out, was stopped or Locator does not exist.");
        }
    }

    @Override
    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        if (this.log.isDebugEnabled()) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Received join response " + join_rsp);
        }
        while (SLOW_JOIN) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "delaying delivery of join response");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.join_promise.setResult(join_rsp);
    }

    @Override
    public void handleLeaveResponse(String reason) {
    }

    @Override
    public void handleJoinsAndLeaves(List joins, List leaves, List suspects, List suspectReasons, boolean forceInclusion) {
    }

    @Override
    public void unsuspect(Address mbr) {
    }

    @Override
    public void handleJoin(Address mbr) {
    }

    public void handleLeave(Address mbr, boolean suspected) {
    }

    @Override
    public void handleLeave(List memberList, boolean suspected, List reasons, boolean forceInclusion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleGetViewResponse(JoinRsp response) {
        Object object = this.getViewLock;
        synchronized (object) {
            if (this.getViewResponse != null) {
                if (this.getViewResponse.getView().getCreator().equals(response.getView().getCreator()) && this.getViewResponse.getView().getVid().compareTo(response.getView().getVid()) < 0) {
                    ++this.getViewResponses;
                    this.getViewResponse = response;
                }
            } else {
                this.getViewResponse = response;
                ++this.getViewResponses;
            }
            this.getViewLock.notify();
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
    }

    private boolean installView(View new_view) {
        Vector mems = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug("new_view=" + new_view);
        }
        if (this.gms.local_addr == null || mems == null || !mems.contains(this.gms.local_addr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("I (" + this.gms.local_addr + ") am not member of " + mems + ", will not install view");
            }
            return false;
        }
        this.gms.installView(new_view);
        this.gms.becomeParticipant();
        this.gms.passUp(new Event(16));
        this.gms.passDown(new Event(16));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 13: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (!this.initial_mbrs_received) {
                        if (tmp != null && tmp.size() > 0) {
                            this.initial_mbrs.addAll(tmp);
                        }
                        this.initial_mbrs_received = true;
                        this.initial_mbrs.notifyAll();
                    }
                }
                return false;
            }
            case 1011: {
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("received FIND_INITIAL_MBRS_FAILED event in ClientGmsImpl with " + evt.getArg());
                }
                Set missing = (Set)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (!this.initial_mbrs_received) {
                        this.initial_mbrs_received = true;
                        this.missing_mbrs = missing;
                        this.initial_mbrs.notifyAll();
                    }
                }
                return false;
            }
            case 46: {
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    this.initial_mbrs_received = true;
                    this.initial_mbrs.notifyAll();
                }
                this.stop();
            }
        }
        return true;
    }

    void sendJoinMessage(Address coord, Address mbr) {
        if (this.lastAttempt == null || this.gms.stack.jgmm.isReconnectingDS() || !coord.equals(this.lastAttempt)) {
            this.log.getInternalLogWriter().info(JGroupsStrings.ClientGmsImpl_ATTEMPTING_TO_JOIN_DS_WHOSE_MEMBERSHIP_COORDINATOR_IS_0_USING_ID_1, new Object[]{coord, mbr});
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(1, mbr);
            msg.putHeader(this.gms.getName(), hdr);
            this.lastAttempt = null;
            this.gms.passDown(new Event(1, msg));
            this.lastAttempt = coord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            PingRsp ping_rsp;
            ++this.findInitialMbrsAttempts;
            this.initial_mbrs.removeAllElements();
            this.initial_mbrs_received = false;
            this.gms.passDown(new Event(12));
            while (!this.initial_mbrs_received) {
                try {
                    this.initial_mbrs.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.initial_mbrs_received = true;
                }
            }
            for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr == null || this.gms.local_addr == null || !ping_rsp.own_addr.equals(this.gms.local_addr)) continue;
                this.initial_mbrs.removeElementAt(i);
                break;
            }
            if (this.findInitialMbrsAttempts > 2) {
                ArrayList<PingRsp> removals = new ArrayList<PingRsp>(this.initial_mbrs.size());
                for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                    ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                    if (ping_rsp.own_addr == null || ping_rsp.isServer() || ping_rsp.getCoordAddress().equals(ping_rsp.own_addr)) continue;
                    removals.add(ping_rsp);
                }
                this.initial_mbrs.removeAll(removals);
            }
        }
    }

    private Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>(5);
        for (int i = 0; i < mbrs.size(); ++i) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (!mbr.is_server || mbr.coord_addr == null) continue;
            if (!votes.containsKey(mbr.coord_addr)) {
                votes.put(mbr.coord_addr, 1);
                continue;
            }
            count = (Integer)votes.get(mbr.coord_addr);
            votes.put(mbr.coord_addr, count + 1);
        }
        if (votes.size() > 1) {
            this.log.getInternalLogWriter().warning(JGroupsStrings.ClientGmsImpl_THERE_WAS_MORE_THAN_1_CANDIDATE_FOR_COORDINATOR__0, votes);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("election results: " + votes);
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        Vector<Address> mbrs = new Vector<Address>(1);
        Digest initial_digest = new Digest(1);
        initial_digest.add(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        ViewId view_id = new ViewId(mbr);
        mbrs.addElement(mbr);
        this.gms.installView(new View(view_id, mbrs));
        this.gms.becomeCoordinator(null);
        this.gms.passUp(new Event(16));
        this.gms.passDown(new Event(16));
        this.gms.notifyOfCoordinator(this.gms.local_addr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("created group (first member). My view is " + this.gms.view_id + ", impl is " + this.gms.getImpl().getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean becomeGroupCoordinator(Address mbr, Address failedCoordinator) {
        Object getView;
        Vector imbrs;
        int sentRequests = 0;
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            imbrs = (Vector)this.initial_mbrs.clone();
        }
        GMS.GmsHeader hdr = new GMS.GmsHeader(11);
        for (int i = 0; i < imbrs.size(); ++i) {
            PingRsp rsp = (PingRsp)imbrs.get(i);
            getView = new Message();
            ((Message)getView).setDest(rsp.getAddress());
            ((Message)getView).putHeader("GMS", hdr);
            this.gms.passDown(new Event(1, getView));
        }
        sentRequests = imbrs.size();
        long endTime = System.currentTimeMillis() + this.gms.view_ack_collection_timeout;
        while (true) {
            getView = this.getViewLock;
            synchronized (getView) {
                long timeLeft = endTime - System.currentTimeMillis();
                if (this.getViewResponses >= sentRequests || timeLeft <= 0L) {
                    break;
                }
                try {
                    this.getViewLock.wait(timeLeft);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new SystemConnectException(JGroupsStrings.ClientGmsImpl_INTERRUPTED_WHILE_BECOMING_COORDINATOR_OF_EXISTING_GROUP.toLocalizedString());
                }
            }
        }
        if (this.getViewResponse == null) {
            throw new SystemConnectException(JGroupsStrings.ClientGmsImpl_UNABLE_TO_BECOME_COORDINATOR_OF_EXISTING_GROUP_BECAUSE_NO_VIEW_RESPONSES_WERE_RECEIVED.toLocalizedString());
        }
        View theView = this.getViewResponse.getView();
        Address theCreator = theView.getCreator();
        if (theCreator != null && theCreator.preferredForCoordinator()) {
            if (failedCoordinator == null && theView.containsMember(theCreator)) {
                return false;
            }
            if (failedCoordinator != null && !theCreator.equals(failedCoordinator)) {
                return false;
            }
        }
        Vector mbrs = theView.getMembers();
        mbrs.add(mbr);
        Digest initial_digest = this.getViewResponse.getDigest();
        initial_digest.add(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        ViewId view_id = new ViewId(mbr, theView.getVid().getId() + 1L);
        View new_view = new View(view_id, mbrs);
        this.gms.installView(new_view);
        this.gms.becomeCoordinator(null);
        this.gms.ucastViewChange(new_view);
        this.gms.passUp(new Event(16));
        this.gms.passDown(new Event(16));
        this.gms.notifyOfCoordinator(this.gms.local_addr);
        this.log.getInternalLogWriter().info(JGroupsStrings.ClientGmsImpl_RECREATED_DISTRIBUTED_SYSTEM_GROUP_0, this.gms.view);
        return true;
    }

    @Override
    public void handleAlreadyJoined(Address mbr) {
    }
}

