/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.LogicalLink;
import com.gemstone.org.jgroups.protocols.WanPipeAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WANPIPE
extends Protocol
implements LogicalLink.Receiver {
    LogicalLink pipe = null;
    String name = null;
    final List links = new List();
    Address local_addr = null;
    String group_addr = null;
    final Properties properties = null;
    final Vector members = new Vector();

    public WANPIPE() {
        this.pipe = new LogicalLink(this);
    }

    public String toString() {
        return "Protocol WANPIPE(local address: " + this.local_addr + ')';
    }

    @Override
    public String getName() {
        return "WANPIPE";
    }

    @Override
    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        Address dest_addr = msg.getDest();
        if (dest_addr == null) {
            for (int i = 0; i < this.members.size(); ++i) {
                dest_addr = (Address)this.members.elementAt(i);
                if (dest_addr.equals(this.local_addr)) {
                    this.returnLocal(msg);
                    continue;
                }
                Message copy = msg.copy();
                copy.setDest(dest_addr);
                copy.putHeader(this.getName(), new WanPipeHeader(this.group_addr));
                this.sendUnicastMessage(copy);
            }
        } else if (dest_addr.equals(this.local_addr)) {
            this.returnLocal(msg);
        } else {
            msg.putHeader(this.getName(), new WanPipeHeader(this.group_addr));
            this.sendUnicastMessage(msg);
        }
    }

    void returnLocal(Message msg) {
        Message rsp = msg.copy();
        rsp.setDest(this.local_addr);
        rsp.setSrc(this.local_addr);
        this.passUp(new Event(1, rsp));
    }

    @Override
    public void start() throws Exception {
        Enumeration e = this.links.elements();
        while (e.hasMoreElements()) {
            LinkInfo l = (LinkInfo)e.nextElement();
            this.pipe.addLink(l.local_addr, l.local_port, l.remote_addr, l.remote_port);
        }
        this.pipe.start();
        this.local_addr = new WanPipeAddress(this.name);
        this.passUp(new Event(8, this.local_addr));
    }

    @Override
    public void stop() {
        this.pipe.stop();
        this.pipe.removeAllLinks();
    }

    @Override
    public void receive(byte[] buf) {
        WanPipeHeader hdr = null;
        Message msg = null;
        try {
            msg = (Message)Util.objectFromByteBuffer(buf);
        }
        catch (Exception e) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPERECEIVE__0, (Throwable)e);
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.WANPIPE_RECEIVED_MSG__0, msg);
        }
        hdr = (WanPipeHeader)msg.removeHeader(this.getName());
        String ch_name = null;
        if (hdr.group_addr != null) {
            ch_name = hdr.group_addr;
        }
        if (this.group_addr == null) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPERECEIVE_GROUP_ADDRESS_IN_HEADER_WAS_NULL_DISCARDED);
            return;
        }
        if (ch_name != null && !this.group_addr.equals(ch_name)) {
            return;
        }
        this.passUp(new Event(1, msg));
    }

    @Override
    public void linkDown(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
        Object p = this.getPeer();
        this.passUp(new Event(9, new SuspectMember(this.local_addr, (Address)p)));
    }

    @Override
    public void linkUp(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
    }

    @Override
    public void missedHeartbeat(InetAddress local2, int local_port, InetAddress remote, int remote_port, int num_hbs) {
    }

    @Override
    public void receivedHeartbeatAgain(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("name");
        if (str != null) {
            this.name = str;
            props.remove("name");
        }
        if ((str = props.getProperty("links")) != null) {
            if (!this.parseLinks(str)) {
                return false;
            }
            props.remove("links");
        }
        if (this.name == null || this.name.length() == 0) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPESETPROPERTIES_NAME_MUST_BE_SET);
            return false;
        }
        if (this.links.size() == 0) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPESETPROPERTIES_NO_LINKS_SPECIFIED_AT_LEAST_1_LINK_MUST_BE_PRESENT);
            return false;
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPESETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    boolean parseLinks(String s) {
        int index2 = 0;
        s = s.replace('[', ' ');
        s = s.replace(']', ' ');
        s = s.trim();
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreElements()) {
            String src = tok.nextToken().trim();
            String dst = tok.nextToken().trim();
            LinkInfo info = new LinkInfo();
            index2 = src.indexOf(64);
            if (index2 == -1) {
                this.log.error(JGroupsStrings.WANPIPE_WANPIPEPARSELINKS_LOCAL_ADDRESS__0__MUST_HAVE_A__SEPARATOR, src);
                return false;
            }
            info.local_addr = src.substring(0, index2);
            info.local_port = Integer.parseInt(src.substring(index2 + 1, src.length()));
            index2 = dst.indexOf(64);
            if (index2 == -1) {
                this.log.error(JGroupsStrings.WANPIPE_WANPIPEPARSELINKS_REMOTE_ADDRESS__0__MUST_HAVE_A__SEPARATOR, dst);
                return false;
            }
            info.remote_addr = dst.substring(0, index2);
            info.remote_port = Integer.parseInt(dst.substring(index2 + 1, dst.length()));
            this.links.add(info);
        }
        return true;
    }

    Object getPeer() {
        Object ret = null;
        if (this.members == null || this.members.size() == 0 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.elementAt(i).equals(this.local_addr)) continue;
            return this.members.elementAt(i);
        }
        return ret;
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    private void sendUnicastMessage(Message msg) {
        byte[] buf = null;
        this.setSourceAddress(msg);
        try {
            buf = Util.objectToByteBuffer(msg);
        }
        catch (Exception e) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPESENDUNICASTMESSAGE__0, (Throwable)e);
            return;
        }
        try {
            this.pipe.send(buf);
        }
        catch (LogicalLink.AllLinksDown links_down) {
            this.log.error("WANPIPE.sendUnicastMessage(): WAN pipe has no currently operational link to send message. Discarding it.");
        }
        catch (LogicalLink.NoLinksAvailable no_links) {
            this.log.error("WANPIPE.sendUnicastMessage(): WAN pipe has no physical links configured; cannot send message");
        }
        catch (Exception e) {
            this.log.error(JGroupsStrings.WANPIPE_WANPIPESENDUNICASTMESSAGE__0, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 9: {
                break;
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
            }
        }
    }

    public static class WanPipeHeader
    extends Header {
        public String group_addr = null;

        public WanPipeHeader() {
        }

        public WanPipeHeader(String n) {
            this.group_addr = n;
        }

        @Override
        public long size(short version) {
            return 100L;
        }

        @Override
        public String toString() {
            return "[WanPipe: group_addr=" + this.group_addr + ']';
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.group_addr);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.group_addr = (String)in.readObject();
        }
    }

    protected static class LinkInfo {
        String local_addr = null;
        String remote_addr = null;
        int local_port = 0;
        int remote_port = 0;

        protected LinkInfo() {
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("local_addr=" + (this.local_addr != null ? this.local_addr : "null"));
            ret.append(":" + this.local_port);
            ret.append(", remote_addr=" + (this.remote_addr != null ? this.remote_addr : "null"));
            ret.append(":" + this.remote_port);
            return ret.toString();
        }
    }
}

