/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.protocols.TransportedVectorTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class VectorTime {
    private final TreeMap entries;
    private int ownerIndex;
    private final Address owner;

    public VectorTime(Address owner) {
        this.owner = owner;
        this.entries = new TreeMap();
        this.entries.put(owner, 0);
    }

    public Collection getMembers() {
        return this.entries.keySet();
    }

    public Collection getVectorValues() {
        return this.entries.values();
    }

    public int[] getValues() {
        int count = 0;
        Collection valuesEntries = this.entries.values();
        int[] values = new int[valuesEntries.size()];
        Iterator iter = valuesEntries.iterator();
        while (iter.hasNext()) {
            values[count++] = (Integer)iter.next();
        }
        return values;
    }

    public void increment() {
        Integer value2 = (Integer)this.entries.get(this.owner);
        this.entries.put(this.owner, value2 + 1);
    }

    public void reset() {
        Address member2 = null;
        Set keyEntries = this.entries.keySet();
        for (Address member2 : keyEntries) {
            this.entries.put(member2, 0);
        }
    }

    public TransportedVectorTime getTransportedVectorTime() {
        return new TransportedVectorTime(this.ownerIndex, this.getValues());
    }

    public void max(TransportedVectorTime other) {
        int count = 0;
        int thisVectorValue = 0;
        int otherVectorValue = 0;
        Address member2 = null;
        int[] values = other.getValues();
        Set keyEntries = this.entries.keySet();
        for (Address member2 : keyEntries) {
            thisVectorValue = (Integer)this.entries.get(member2);
            if ((otherVectorValue = values[count++]) <= thisVectorValue) continue;
            this.entries.put(member2, otherVectorValue);
        }
    }

    public boolean isCausallyNext(TransportedVectorTime other) {
        int senderIndex = other.getSenderIndex();
        int receiverIndex = this.ownerIndex;
        int[] sender = other.getValues();
        int[] receiver = this.getValues();
        boolean nextCasualFromSender = false;
        boolean nextCasual = true;
        if (receiverIndex == senderIndex) {
            return true;
        }
        for (int k = 0; k < receiver.length; ++k) {
            if (k == senderIndex && sender[k] == receiver[k] + 1) {
                nextCasualFromSender = true;
                continue;
            }
            if (k == receiverIndex || sender[k] <= receiver[k]) continue;
            nextCasual = false;
        }
        return nextCasualFromSender && nextCasual;
    }

    public int getOwnerIndex() {
        return this.indexOf(this.owner);
    }

    public int indexOf(Address member) {
        Set set = this.entries.keySet();
        Iterator iter = set.iterator();
        int index2 = -1;
        Address temp = null;
        while (iter.hasNext()) {
            temp = (Address)iter.next();
            ++index2;
            if (temp.hashCode() != member.hashCode()) continue;
            return index2;
        }
        return -1;
    }

    public void merge(Vector newMembers) {
        if (newMembers.size() > this.entries.size()) {
            newMembers.removeAll(this.entries.keySet());
            this.intializeEntries(newMembers);
        } else {
            this.entries.keySet().retainAll(newMembers);
        }
        this.ownerIndex = this.indexOf(this.owner);
    }

    public String toString() {
        String classType = "VectorTime";
        int bufferSize = this.entries.size() * 2 + classType.length() + 2;
        StringBuffer buf = new StringBuffer(bufferSize);
        buf.append(classType);
        buf.append(this.entries);
        return buf.toString();
    }

    private void intializeEntries(Collection c) {
        for (Address newMember : c) {
            this.entries.put(newMember, 0);
        }
    }
}

