/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.stack.AckReceiverWindow;
import com.gemstone.org.jgroups.stack.AckSenderWindow;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;

public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand {
    private ViewId myViewId;
    private final Vector members = new Vector(11);
    private final Vector tmp_members = new Vector(11);
    private final HashMap connections = new HashMap(11);
    private long[] timeout = new long[]{400L, 800L, 1600L, 3200L};
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private volatile boolean connected;
    private boolean use_gms = true;
    private final BoundedList previous_members = new BoundedList(50);
    private static final String name = "UNICAST";
    private static final long DEFAULT_FIRST_SEQNO = 1L;
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_acks_sent = 0L;
    private long num_acks_received = 0L;
    private long num_xmit_requests_received = 0L;
    private AckSender ackSender;
    private final AtomicLong numReceivedMsgs = new AtomicLong();
    private final AtomicLong numSentMsgs = new AtomicLong();
    private final AtomicLong numSentHighPrioMsgs = new AtomicLong();
    private final Object deliverySync = new Object();
    private long max_xmit_burst = 0L;
    public static final String BYPASS_UNICAST = "NO_UCAST";
    boolean debug39744 = Boolean.getBoolean("debug39744");

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 4;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    public String printConnections() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : this.connections.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    public long getNumberOfRetransmitRequestsReceived() {
        return this.num_xmit_requests_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfUnackedMessages() {
        int num = 0;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            for (Entry entry : this.connections.values()) {
                if (entry.sent_msgs != null) {
                    num += entry.sent_msgs.size();
                }
                num += entry.sent_high_prio_msgs.size();
            }
        }
        return num;
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmit_requests_received = 0L;
    }

    @Override
    public Map dumpStats() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        m.put("num_msgs_sent", this.num_msgs_sent);
        m.put("num_msgs_received", this.num_msgs_received);
        m.put("num_bytes_sent", this.num_bytes_sent);
        m.put("num_bytes_received", this.num_bytes_received);
        m.put("num_acks_sent", this.num_acks_sent);
        m.put("num_acks_received", this.num_acks_received);
        m.put("num_xmit_requests_received", this.num_xmit_requests_received);
        return m;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("window_size")) != null) {
            props.remove("window_size");
            this.log.error(JGroupsStrings.UNICAST_WINDOW_SIZE_IS_DEPRECATED_AND_WILL_BE_IGNORED);
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            props.remove("min_threshold");
            this.log.error(JGroupsStrings.UNICAST_MIN_THRESHOLD_IS_DEPRECATED_AND_WILL_BE_IGNORED);
        }
        if ((str = props.getProperty("use_gms")) != null) {
            this.use_gms = Boolean.valueOf(str);
            props.remove("use_gms");
        }
        if ((str = props.getProperty("max_xmit_burst")) != null) {
            this.max_xmit_burst = Long.parseLong(str);
            props.remove("max_xmit_burst");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.UNICAST_UNICASTSETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        this.removeAllConnections();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (Boolean.getBoolean("p2p.ackSenderThread")) {
            if (this.ackSender == null) {
                this.ackSender = new AckSender();
            }
            this.ackSender.start();
        }
    }

    @Override
    public void stop() {
        if (this.ackSender != null) {
            this.ackSender.stop();
        }
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.getHeader(name)) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, msg);
                        return;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno, msg.timeStamp, false);
                        break;
                    }
                    case 2: {
                        this.handleAckReceived(src, hdr.seqno, msg.timeStamp, true);
                        break;
                    }
                    default: {
                        this.log.error(JGroupsStrings.UNICAST_UNICASTHEADER_TYPE__0__NOT_KNOWN_, hdr.type);
                    }
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 3: {
                this.connected = true;
                break;
            }
            case 1: {
                Message tmp;
                Entry entry;
                Object addr;
                Address dst;
                Message msg = (Message)evt.getArg();
                if (msg.getHeader(BYPASS_UNICAST) != null || (dst = msg.getDest()) == null || dst.isMulticastAddress()) break;
                if (this.previous_members.contains(dst)) {
                    if (trace) {
                        this.log.trace("discarding message to " + dst + " as this member left the group,");
                    }
                    return;
                }
                HashMap hashMap = this.connections;
                synchronized (hashMap) {
                    addr = dst;
                    entry = (Entry)this.connections.get(addr);
                    if (entry == null) {
                        entry = new Entry((Address)addr);
                        this.connections.put(addr, entry);
                        if (trace) {
                            this.log.trace(this.local_addr + ": created new UNICAST connection for recipient " + dst);
                        }
                    }
                }
                addr = entry;
                synchronized (addr) {
                    long seqno = entry.sent_msgs_seqno;
                    UnicastHeader hdr = new UnicastHeader(0, seqno);
                    if (entry.sent_msgs == null) {
                        entry.sent_msgs = new AckSenderWindow(this, this.timeout, this.timer);
                        entry.sent_high_prio_msgs = new AckSenderWindow(this, this.timeout, this.timer);
                    }
                    msg.putHeader(name, hdr);
                    ++entry.sent_msgs_seqno;
                    tmp = msg;
                    if (msg.isHighPriority) {
                        entry.sent_high_prio_msgs.add(seqno, tmp);
                        ++entry.numSentHighPrioMsgs;
                        long hm = this.numSentHighPrioMsgs.incrementAndGet();
                        entry.sentMsgsBytes += tmp.size();
                        if (this.stack.gemfireStats != null) {
                            this.stack.gemfireStats.setJgUNICASTsentHighPriorityMessagesSize(hm);
                        }
                    } else {
                        entry.sent_msgs.add(seqno, tmp);
                        ++entry.numSentMsgs;
                        entry.sentMsgsBytes += tmp.size();
                        long sm = this.numSentMsgs.incrementAndGet();
                        if (this.stack.gemfireStats != null) {
                            this.stack.gemfireStats.setJgUNICASTsentMessagesSize(sm);
                        }
                    }
                    ++this.num_msgs_sent;
                    this.num_bytes_sent += (long)msg.getLength();
                }
                this.passDown(new Event(1, tmp));
                msg = null;
                return;
            }
            case 6: {
                void var11_27;
                Vector left_members;
                View view = (View)evt.getArg();
                Vector new_members = view.getMembers();
                Cloneable hdr = this.members;
                synchronized (hdr) {
                    left_members = Util.determineLeftMembers(this.members, new_members);
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    for (Object e : this.members) {
                        this.previous_members.removeElement(e);
                    }
                    this.myViewId = view.getVid();
                }
                hdr = this.connections;
                synchronized (hdr) {
                    for (Map.Entry entry : this.connections.entrySet()) {
                        Address memberId;
                        IpAddress addr = (IpAddress)entry.getKey();
                        if (addr.getBirthViewId() >= 0 || (memberId = view.getMember(addr)) == null || memberId == addr) continue;
                        if (this.log.isInfoEnabled()) {
                            this.log.info("establishing UNICAST view ID of " + addr + " with that of " + memberId);
                        }
                        addr.setBirthViewId(memberId.getBirthViewId());
                        Entry e = (Entry)entry.getValue();
                        e.memberId = memberId;
                    }
                }
                if (!this.use_gms || left_members.size() <= 0) break;
                boolean bl = false;
                while (var11_27 < left_members.size()) {
                    Object mbr = left_members.elementAt((int)var11_27);
                    boolean rc = this.removeConnection(mbr);
                    if (rc && trace) {
                        this.log.trace("removed " + mbr + " from connection table, member(s) " + left_members + " left");
                    }
                    ++var11_27;
                }
                break;
            }
            case 15: {
                Vector mbr = this.members;
                synchronized (mbr) {
                    this.tmp_members.clear();
                    this.tmp_members.addAll(((View)evt.getArg()).getMembers());
                    break;
                }
            }
            case 67: {
                Object member = evt.getArg();
                this.previous_members.removeElement(member);
                if (!trace) break;
                this.log.trace("removing " + member + " from previous_members as result of ENABLE_UNICAST_TO event, " + "previous_members=" + this.previous_members);
                break;
            }
            case 1008: {
                Object member = evt.getArg();
                if (trace) {
                    this.log.trace("removing connection for " + member + " as result of DISABLE_UNICAST_TO event, " + "previous_members=" + this.previous_members);
                }
                this.removeConnection(member);
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeConnection(Object mbr) {
        Entry entry;
        Object object = this.connections;
        synchronized (object) {
            entry = (Entry)this.connections.remove(mbr);
            if (!this.previous_members.contains(mbr)) {
                this.previous_members.add(mbr);
            }
        }
        if (entry != null) {
            object = entry;
            synchronized (object) {
                long rm2 = this.numReceivedMsgs.addAndGet(-entry.numReceivedMsgs);
                long sm = this.numSentMsgs.addAndGet(-entry.numSentMsgs);
                long hm = this.numSentHighPrioMsgs.addAndGet(-entry.numSentHighPrioMsgs);
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.setJgUNICASTreceivedMessagesSize(rm2);
                    this.stack.gemfireStats.setJgUNICASTsentMessagesSize(sm);
                    this.stack.gemfireStats.setJgUNICASTsentHighPriorityMessagesSize(hm);
                }
            }
            entry.reset();
            if (trace) {
                this.log.trace(this.local_addr + ": removed connection for dst " + mbr);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConnections() {
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            for (Entry entry : this.connections.values()) {
                entry.reset();
            }
            this.connections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retransmit(long seqno, Message msg) {
        if (this.connected) {
            Vector vector = this.members;
            synchronized (vector) {
                if (!this.members.contains(msg.getDest()) && !this.tmp_members.contains(msg.getDest())) {
                    IpAddress mbr = (IpAddress)msg.getDest();
                    if (this.myViewId != null && mbr.getBirthViewId() > 0 && (long)mbr.getBirthViewId() <= this.myViewId.getId()) {
                        if (trace) {
                            this.log.trace("stopping retransmission of message for non member: " + msg);
                        }
                        throw new IllegalStateException();
                    }
                }
            }
        }
        msg.bundleable = false;
        this.passDown(new Event(1, msg));
        ++this.num_xmit_requests_received;
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incUcastRetransmits();
        }
    }

    @Override
    public long getMaxRetransmissionBurst() {
        return this.max_xmit_burst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataReceived(Address sender, long seqno, Message msg) {
        Entry entry;
        if (this.previous_members.contains(sender)) {
            if (seqno > 1L) {
                if (trace) {
                    this.log.trace("discarding message " + seqno + " from previous member " + sender);
                }
                return;
            }
            if (trace) {
                this.log.trace("removed " + sender + " from previous_members as we received a message from it");
            }
            this.previous_members.removeElement(sender);
        }
        if (this.debug39744 && msg.isJoinResponse) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "received " + msg + " from " + sender);
        }
        this.sendAck(msg.getSrc(), seqno, msg.isHighPriority);
        Object object = this.connections;
        synchronized (object) {
            entry = (Entry)this.connections.get(sender);
            if (sender.getBirthViewId() < 0) {
                while (entry != null && entry.memberId.getBirthViewId() >= 0) {
                    this.connections.remove(sender);
                    if (trace) {
                        this.log.trace(this.local_addr + ": removed UNICAST connection for old sender " + entry.memberId);
                    }
                    entry = (Entry)this.connections.get(sender);
                }
            }
            if (entry == null) {
                entry = new Entry(sender);
                this.connections.put(sender, entry);
                if (trace) {
                    this.log.trace(this.local_addr + ": created new UNICAST connection for sender " + sender);
                }
            }
            if (entry.received_msgs == null) {
                entry.received_msgs = new AckReceiverWindow(1L);
            }
        }
        object = this.deliverySync;
        synchronized (object) {
            boolean alreadyAdded = !entry.received_msgs.add(seqno, msg);
            ++this.num_msgs_received;
            this.num_bytes_received += (long)msg.getLength();
            if (!alreadyAdded) {
                Message m;
                if (msg.isHighPriority) {
                    if (this.stack.enableClockStats && msg.timeStamp > 0L) {
                        this.stack.gemfireStats.incJgUNICASTdataReceived(this.nanoTime() - msg.timeStamp);
                    }
                    if (TP.VERBOSE) {
                        try {
                            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "dispatching message with payload " + msg.getObject());
                        }
                        catch (Exception e) {
                            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "dispatching message (payload not deserializable)", (Throwable)e);
                        }
                    }
                    this.passUp(new Event(1, msg));
                } else {
                    if (TP.VERBOSE && !entry.received_msgs.isNextToRemove(seqno)) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.ONE_ARG, "waiting for unicast msg with seqno " + entry.received_msgs.nextToRemove());
                    }
                    Entry e = entry;
                    synchronized (e) {
                        ++entry.numReceivedMsgs;
                        long rm2 = this.numReceivedMsgs.incrementAndGet();
                        if (this.stack.gemfireStats != null) {
                            this.stack.gemfireStats.setJgUNICASTreceivedMessagesSize(rm2);
                        }
                    }
                }
                while ((m = entry.received_msgs.remove()) != null) {
                    if (m.isHighPriority) continue;
                    if (this.stack.enableClockStats && m.timeStamp > 0L) {
                        this.stack.gemfireStats.incJgUNICASTdataReceived(this.nanoTime() - m.timeStamp);
                    }
                    if (TP.VERBOSE) {
                        try {
                            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "dispatching message " + m + " with payload " + msg.getObject());
                        }
                        catch (Exception e) {
                            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "dispatching message " + m + " (payload not deserializable)", (Throwable)e);
                        }
                    }
                    this.passUp(new Event(1, m));
                    Entry entry2 = entry;
                    synchronized (entry2) {
                        --entry.numReceivedMsgs;
                        long rm3 = this.numReceivedMsgs.decrementAndGet();
                        if (this.stack.gemfireStats != null) {
                            this.stack.gemfireStats.setJgUNICASTreceivedMessagesSize(rm3);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAckReceived(Object sender, long seqno, long timeStamp, boolean highPriority) {
        Entry entry;
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            entry = (Entry)this.connections.get(sender);
        }
        if (this.debug39744) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "ack received from " + sender + " for " + seqno);
        }
        if (entry == null || highPriority && entry.sent_high_prio_msgs == null || !highPriority && entry.sent_msgs == null) {
            if (trace) {
                this.log.trace("No entry found for unicast ack from " + sender);
            }
            return;
        }
        if (highPriority) {
            long size2 = entry.sent_high_prio_msgs.ack(seqno);
            if (size2 >= 0L) {
                --entry.numSentHighPrioMsgs;
                long hm = this.numSentHighPrioMsgs.decrementAndGet();
                entry.sentMsgsBytes -= size2;
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.setJgUNICASTsentHighPriorityMessagesSize(hm);
                }
            }
        } else {
            long size3 = entry.sent_msgs.ack(seqno);
            if (size3 >= 0L) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    --entry.numSentMsgs;
                    entry.sentMsgsBytes -= size3;
                    long sm = this.numSentMsgs.decrementAndGet();
                    if (this.stack.gemfireStats != null) {
                        this.stack.gemfireStats.setJgUNICASTsentMessagesSize(sm);
                    }
                }
            }
        }
        ++this.num_acks_received;
    }

    private void sendAck(Address dst, long seqno, boolean highPriority) {
        Message ack = new Message(dst, null, null);
        ack.putHeader(name, new UnicastHeader(highPriority ? (byte)2 : 1, seqno));
        ack.isHighPriority = true;
        Event e = new Event(1, ack);
        if (this.ackSender == null) {
            this.passDown(e);
        } else {
            try {
                this.ackSender.ackQueue.add(e);
            }
            catch (QueueClosedException qe) {
                this.passDown(e);
            }
        }
        ++this.num_acks_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAckSenderWindows() {
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "dump of UNICAST sender windows:");
            for (Map.Entry entry : this.connections.entrySet()) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "receiver=" + entry.getKey() + " entry=" + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAckSenderWindow(Address addr) {
        Entry entry = null;
        Object object = this.connections;
        synchronized (object) {
            entry = (Entry)this.connections.get(addr);
        }
        if (entry == null) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "UNICAST: no entry found for " + addr);
        } else {
            object = entry;
            synchronized (object) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "UNICAST: high priority ack sender window for " + addr + " is " + entry.sent_high_prio_msgs);
            }
        }
    }

    class AckSender
    implements Runnable {
        public Queue ackQueue = new Queue();
        public Thread t;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            AckSender ackSender = this;
            synchronized (ackSender) {
                this.t = new Thread(GemFireTracer.GROUP, this, "AckSender");
                this.t.setDaemon(true);
                this.ackQueue = new Queue();
                this.t.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.ackQueue.close(true);
            AckSender ackSender = this;
            synchronized (ackSender) {
                if (this.t != null) {
                    this.t.interrupt();
                }
                this.t = null;
            }
        }

        @Override
        public void run() {
            while (true) {
                block7: {
                    SystemFailure.checkFailure();
                    if (this.ackQueue.closed() || Thread.currentThread().isInterrupted()) break;
                    try {
                        Event e = (Event)this.ackQueue.remove();
                        UNICAST.this.passDown(e);
                    }
                    catch (InterruptedException ie) {
                        if (UNICAST.this.log.isTraceEnabled()) {
                            UNICAST.this.log.trace("ack sender thread terminated by interrupt");
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (QueueClosedException ce) {
                        return;
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable ex) {
                        SystemFailure.checkFailure();
                        if (!UNICAST.this.log.isErrorEnabled()) break block7;
                        UNICAST.this.log.error(JGroupsStrings.UNICAST_ERROR_PROCESSING_OUTGOING_ACK_EVENT, ex);
                    }
                }
                if (!Protocol.trace) continue;
                UNICAST.this.log.trace("ack sender thread terminating");
            }
        }
    }

    protected static final class Entry {
        Address memberId;
        AckReceiverWindow received_msgs = null;
        AckSenderWindow sent_msgs = null;
        AckSenderWindow sent_high_prio_msgs;
        long numReceivedMsgs;
        long numSentMsgs;
        long numSentHighPrioMsgs;
        long sentMsgsBytes;
        long sent_msgs_seqno = 1L;

        Entry(Address mbr) {
            this.memberId = mbr;
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.sent_high_prio_msgs != null) {
                this.sent_high_prio_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
            this.numSentHighPrioMsgs = 0L;
            this.numSentMsgs = 0L;
            this.numReceivedMsgs = 0L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=" + this.sent_msgs + '\n');
            }
            if (this.sent_high_prio_msgs != null) {
                sb.append("sent_high_prio_msgs=" + this.sent_msgs + '\n');
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=" + this.received_msgs + '\n');
            }
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header
    implements Streamable {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte HIGH_PRIO_ACK = 2;
        byte type = 0;
        long seqno = 0L;
        static final long serialized_size = 9L;

        public UnicastHeader() {
        }

        public UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        @Override
        public String toString() {
            return "[UNICAST: " + UnicastHeader.type2Str(this.type) + ", seqno=" + this.seqno + ']';
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "HIGH_PRIO_ACK";
                }
            }
            return "<unknown>";
        }

        @Override
        public long size(short version) {
            return 9L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }
    }
}

