/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.Logger;

public class UDP
extends TP
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    DatagramSocket sock = null;
    private static BoundedList last_ports_used = null;
    int num_last_ports = 100;
    MulticastSocket mcast_recv_sock = null;
    MulticastSocket mcast_send_sock = null;
    MulticastSocket[] mcast_send_sockets = null;
    int[] membership_port_range = new int[]{0, 65535};
    int tos = 0;
    IpAddress mcast_addr = null;
    String mcast_addr_name = "228.8.8.8";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    UcastReceiver ucast_receiver = null;
    boolean ip_mcast = true;
    int ip_ttl = 64;
    int mcast_send_buf_size = 32000;
    int mcast_recv_buf_size = 64000;
    int ucast_send_buf_size = 32000;
    int ucast_recv_buf_size = 64000;
    boolean closed = false;
    private boolean can_bind_to_mcast_addr = Boolean.getBoolean("gemfire.jg-can_bind_to_mcast_addr") || Util.checkForLinux() || Util.checkForSolaris() || Util.checkForAIX();

    @Override
    public boolean setProperties(Properties props) {
        if (!super.setProperties(props)) {
            return false;
        }
        String str = props.getProperty("membership_port_range_start");
        if (str != null) {
            this.membership_port_range[0] = Integer.parseInt(str);
            props.remove("membership_port_range_start");
        }
        if ((str = props.getProperty("membership_port_range_end")) != null) {
            this.membership_port_range[1] = Integer.parseInt(str);
            props.remove("membership_port_range_end");
        }
        if ((str = props.getProperty("num_last_ports")) != null) {
            this.num_last_ports = Integer.parseInt(str);
            props.remove("num_last_ports");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            this.mcast_addr_name = str;
            props.remove("mcast_addr");
        }
        if ((str = System.getProperty("jboss.partition.udpGroup")) != null) {
            this.mcast_addr_name = str;
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = Integer.parseInt(str);
            props.remove("mcast_port");
        }
        if ((str = System.getProperty("jboss.partition.udpPort")) != null) {
            this.mcast_port = Integer.parseInt(str);
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = Boolean.valueOf(str);
            props.remove("ip_mcast");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("tos")) != null) {
            this.tos = Integer.parseInt(str);
            props.remove("tos");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            props.remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            props.remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            props.remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            props.remove("ucast_recv_buf_size");
        }
        if ((str = props.getProperty("null_src_addresses")) != null) {
            props.remove("null_src_addresses");
            this.log.error(JGroupsStrings.UDP_NULL_SRC_ADDRESSES_HAS_BEEN_DEPRECATED_PROPERTY_WILL_BE_IGNORED);
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.UDP_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    private BoundedList getLastPortsUsed() {
        if (last_ports_used == null) {
            last_ports_used = new BoundedList(this.num_last_ports);
        }
        return last_ports_used;
    }

    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (true) {
            SystemFailure.checkFailure();
            if (this.mcast_recv_sock == null || this.mcast_recv_sock.isClosed() || Thread.currentThread().isInterrupted()) break;
            try {
                packet.setData(receive_buf, 0, receive_buf.length);
                if (Thread.currentThread().isInterrupted()) break;
                this.mcast_recv_sock.receive(packet);
                InetAddress sender_addr = packet.getAddress();
                int sender_port = packet.getPort();
                int offset = packet.getOffset();
                int len = packet.getLength();
                byte[] data = packet.getData();
                IpAddress sender = new IpAddress(sender_addr, sender_port);
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.incMcastReadBytes(len);
                }
                if (len > receive_buf.length && this.log.isErrorEnabled()) {
                    this.log.error("size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                }
                this.receive(this.mcast_addr, sender, data, offset, len);
            }
            catch (SocketException sock_ex) {
                if (!trace) break;
                this.log.trace("multicast socket is closed, exception=" + sock_ex);
                break;
            }
            catch (InterruptedIOException io_ex) {
                break;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (this.mcast_recv_sock.isClosed()) continue;
                if (ex.getCause() != null) {
                    ex.fillInStackTrace();
                }
                if (!Thread.currentThread().isInterrupted() && this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.UDP_FAILURE_IN_MULTICAST_RECEIVE, ex);
                }
                try {
                    Util.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("multicast thread terminated");
        }
    }

    @Override
    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("group_addr=").append(this.mcast_addr_name).append(':').append(this.mcast_port).append("\n");
        return sb.toString();
    }

    @Override
    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        if (this.ip_mcast && this.mcast_addr != null) {
            this._send(this.mcast_addr, true, false, data, offset, length);
        } else {
            ArrayList mbrs = new ArrayList(this.members);
            for (IpAddress mbr : mbrs) {
                this._send(mbr, false, false, data, offset, length);
            }
        }
    }

    @Override
    public void sendToSingleMember(Address dest, boolean isJoinResponse, byte[] data, int offset, int length) throws Exception {
        this._send((IpAddress)dest, false, isJoinResponse, data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
        Address sender = src;
        if (msg.getSrc() != null) {
            sender = msg.getSrc();
        }
        if (sender != null) {
            Vector vector = this.members;
            synchronized (vector) {
                int idx = this.members.indexOf(sender);
                Address canonical = idx >= 0 ? (Address)this.members.get(idx) : sender;
                msg.setSrc(canonical);
            }
        }
        msg.setDest(dest);
    }

    @Override
    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
        msg.setDest(dest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _send(IpAddress destAddr, boolean mcast, boolean isJoinResponse, byte[] data, int offset, int length) throws Exception {
        if (this.closed) {
            return;
        }
        InetAddress dest = destAddr.getIpAddress();
        int port = destAddr.getPort();
        DatagramPacket packet = new DatagramPacket(data, offset, length, dest, port);
        try {
            if (mcast) {
                if (this.mcast_send_sock != null) {
                    long start = 0L;
                    if (this.stack.enableClockStats) {
                        start = this.stack.gemfireStats.startMcastWrite();
                    }
                    this.mcast_send_sock.send(packet);
                    if (this.stack.gemfireStats == null) return;
                    this.stack.gemfireStats.endMcastWrite(start, length);
                    return;
                } else {
                    if (this.mcast_send_sockets == null) throw new Exception("both mcast_send_sock and mcast_send_sockets are null");
                    for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                        MulticastSocket s = this.mcast_send_sockets[i];
                        try {
                            long start = 0L;
                            if (this.stack.enableClockStats) {
                                start = this.stack.gemfireStats.startMcastWrite();
                            }
                            s.send(packet);
                            if (this.stack.gemfireStats == null) continue;
                            this.stack.gemfireStats.endMcastWrite(start, length);
                            continue;
                        }
                        catch (InterruptedIOException ie) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedException("Solaris-only: InterruptedIOException, we must be closing");
                        }
                        catch (Exception e) {
                            this.log.error(JGroupsStrings.UDP_FAILED_SENDING_PACKET_ON_SOCKET__0, s, (Throwable)e);
                        }
                    }
                }
                return;
            } else {
                if (this.sock == null) return;
                long start = 0L;
                if (this.stack.enableClockStats) {
                    start = this.stack.gemfireStats.startUcastWrite();
                }
                this.sock.send(packet);
                if ((VERBOSE || GemFireTracer.DEBUG) && isJoinResponse) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Sent packet of length " + length + " to " + dest + ":" + port);
                }
                if (this.stack.gemfireStats == null) return;
                this.stack.gemfireStats.endUcastWrite(start, length);
            }
            return;
        }
        catch (InterruptedIOException ie) {
            Thread.currentThread().interrupt();
            if (this.closed) return;
            throw new Exception("dest=" + dest + ":" + port + " (" + length + " bytes)", ie);
        }
        catch (IOException ex) {
            if (ex.getMessage().equalsIgnoreCase("operation not permitted")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("unable to send message to " + dest + ":" + port + " (" + length + " bytes);  Operation was not permitted by datagram socket.");
                }
                this.passUp(new Event(9, new SuspectMember(this.local_addr, destAddr)));
                return;
            }
            if (this.stack.getChannel().closing()) return;
            Exception new_ex = new Exception("dest=" + dest + ":" + port + " (" + length + " bytes)", ex);
            throw new_ex;
        }
        catch (Exception ex) {
            Exception new_ex = new Exception("dest=" + dest + ":" + port + " (" + length + " bytes)", ex);
            throw new_ex;
        }
    }

    @Override
    public String getName() {
        return "UDP";
    }

    @Override
    public int getProtocolEnum() {
        return 1;
    }

    public DatagramSocket getMembershipSocket() {
        return this.sock;
    }

    @Override
    public void start() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("creating sockets and starting threads");
        }
        try {
            this.createSockets();
        }
        catch (SystemConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String tmp = "Problem creating sockets (bind_addr=" + this.bind_addr + ", mcast_addr=" + this.mcast_addr_name + ")";
            throw new Exception(tmp, ex);
        }
        super.start();
        this.startThreads();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
        super.stop();
    }

    private void createSockets() throws Exception {
        DatagramSocket override = this.stack.jgmm.getMembershipSocketForUDP();
        if (override != null && !override.isClosed()) {
            this.sock = override;
        } else {
            String bindAddress = System.getProperty("gemfire.jg-bind-address");
            int bp = Integer.getInteger("gemfire.jg-bind-port", 0);
            if (bp > 0) {
                this.bind_port = bp;
            }
            if (bindAddress != null && bindAddress.length() > 0) {
                this.bind_addr = InetAddress.getByName(bindAddress);
            }
            if (this.bind_addr == null) {
                this.bind_addr = SocketCreator.getLocalHost();
            }
            if (this.bind_addr != null && this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.UDP_DATAGRAM_SOCKETS_WILL_USE_INTERFACE__0, this.bind_addr.getHostAddress());
            }
            this.sock = this.bind_port > 0 ? this.createDatagramSocketWithBindPort() : this.createEphemeralDatagramSocket();
            if (this.tos > 0) {
                try {
                    this.sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    // empty catch block
                }
            }
            if (this.sock != null) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("setting SO_TIMEOUT on UDP unicast socket to 1000");
                    }
                    this.sock.setSoTimeout(1000);
                }
                catch (SocketException e) {
                    logger.debug("unable to set SO_TIMEOUT on UDP datagram port", (Throwable)e);
                }
            }
            if (this.sock == null) {
                throw new Exception("UDP.createSocket(): sock is null");
            }
        }
        this.local_addr = new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
        if (this.additional_data != null) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        ((IpAddress)this.local_addr).setGemFireAttributes(MemberAttributes.DEFAULT);
        if (this.ip_mcast) {
            List interfaces;
            InetAddress tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            if (this.can_bind_to_mcast_addr) {
                try {
                    this.mcast_recv_sock = new MulticastSocket(new InetSocketAddress(tmp_addr, this.mcast_port));
                }
                catch (SocketException b) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("unable to bind multicast socket to " + this.mcast_addr_name + ".  using null InetAddress instead");
                    }
                    this.can_bind_to_mcast_addr = false;
                    this.mcast_recv_sock = new MulticastSocket(this.mcast_port);
                }
            } else {
                this.mcast_recv_sock = new MulticastSocket(this.mcast_port);
            }
            this.mcast_recv_sock.setTimeToLive(this.ip_ttl);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            this.passUp(new Event(1001, this.mcast_addr));
            if (this.receive_on_all_interfaces || this.receive_interfaces != null && this.receive_interfaces.size() > 0) {
                interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
                this.bindToInterfaces(interfaces, this.mcast_recv_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.mcast_recv_sock.setInterface(this.bind_addr);
                }
                this.mcast_recv_sock.joinGroup(tmp_addr);
            }
            if (this.send_on_all_interfaces || this.send_interfaces != null && this.send_interfaces.size() > 0) {
                interfaces = this.send_interfaces != null ? this.send_interfaces : Util.getAllAvailableInterfaces();
                this.mcast_send_sockets = new MulticastSocket[interfaces.size()];
                int index2 = 0;
                for (NetworkInterface intf : interfaces) {
                    this.mcast_send_sockets[index2] = new MulticastSocket();
                    this.mcast_send_sockets[index2].setNetworkInterface(intf);
                    this.mcast_send_sockets[index2].setTimeToLive(this.ip_ttl);
                    if (this.tos > 0) {
                        try {
                            this.mcast_send_sockets[index2].setTrafficClass(this.tos);
                        }
                        catch (SocketException e) {
                            // empty catch block
                        }
                    }
                    ++index2;
                }
            } else {
                this.mcast_send_sock = new MulticastSocket();
                this.mcast_send_sock.setTimeToLive(this.ip_ttl);
                if (this.bind_addr != null) {
                    this.mcast_send_sock.setInterface(this.bind_addr);
                }
                if (this.tos > 0) {
                    try {
                        this.mcast_send_sock.setTrafficClass(this.tos);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                }
            }
        }
        this.setBufferSizes();
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.UDP_SOCKET_INFORMATIONN_0, this.dumpSocketInfo());
        }
        this.closed = false;
    }

    private void bindToInterfaces(List interfaces, MulticastSocket s, InetAddress mcastAddr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcastAddr, this.mcast_port);
        for (NetworkInterface i : interfaces) {
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            s.joinGroup(tmp_mcast_addr, i);
            if (!trace) continue;
            this.log.trace("joined " + tmp_mcast_addr + " on " + i.getName() + " (" + addr + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DatagramSocket createEphemeralDatagramSocket() throws SocketException {
        int localPort;
        DatagramSocket tmp = null;
        SecureRandom rand = new SecureRandom();
        int startingLocalPort = localPort = this.membership_port_range[0] + rand.nextInt(this.membership_port_range[1] - this.membership_port_range[0] + 1);
        int lastPortInRange = this.membership_port_range[1];
        while (true) {
            if (localPort > lastPortInRange) {
                if (startingLocalPort == 0) throw new SystemConnectException(JGroupsStrings.UNABLE_TO_FIND_FREE_PORT.toLocalizedString());
                localPort = this.membership_port_range[0];
                lastPortInRange = startingLocalPort - 1;
                startingLocalPort = 0;
            }
            if (localPort < 0) {
                localPort = 0;
            }
            try {
                tmp = null;
                tmp = new DatagramSocket(localPort, this.bind_addr);
            }
            catch (SocketException b) {
                if (!Util.treatAsBindException(b)) throw b;
                ++localPort;
            }
            if (tmp == null) continue;
            if (this.num_last_ports <= 0) {
                return tmp;
            }
            localPort = tmp.getLocalPort();
            if (!this.getLastPortsUsed().contains(localPort)) {
                this.getLastPortsUsed().add(localPort);
                return tmp;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("local port " + localPort + " already seen in this session; will try to get other port");
            }
            try {
                tmp.close();
                ++localPort;
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                ++localPort;
                continue;
            }
            break;
        }
    }

    private DatagramSocket createDatagramSocketWithBindPort() throws Exception {
        DatagramSocket tmp = null;
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                tmp = new DatagramSocket(rcv_port, this.bind_addr);
                break;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
            if (rcv_port < max_port + 1) continue;
            throw new Exception("UDP.createSockets(): cannot create a socket on any port in range " + this.bind_port + '-' + (this.bind_port + this.port_range));
        }
        return tmp;
    }

    private String dumpSocketInfo() throws Exception {
        StringBuffer sb = new StringBuffer(128);
        sb.append("local_addr=").append(this.local_addr);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.sock != null) {
            sb.append("\nsock: bound to ");
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.sock.getReceiveBufferSize());
            sb.append(", send buffer size=").append(this.sock.getSendBufferSize());
        }
        if (this.mcast_recv_sock != null) {
            sb.append("\nmcast_recv_sock: bound to ");
            sb.append(this.mcast_recv_sock.getInterface().getHostAddress()).append(':').append(this.mcast_recv_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_recv_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_recv_sock.getReceiveBufferSize());
        }
        if (this.mcast_send_sock != null) {
            sb.append("\nmcast_send_sock: bound to ");
            sb.append(this.mcast_send_sock.getInterface().getHostAddress()).append(':').append(this.mcast_send_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_send_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_send_sock.getReceiveBufferSize());
        }
        if (this.mcast_send_sockets != null) {
            sb.append("\n").append(this.mcast_send_sockets.length).append(" mcast send sockets:\n");
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                MulticastSocket s = this.mcast_send_sockets[i];
                sb.append(s.getInterface().getHostAddress()).append(':').append(s.getLocalPort());
                sb.append(", send buffer size=").append(s.getSendBufferSize());
                sb.append(", receive buffer size=").append(s.getReceiveBufferSize()).append("\n");
            }
        }
        return sb.toString();
    }

    void setBufferSizes() {
        if (this.sock != null) {
            this.setBufferSize(this.sock, this.ucast_send_buf_size, this.ucast_recv_buf_size, false);
        }
        if (this.mcast_recv_sock != null) {
            this.setBufferSize(this.mcast_recv_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size, true);
        }
        if (this.mcast_send_sock != null) {
            this.setBufferSize(this.mcast_send_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size, true);
        }
        if (this.mcast_send_sockets != null) {
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                this.setBufferSize(this.mcast_send_sockets[i], this.mcast_send_buf_size, this.mcast_recv_buf_size, true);
            }
        }
    }

    private void setBufferSize(DatagramSocket sock, int send_buf_size, int recv_buf_size, boolean ismcast) {
        block13: {
            Object[] msgArgs;
            StringId msg;
            int def;
            int real;
            String socktype;
            block12: {
                socktype = ismcast ? "multicast" : "unicast";
                try {
                    sock.setSendBufferSize(send_buf_size);
                    real = sock.getSendBufferSize();
                    if (real != send_buf_size) {
                        def = ismcast ? 65535 : 65535;
                        msg = JGroupsStrings.UDP_REQUESTED_0_1_OF_2_BUT_GOT_3;
                        msgArgs = new Object[]{socktype, "send buffer size", send_buf_size, real};
                        if (send_buf_size != def) {
                            this.log.getInternalLogWriter().warning(msg, msgArgs);
                        } else {
                            this.log.getInternalLogWriter().info(msg, msgArgs);
                        }
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (!this.warn) break block12;
                    this.log.warn("failed setting send buffer size of " + send_buf_size + " in " + sock + ": " + ex);
                }
            }
            try {
                sock.setReceiveBufferSize(recv_buf_size);
                real = sock.getReceiveBufferSize();
                if (real != recv_buf_size) {
                    def = ismcast ? 0x100000 : 0x100000;
                    msg = JGroupsStrings.UDP_REQUESTED_0_1_OF_2_BUT_GOT_3;
                    msgArgs = new Object[]{socktype, "receive buffer size", recv_buf_size, real};
                    if (recv_buf_size != def) {
                        this.log.getInternalLogWriter().warning(msg, msgArgs);
                    } else {
                        this.log.getInternalLogWriter().info(msg, msgArgs);
                    }
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.warn) break block13;
                this.log.warn("failed setting receive buffer size of " + recv_buf_size + " in " + sock + ": " + ex);
            }
        }
    }

    synchronized void closeSockets() {
        this.closeMulticastSocket();
        this.closeSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_recv_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.mcast_recv_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.mcast_recv_sock.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("multicast receive socket closed");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
        if (this.mcast_send_sock != null) {
            this.mcast_send_sock.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug("multicast send socket closed");
            }
        }
        if (this.mcast_send_sockets != null) {
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                MulticastSocket s = this.mcast_send_sockets[i];
                s.close();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("multicast send socket " + s + " closed");
            }
            this.mcast_send_sockets = null;
        }
    }

    protected void closeSocket() {
        if (this.sock != null) {
            boolean isForcedDisconnect = ((JChannel)this.stack.getChannel()).getCloseException() instanceof ForcedDisconnectException;
            if (this.stack.jgmm.getDistributionConfig().getDisableAutoReconnect() || !isForcedDisconnect && !this.stack.jgmm.isReconnectingDS()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("UDP is closing its socket.  Channel close exception = {} isReconnecting={}  disableAutoReconnect={} port={} isClosed={}", ((JChannel)this.stack.getChannel()).getCloseException(), this.stack.jgmm.isReconnectingDS(), this.stack.jgmm.getDistributionConfig().getDisableAutoReconnect(), this.sock.getLocalPort(), this.sock.isClosed());
                }
                this.sock.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("socket closed");
                }
            } else if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("UDP is not closing its socket.  Channel close exception = " + ((JChannel)this.stack.getChannel()).getCloseException() + " isReconnecting=" + this.stack.jgmm.isReconnectingDS() + "  disableAutoReconnect=" + this.stack.jgmm.getDistributionConfig().getDisableAutoReconnect() + " port=" + this.sock.getLocalPort() + " isClosed=" + this.sock.isClosed());
            }
        }
    }

    public static void loadEmergencyClasses() {
    }

    @Override
    public void emergencyClose() {
        UcastReceiver ur;
        Thread thr;
        this.closeSocket();
        MulticastSocket ms = this.mcast_recv_sock;
        if (ms != null) {
            ms.close();
        }
        if ((ms = this.mcast_send_sock) != null) {
            ms.close();
        }
        if (this.mcast_send_sockets != null) {
            for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                ms = this.mcast_send_sockets[i];
                if (ms == null) continue;
                ms.close();
            }
        }
        if ((thr = this.mcast_receiver) != null) {
            thr.interrupt();
        }
        if ((ur = this.ucast_receiver) != null && (thr = ur.thread) != null) {
            thr.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (this.log.isDebugEnabled()) {
                this.log.debug("created unicast receiver thread");
            }
        }
        if (this.ip_mcast) {
            UDP uDP = this;
            synchronized (uDP) {
                if (this.mcast_receiver != null) {
                    if (this.mcast_receiver.isAlive()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                        }
                    } else {
                        this.mcast_receiver = null;
                    }
                }
                if (this.mcast_receiver == null) {
                    this.mcast_receiver = new Thread(GemFireTracer.GROUP, this, "UDP mcast receiver");
                    this.mcast_receiver.setPriority(10);
                    this.mcast_receiver.setDaemon(true);
                    this.mcast_receiver.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopThreads() {
        UDP uDP = this;
        synchronized (uDP) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    Thread tmp = this.mcast_receiver;
                    this.mcast_receiver = null;
                    tmp.interrupt();
                    this.closeMulticastSocket();
                    try {
                        tmp.join(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    Object var1_2 = null;
                }
                this.mcast_receiver = null;
            }
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
    }

    @Override
    protected void handleConfigEvent(HashMap map) {
        super.handleConfigEvent(map);
        if (map == null) {
            return;
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
        }
        this.setBufferSizes();
    }

    public class UcastReceiver
    implements Runnable {
        Thread thread = null;

        public synchronized void start() {
            if (this.thread == null) {
                this.thread = new Thread(GemFireTracer.GROUP, this, "UDP ucast receiver");
                this.thread.setDaemon(true);
                this.thread.setPriority(10);
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                Thread tmp = this.thread;
                this.thread = null;
                tmp.interrupt();
                UDP.this.closeSocket();
                Object var1_1 = null;
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] receive_buf = new byte[65535];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (true) {
                Object s;
                if (SystemFailure.getFailure() != null) {
                    s = UDP.this.sock;
                    if (s != null) {
                        ((DatagramSocket)s).close();
                    }
                    SystemFailure.checkFailure();
                }
                if (Thread.currentThread().isInterrupted()) break;
                s = this;
                synchronized (s) {
                    if (this.thread == null) {
                        break;
                    }
                }
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.sock.receive(packet);
                    InetAddress sender_addr = packet.getAddress();
                    int sender_port = packet.getPort();
                    int offset = packet.getOffset();
                    int len = packet.getLength();
                    byte[] data = packet.getData();
                    IpAddress sender = new IpAddress(sender_addr, sender_port);
                    if (UDP.this.stack.gemfireStats != null) {
                        UDP.this.stack.gemfireStats.incUcastReadBytes(len);
                    }
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error("size of the received packet (" + len + ") is bigger than allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                    }
                    UDP.this.receive(UDP.this.local_addr, sender, data, offset, len);
                }
                catch (SocketTimeoutException e) {
                }
                catch (SocketException sock_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug("unicast receiver socket is closed, exception=" + sock_ex);
                    break;
                }
                catch (InterruptedIOException io_ex) {
                    break;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (UDP.this.sock.isClosed()) continue;
                    if (ex.getCause() != null) {
                        ex.fillInStackTrace();
                    }
                    if (!Thread.currentThread().isInterrupted() && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error(JGroupsStrings.UDP__0__FAILED_RECEIVING_UNICAST_PACKET, UDP.this.local_addr, ex);
                    }
                    try {
                        Util.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug("unicast receiver thread terminated");
            }
        }
    }
}

