/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.TunnelHeader;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.RouterStub;
import com.gemstone.org.jgroups.util.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class TUNNEL
extends Protocol
implements Runnable {
    final Properties properties = null;
    String channel_name = null;
    final Vector members = new Vector();
    String router_host = null;
    int router_port = 0;
    Address local_addr = null;
    Thread receiver = null;
    RouterStub stub = null;
    private final Object stub_mutex = new Object();
    boolean loopback = true;
    private final Reconnector reconnector = new Reconnector();
    private final Object reconnector_mutex = new Object();
    byte[] additional_data = null;
    long reconnect_interval = 5000L;

    public String toString() {
        return "Protocol TUNNEL(local_addr=" + this.local_addr + ')';
    }

    @Override
    public String getName() {
        return "TUNNEL";
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start() throws Exception {
        this.createTunnel();
        this.passUp(new Event(8, this.local_addr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TUNNEL tUNNEL = this;
        synchronized (tUNNEL) {
            if (this.receiver != null) {
                this.receiver.interrupt();
                this.receiver = null;
            }
        }
        this.teardownTunnel();
        this.stopReconnector();
    }

    @Override
    public void startUpHandler() {
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("router_host");
        if (str != null) {
            this.router_host = str;
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = Integer.parseInt(str);
            props.remove("router_port");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("router_host=" + this.router_host + ";router_port=" + this.router_port);
        }
        if ((this.router_host == null || this.router_port == 0) && this.log.isErrorEnabled()) {
            this.log.error(JGroupsStrings.TUNNEL_BOTH_ROUTER_HOST_AND_ROUTER_PORT_HAVE_TO_BE_SET_);
            return false;
        }
        str = props.getProperty("reconnect_interval");
        if (str != null) {
            this.reconnect_interval = Long.parseLong(str);
            props.remove("reconnect_interval");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.TUNNEL_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, sb);
            }
            return false;
        }
        return true;
    }

    @Override
    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        TunnelHeader hdr = new TunnelHeader(this.channel_name);
        Message msg = (Message)evt.getArg();
        Address dest = msg.getDest();
        msg.putHeader(this.getName(), hdr);
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (trace) {
            this.log.trace(msg + ", hdrs: " + msg.getHeaders());
        }
        if (this.loopback && (dest == null || dest.equals(this.local_addr) || dest.isMulticastAddress())) {
            Message copy = msg.copy();
            copy.setSrc(this.local_addr);
            evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            if (trace) {
                this.log.trace("looped back local message " + copy);
            }
            this.passUp(evt);
            if (dest != null && !dest.isMulticastAddress()) {
                return;
            }
        }
        if (!this.stub.isConnected()) {
            this.startReconnector();
        } else if (!this.stub.send(msg, this.channel_name)) {
            this.startReconnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTunnel() throws Exception {
        if (this.router_host == null || this.router_port == 0) {
            throw new Exception("router_host and/or router_port not set correctly; tunnel cannot be created");
        }
        Object object = this.stub_mutex;
        synchronized (object) {
            this.stub = new RouterStub(this.router_host, this.router_port);
            this.local_addr = this.stub.connect();
            if (this.additional_data != null && this.local_addr instanceof IpAddress) {
                ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
            }
        }
        if (this.local_addr == null) {
            throw new Exception("could not obtain local address !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void teardownTunnel() {
        Object object = this.stub_mutex;
        synchronized (object) {
            if (this.stub != null) {
                this.stub.disconnect();
                this.stub = null;
            }
        }
    }

    @Override
    public void run() {
        if (this.stub == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.TUNNEL_ROUTER_STUB_IS_NULL_CANNOT_RECEIVE_MESSAGES_FROM_ROUTER_);
            }
            return;
        }
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            Message msg = this.stub.receive();
            if (msg == null) {
                if (Thread.currentThread().isInterrupted()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("received a null message. Trying to reconnect to router");
                }
                if (!this.stub.isConnected()) {
                    this.startReconnector();
                }
                try {
                    Util.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.handleIncomingMessage(msg);
        }
    }

    public void handleIncomingMessage(Message msg) {
        String ch_name;
        TunnelHeader hdr = (TunnelHeader)msg.removeHeader(this.getName());
        if (this.loopback) {
            Address dst = msg.getDest();
            Address src = msg.getSrc();
            if (dst != null && dst.isMulticastAddress() && src != null && this.local_addr.equals(src)) {
                if (trace) {
                    this.log.trace("discarded own loopback multicast packet");
                }
                return;
            }
        }
        if (trace) {
            this.log.trace(msg + ", hdrs: " + msg.getHeaders());
        }
        String string = ch_name = hdr != null ? hdr.channel_name : null;
        if (ch_name != null && !this.channel_name.equals(ch_name)) {
            return;
        }
        this.passUp(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        if (trace) {
            this.log.trace(evt);
        }
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!(this.local_addr instanceof IpAddress) || this.additional_data == null) break;
                ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                if (this.stub == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TUNNEL_CONNECT__ROUTER_STUB_IS_NULL);
                    }
                } else {
                    this.stub.register(this.channel_name);
                }
                TUNNEL tUNNEL = this;
                synchronized (tUNNEL) {
                    this.receiver = new Thread((Runnable)this, "TUNNEL receiver thread");
                }
                this.receiver.setDaemon(true);
                this.receiver.start();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                if (this.receiver != null) {
                    this.receiver = null;
                    if (this.stub != null) {
                        this.stub.disconnect();
                    }
                }
                this.teardownTunnel();
                this.passUp(new Event(5));
                this.passUp(new Event(8, null));
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReconnector() {
        Object object = this.reconnector_mutex;
        synchronized (object) {
            this.reconnector.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnector() {
        Object object = this.reconnector_mutex;
        synchronized (object) {
            this.reconnector.stop();
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
    }

    protected class Reconnector
    implements Runnable {
        Thread my_thread = null;

        protected Reconnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Reconnector reconnector = this;
            synchronized (reconnector) {
                if (this.my_thread == null || !this.my_thread.isAlive()) {
                    this.my_thread = new Thread((Runnable)this, "Reconnector");
                    this.my_thread.setDaemon(true);
                    this.my_thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Reconnector reconnector = this;
            synchronized (reconnector) {
                if (this.my_thread != null) {
                    this.my_thread.interrupt();
                }
                this.my_thread = null;
            }
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (Thread.currentThread().isInterrupted()) break;
                if (TUNNEL.this.stub.reconnect()) {
                    TUNNEL.this.stub.register(TUNNEL.this.channel_name);
                    if (TUNNEL.this.log.isDebugEnabled()) {
                        TUNNEL.this.log.debug("reconnected");
                    }
                    return;
                }
                try {
                    Util.sleep(TUNNEL.this.reconnect_interval);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

