/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.ReadWriteLock;
import com.gemstone.org.jgroups.oswego.concurrent.WriterPreferenceReadWriteLock;
import com.gemstone.org.jgroups.stack.AckSenderWindow;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class TOTAL
extends Protocol {
    private static final String PROT_NAME = "TOTAL";
    private static final String TRACE_PROP = "trace";
    private final long[] AVG_RETRANSMIT_INTERVAL = new long[]{1000L, 2000L, 3000L, 4000L};
    private static final long NULL_ID = -1L;
    private static final int NULL_STATE = -1;
    private static final int RUN = 0;
    private static final int FLUSH = 1;
    private static final int BLOCK = 2;
    private final ReadWriteLock stateLock = new WriterPreferenceReadWriteLock();
    private int state = -1;
    private Address addr = null;
    private Address sequencerAddr = null;
    private long sequencerSeqID = -1L;
    private long localSeqID = -1L;
    private long seqID = -1L;
    private SortedMap reqTbl;
    private SortedMap upTbl;
    private AckSenderWindow retransmitter;

    private String _addrToString(Object addr) {
        return addr == null ? "<null>" : (addr instanceof IpAddress ? ((IpAddress)addr).getIpAddress().getHostAddress() + ':' + ((IpAddress)addr).getPort() : addr.toString());
    }

    private String _getName() {
        return PROT_NAME;
    }

    private boolean _setProperties(Properties properties) {
        String value2 = properties.getProperty(TRACE_PROP);
        if (value2 != null) {
            properties.remove(TRACE_PROP);
        }
        if (properties.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error("The following properties are not recognized: " + properties.toString());
            }
            return false;
        }
        return true;
    }

    Vector _requiredDownServices() {
        Vector services = new Vector();
        return services;
    }

    Vector _requiredUpServices() {
        Vector services = new Vector();
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deliverBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            Message msg;
            while ((msg = (Message)this.upTbl.remove(this.seqID + 1L)) != null) {
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSequenceID != -1L) {
                    this.passUp(new Event(1, msg));
                }
                ++this.seqID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _replayBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (this.upTbl.size() > 0 && this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_REPLAYING_UNDELIVERED_BCASTS);
            }
            Iterator it = this.upTbl.entrySet().iterator();
            while (it.hasNext()) {
                Message msg = (Message)it.next().getValue();
                it.remove();
                if (!msg.getSrc().equals(this.addr)) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("During replay: discarding BCAST[" + ((Header)msg.getHeader((String)this.getName())).sequenceID + "] from " + this._addrToString(msg.getSrc()));
                    continue;
                }
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSequenceID == -1L) continue;
                this._sendBcastRequest(msg, header.localSequenceID);
            }
        }
    }

    private Message _sendUcast(Message msg) {
        msg.putHeader(this.getName(), new Header(2, -1L, -1L));
        return msg;
    }

    private void _sendBcastRequest(Message msg) {
        this._sendBcastRequest(msg, ++this.localSeqID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendBcastRequest(Message msg, long id) {
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            this.reqTbl.put(id, msg);
        }
        this._transmitBcastRequest(id);
        this.retransmitter.add(id, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _transmitBcastRequest(long seqID) {
        if (this.state == -1) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TRANSMIT_BCAST_REQ_0__IN_NULL_STATE, seqID);
            }
            return;
        }
        if (this.state == 2) {
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            if (!this.reqTbl.containsKey(seqID)) {
                this.retransmitter.ack(seqID);
                return;
            }
        }
        Message reqMsg = new Message(this.sequencerAddr, this.addr, new byte[0]);
        reqMsg.putHeader(this.getName(), new Header(0, seqID, -1L));
        this.passDown(new Event(1, reqMsg));
    }

    private void _recvUcast(Message msg) {
        msg.removeHeader(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcast(Message msg) {
        Header header = (Header)msg.getHeader(this.getName());
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (header.sequenceID <= this.seqID) {
                return;
            }
            this.upTbl.put(header.sequenceID, msg);
        }
        this._deliverBcast();
    }

    private void _recvBcastRequest(Message msg) {
        if (!this.addr.equals(this.sequencerAddr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Received bcast request but not a sequencer");
            }
            return;
        }
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_BLOCKED_DISCARD_BCAST_REQ);
            }
            return;
        }
        Header header = (Header)msg.getHeader(this.getName());
        ++this.sequencerSeqID;
        Message repMsg = new Message(msg.getSrc(), this.addr, new byte[0]);
        repMsg.putHeader(this.getName(), new Header(1, header.localSequenceID, this.sequencerSeqID));
        this.passDown(new Event(1, repMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcastReply(Header header) {
        long id;
        Message msg;
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_BLOCKED_DISCARD_BCAST_REP);
            }
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            msg = (Message)this.reqTbl.remove(header.localSequenceID);
        }
        if (msg != null) {
            this.retransmitter.ack(header.localSequenceID);
            id = header.localSequenceID;
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info("Bcast reply to non-existent BCAST_REQ[" + header.localSequenceID + "], Sending NULL bcast");
            }
            id = -1L;
            msg = new Message(null, this.addr, new byte[0]);
        }
        msg.putHeader(this.getName(), new Header(3, id, header.sequenceID));
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _retransmitBcastRequest(long seqID) {
        try {
            this.stateLock.readLock().acquire();
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.TOTAL_RETRANSMIT_BCAST_REQ_0, seqID);
                }
                this._transmitBcastRequest(seqID);
            }
            finally {
                this.stateLock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(JGroupsStrings.TOTAL_FAILED_ACQUIRING_A_READ_LOCK, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upBlock() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 1;
            }
            finally {
                this.stateLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(JGroupsStrings.TOTAL_FAILED_ACQUIRING_THE_WRITE_LOCK, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _upMsg(Event event) {
        try {
            this.stateLock.readLock().acquire();
            try {
                if (this.state == -1) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TOTAL_UP_MSG_IN_NULL_STATE);
                    }
                    boolean bl = false;
                    return bl;
                }
                Message msg = (Message)event.getArg();
                Object obj = msg.getHeader(this.getName());
                if (!(obj instanceof Header)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TOTAL_NO_TOTALHEADER_FOUND);
                    }
                    boolean bl = false;
                    return bl;
                }
                Header header = (Header)obj;
                switch (header.type) {
                    case 2: {
                        this._recvUcast(msg);
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        this._recvBcast(msg);
                        boolean bl = false;
                        return bl;
                    }
                    case 0: {
                        this._recvBcastRequest(msg);
                        boolean bl = false;
                        return bl;
                    }
                    case 1: {
                        this._recvBcastReply(header);
                        boolean bl = false;
                        return bl;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.TOTAL_UNKNOWN_HEADER_TYPE);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.stateLock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.log.isErrorEnabled()) return true;
            this.log.error(e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upSetLocalAddress(Event event) {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.addr = (Address)event.getArg();
            }
            finally {
                this.stateLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upViewChange(Event event) {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 0;
                Address oldSequencerAddr = this.sequencerAddr;
                this.sequencerAddr = (Address)((View)event.getArg()).getMembers().elementAt(0);
                if (this.addr.equals(this.sequencerAddr)) {
                    this.sequencerSeqID = -1L;
                    if ((oldSequencerAddr == null || !this.addr.equals(oldSequencerAddr)) && this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.TOTAL_IM_THE_NEW_SEQUENCER);
                    }
                }
                this.seqID = -1L;
                this._replayBcast();
            }
            finally {
                this.stateLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _downBlockOk() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = 2;
            }
            finally {
                this.stateLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _downMsg(Event event) {
        try {
            this.stateLock.readLock().acquire();
            try {
                if (this.state == -1) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TOTAL_DISCARD_MSG_IN_NULL_STATE);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.state == 2) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.TOTAL_BLOCKED_DISCARD_MSG);
                    }
                    boolean bl = false;
                    return bl;
                }
                Message msg = (Message)event.getArg();
                if (msg.getDest() == null) {
                    this._sendBcastRequest(msg);
                    boolean bl = false;
                    return bl;
                }
                msg = this._sendUcast(msg);
                event.setArg(msg);
                return true;
            }
            finally {
                this.stateLock.readLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(e.getMessage());
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        TimeScheduler timer;
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("TOTAL.start(): timer is null");
        }
        this.reqTbl = new TreeMap();
        this.upTbl = new TreeMap();
        this.retransmitter = new AckSenderWindow(new Command(), this.AVG_RETRANSMIT_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.stateLock.writeLock().acquire();
            try {
                this.state = -1;
                this.retransmitter.reset();
                this.reqTbl.clear();
                this.upTbl.clear();
                this.addr = null;
            }
            finally {
                this.stateLock.writeLock().release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error(e.getMessage());
        }
    }

    private void _up(Event event) {
        switch (event.getType()) {
            case 10: {
                if (this._upBlock()) break;
                return;
            }
            case 1: {
                if (this._upMsg(event)) break;
                return;
            }
            case 8: {
                if (this._upSetLocalAddress(event)) break;
                return;
            }
            case 6: {
                if (this._upViewChange(event)) break;
                return;
            }
        }
        this.passUp(event);
    }

    private void _down(Event event) {
        switch (event.getType()) {
            case 11: {
                if (this._downBlockOk()) break;
                return;
            }
            case 1: {
                if (this._downMsg(event)) break;
                return;
            }
        }
        this.passDown(event);
    }

    @Override
    public String getName() {
        return this._getName();
    }

    @Override
    public boolean setProperties(Properties properties) {
        return this._setProperties(properties);
    }

    @Override
    public Vector requiredDownServices() {
        return this._requiredDownServices();
    }

    @Override
    public Vector requiredUpServices() {
        return this._requiredUpServices();
    }

    @Override
    public void up(Event event) {
        this._up(event);
    }

    @Override
    public void down(Event event) {
        this._down(event);
    }

    private class Command
    implements AckSenderWindow.RetransmitCommand {
        Command() {
        }

        @Override
        public void retransmit(long seqNo, Message msg) {
            TOTAL.this._retransmitBcastRequest(seqNo);
        }

        @Override
        public long getMaxRetransmissionBurst() {
            return 0L;
        }
    }

    public static class Header
    extends com.gemstone.org.jgroups.Header {
        public static final int NULL_TYPE = -1;
        public static final int REQ = 0;
        public static final int REP = 1;
        public static final int UCAST = 2;
        public static final int BCAST = 3;
        public int type;
        public long localSequenceID;
        public long sequenceID;

        public Header() {
        }

        public Header(int type, long localSeqID, long seqID) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.type = type;
                    break;
                }
                default: {
                    this.type = -1;
                    throw new IllegalArgumentException("type");
                }
            }
            this.localSequenceID = localSeqID;
            this.sequenceID = seqID;
        }

        @Override
        public String toString() {
            String typeName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[TOTAL.Header");
            switch (this.type) {
                case 0: {
                    typeName = "REQ";
                    break;
                }
                case 1: {
                    typeName = "REP";
                    break;
                }
                case 2: {
                    typeName = "UCAST";
                    break;
                }
                case 3: {
                    typeName = "BCAST";
                    break;
                }
                case -1: {
                    typeName = "NULL_TYPE";
                    break;
                }
                default: {
                    typeName = "";
                }
            }
            buffer.append(", type=" + typeName);
            buffer.append(", localID=" + this.localSequenceID);
            buffer.append(", seqID=" + this.sequenceID);
            buffer.append(']');
            return buffer.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.localSequenceID);
            out.writeLong(this.sequenceID);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.localSequenceID = in.readLong();
            this.sequenceID = in.readLong();
        }
    }
}

