/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.Discovery;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.stack.IpAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TCPPING
extends Discovery {
    int port_range = 1;
    ArrayList initial_hosts = null;
    static final String name = "TCPPING";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("port_range");
        if (str != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        return super.setProperties(props);
    }

    @Override
    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && addr != null && this.initial_hosts.contains(addr)) {
            this.initial_hosts.remove(addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug("[SET_LOCAL_ADDRESS]: removing my own address (" + addr + ") from initial_hosts; initial_hosts=" + this.initial_hosts);
            }
        }
    }

    @Override
    public void sendGetMembersRequest(AtomicBoolean waiter_sync) {
        this.wakeWaiter(waiter_sync);
        for (Address addr : this.initial_hosts) {
            Message msg = new Message(addr, null, null);
            msg.putHeader(name, new PingHeader(1, null));
            if (trace) {
                this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
            }
            this.passDown(new Event(1, msg));
        }
    }

    private ArrayList createInitialHosts(String l) {
        StringTokenizer tok = new StringTokenizer(l, ",");
        ArrayList<IpAddress> retval = new ArrayList<IpAddress>();
        while (tok.hasMoreTokens()) {
            try {
                int port;
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + this.port_range; ++i) {
                    IpAddress addr = new IpAddress(host, i);
                    retval.add(addr);
                }
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.TCPPING_EXEPTION_IS__0, (Throwable)e);
            }
        }
        return retval;
    }
}

