/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.Discovery;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.stack.GossipClient;
import com.gemstone.org.jgroups.stack.IpAddress;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class TCPGOSSIP
extends Discovery {
    Vector initial_hosts = null;
    GossipClient gossip_client = null;
    long gossip_refresh_rate = 20000L;
    private boolean splitBrainDetectionEnabled;
    private int gossipServerWaitTime;
    static final Vector EMPTY_VECTOR = new Vector();
    static final String name = "TCPGOSSIP";
    private boolean ipWarningIssued;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 11;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("gossip_refresh_rate");
        if (str != null) {
            this.gossip_refresh_rate = Integer.parseInt(str);
            props.remove("gossip_refresh_rate");
        }
        if ((str = props.getProperty("split-brain-detection")) != null) {
            this.splitBrainDetectionEnabled = Boolean.valueOf(str);
            props.remove("split-brain-detection");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = TCPGOSSIP.createInitialHosts(str);
        }
        if ((str = props.getProperty("gossip_server_wait_time")) != null) {
            props.remove("gossip_server_wait_time");
            this.gossipServerWaitTime = Integer.parseInt(str);
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.TCPGOSSIP_INITIAL_HOSTS_MUST_CONTAIN_THE_ADDRESS_OF_AT_LEAST_ONE_GOSSIPSERVER);
            }
            return false;
        }
        return super.setProperties(props);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.gossip_client == null) {
            this.gossip_client = new GossipClient(this.initial_hosts, this.gossip_refresh_rate, this.stack);
            this.gossip_client.setTimeout((int)this.timeout);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.gossip_client != null) {
            this.gossip_client.stop();
        }
    }

    @Override
    public void handleConnectOK() {
        if (this.group_addr == null || this.local_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("[CONNECT_OK]: group_addr or local_addr is null. cannot register with GossipServer(s)");
            }
        } else {
            this.gossip_client.register(this.group_addr, this.local_addr, this.timeout, true);
        }
    }

    @Override
    public void sendGetMembersRequest(AtomicBoolean waiter_sync) {
        Address coordinator;
        boolean isAdminOnly;
        boolean shortcutOK;
        GossipClient client = this.gossip_client;
        boolean bl = shortcutOK = !this.stack.hasTriedJoinShortcut();
        if (this.group_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.TCPGOSSIP_FIND_INITIAL_MBRS_GROUP_ADDR_IS_NULL_CANNOT_GET_MBRSHIP);
            }
            this.passUp(new Event(13, EMPTY_VECTOR));
            return;
        }
        if (trace) {
            this.log.trace("fetching members from GossipServer(s)");
        }
        boolean bl2 = isAdminOnly = (DistributionManager.getDistributionManagerType() == 12 || DistributionManager.getDistributionManagerType() == 11) && !Boolean.getBoolean("Locator.forceLocatorDMType") && !DistributionManager.isCommandLineAdminVM;
        if (this.gossip_client == null) {
            return;
        }
        long giveUpTime = System.currentTimeMillis() + (long)this.gossipServerWaitTime * 1000L;
        Vector tmp_mbrs = client.getMembers(this.group_addr, this.local_addr, true, this.timeout);
        boolean firstWait = true;
        boolean startupStatusWaitingSet = false;
        while ((this.gossip_client != null && client.getResponsiveServerCount() == 0 || tmp_mbrs == null || tmp_mbrs.size() == 0) && (isAdminOnly || System.currentTimeMillis() < giveUpTime)) {
            if (firstWait) {
                StringBuilder sb = new StringBuilder(100);
                for (Object obj : this.initial_hosts) {
                    if (!firstWait) {
                        sb.append(',');
                    }
                    firstWait = false;
                    IpAddress addr = (IpAddress)obj;
                    sb.append(addr.getIpAddress().getHostName()).append('[').append(addr.getPort()).append(']');
                }
                startupStatusWaitingSet = true;
                this.log.startup(JGroupsStrings.WAITING_FOR_LOCATOR_TO_START, sb.toString());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
            tmp_mbrs = client.getMembers(this.group_addr, this.local_addr, true, this.timeout);
            Thread shutdownHook = InternalDistributedSystem.shutdownHook;
            if (shutdownHook == null || !shutdownHook.isAlive()) continue;
            throw new GemFireConfigException("Unable to contact a Locator service before detecting that VM is exiting");
        }
        if (client.getResponsiveServerCount() == 0) {
            GemFireConfigException re = new GemFireConfigException("Unable to contact a Locator service.  Operation either timed out or Locator does not exist.  Configured list of locators is \"" + this.initial_hosts + "\".");
            throw re;
        }
        if (startupStatusWaitingSet) {
            this.log.startup(JGroupsStrings.WAITING_FOR_LOCATOR_TO_START_COMPLETED, new Object[0]);
        }
        Set<Address> serverAddresses = client.getServerAddresses();
        if (client.getFloatingCoordinatorDisabled()) {
            this.passUp(new Event(1004, null));
        }
        if (client.getNetworkPartitionDetectionEnabled() != this.splitBrainDetectionEnabled) {
            if (!this.splitBrainDetectionEnabled) {
                this.splitBrainDetectionEnabled = true;
                this.passUp(new Event(1010));
            } else {
                throw new GemFireConfigException("Locator has enable-network-partition-detection=" + client.getNetworkPartitionDetectionEnabled() + " but this member has enable-network-partition-detection=" + this.splitBrainDetectionEnabled);
            }
        }
        if (client.getNetworkPartitionDetectionEnabled() && !SocketCreator.FORCE_DNS_USE) {
            IpAddress.resolve_dns = false;
            SocketCreator.resolve_dns = false;
        }
        if (tmp_mbrs != null && !this.ipWarningIssued) {
            InetAddress bindAddress;
            TP protocol = (TP)this.stack.findProtocol("UDP");
            if (protocol == null) {
                protocol = (TP)this.stack.findProtocol("TCP");
            }
            if ((bindAddress = protocol.getInetBindAddress()) != null) {
                boolean iAmIPv4 = bindAddress instanceof Inet4Address;
                for (int i = 0; i < tmp_mbrs.size(); ++i) {
                    IpAddress addr = (IpAddress)tmp_mbrs.get(i);
                    InetAddress iaddr = addr.getIpAddress();
                    if (iAmIPv4 == iaddr instanceof Inet4Address) continue;
                    this.log.getInternalLogWriter().warning(JGroupsStrings.TCPGOSSIP_IP_VERSION_MISMATCH);
                    this.ipWarningIssued = true;
                    break;
                }
            }
        }
        serverAddresses.remove(this.local_addr);
        this.ping_waiter.setRequiredResponses(serverAddresses);
        if (client.getServerDistributedSystemCount() == 0) {
            this.passUp(new Event(1002, null));
        }
        if (shortcutOK && (coordinator = client.getCoordinator()) != null) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("Locator returned coordinator " + coordinator + ", so bypassing unicast discovery processing");
            }
            this.ping_waiter.setCoordinator(coordinator);
            this.wakeWaiter(waiter_sync);
            return;
        }
        if (tmp_mbrs == null || tmp_mbrs.size() == 0) {
            if (trace) {
                this.log.trace("[FIND_INITIAL_MBRS]: gossip client found no members");
            }
            this.passUp(new Event(13, EMPTY_VECTOR));
            this.wakeWaiter(waiter_sync);
            return;
        }
        if (trace) {
            this.log.trace("consolidated mbrs from GossipServer(s) are " + tmp_mbrs + ".  Locator distributed system count=" + client.getServerDistributedSystemCount() + ", and floatingCoordinationDisabled=" + client.getFloatingCoordinatorDisabled());
        }
        PingHeader hdr = new PingHeader(1, null);
        Message msg = new Message(null, null, null);
        msg.putHeader(name, hdr);
        msg.bundleable = false;
        this.wakeWaiter(waiter_sync);
        int max_msgs = Integer.getInteger("gemfire.max_ping_requests", 40);
        int msgs_sent = 0;
        for (int i = tmp_mbrs.size() - 1; i >= 0; --i) {
            Address mbr_addr = (Address)tmp_mbrs.elementAt(i);
            if (!serverAddresses.contains(mbr_addr) && msgs_sent >= max_msgs) continue;
            Message copy = msg.copy();
            copy.setDest(mbr_addr);
            if (trace) {
                this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + copy.getDest());
            }
            this.passDown(new Event(1, copy));
            if (Thread.currentThread().isInterrupted()) break;
            ++msgs_sent;
        }
    }

    public static Vector createInitialHosts(String l) {
        Vector<IpAddress> tmp = new Vector<IpAddress>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        boolean isLoopback = false;
        Object myAddress = null;
        String bindAddress = System.getProperty("gemfire.jg-bind-address");
        try {
            isLoopback = bindAddress == null ? SocketCreator.getLocalHost().isLoopbackAddress() : InetAddress.getByName(bindAddress).isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        while (tok.hasMoreTokens()) {
            try {
                String h;
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int idx = host.lastIndexOf(64);
                if (idx < 0) {
                    idx = host.lastIndexOf(58);
                }
                if ((h = host.substring(0, idx > -1 ? idx : host.length())).indexOf(58) >= 0) {
                    idx = host.lastIndexOf(64);
                }
                if (idx >= 0) {
                    host = host.substring(idx + 1, host.length());
                }
                int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                IpAddress addr = new IpAddress(host, port);
                if (isLoopback && !addr.getIpAddress().isLoopbackAddress()) {
                    throw new GemFireConfigException("This process is attempting to join with a loopback address (" + myAddress + ") using a locator that does not have a local address (" + addr.getIpAddress() + ").  On Unix this usually means that /etc/hosts is misconfigured.");
                }
                tmp.addElement(addr);
            }
            catch (NumberFormatException e) {}
        }
        return tmp;
    }

    @Override
    public void destroy() {
        if (this.gossip_client != null) {
            this.gossip_client.destroy();
            this.gossip_client = null;
        }
    }
}

