/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.blocks.ConnectionTable;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.BoundedList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;

public class TCP
extends TP
implements ConnectionTable.Receiver {
    private ConnectionTable ct = null;
    private InetAddress external_addr = null;
    private int start_port = 7800;
    private int end_port = 0;
    private long reaper_interval = 0L;
    private long conn_expire_time = 0L;
    final BoundedList suspected_mbrs = new BoundedList(20);
    boolean skip_suspected_members = true;
    boolean use_send_queues = true;
    int recv_buf_size = 150000;
    int send_buf_size = 150000;
    int sock_conn_timeout = 2000;

    @Override
    public String getName() {
        return "TCP";
    }

    public int getOpenConnections() {
        return this.ct.getNumConnections();
    }

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public void setBindAddr(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public int getStartPort() {
        return this.start_port;
    }

    public void setStartPort(int start_port) {
        this.start_port = start_port;
    }

    public int getEndPort() {
        return this.end_port;
    }

    public void setEndPort(int end_port) {
        this.end_port = end_port;
    }

    public long getReaperInterval() {
        return this.reaper_interval;
    }

    public void setReaperInterval(long reaper_interval) {
        this.reaper_interval = reaper_interval;
    }

    public long getConnExpireTime() {
        return this.conn_expire_time;
    }

    public void setConnExpireTime(long conn_expire_time) {
        this.conn_expire_time = conn_expire_time;
    }

    @Override
    public boolean isLoopback() {
        return this.loopback;
    }

    @Override
    public void setLoopback(boolean loopback) {
        this.loopback = loopback;
    }

    public String printConnections() {
        return this.ct.toString();
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("start_port");
        if (str != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("end_port")) != null) {
            this.end_port = Integer.parseInt(str);
            props.remove("end_port");
        }
        if ((str = props.getProperty("external_addr")) != null) {
            try {
                this.external_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal("(external_addr): host " + str + " not known");
                }
                return false;
            }
            props.remove("external_addr");
        }
        if ((str = props.getProperty("reaper_interval")) != null) {
            this.reaper_interval = Long.parseLong(str);
            props.remove("reaper_interval");
        }
        if ((str = props.getProperty("conn_expire_time")) != null) {
            this.conn_expire_time = Long.parseLong(str);
            props.remove("conn_expire_time");
        }
        if ((str = props.getProperty("sock_conn_timeout")) != null) {
            this.sock_conn_timeout = Integer.parseInt(str);
            props.remove("sock_conn_timeout");
        }
        if ((str = props.getProperty("recv_buf_size")) != null) {
            this.recv_buf_size = Integer.parseInt(str);
            props.remove("recv_buf_size");
        }
        if ((str = props.getProperty("send_buf_size")) != null) {
            this.send_buf_size = Integer.parseInt(str);
            props.remove("send_buf_size");
        }
        if ((str = props.getProperty("skip_suspected_members")) != null) {
            this.skip_suspected_members = Boolean.valueOf(str);
            props.remove("skip_suspected_members");
        }
        if ((str = props.getProperty("use_send_queues")) != null) {
            this.use_send_queues = Boolean.valueOf(str);
            props.remove("use_send_queues");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.TCP_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.start_port, this.end_port);
        this.ct.setUseSendQueues(this.use_send_queues);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.local_addr = this.ct.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        super.start();
    }

    @Override
    public void stop() {
        this.ct.stop();
        super.stop();
    }

    @Override
    protected void handleDownEvent(Event evt) {
        super.handleDownEvent(evt);
        if (evt.getType() == 6) {
            this.suspected_mbrs.removeAll();
        } else if (evt.getType() == 51) {
            this.suspected_mbrs.removeElement(evt.getArg());
        }
    }

    protected ConnectionTable getConnectionTable(long reaperInterval, long connExpireTime, InetAddress bindAddress, InetAddress externalAddress, int startPort, int endPort) throws Exception {
        ConnectionTable cTable;
        if (reaperInterval == 0L && connExpireTime == 0L) {
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort);
        } else {
            if (reaperInterval == 0L) {
                reaperInterval = 5000L;
                if (this.warn) {
                    this.log.warn("reaper_interval was 0, set it to " + reaperInterval);
                }
            }
            if (connExpireTime == 0L) {
                connExpireTime = 300000L;
                if (this.warn) {
                    this.log.warn("conn_expire_time was 0, set it to " + connExpireTime);
                }
            }
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort, reaperInterval, connExpireTime);
        }
        return cTable;
    }

    @Override
    public void receive(Address sender, byte[] data, int offset, int length) {
        super.receive(this.local_addr, sender, data, offset, length);
    }

    @Override
    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        Vector mbrs = (Vector)this.members.clone();
        for (int i = 0; i < mbrs.size(); ++i) {
            Address dest = (Address)mbrs.elementAt(i);
            this.sendToSingleMember(dest, false, data, offset, length);
        }
    }

    @Override
    public void sendToSingleMember(Address dest, boolean isJoinResponse, byte[] data, int offset, int length) throws Exception {
        block5: {
            if (trace) {
                this.log.trace("dest=" + dest + " (" + data.length + " bytes)");
            }
            if (this.skip_suspected_members && this.suspected_mbrs.contains(dest)) {
                if (trace) {
                    this.log.trace("will not send unicast message to " + dest + " as it is currently suspected");
                }
                return;
            }
            try {
                this.ct.send(dest, data, offset, length);
            }
            catch (Exception e) {
                if (!this.members.contains(dest) || this.suspected_mbrs.contains(dest)) break block5;
                this.suspected_mbrs.add(dest);
                this.passUp(new Event(9, new SuspectMember(this.local_addr, dest)));
            }
        }
    }

    @Override
    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("connections: ").append(this.printConnections()).append("\n");
        return sb.toString();
    }

    @Override
    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
        if (multicast) {
            msg.setDest(null);
        } else {
            msg.setDest(dest);
        }
    }

    @Override
    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
        this.postUnmarshalling(msg, dest, null, multicast);
    }
}

