/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class STATS
extends Protocol {
    long sent_msgs;
    long sent_bytes;
    long sent_ucasts;
    long sent_mcasts;
    long received_ucasts;
    long received_mcasts;
    long received_msgs;
    long received_bytes;
    long sent_ucast_bytes;
    long sent_mcast_bytes;
    long received_ucast_bytes;
    long received_mcast_bytes;
    HashMap sent = new HashMap();
    HashMap received = new HashMap();
    static final short UP = 1;
    static final short DOWN = 2;

    @Override
    public String getName() {
        return "STATS";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.down_thread = false;
        this.up_thread = false;
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.STATS_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        this.received_mcasts = 0L;
        this.received_ucasts = 0L;
        this.sent_mcasts = 0L;
        this.sent_ucasts = 0L;
        this.sent_bytes = 0L;
        this.sent_msgs = 0L;
        this.received_mcast_bytes = 0L;
        this.received_ucast_bytes = 0L;
        this.sent_mcast_bytes = 0L;
        this.sent_ucast_bytes = 0L;
        this.received_bytes = 0L;
        this.received_msgs = 0L;
        this.sent.clear();
        this.received.clear();
    }

    public long getSentMessages() {
        return this.sent_msgs;
    }

    public long getSentBytes() {
        return this.sent_bytes;
    }

    public long getSentUnicastMessages() {
        return this.sent_ucasts;
    }

    public long getSentUnicastBytes() {
        return this.sent_ucast_bytes;
    }

    public long getSentMcastMessages() {
        return this.sent_mcasts;
    }

    public long getSentMcastBytes() {
        return this.sent_mcast_bytes;
    }

    public long getReceivedMessages() {
        return this.received_msgs;
    }

    public long getReceivedBytes() {
        return this.received_bytes;
    }

    public long getReceivedUnicastMessages() {
        return this.received_ucasts;
    }

    public long getReceivedUnicastBytes() {
        return this.received_ucast_bytes;
    }

    public long getReceivedMcastMessages() {
        return this.received_mcasts;
    }

    public long getReceivedMcastBytes() {
        return this.received_mcast_bytes;
    }

    @Override
    public void up(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)1);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)2);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        this.passDown(evt);
    }

    @Override
    public String printStats() {
        Object val;
        Object key2;
        StringBuffer sb = new StringBuffer();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key2 = entry.getKey();
            if (key2 == null) {
                key2 = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key2).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key2 = entry.getKey();
            val = entry.getValue();
            sb.append(key2).append(": ").append(val).append("\n");
        }
        return sb.toString();
    }

    private void handleViewChange(View view) {
        Vector members = view.getMembers();
        LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(members);
        tmp.add(null);
        this.sent.keySet().retainAll(tmp);
        this.received.keySet().retainAll(tmp);
    }

    private void updateStats(Message msg, short direction) {
        boolean mcast;
        if (msg == null) {
            return;
        }
        int length = msg.getLength();
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        boolean bl = mcast = dest == null || dest.isMulticastAddress();
        if (direction == 1) {
            ++this.received_msgs;
            this.received_bytes += (long)length;
            if (mcast) {
                ++this.received_mcasts;
                this.received_mcast_bytes += (long)length;
            } else {
                ++this.received_ucasts;
                this.received_ucast_bytes += (long)length;
            }
        } else {
            ++this.sent_msgs;
            this.sent_bytes += (long)length;
            if (mcast) {
                ++this.sent_mcasts;
                this.sent_mcast_bytes += (long)length;
            } else {
                ++this.sent_ucasts;
                this.sent_ucast_bytes += (long)length;
            }
        }
        Address key2 = direction == 1 ? src : dest;
        HashMap map = direction == 1 ? this.received : this.sent;
        Entry entry = (Entry)map.get(key2);
        if (entry == null) {
            entry = new Entry();
            map.put(key2, entry);
        }
        ++entry.msgs;
        entry.bytes += (long)length;
        if (mcast) {
            ++entry.mcasts;
            entry.mcast_bytes += (long)length;
        } else {
            ++entry.ucasts;
            entry.ucast_bytes += (long)length;
        }
    }

    static class Entry {
        long msgs;
        long bytes;
        long ucasts;
        long mcasts;
        long ucast_bytes;
        long mcast_bytes;

        Entry() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.msgs).append(" (").append(this.bytes).append(" bytes)");
            sb.append(": ").append(this.ucasts).append(" ucasts (").append(this.ucast_bytes).append(" bytes), ");
            sb.append(this.mcasts).append(" mcasts (").append(this.mcast_bytes).append(" bytes)");
            return sb.toString();
        }
    }
}

