/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.GroupRequest;
import com.gemstone.org.jgroups.blocks.RequestCorrelator;
import com.gemstone.org.jgroups.blocks.RequestHandler;
import com.gemstone.org.jgroups.protocols.StateTransferRequest;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.StateTransferInfo;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class STATE_TRANSFER
extends Protocol
implements RequestHandler {
    Address local_addr = null;
    final Vector members = new Vector(11);
    final Message m = null;
    boolean is_server = false;
    byte[] cached_state = null;
    final Object state_xfer_mutex = new Object();
    long timeout_get_appl_state = 5000L;
    long timeout_return_state = 5000L;
    RequestCorrelator corr = null;
    final Vector observers = new Vector(5);
    final HashMap map = new HashMap(7);

    @Override
    public String getName() {
        return "STATE_TRANSFER";
    }

    @Override
    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    @Override
    public void start() throws Exception {
        this.corr = new RequestCorrelator(this.getName(), this, this);
        this.passUp(new Event(56, this.map));
    }

    @Override
    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
            this.corr = null;
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout_get_appl_state");
        if (str != null) {
            this.timeout_get_appl_state = Long.parseLong(str);
            props.remove("timeout_get_appl_state");
        }
        if ((str = props.getProperty("timeout_return_state")) != null) {
            this.timeout_return_state = Long.parseLong(str);
            props.remove("timeout_return_state");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.STATE_TRANSFER_STATE_TRANSFERSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public Vector requiredUpServices() {
        Vector<Integer> ret = new Vector<Integer>(2);
        ret.addElement(22);
        ret.addElement(23);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                this.is_server = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int k = 0; k < new_members.size(); ++k) {
                            this.members.addElement(new_members.elementAt(k));
                        }
                    }
                    break;
                }
            }
        }
        if (this.corr != null) {
            this.corr.receive(evt);
        } else {
            this.passUp(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int k = 0; k < new_members.size(); ++k) {
                            this.members.addElement(new_members.elementAt(k));
                        }
                    }
                    break;
                }
            }
            case 19: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                Address coord = this.determineCoordinator();
                if (coord == null || coord.equals(this.local_addr)) {
                    Vector<Event> event_list = new Vector<Event>(1);
                    event_list.addElement(new Event(20, null));
                    this.passUp(new Event(23, event_list));
                    return;
                }
                this.sendMakeCopyMessage();
                Object state = info.type == 2 ? this.getStateFromMany(info.targets) : (Object)this.getStateFromSingle(info.target);
                Vector<Event> event_list = new Vector<Event>(1);
                event_list.addElement(new Event(20, state));
                this.passUp(new Event(23, event_list));
                return;
            }
            case 18: {
                Object object = this.state_xfer_mutex;
                synchronized (object) {
                    this.cached_state = (byte[])evt.getArg();
                    this.state_xfer_mutex.notifyAll();
                }
                return;
            }
        }
        this.passDown(evt);
    }

    @Override
    public Object handle(Message msg) {
        try {
            StateTransferRequest req = (StateTransferRequest)msg.getObject();
            switch (req.getType()) {
                case 1: {
                    this.makeCopy(req.getArg());
                    return null;
                }
                case 2: {
                    if (this.is_server) {
                        return this.cached_state;
                    }
                    if (this.warn) {
                        this.log.warn("RETURN_STATE: returning nullas I'm not yet an operational state server !");
                    }
                    return null;
                }
            }
            if (this.log.isErrorEnabled()) {
                this.log.error("type " + req.getType() + "is unknown in StateTransferRequest !");
            }
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.STATE_TRANSFER_EXCEPTION_IS__0, (Throwable)e);
            }
            return null;
        }
    }

    byte[] getStateFromSingle(Address target) {
        Message msg;
        Vector<Address> dests = new Vector<Address>(11);
        StateTransferRequest r = new StateTransferRequest(2, this.local_addr);
        int num_tries = 0;
        try {
            msg = new Message(null, null, Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.STATE_TRANSFER_EXCEPTION_0, (Throwable)e);
            }
            return null;
        }
        while (this.members.size() > 1 && num_tries++ < 3) {
            Address dest;
            Address address = dest = target != null ? target : this.determineCoordinator();
            if (dest == null) {
                return null;
            }
            msg.setDest(dest);
            dests.removeAllElements();
            dests.addElement(dest);
            GroupRequest req = new GroupRequest(msg, this.corr, dests, 1, this.timeout_return_state, 0);
            req.execute();
            RspList rsp_list = req.getResults();
            for (int i = 0; i < rsp_list.size(); ++i) {
                Rsp rsp = (Rsp)rsp_list.elementAt(i);
                if (!rsp.wasReceived()) continue;
                return (byte[])rsp.getValue();
            }
            try {
                Util.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }

    Vector getStateFromMany(Vector targets) {
        Vector dests = new Vector(11);
        StateTransferRequest r = new StateTransferRequest(2, this.local_addr);
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                if (this.local_addr.equals(targets.elementAt(i))) continue;
                dests.addElement(targets.elementAt(i));
            }
        } else {
            for (int i = 0; i < this.members.size(); ++i) {
                if (this.local_addr.equals(this.members.elementAt(i))) continue;
                dests.addElement(this.members.elementAt(i));
            }
        }
        if (dests.size() == 0) {
            return null;
        }
        Message msg = new Message();
        try {
            msg.setBuffer(Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            // empty catch block
        }
        GroupRequest req = new GroupRequest(msg, this.corr, dests, 2, this.timeout_return_state, 0);
        req.execute();
        RspList rsp_list = req.getResults();
        return rsp_list.getResults();
    }

    void sendMakeCopyMessage() {
        Message msg = new Message();
        StateTransferRequest r = new StateTransferRequest(1, this.local_addr);
        Vector dests = new Vector(11);
        for (int i = 0; i < this.members.size(); ++i) {
            dests.addElement(this.members.elementAt(i));
        }
        if (dests.size() == 0) {
            return;
        }
        try {
            msg.setBuffer(Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            // empty catch block
        }
        GroupRequest req = new GroupRequest(msg, this.corr, dests, 2, this.timeout_return_state, 0);
        req.execute();
    }

    Address determineCoordinator() {
        Address ret = null;
        if (this.members != null && this.members.size() > 1) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (this.local_addr.equals(this.members.elementAt(i))) continue;
                return (Address)this.members.elementAt(i);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeCopy(Object sender) {
        if (sender.equals(this.local_addr)) {
            this.passUp(new Event(22));
        } else if (this.is_server) {
            Object object = this.state_xfer_mutex;
            synchronized (object) {
                this.cached_state = null;
                this.passUp(new Event(17, this.local_addr));
                if (this.cached_state == null) {
                    try {
                        this.state_xfer_mutex.wait(this.timeout_get_appl_state);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

