/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class SHUFFLE
extends Protocol
implements Runnable {
    String name = "SHUFFLE";
    final List messages = Collections.synchronizedList(new ArrayList());
    Thread messagesHandler;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("name");
        if (str != null) {
            this.name = str;
            props.remove("name");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.SHUFFLE_DUMMYSETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.messages.add(msg);
                return;
            }
        }
        this.passUp(evt);
    }

    @Override
    public synchronized void start() throws Exception {
        this.messagesHandler = new Thread((Runnable)this, "MessagesHandler");
        this.messagesHandler.setDaemon(true);
        this.messagesHandler.start();
    }

    @Override
    public synchronized void stop() {
        Thread tmp = this.messagesHandler;
        this.messagesHandler = null;
        if (tmp != null) {
            tmp.interrupt();
            try {
                tmp.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            if (this.messages.size() > 0) {
                Message msg = (Message)this.messages.remove(this.rnd(this.messages.size()));
                this.passUp(new Event(1, msg));
            }
            if (this.messages.size() >= 5) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        for (Message msg : this.messages) {
            this.passUp(new Event(1, msg));
        }
    }

    int rnd(int n) {
        return (int)(Math.random() * (double)n);
    }
}

