/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.protocols.PingSender;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class PingWaiter
implements Runnable {
    public static boolean TEST_HOOK_IGNORE_REQUIRED_RESPONSE = false;
    Object tLock = new Object();
    Thread t = null;
    final List rsps = new LinkedList();
    long timeout = 3000L;
    volatile int num_rsps = 3;
    Protocol parent = null;
    PingSender ping_sender;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private volatile int num_servers_received;
    private volatile Address coordinator;
    private volatile Set<Address> requiredResponses = Collections.EMPTY_SET;
    private volatile Set<Address> requiredResponsesReceived = new HashSet<Address>();

    public PingWaiter(long timeout, int num_rsps, Protocol parent, PingSender ping_sender) {
        this.timeout = timeout;
        this.num_rsps = num_rsps;
        this.parent = parent;
        this.ping_sender = ping_sender;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void setNumRsps(int num) {
        this.num_rsps = num;
    }

    void setCoordinator(Address theCoordinator) {
        this.coordinator = theCoordinator;
        if (theCoordinator != null) {
            this.requiredResponses = Collections.EMPTY_SET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.tLock;
        synchronized (object) {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread(GemFireTracer.GROUP, this, "PingWaiter");
                this.t.setDaemon(true);
                this.t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.ping_sender != null) {
            this.ping_sender.stop();
        }
        Thread thr = null;
        Object object = this.tLock;
        synchronized (object) {
            thr = this.t;
        }
        if (thr != null) {
            thr.interrupt();
            object = this.rsps;
            synchronized (object) {
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isRunning() {
        Object object = this.tLock;
        synchronized (object) {
            return this.t != null && this.t.isAlive();
        }
    }

    public void setRequiredResponses(Set<Address> addresses) {
        this.requiredResponses = addresses;
        this.requiredResponsesReceived.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(PingRsp rsp) {
        if (rsp != null) {
            if (TEST_HOOK_IGNORE_REQUIRED_RESPONSE) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "TEST HOOK: required responses are " + this.requiredResponses);
                if (this.requiredResponses.contains(rsp.own_addr)) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "TEST HOOK: ignoring response from " + rsp.own_addr);
                    return;
                }
            }
            if (this.trace) {
                this.log.trace("Received Ping response " + rsp);
            }
            List list = this.rsps;
            synchronized (list) {
                if (this.rsps.contains(rsp)) {
                    this.rsps.remove(rsp);
                }
                this.rsps.add(rsp);
                if (rsp.is_server) {
                    ++this.num_servers_received;
                }
                if (this.requiredResponses.contains(rsp.own_addr)) {
                    this.requiredResponsesReceived.add(rsp.own_addr);
                    if (this.trace) {
                        this.log.trace("Received " + this.requiredResponsesReceived.size() + " of " + this.requiredResponses.size() + " required ping responses");
                    }
                }
                this.rsps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponses() {
        if (this.trace) {
            this.log.trace("<PingWaiter> clearing responses for a new attempt");
        }
        List list = this.rsps;
        synchronized (list) {
            this.rsps.clear();
            this.num_servers_received = 0;
            this.rsps.notifyAll();
            this.coordinator = null;
            this.requiredResponses = Collections.emptySet();
            this.requiredResponsesReceived = new HashSet<Address>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector responses = this.findInitialMembers();
        Object object = this.tLock;
        synchronized (object) {
            this.t = null;
        }
        if (this.parent != null) {
            if (this.log.getInternalLogWriter().finerEnabled()) {
                this.log.getInternalLogWriter().finer("PingWaiter: required responses=" + this.requiredResponses + "; received=" + this.requiredResponsesReceived + "; responses=" + responses);
            }
            if (this.requiredResponses.size() != this.requiredResponsesReceived.size()) {
                HashSet<Address> missing = new HashSet<Address>(this.requiredResponses);
                missing.removeAll(this.requiredResponsesReceived);
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("Find Initial Members failed.  missing responses = " + missing);
                }
                this.parent.passUp(new Event(1011, missing));
            } else {
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("Find Initial Members completed.");
                }
                this.parent.passUp(new Event(13, responses));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"TLW_TWO_LOCK_WAIT"}, justification="the code is correct")
    public Vector findInitialMembers() {
        List list = this.rsps;
        synchronized (list) {
            Vector vector;
            if (this.num_servers_received >= this.num_rsps && this.rsps.size() > 0) {
                this.rsps.clear();
                this.num_servers_received = 0;
            }
            AtomicBoolean sync = new AtomicBoolean();
            this.coordinator = null;
            this.ping_sender.setSync(sync);
            while (!sync.get()) {
                AtomicBoolean atomicBoolean = sync;
                synchronized (atomicBoolean) {
                    this.clearResponses();
                    this.ping_sender.start();
                    try {
                        sync.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return new Vector();
                    }
                }
            }
            long start_time = System.currentTimeMillis();
            long time_to_wait = this.timeout;
            try {
                Thread tTmp;
                Object ie = this.tLock;
                synchronized (ie) {
                    tTmp = this.t;
                }
                while (time_to_wait > 0L && tTmp != null && (this.requiredResponsesReceived.size() != this.requiredResponses.size() || this.num_servers_received < this.num_rsps)) {
                    if (this.coordinator != null) {
                        PingRsp ping_rsp = new PingRsp(this.coordinator, this.coordinator, true);
                        this.rsps.add(ping_rsp);
                        this.coordinator = null;
                        break;
                    }
                    if (this.trace) {
                        this.log.trace(new StringBuffer("waiting for initial members: time_to_wait=").append(time_to_wait).append(", got ").append(this.rsps.size()).append(" rsps"));
                    }
                    try {
                        this.rsps.wait(time_to_wait);
                    }
                    catch (InterruptedException intex) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception e) {
                        this.log.error(JGroupsStrings.PingWaiter_GOT_AN_EXCEPTION_WAITING_FOR_RESPONSES, (Throwable)e);
                    }
                    time_to_wait = this.timeout - (System.currentTimeMillis() - start_time);
                }
                if (this.trace) {
                    this.log.info(JGroupsStrings.PingWaiter_INITIAL_MEMBERS_ARE_0, this.rsps);
                }
                vector = new Vector(this.rsps);
                this.ping_sender.stop();
            }
            catch (Throwable throwable) {
                this.ping_sender.stop();
                throw throwable;
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getPossibleCoordinator(Address local_addr) {
        Vector initial_mbrs;
        TreeSet<Address> clients = new TreeSet<Address>();
        clients.add(local_addr);
        List list = this.rsps;
        synchronized (list) {
            initial_mbrs = new Vector(this.rsps);
        }
        if (initial_mbrs.size() == 0) {
            return local_addr;
        }
        for (int i = 0; i < initial_mbrs.size(); ++i) {
            PingRsp pingRsp = (PingRsp)initial_mbrs.elementAt(i);
            Address client_addr = pingRsp.getCoordAddress();
            if (client_addr == null) continue;
            clients.add(client_addr);
        }
        return (Address)clients.iterator().next();
    }
}

