/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.ShunnedAddressException;
import com.gemstone.org.jgroups.protocols.Discovery;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public class PingSender
implements Runnable {
    Thread t = null;
    double interval;
    int num_requests = 1;
    Discovery discovery_prot;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    protected boolean trace = this.log.isTraceEnabled();
    private AtomicBoolean waiter_sync;

    public PingSender(long timeout, int num_requests, Discovery d) {
        this.num_requests = num_requests;
        this.discovery_prot = d;
        this.interval = (double)timeout / (double)num_requests;
    }

    public void setSync(AtomicBoolean waiter_sync) {
        this.waiter_sync = waiter_sync;
    }

    public synchronized void start() {
        if (this.t == null || !this.t.isAlive()) {
            this.t = new Thread(GemFireTracer.GROUP, this, "PingSender");
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    public synchronized void stop() {
        if (this.t != null) {
            Thread tmp = this.t;
            this.t = null;
            try {
                tmp.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.t != null && this.t.isAlive();
    }

    @Override
    public void run() {
        RuntimeException gfe = null;
        boolean anysuccess = false;
        for (int i = 0; i < this.num_requests && !Thread.currentThread().isInterrupted(); ++i) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            if (this.trace) {
                this.log.trace("sending GET_MBRS_REQ");
            }
            try {
                this.discovery_prot.sendGetMembersRequest(this.waiter_sync);
                anysuccess = true;
                try {
                    Util.sleep((long)this.interval);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            catch (GemFireConfigException ex) {
                gfe = ex;
                continue;
            }
            catch (ShunnedAddressException ex) {
                gfe = ex;
            }
        }
        if (!anysuccess) {
            this.discovery_prot.passUp(new Event(46, gfe));
            this.discovery_prot.wakeWaiter(this.waiter_sync);
        }
    }
}

