/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.PerfHeader;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.ProtocolObserver;

class PerfObserver
implements ProtocolObserver {
    final String prot_name;
    boolean bottom = false;

    PerfObserver(String prot_name) {
        this.prot_name = prot_name;
    }

    @Override
    public void setProtocol(Protocol prot) {
        if (prot != null && prot.getDownProtocol() == null) {
            this.bottom = true;
        }
    }

    @Override
    public boolean up(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 1);
            if (this.bottom) {
                hdr.setNetworkReceived();
            }
        }
        return true;
    }

    @Override
    public boolean passUp(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 1);
        }
        return true;
    }

    @Override
    public boolean down(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 2);
        }
        return true;
    }

    @Override
    public boolean passDown(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 2);
            if (this.bottom) {
                hdr.setNetworkSent();
            }
        }
        return true;
    }

    PerfHeader getPerfHeader(Message m) {
        Object hdr;
        block3: {
            block2: {
                hdr = null;
                if (m == null) break block2;
                Object t = m.getHeader("PERF");
                hdr = t;
                if (t != null) break block3;
            }
            return null;
        }
        return hdr;
    }
}

