/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.Protocol;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PARTITIONER
extends Protocol {
    final Vector members = new Vector();
    Address local_addr = null;
    int my_partition = 1;

    @Override
    public String getName() {
        return "PARTITIONER";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.PARTITIONER_EXAMPLESETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    public void reset() {
    }

    @Override
    public void up(Event evt) {
        PartitionerHeader partHead = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!this.log.isInfoEnabled()) break;
                this.log.info(JGroupsStrings.PARTITIONER_LOCAL_ADDRESS_IS__0, this.local_addr);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                partHead = (PartitionerHeader)msg.removeHeader(this.getName());
                if (partHead.type == 1) {
                    Integer num = (Integer)partHead.Destinations.get(this.local_addr);
                    if (num == null) {
                        return;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.PARTITIONER_NEW_PARTITION___0, num);
                    }
                    this.my_partition = num;
                    return;
                }
                if (partHead.type != 0 || partHead.partition == this.my_partition) break;
                return;
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 44: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.PARTITIONER_SET_PARTITIONS_RECEIVED_ARGUMENT__0, evt.getArg().toString());
                }
                Message msg = new Message(null, null, null);
                PartitionerHeader partHeader = new PartitionerHeader(1);
                partHeader.Destinations = (Hashtable)evt.getArg();
                msg.putHeader(this.getName(), partHeader);
                this.passDown(new Event(1, msg));
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                msg.putHeader(this.getName(), new PartitionerHeader(0, this.my_partition));
            }
        }
        this.passDown(evt);
    }

    public static class PartitionerHeader
    extends Header {
        static final int NORMAL = 0;
        static final int COMMAND = 1;
        int type = 0;
        int partition = 1;
        Hashtable Destinations = null;

        public PartitionerHeader() {
        }

        public PartitionerHeader(int type) {
            this.type = type;
        }

        public PartitionerHeader(int type, int partition) {
            this.type = type;
            this.partition = partition;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "NORMAL ->partition :" + this.partition;
                }
                case 1: {
                    return "COMMAND ->hashtable :" + this.Destinations;
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeInt(this.partition);
            out.writeObject(this.Destinations);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.partition = in.readInt();
            this.Destinations = (Hashtable)in.readObject();
        }
    }
}

