/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class MERGE3
extends Protocol {
    Address local_addr = null;
    long min_interval = 5000L;
    long max_interval = 20000L;
    boolean is_coord = false;
    final Vector mbrs = new Vector();
    TimeScheduler timer = null;
    CoordinatorAnnouncer announcer_task = null;
    final Set announcements = Collections.synchronizedSet(new HashSet());
    boolean use_separate_thread = false;

    @Override
    public String getName() {
        return "MERGE3";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("min_interval");
        if (str != null) {
            this.min_interval = Long.parseLong(str);
            props.remove("min_interval");
        }
        if ((str = props.getProperty("max_interval")) != null) {
            this.max_interval = Long.parseLong(str);
            props.remove("max_interval");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MERGE3_MIN_INTERVAL_AND_MAX_INTERVAL_HAVE_TO_BE__0);
            }
            return false;
        }
        if (this.max_interval <= this.min_interval) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MERGE3_MAX_INTERVAL_HAS_TO_BE_GREATER_THAN_MIN_INTERVAL);
            }
            return false;
        }
        str = props.getProperty("use_separate_thread");
        if (str != null) {
            this.use_separate_thread = Boolean.valueOf(str);
            props.remove("use_separate_thread");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.MERGE3_MERGE2SETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        this.timer = this.stack.timer;
    }

    @Override
    public void startUpHandler() {
    }

    @Override
    public void startDownHandler() {
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                CoordAnnouncement hdr = (CoordAnnouncement)msg.removeHeader(this.getName());
                if (hdr != null) {
                    if (hdr.coord_addr == null || !this.is_coord) break;
                    boolean contains = this.announcements.contains(hdr.coord_addr);
                    this.announcements.add(hdr.coord_addr);
                    if (this.log.isDebugEnabled()) {
                        if (contains) {
                            this.log.debug("discarded duplicate announcement: " + hdr.coord_addr + ", announcements=" + this.announcements);
                        } else {
                            this.log.debug("received announcement: " + hdr.coord_addr + ", announcements=" + this.announcements);
                        }
                    }
                    if (this.announcements.size() <= 1 || !this.is_coord) break;
                    this.processAnnouncements();
                    break;
                }
                this.passUp(evt);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                Vector tmp = ((View)evt.getArg()).getMembers();
                this.mbrs.clear();
                this.mbrs.addAll(tmp);
                Address coord = (Address)this.mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    if (this.is_coord) break;
                    this.is_coord = true;
                    this.startCoordAnnouncerTask();
                    break;
                }
                if (!this.is_coord) break;
                this.is_coord = false;
                this.stopCoordAnnouncerTask();
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    void startCoordAnnouncerTask() {
        if (this.announcer_task == null) {
            this.announcements.add(this.local_addr);
            this.announcer_task = new CoordinatorAnnouncer();
            this.timer.add(this.announcer_task);
            if (this.log.isDebugEnabled()) {
                this.log.debug("coordinator announcement task started, announcements=" + this.announcements);
            }
        }
    }

    void stopCoordAnnouncerTask() {
        if (this.announcer_task != null) {
            this.announcer_task.stop();
            this.announcer_task = null;
            this.announcements.clear();
            if (this.log.isDebugEnabled()) {
                this.log.debug("coordinator announcement task stopped");
            }
        }
    }

    long computeInterval() {
        return this.min_interval + Util.random(this.max_interval - this.min_interval);
    }

    void sendCoordinatorAnnouncement(Address coord) {
        Message coord_announcement = new Message();
        CoordAnnouncement hdr = new CoordAnnouncement(coord);
        coord_announcement.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, coord_announcement));
    }

    void processAnnouncements() {
        if (this.announcements.size() > 1) {
            Vector coords = new Vector(this.announcements);
            if (coords.size() > 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("passing up MERGE event, coords=" + coords);
                }
                final Event evt = new Event(14, coords);
                if (this.use_separate_thread) {
                    Thread merge_notifier = new Thread(){

                        @Override
                        public void run() {
                            MERGE3.this.passUp(evt);
                        }
                    };
                    merge_notifier.setDaemon(true);
                    merge_notifier.setName("merge notifier thread");
                } else {
                    this.passUp(evt);
                }
            }
            this.announcements.clear();
        }
    }

    public static class CoordAnnouncement
    extends Header {
        Address coord_addr = null;

        public CoordAnnouncement() {
        }

        public CoordAnnouncement(Address coord) {
            this.coord_addr = coord;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.coord_addr = (Address)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.coord_addr);
        }
    }

    class CoordinatorAnnouncer
    implements TimeScheduler.Task {
        boolean cancelled = false;

        CoordinatorAnnouncer() {
        }

        public void start() {
            this.cancelled = false;
        }

        public void stop() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }

        @Override
        public long nextInterval() {
            return MERGE3.this.computeInterval();
        }

        @Override
        public void run() {
            if (MERGE3.this.is_coord) {
                MERGE3.this.sendCoordinatorAnnouncement(MERGE3.this.local_addr);
            }
        }
    }
}

