/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.RouterStub;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MERGE
extends Protocol
implements Runnable {
    final Vector members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    final String groupname;
    Thread hello_thread = null;
    long timeout = 5000L;
    String router_host = null;
    int router_port = 0;
    RouterStub client = null;
    boolean is_server = false;
    boolean is_coord = false;
    boolean merging = false;

    public MERGE() {
        this.groupname = null;
    }

    @Override
    public String getName() {
        return "MERGE";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("router_host")) != null) {
            this.router_host = str;
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = Integer.parseInt(str);
            props.remove("router_port");
        }
        if (this.router_host != null && this.router_port != 0) {
            this.client = new RouterStub(this.router_host, this.router_port);
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.MERGE_MERGESETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        MERGE mERGE = this;
        synchronized (mERGE) {
            if (this.hello_thread == null) {
                this.hello_thread = new Thread((Runnable)this, "MERGE Thread");
                this.hello_thread.setDaemon(true);
                this.hello_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Thread tmp;
        MERGE mERGE = this;
        synchronized (mERGE) {
            tmp = this.hello_thread;
            this.hello_thread = null;
        }
        if (tmp != null && tmp.isAlive()) {
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Object obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof MergeHeader)) {
                    this.passUp(evt);
                    return;
                }
                MergeHeader hdr = (MergeHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_server || !this.is_coord) {
                            return;
                        }
                        if (this.merging) {
                            return;
                        }
                        Address sender = msg.getSrc();
                        if (sender != null && this.members.size() >= 0) {
                            boolean contains;
                            Vector vector = this.members;
                            synchronized (vector) {
                                contains = this.members.contains(sender);
                            }
                            if (!contains && sender.compareTo(this.local_addr) < 0) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("membership " + this.members + " does not contain " + sender + "; merging it");
                                }
                                Vector<Address> tmp = new Vector<Address>();
                                tmp.addElement(sender);
                                this.merging = true;
                                this.passUp(new Event(14, tmp));
                            }
                        }
                        return;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.MERGE_GOT_MERGE_HDR_WITH_UNKNOWN_TYPE_0, hdr.type);
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 15: {
                this.passDown(evt);
                break;
            }
            case 45: {
                this.merging = false;
                this.passDown(evt);
                break;
            }
            case 6: {
                this.merging = false;
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    this.members.addAll(((View)evt.getArg()).getMembers());
                    if (this.members.size() == 0 && this.log.isFatalEnabled()) {
                        this.log.fatal("received VIEW_CHANGE with null or empty vector");
                    }
                }
                this.is_coord = this.members.elementAt(0).equals(this.local_addr);
                this.passDown(evt);
                if (this.is_coord) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.MERGE_START_SENDING_HELLOS);
                    }
                    try {
                        this.start();
                    }
                    catch (Exception ex) {
                        if (!this.warn) break;
                        this.log.warn("exception calling start(): " + ex);
                    }
                    break;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.MERGE_STOP_SENDING_HELLOS);
                }
                this.stop();
                break;
            }
            case 16: {
                this.passDown(evt);
                try {
                    this.start();
                    this.is_server = true;
                }
                catch (Exception ex) {
                    if (!this.warn) break;
                    this.log.warn("exception calling start(): " + ex);
                }
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                if (this.local_addr != null && evt.getArg() != null && this.local_addr.equals(evt.getArg())) {
                    this.stop();
                }
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector members_to_merge = new Vector();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            return;
        }
        while (true) {
            SystemFailure.checkFailure();
            try {
                Util.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                break;
            }
            if (Thread.currentThread().isInterrupted()) break;
            if (this.client == null) {
                Message hello_msg = new Message(null, null, null);
                MergeHeader hdr = new MergeHeader(1);
                hello_msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, hello_msg));
                continue;
            }
            List rsps = this.client.get(this.group_addr);
            Vector vector = this.members;
            synchronized (vector) {
                members_to_merge.removeAllElements();
                Enumeration e = rsps.elements();
                while (e.hasMoreElements()) {
                    Object mbr = e.nextElement();
                    if (this.members.contains(mbr)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("membership " + this.members + " does not contain " + mbr + "; merging it");
                    }
                    members_to_merge.addElement(mbr);
                }
                if (members_to_merge.size() > 0) {
                    Membership new_membership = new Membership(members_to_merge);
                    new_membership.sort();
                    Address coord = (Address)new_membership.elementAt(0);
                    Vector<Address> tmp = new Vector<Address>();
                    tmp.addElement(coord);
                    if (coord.compareTo(this.local_addr) < 0) {
                        this.passUp(new Event(14, tmp));
                    }
                }
            }
        }
    }

    public static class MergeHeader
    extends Header {
        public static final int HELLO = 1;
        public int type = 0;

        public MergeHeader() {
        }

        public MergeHeader(int type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return "[MERGE: type=" + this.type2Str(this.type) + ']';
        }

        String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "HELLO";
                }
            }
            return "<unkown type (" + t + ")>";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

