/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Streamable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class GemFireTimeSync
extends Protocol {
    private static boolean DEBUG = Boolean.getBoolean("gemfire.time-service.debug");
    private int clockSyncInterval = 100;
    private int replyWaitInterval = 15;
    private long currCoordOffset = 0L;
    private Address localAddress = null;
    private volatile View view;
    private final AtomicLong nextProcId = new AtomicLong(0L);
    private final ConcurrentMap<Long, ReplyProcessor> processors = new ConcurrentHashMap<Long, ReplyProcessor>();
    private final ConcurrentMap<Address, GFTimeSyncHeader> joinTimeOffsets = new ConcurrentHashMap<Address, GFTimeSyncHeader>();
    private ServiceThread syncThread;
    private final Object syncThreadLock = new Object();
    private TestHook testHook;
    private long joinReqTime = 0L;
    public static final int TIME_RESPONSES = 0;
    public static final int OFFSET_RESPONSE = 1;

    @Override
    public String getName() {
        return "GemFireTimeSync";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void computeAndSendOffsets(View v) {
        if (v.getMembers().size() < 2) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long procID = this.nextProcId.incrementAndGet();
        GFTimeSyncHeader timeHeader = new GFTimeSyncHeader(procID, 0, currentTime);
        ReplyProcessor proc = new ReplyProcessor(this.view, procID);
        this.processors.put(procID, proc);
        try {
            for (Address mbr : v.getMembers()) {
                if (mbr.equals(this.localAddress)) continue;
                Message timeMessage = new Message();
                timeMessage.setDest(mbr);
                timeMessage.isHighPriority = true;
                timeMessage.putHeader(this.getName(), timeHeader);
                this.passDown(new Event(1, timeMessage));
            }
            GFTimeSyncHeader myResponse = new GFTimeSyncHeader(0L, 0, currentTime);
            proc.replyReceived(this.localAddress, myResponse);
            proc.waitForReplies(this.replyWaitInterval * 1000);
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            if (this.testHook != null) {
                this.testHook.setResponses(proc.responses, currentTime);
                this.testHook.hook(0);
            }
            this.processors.remove(procID);
        }
        Map<Address, GFTimeSyncHeader> responses = proc.responses;
        int numResponses = responses.size();
        if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Received " + numResponses + " responses");
        }
        if (numResponses > 1) {
            long stddev;
            long averageTime;
            long newAverageTime;
            long rTTStddev;
            long averageRTT = this.getMeanRTT(responses, 0L, Long.MAX_VALUE);
            long newAverageRTT = this.getMeanRTT(responses, averageRTT, rTTStddev = this.getRTTStdDev(responses, averageRTT));
            if (newAverageRTT > 0L) {
                averageRTT = newAverageRTT;
            }
            if ((newAverageTime = this.getMeanClock(responses, averageTime = this.getMeanClock(responses, 0L, Long.MAX_VALUE), stddev = this.getClockStdDev(responses, averageTime))) > 0L) {
                averageTime = newAverageTime;
            }
            long averageTransmitTime = averageRTT / 2L;
            long adjustedAverageTime = averageTime + averageTransmitTime;
            if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                StringBuilder buffer = new StringBuilder(5000);
                for (Map.Entry<Address, GFTimeSyncHeader> entry : responses.entrySet()) {
                    buffer.append("\n\t").append(entry.getKey()).append(": ").append(entry.getValue());
                }
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service computed round trip time of " + averageRTT + " with stddev of " + rTTStddev + " and " + "clock time of " + averageTime + " with stddev of " + stddev + " for " + numResponses + " members.  Details: \n\tstart time=" + currentTime + "  group time=" + adjustedAverageTime + " transmit time=" + averageTransmitTime + buffer.toString());
            }
            for (Map.Entry<Address, GFTimeSyncHeader> entry : responses.entrySet()) {
                IpAddress mbr = (IpAddress)entry.getKey();
                GFTimeSyncHeader response = entry.getValue();
                Message offsetMessage = new Message();
                offsetMessage.setDest(mbr);
                offsetMessage.isHighPriority = true;
                long responseTransmitTime = (response.timeReceived - currentTime) / 2L;
                long offset = adjustedAverageTime - (response.time + responseTransmitTime);
                if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "sending time offset of " + offset + " to " + entry.getKey() + " whose time was " + response.time + " and transmit time was " + responseTransmitTime);
                }
                offsetMessage.putHeader(this.getName(), new GFTimeSyncHeader(0L, 2, offset));
                if (mbr == this.localAddress) {
                    this.currCoordOffset = offset;
                    offsetMessage.setSrc(this.localAddress);
                    this.up(new Event(1, offsetMessage));
                    continue;
                }
                this.passDown(new Event(1, offsetMessage));
            }
        }
    }

    @Override
    public void up(Event event) {
        block22: {
            block0 : switch (event.getType()) {
                case 8: {
                    this.localAddress = (Address)event.getArg();
                    if (!DEBUG && !this.log.getInternalLogWriter().fineEnabled()) break;
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GF time service setting local address to " + this.localAddress);
                    break;
                }
                case 1: {
                    Message msg = (Message)event.getArg();
                    GFTimeSyncHeader header = (GFTimeSyncHeader)msg.removeHeader(this.getName());
                    if (header == null) break;
                    switch (header.opType) {
                        case 3: {
                            long beforeJoinTime = System.currentTimeMillis() + this.currCoordOffset;
                            if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service received join time offset request from " + msg.getSrc() + " join time=" + beforeJoinTime);
                            }
                            GFTimeSyncHeader respHeader = new GFTimeSyncHeader(0L, 4, this.currCoordOffset, beforeJoinTime, 0L);
                            this.joinTimeOffsets.put(msg.getSrc(), respHeader);
                            break block0;
                        }
                        case 4: {
                            if (header.coordTimeAfterJoin != 0L) {
                                JGroupMembershipManager mgr;
                                long currentLocalTime = System.currentTimeMillis();
                                if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, " currentLocalTime =" + currentLocalTime + " coordAfterJoinTime = " + header.coordTimeAfterJoin + " coordBeforeJoinTime = " + header.coordTimeBeforeJoin + " joinReqTime = " + this.joinReqTime);
                                }
                                long transmissionTime = (currentLocalTime - (header.coordTimeAfterJoin - header.coordTimeBeforeJoin) - this.joinReqTime) / 2L;
                                long timeOffs = header.coordTimeBeforeJoin - (this.joinReqTime + transmissionTime);
                                if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service received join time offset from " + msg.getSrc() + " offset=" + timeOffs);
                                }
                                if ((mgr = this.stack.jgmm) != null) {
                                    mgr.setCacheTimeOffset(msg.getSrc(), timeOffs, true);
                                    break block0;
                                }
                            }
                            break block22;
                        }
                        case 0: {
                            if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service received time request from " + msg.getSrc());
                            }
                            GFTimeSyncHeader responseHeader = new GFTimeSyncHeader(header.procID, 1, System.currentTimeMillis());
                            Message response = new Message();
                            response.setDest(msg.getSrc());
                            response.putHeader(this.getName(), responseHeader);
                            response.isHighPriority = true;
                            this.passDown(new Event(1, response));
                            return;
                        }
                        case 1: {
                            ReplyProcessor p;
                            if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service received time response from " + msg.getSrc());
                            }
                            if ((p = (ReplyProcessor)this.processors.get(new Long(header.procID))) != null) {
                                p.replyReceived(msg.getSrc(), header);
                            }
                            return;
                        }
                        case 2: {
                            JGroupMembershipManager jmm;
                            long timeOffset = header.time;
                            if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service received time offset update from " + msg.getSrc() + " offset=" + timeOffset);
                            }
                            if ((jmm = this.stack.jgmm) != null) {
                                jmm.setCacheTimeOffset(msg.getSrc(), timeOffset, false);
                            }
                            if (this.testHook != null) {
                                this.testHook.hook(1);
                            }
                            return;
                        }
                    }
                }
            }
        }
        this.passUp(event);
    }

    @Override
    public void down(Event event) {
        switch (event.getType()) {
            case 6: {
                View view = (View)event.getArg();
                if (DEBUG || this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GF time service is processing view " + view);
                }
                this.viewChanged(view);
                break;
            }
            case 1: {
                long afterJoinTime;
                GFTimeSyncHeader joinTimeSyncHeader;
                Message msg = (Message)event.getArg();
                GMS.GmsHeader header = (GMS.GmsHeader)msg.getHeader("GMS");
                if (header == null) break;
                if (header.getType() == 1) {
                    this.joinReqTime = System.currentTimeMillis();
                    GFTimeSyncHeader timeHeader = new GFTimeSyncHeader(0L, 3, this.joinReqTime);
                    msg.putHeader(this.getName(), timeHeader);
                    break;
                }
                if (header.getType() != 2 || (joinTimeSyncHeader = (GFTimeSyncHeader)this.joinTimeOffsets.remove(msg.getDest())) == null) break;
                joinTimeSyncHeader.coordTimeAfterJoin = afterJoinTime = System.currentTimeMillis() + this.currCoordOffset;
                msg.putHeader(this.getName(), joinTimeSyncHeader);
                if (!DEBUG && !this.log.getInternalLogWriter().fineEnabled()) break;
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "GemFire time service is including after-join time in join-response to " + msg.getDest() + " after join time=" + afterJoinTime);
            }
        }
        this.passDown(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewChanged(View newView) {
        this.view = (View)newView.clone();
        if (this.localAddress.equals(newView.getCoordinator())) {
            boolean newThread = false;
            Object object = this.syncThreadLock;
            synchronized (object) {
                if (this.syncThread == null) {
                    this.syncThread = new ServiceThread(GemFireTracer.GROUP, "GemFire Time Service");
                    this.syncThread.setDaemon(true);
                    this.syncThread.start();
                    newThread = true;
                }
                if (!newThread) {
                    this.syncThread.computeOffsetsForNewView();
                }
            }
        }
        Object object = this.syncThreadLock;
        synchronized (object) {
            if (this.syncThread != null) {
                this.syncThread.cancel();
            }
        }
    }

    private long getMeanRTT(Map<Address, GFTimeSyncHeader> values, long previousMean, long stddev) {
        long totalTime = 0L;
        long numSamples = 0L;
        long upperLimit = previousMean + stddev;
        for (GFTimeSyncHeader response : values.values()) {
            long rtt = response.timeReceived - response.time;
            if (rtt > upperLimit) continue;
            ++numSamples;
            totalTime += rtt;
        }
        long averageTime = totalTime / numSamples;
        return averageTime;
    }

    private long getRTTStdDev(Map<Address, GFTimeSyncHeader> values, long average) {
        long sqDiffs = 0L;
        for (GFTimeSyncHeader response : values.values()) {
            long diff = average - (response.timeReceived - response.time);
            sqDiffs += diff * diff;
        }
        return Math.round(Math.sqrt(sqDiffs));
    }

    private long getMeanClock(Map<Address, GFTimeSyncHeader> values, long previousMean, long stddev) {
        long totalTime = 0L;
        long numSamples = 0L;
        long upperLimit = previousMean + stddev;
        long lowerLimit = previousMean - stddev;
        for (GFTimeSyncHeader response : values.values()) {
            if (lowerLimit > response.time || response.time > upperLimit) continue;
            ++numSamples;
            totalTime += response.time;
        }
        long averageTime = totalTime / numSamples;
        return averageTime;
    }

    private long getClockStdDev(Map<Address, GFTimeSyncHeader> values, long average) {
        long sqDiffs = 0L;
        for (GFTimeSyncHeader response : values.values()) {
            long diff = average - response.time;
            sqDiffs += diff * diff;
        }
        return Math.round(Math.sqrt(sqDiffs));
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("clock_sync_interval");
        if (str != null) {
            this.clockSyncInterval = Integer.parseInt(str);
            props.remove("clock_sync_interval");
        }
        if ((str = props.getProperty("reply_wait_interval")) != null) {
            this.replyWaitInterval = Integer.parseInt(str);
            props.remove("reply_wait_interval");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.DEBUG, "The following GemFireTimeSync properties were not recognized: " + props);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.syncThread != null) {
            this.syncThread.cancel();
        }
    }

    public void invokeServiceThreadForTest() {
        if (this.syncThread != null) {
            this.syncThread.computeOffsetsForNewView();
        }
    }

    public boolean isServiceThreadCancelledForTest() {
        if (this.syncThread != null) {
            return this.syncThread.cancelled();
        }
        return true;
    }

    public TestHook getTestHook() {
        return this.testHook;
    }

    public void setTestHook(TestHook testHook) {
        this.testHook = testHook;
    }

    public static interface TestHook {
        public void hook(int var1);

        public void setResponses(Map<Address, GFTimeSyncHeader> var1, long var2);
    }

    private class ServiceThread
    extends Thread {
        private boolean cancelled;
        private boolean waiting;
        private boolean skipWait;
        private Object lock;

        ServiceThread(ThreadGroup g, String name) {
            super(g, name);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = false;
            }
            while (!this.cancelled()) {
                View v = GemFireTimeSync.this.view;
                if (v != null && v.getCreator().equals(GemFireTimeSync.this.localAddress)) {
                    GemFireTimeSync.this.computeAndSendOffsets(v);
                }
                try {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (this.skipWait) {
                            this.skipWait = false;
                        } else {
                            this.waiting = true;
                            try {
                                this.lock.wait(GemFireTimeSync.this.clockSyncInterval * 1000);
                            }
                            finally {
                                this.waiting = false;
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancelled() {
            Object object = this.lock;
            synchronized (object) {
                return this.cancelled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeOffsetsForNewView() {
            Object object = this.lock;
            synchronized (object) {
                if (this.waiting) {
                    this.lock.notifyAll();
                } else {
                    this.skipWait = true;
                }
            }
        }
    }

    public static class GFTimeSyncHeader
    extends Header
    implements Streamable {
        static final byte OP_TIME_REQUEST = 0;
        static final byte OP_TIME_RESPONSE = 1;
        static final byte OP_TIME_OFFSET = 2;
        static final byte JOIN_TIME_REQUEST = 3;
        static final byte JOIN_RESPONSE_OFFSET = 4;
        long procID;
        byte opType;
        long time;
        long coordTimeBeforeJoin;
        long coordTimeAfterJoin;
        transient long timeReceived;

        public GFTimeSyncHeader() {
        }

        GFTimeSyncHeader(long procID, byte opType, long time) {
            this.procID = procID;
            this.opType = opType;
            this.time = time;
        }

        GFTimeSyncHeader(long procID, byte opType, long time, long beforeTime, long afterTime) {
            this.procID = procID;
            this.opType = opType;
            this.time = time;
            this.coordTimeBeforeJoin = beforeTime;
            this.coordTimeAfterJoin = afterTime;
        }

        @Override
        public long size(short version) {
            return super.size(version) + 17L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.procID);
            out.writeLong(this.time);
            out.write(this.opType);
            if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GFE_80) >= 0) {
                out.writeLong(this.coordTimeBeforeJoin);
                out.writeLong(this.coordTimeAfterJoin);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.procID = in.readLong();
            this.time = in.readLong();
            this.opType = in.readByte();
            if (InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_80) >= 0) {
                this.coordTimeBeforeJoin = in.readLong();
                this.coordTimeAfterJoin = in.readLong();
            }
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeLong(this.procID);
            out.writeLong(this.time);
            out.write(this.opType);
            if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GFE_80) >= 0) {
                out.writeLong(this.coordTimeBeforeJoin);
                out.writeLong(this.coordTimeAfterJoin);
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.procID = in.readLong();
            this.time = in.readLong();
            this.opType = in.readByte();
            if (InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_80) >= 0) {
                this.coordTimeBeforeJoin = in.readLong();
                this.coordTimeAfterJoin = in.readLong();
            }
        }

        @Override
        public String toString() {
            return "SyncMessage(procID=" + this.procID + "; op=" + this.op2String(this.opType) + "; time=" + this.time + "; timeRcvd=" + this.timeReceived + "; coordTimeBeforeJoin=" + this.coordTimeBeforeJoin + "; coordTimeAfterJoin=" + this.coordTimeAfterJoin + ")";
        }

        private String op2String(byte op) {
            switch (op) {
                case 0: {
                    return "REQUEST";
                }
                case 1: {
                    return "RESPONSE";
                }
                case 2: {
                    return "OFFSET";
                }
                case 3: {
                    return "JOIN_TIME_REQUEST";
                }
                case 4: {
                    return "JOIN_OFFSET";
                }
            }
            return "??";
        }
    }

    static class ReplyProcessor {
        int responderCount;
        long procID;
        Map<Address, GFTimeSyncHeader> responses = new HashMap<Address, GFTimeSyncHeader>();
        Object doneSync = new Object();

        ReplyProcessor(View view, long procID) {
            this.responderCount = view.getMembers().size();
            this.procID = procID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replyReceived(Address sender, GFTimeSyncHeader response) {
            response.timeReceived = System.currentTimeMillis();
            Object object = this.responses;
            synchronized (object) {
                this.responses.put(sender, response);
            }
            object = this.doneSync;
            synchronized (object) {
                if (this.responses.size() >= this.responderCount) {
                    this.doneSync.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean done() {
            Map<Address, GFTimeSyncHeader> map = this.responses;
            synchronized (map) {
                return this.responses.size() >= this.responderCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForReplies(long timeout) throws InterruptedException {
            Object object = this.doneSync;
            synchronized (object) {
                long endTime = System.currentTimeMillis() + timeout;
                while (!this.done()) {
                    long remainingTime = endTime - System.currentTimeMillis();
                    if (remainingTime <= 0L) {
                        return;
                    }
                    this.doneSync.wait(remainingTime);
                }
            }
        }
    }
}

