/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.FragHeader;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Range;
import com.gemstone.org.jgroups.util.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class FRAG2
extends Protocol {
    public static boolean DEBUG_FRAG2 = Boolean.getBoolean("gemfire.debug-frag2");
    int frag_size = 1500;
    int overhead = 50;
    private final FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private final Vector members = new Vector(11);
    static String name = "FRAG2";
    long num_sent_msgs = 0L;
    long num_sent_frags = 0L;
    long num_received_msgs = 0L;
    long num_received_frags = 0L;
    private long initialViewId;
    private long currentViewId;
    private List preJoinMessages = new LinkedList();

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 6;
    }

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public int getOverhead() {
        return this.overhead;
    }

    public void setOverhead(int o) {
        this.overhead = o;
    }

    public long getNumberOfSentMessages() {
        return this.num_sent_msgs;
    }

    public long getNumberOfSentFragments() {
        return this.num_sent_frags;
    }

    public long getNumberOfReceivedMessages() {
        return this.num_received_msgs;
    }

    public long getNumberOfReceivedFragments() {
        return this.num_received_frags;
    }

    synchronized int getNextId() {
        return this.curr_id++;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("frag_size");
        if (str != null) {
            this.frag_size = Integer.parseInt(str);
            props.remove("frag_size");
        }
        if ((str = props.getProperty("overhead")) != null) {
            this.overhead = Integer.parseInt(str);
            props.remove("overhead");
        }
        int old_frag_size = this.frag_size;
        this.frag_size -= this.overhead;
        if (this.frag_size <= 0) {
            this.log.error("frag_size=" + old_frag_size + ", overhead=" + this.overhead + ", new frag_size=" + this.frag_size + ": new frag_size is invalid");
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FRAG2_FRAG_SIZE_0__OVERHEAD_1__NEW_FRAG_SIZE_2, new Object[]{old_frag_size, this.overhead, this.frag_size});
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FRAG2_FRAG2SETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_received_frags = 0L;
        this.num_received_msgs = 0L;
        this.num_sent_frags = 0L;
        this.num_sent_msgs = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size2 = msg.getLength();
                FRAG2 fRAG2 = this;
                synchronized (fRAG2) {
                    ++this.num_sent_msgs;
                }
                if (size2 <= (long)this.frag_size) break;
                if (trace) {
                    StringBuffer sb = new StringBuffer("message's buffer size is ");
                    sb.append(size2).append(", will fragment ").append("(frag_size=");
                    sb.append(this.frag_size).append(')');
                    this.log.trace(sb.toString());
                }
                this.gf_fragment(msg);
                this.recordSize();
                return;
            }
            case 6: {
                long initId = this.initialViewId;
                this.viewChanged(evt);
                List list = this.preJoinMessages;
                synchronized (list) {
                    if (initId == 0L && this.initialViewId != 0L) {
                        for (Message m : this.preJoinMessages) {
                            this.unfragment(m);
                            this.recordSize();
                        }
                        this.preJoinMessages.clear();
                    }
                    break;
                }
            }
            case 56: {
                this.passDown(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Object obj = msg.getHeader(this.getName());
                if (obj != null && obj instanceof FragHeader) {
                    this.unfragment(msg);
                    this.recordSize();
                    return;
                }
                ++this.num_received_msgs;
                break;
            }
            case 56: {
                this.passUp(evt);
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.FRAG2_RECEIVED_CONFIG_EVENT__0, evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 6: {
                long initId = this.initialViewId;
                this.viewChanged(evt);
                List list = this.preJoinMessages;
                synchronized (list) {
                    if (initId == 0L && this.initialViewId != 0L) {
                        for (Message m : this.preJoinMessages) {
                            this.unfragment(m);
                            this.recordSize();
                        }
                        this.preJoinMessages.clear();
                    }
                    break;
                }
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewChanged(Event evt) {
        ViewId vid = ((View)evt.getArg()).getVid();
        if (this.initialViewId == 0L) {
            this.initialViewId = vid.getId();
        }
        this.currentViewId = vid.getId();
        View view = (View)evt.getArg();
        Vector new_mbrs = view.getMembers();
        Vector left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        Vector vector = this.members;
        synchronized (vector) {
            this.members.clear();
            this.members.addAll(new_mbrs);
        }
        for (int i = 0; i < left_mbrs.size(); ++i) {
            Address mbr = (Address)left_mbrs.elementAt(i);
            this.fragment_list.remove(mbr);
            if (!trace) continue;
            this.log.trace("removed " + mbr + " from fragmentation table");
        }
        this.recordSize();
    }

    private void recordSize() {
    }

    void gf_fragment(Message msg) {
        this.fragment(msg);
    }

    void fragment(Message msg) {
        block5: {
            Address dest = msg.getDest();
            long id = 0L;
            try {
                FragHeader hdr = (FragHeader)msg.getHeader(this.getName());
                id = this.getNextId();
                byte[] buffer = msg.getBuffer();
                List fragments = Util.computeFragOffsets(buffer, this.frag_size);
                int num_frags = fragments.size();
                if (this.stack != null && this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.incJgFragmentsCreated(num_frags);
                    this.stack.gemfireStats.incJgFragmentationsPerformed();
                }
                if (trace) {
                    StringBuffer sb = new StringBuffer("fragmenting packet to ");
                    sb.append(dest != null ? dest.toString() : "<all members>").append(" (size=").append(buffer.length);
                    sb.append(") into ").append(num_frags).append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                    this.log.trace(sb.toString());
                }
                int fsize = fragments.size();
                for (int i = 0; i < fsize; ++i) {
                    Range r = (Range)fragments.get(i);
                    Message frag_msg = msg.copy(false);
                    frag_msg.bundleable = false;
                    frag_msg.setBuffer(buffer, (int)r.low, (int)r.high);
                    hdr = new FragHeader(id, i, num_frags, this.currentViewId);
                    frag_msg.putHeader(this.getName(), hdr);
                    Event evt = new Event(1, frag_msg);
                    this.passDown(evt);
                }
                msg.putHeader(this.getName(), hdr);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error(JGroupsStrings.FRAG2_EXCEPTION_IS__0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unfragment(Message msg) {
        block11: {
            Address sender = msg.getSrc();
            FragHeader hdr = (FragHeader)msg.removeHeader(this.getName());
            List list = this.preJoinMessages;
            synchronized (list) {
                if (this.initialViewId == 0L) {
                    this.preJoinMessages.add(msg);
                    return;
                }
            }
            FragmentationTable frag_table = this.fragment_list.get(sender);
            if (frag_table == null) {
                frag_table = new FragmentationTable(sender);
                try {
                    this.fragment_list.add(sender, frag_table);
                }
                catch (IllegalArgumentException x) {
                    frag_table = this.fragment_list.get(sender);
                }
            }
            ++this.num_received_frags;
            Message assembled_msg = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg);
            if (assembled_msg != null) {
                try {
                    if (trace) {
                        this.log.trace("assembled_msg is " + assembled_msg);
                    }
                    assembled_msg.setSrc(sender);
                    ++this.num_received_msgs;
                    this.passUp(new Event(1, assembled_msg));
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error(JGroupsStrings.FRAG2_EXCEPTION_IS__0, (Throwable)e);
                }
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
            if (this.log.isDebugEnabled()) {
                this.log.debug("setting frag_size=" + this.frag_size);
            }
        }
    }

    static class FragmentationTable {
        private final Address sender;
        private final Hashtable h = new Hashtable(11);

        FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized Message add(long id, int frag_id, int tot_frags, Message fragment) {
            Message retval = null;
            Entry e = (Entry)this.h.get(id);
            if (e == null) {
                e = new Entry(id, tot_frags);
                this.h.put(id, e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleMessage();
                this.h.remove(id);
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                int count = 0;
                for (int i = 0; i < entry.fragments.length; ++i) {
                    if (entry.fragments[i] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        public int size() {
            int result = 0;
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                result += entry.size();
            }
            return result;
        }

        static class Entry {
            int tot_frags = 0;
            Message[] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            Entry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new Message[tot_frags];
                for (int i = 0; i < tot_frags; ++i) {
                    this.fragments[i] = null;
                }
            }

            public void set(int frag_id, Message frag) {
                if (this.fragments[frag_id] == null) {
                    this.fragments[frag_id] = frag;
                    ++this.number_of_frags_recvd;
                }
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i = 0; i < this.fragments.length; ++i) {
                    if (this.fragments[i] != null) continue;
                    return false;
                }
                return true;
            }

            public Message assembleMessage() {
                Message fragment;
                int i;
                int combined_length = 0;
                int index2 = 0;
                for (i = 0; i < this.fragments.length; ++i) {
                    fragment = this.fragments[i];
                    combined_length += fragment.getLength();
                }
                byte[] combined_buffer = new byte[combined_length];
                for (i = 0; i < this.fragments.length; ++i) {
                    fragment = this.fragments[i];
                    byte[] tmp = fragment.getRawBuffer();
                    int length = fragment.getLength();
                    int offset = fragment.getOffset();
                    System.arraycopy(tmp, offset, combined_buffer, index2, length);
                    index2 += length;
                }
                Message retval = this.fragments[this.fragments.length - 1].copy(false);
                retval.setBuffer(combined_buffer);
                return retval;
            }

            public String toString() {
                StringBuffer ret = new StringBuffer();
                ret.append("[tot_frags=" + this.tot_frags + ", number_of_frags_recvd=" + this.number_of_frags_recvd + ']');
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }

            public int size() {
                int result = 0;
                for (int i = 0; i < this.fragments.length; ++i) {
                    Message m = this.fragments[i];
                    if (m == null) continue;
                    result += m.getLength();
                }
                return result;
            }
        }
    }

    static class FragmentationList {
        private final HashMap frag_tables = new HashMap(11);

        FragmentationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                FragmentationTable healthCheck = (FragmentationTable)this.frag_tables.get(sender);
                if (healthCheck != null) {
                    throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list.");
                }
                this.frag_tables.put(sender, table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FragmentationTable get(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return (FragmentationTable)this.frag_tables.get(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsSender(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.containsKey(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                boolean result = this.containsSender(sender);
                this.frag_tables.remove(sender);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Address[] getSenders() {
            Address[] result;
            int index2 = 0;
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                result = new Address[this.frag_tables.size()];
                Iterator it = this.frag_tables.keySet().iterator();
                while (it.hasNext()) {
                    result[index2++] = (Address)it.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer buf = new StringBuffer("Fragmentation list contains ");
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                buf.append(this.frag_tables.size()).append(" tables\n");
                for (Map.Entry entry : this.frag_tables.entrySet()) {
                    buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            int result = 0;
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                for (FragmentationTable f : this.frag_tables.values()) {
                    result += f.size();
                }
            }
            return result;
        }
    }
}

