/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.TimeScheduler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class FD_SIMPLE
extends Protocol {
    Address local_addr = null;
    TimeScheduler timer = null;
    HeartbeatTask task = null;
    long interval = 3000L;
    long timeout = 3000L;
    final Vector members = new Vector();
    final HashMap counters = new HashMap();
    int max_missed_hbs = 5;
    static final String name = "FD_SIMPLE";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void init() throws Exception {
        this.timer = this.stack.timer;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("max_missed_hbs")) != null) {
            this.max_missed_hbs = Integer.parseInt(str);
            props.remove("max_missed_hbs");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FD_SIMPLE_FD_SIMPLESETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
    }

    @Override
    public void up(Event evt) {
        FdHeader hdr = null;
        boolean counter_reset = false;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.resetCounter(sender);
                counter_reset = true;
                hdr = (FdHeader)msg.removeHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message rsp = new Message(sender, null, null);
                        rsp.putHeader(name, new FdHeader(2));
                        this.passDown(new Event(1, rsp));
                        return;
                    }
                    case 2: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info(JGroupsStrings.FD_SIMPLE_RECEIVED_I_AM_ALIVE_RESPONSE_FROM__0, sender);
                        }
                        if (this.task != null) {
                            this.task.receivedHeartbeatResponse(sender);
                        }
                        if (!counter_reset) {
                            this.resetCounter(sender);
                        }
                        return;
                    }
                }
                if (this.warn) {
                    this.log.warn("FdHeader type " + hdr.type + " not known");
                }
                return;
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View new_view = (View)evt.getArg();
                this.members.clear();
                this.members.addAll(new_view.getMembers());
                if (new_view.size() > 1) {
                    if (this.task == null) {
                        this.task = new HeartbeatTask();
                        if (this.log.isInfoEnabled()) {
                            this.log.info(JGroupsStrings.FD_SIMPLE_STARTING_HEARTBEAT_TASK);
                        }
                        this.timer.add(this.task, true);
                    }
                } else if (this.task != null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.FD_SIMPLE_STOPPING_HEARTBEAT_TASK);
                    }
                    this.task.stop();
                    this.task = null;
                }
                Iterator it = this.counters.keySet().iterator();
                while (it.hasNext()) {
                    Address key2 = (Address)it.next();
                    if (this.members.contains(key2)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.FD_SIMPLE_REMOVING__0__FROM_COUNTERS, key2);
                    }
                    it.remove();
                }
                break;
            }
        }
        this.passDown(evt);
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size2 = members_copy.size();
        int r = (int)(Math.random() * (double)(size2 + 1)) % size2;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementCounter(Address mbr) {
        int ret = 0;
        if (mbr == null) {
            return ret;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            Integer cnt = (Integer)this.counters.get(mbr);
            if (cnt == null) {
                cnt = 0;
                this.counters.put(mbr, cnt);
            } else {
                ret = cnt + 1;
                this.counters.put(mbr, ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            this.counters.put(mbr, 0);
        }
    }

    String printCounters() {
        StringBuffer sb = new StringBuffer();
        for (Address key2 : this.counters.keySet()) {
            sb.append(key2).append(": ").append(this.counters.get(key2)).append('\n');
        }
        return sb.toString();
    }

    class HeartbeatTask
    implements TimeScheduler.Task {
        boolean stopped = false;
        final Promise promise = new Promise();
        Address dest = null;

        HeartbeatTask() {
        }

        void stop() {
            this.stopped = true;
        }

        @Override
        public boolean cancelled() {
            return this.stopped;
        }

        @Override
        public long nextInterval() {
            return FD_SIMPLE.this.interval;
        }

        public void receivedHeartbeatResponse(Address from) {
            if (from != null && this.dest != null && from.equals(this.dest)) {
                this.promise.setResult(from);
            }
        }

        @Override
        public void run() {
            int num_missed_hbs = 0;
            this.dest = FD_SIMPLE.this.getHeartbeatDest();
            if (this.dest == null) {
                if (FD_SIMPLE.this.warn) {
                    FD_SIMPLE.this.log.warn("heartbeat destination was null, will not send ARE_YOU_ALIVE message");
                }
                return;
            }
            if (FD_SIMPLE.this.log.isInfoEnabled()) {
                FD_SIMPLE.this.log.info("sending ARE_YOU_ALIVE message to " + this.dest + ", counters are\n" + FD_SIMPLE.this.printCounters());
            }
            this.promise.reset();
            Message msg = new Message(this.dest, null, null);
            msg.putHeader(FD_SIMPLE.name, new FdHeader(1));
            FD_SIMPLE.this.passDown(new Event(1, msg));
            this.promise.getResult(FD_SIMPLE.this.timeout);
            num_missed_hbs = FD_SIMPLE.this.incrementCounter(this.dest);
            if (num_missed_hbs >= FD_SIMPLE.this.max_missed_hbs) {
                if (FD_SIMPLE.this.log.isInfoEnabled()) {
                    FD_SIMPLE.this.log.info("missed " + num_missed_hbs + " from " + this.dest + ", suspecting member");
                }
                FD_SIMPLE.this.passUp(new Event(9, new SuspectMember(FD_SIMPLE.this.local_addr, this.dest)));
            }
        }
    }

    public static class FdHeader
    extends Header {
        static final int ARE_YOU_ALIVE = 1;
        static final int I_AM_ALIVE = 2;
        int type = 1;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_SIMPLE: ARE_YOU_ALIVE]";
                }
                case 2: {
                    return "[FD_SIMPLE: I_AM_ALIVE]";
                }
            }
            return "[FD_SIMPLE: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

