/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class FD_PROB
extends Protocol
implements Runnable {
    Address local_addr = null;
    Thread hb = null;
    long timeout = 3000L;
    long gossip_interval = 1000L;
    Vector members = null;
    final Hashtable counters = new Hashtable();
    final Hashtable invalid_pingers = new Hashtable();
    int max_tries = 2;

    @Override
    public String getName() {
        return "FD_PROB";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("gossip_interval")) != null) {
            this.gossip_interval = Long.parseLong(str);
            props.remove("gossip_interval");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FD_PROB_FD_PROBSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        FD_PROB fD_PROB = this;
        synchronized (fD_PROB) {
            if (this.hb == null) {
                this.hb = new Thread((Runnable)this, "FD_PROB.HeartbeatThread");
                this.hb.setDaemon(true);
                this.hb.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Thread tmp = null;
        FD_PROB fD_PROB = this;
        synchronized (fD_PROB) {
            tmp = this.hb;
            this.hb = null;
        }
        if (tmp != null && tmp.isAlive()) {
            tmp.interrupt();
            try {
                tmp.join(this.timeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.hb = null;
    }

    @Override
    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Object obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof FdHeader)) {
                    this.updateCounter(msg.getSrc());
                    break;
                }
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        if (!this.checkPingerValidity(msg.getSrc())) {
                            return;
                        }
                        if (this.log.isInfoEnabled()) {
                            this.log.info(JGroupsStrings.FD_PROB__HEARTBEAT_FROM__0, msg.getSrc());
                        }
                        this.updateCounters(hdr);
                        return;
                    }
                    case 2: {
                        if (this.warn) {
                            this.log.warn("NOT_MEMBER: I'm being shunned; exiting");
                        }
                        this.passUp(new Event(46));
                        return;
                    }
                }
                if (this.warn) {
                    this.log.warn("FdHeader type " + hdr.type + " not known");
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                FD_PROB fD_PROB = this;
                synchronized (fD_PROB) {
                    View v = (View)evt.getArg();
                    Vector excluded_mbrs = FD_PROB.computeExcludedMembers(this.members, v.getMembers());
                    if (excluded_mbrs != null && excluded_mbrs.size() > 0) {
                        for (int i = 0; i < excluded_mbrs.size(); ++i) {
                            Address mbr = (Address)excluded_mbrs.elementAt(i);
                            FdEntry entry = (FdEntry)this.counters.get(mbr);
                            if (entry == null) continue;
                            entry.setExcluded(true);
                        }
                    }
                    this.members = v.getMembers();
                    if (this.members != null) {
                        int num_mbrs = this.members.size();
                        if (num_mbrs >= 2) {
                            if (this.hb == null) {
                                try {
                                    this.start();
                                }
                                catch (Exception ex) {
                                    if (this.warn) {
                                        this.log.warn("exception when calling start(): " + ex);
                                    }
                                }
                            }
                        } else {
                            this.stop();
                        }
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    @Override
    public void run() {
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FD_PROB_HEARTBEAT_THREAD_WAS_STARTED);
        }
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            Address hb_dest = this.getHeartbeatDest();
            if (hb_dest == null) {
                if (this.warn) {
                    this.log.warn("hb_dest is null");
                }
                try {
                    Util.sleep(this.gossip_interval);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            FdEntry entry = (FdEntry)this.counters.get(this.local_addr);
            if (entry == null) {
                entry = new FdEntry();
                this.counters.put(this.local_addr, entry);
            }
            entry.incrementCounter();
            FdHeader hdr = this.createHeader();
            if (hdr == null) {
                if (this.warn) {
                    this.log.warn("header could not be created. Heartbeat will not be sent");
                } else {
                    Message hb_msg = new Message(hb_dest, null, null);
                    hb_msg.putHeader(this.getName(), hdr);
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.FD_PROB__HEARTBEAT_TO__0, hb_dest);
                    }
                    this.passDown(new Event(1, hb_msg));
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.FD_PROB_OWN_COUNTERS_ARE__0, this.printCounters());
            }
            Enumeration e = this.counters.keys();
            while (e.hasMoreElements()) {
                long diff;
                long curr_time = System.currentTimeMillis();
                Address key2 = (Address)e.nextElement();
                entry = (FdEntry)this.counters.get(key2);
                if (entry.getTimestamp() <= 0L || (diff = curr_time - entry.getTimestamp()) < this.timeout) continue;
                if (entry.excluded()) {
                    if (diff < 2L * this.timeout) continue;
                    this.counters.remove(key2);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info(JGroupsStrings.FD_PROB_REMOVED__0, key2);
                    continue;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.FD_PROB_SUSPECTING__0, key2);
                }
                this.passUp(new Event(9, new SuspectMember(this.local_addr, key2)));
            }
            try {
                Util.sleep(this.gossip_interval);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FD_PROB_HEARTBEAT_THREAD_WAS_STOPPED);
        }
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size2 = members_copy.size();
        int r = (int)(Math.random() * (double)(size2 + 1)) % size2;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    FdHeader createHeader() {
        int num_mbrs = this.counters.size();
        int index2 = 0;
        FdHeader ret = null;
        if (num_mbrs <= 0) {
            return null;
        }
        ret = new FdHeader(1, num_mbrs);
        Enumeration e = this.counters.keys();
        while (e.hasMoreElements()) {
            Address key2 = (Address)e.nextElement();
            FdEntry entry = (FdEntry)this.counters.get(key2);
            if (entry.excluded()) continue;
            if (index2 >= ret.members.length) {
                if (!this.warn) break;
                this.log.warn("index " + index2 + " is out of bounds (" + ret.members.length + ')');
                break;
            }
            ret.members[index2] = key2;
            ret.counters[index2] = entry.getCounter();
            ++index2;
        }
        return ret;
    }

    void updateCounters(FdHeader hdr) {
        if (hdr == null || hdr.members == null || hdr.counters == null) {
            if (this.warn) {
                this.log.warn("hdr is null or contains no counters");
            }
            return;
        }
        for (int i = 0; i < hdr.members.length; ++i) {
            Address key2 = hdr.members[i];
            if (key2 == null) continue;
            FdEntry entry = (FdEntry)this.counters.get(key2);
            if (entry == null) {
                entry = new FdEntry(hdr.counters[i]);
                this.counters.put(key2, entry);
                continue;
            }
            if (entry.excluded()) continue;
            entry.setCounter(Math.max(entry.getCounter(), hdr.counters[i]));
        }
    }

    void updateCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        FdEntry entry = (FdEntry)this.counters.get(mbr);
        if (entry != null) {
            entry.setTimestamp();
        }
    }

    String printCounters() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.counters.keys();
        while (e.hasMoreElements()) {
            Address mbr = (Address)e.nextElement();
            FdEntry entry = (FdEntry)this.counters.get(mbr);
            sb.append("\n" + mbr + ": " + entry._toString());
        }
        return sb.toString();
    }

    static Vector computeExcludedMembers(Vector old_mbrship, Vector new_mbrship) {
        Vector ret = new Vector();
        if (old_mbrship == null || new_mbrship == null) {
            return ret;
        }
        for (int i = 0; i < old_mbrship.size(); ++i) {
            if (new_mbrship.contains(old_mbrship.elementAt(i))) continue;
            ret.addElement(old_mbrship.elementAt(i));
        }
        return ret;
    }

    boolean checkPingerValidity(Object hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("sender " + hb_sender + " is not member in " + this.members + " ! Telling it to leave group");
                    }
                    Message shun_msg = new Message((Address)hb_sender, null, null);
                    FdHeader hdr = new FdHeader(2);
                    shun_msg.putHeader(this.getName(), hdr);
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, ++num_pings);
                }
            } else {
                this.invalid_pingers.put(hb_sender, ++num_pings);
            }
            return false;
        }
        return true;
    }

    private static class FdEntry {
        private long counter = 0L;
        private long timestamp = 0L;
        private boolean excluded = false;

        FdEntry() {
        }

        FdEntry(long counter) {
            this.counter = counter;
            this.timestamp = System.currentTimeMillis();
        }

        long getCounter() {
            return this.counter;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        boolean excluded() {
            return this.excluded;
        }

        synchronized void setCounter(long new_counter) {
            if (new_counter > this.counter) {
                this.timestamp = System.currentTimeMillis();
                this.counter = new_counter;
            }
        }

        synchronized void incrementCounter() {
            ++this.counter;
            this.timestamp = System.currentTimeMillis();
        }

        synchronized void setTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        synchronized void setExcluded(boolean flag) {
            this.excluded = flag;
        }

        public String toString() {
            return "counter=" + this.counter + ", timestamp=" + this.timestamp + ", excluded=" + this.excluded;
        }

        public String _toString() {
            return "counter=" + this.counter + ", age=" + (System.currentTimeMillis() - this.timestamp) + ", excluded=" + this.excluded;
        }
    }

    public static class FdHeader
    extends Header {
        static final int HEARTBEAT = 1;
        static final int NOT_MEMBER = 2;
        int type = 1;
        Address[] members = null;
        long[] counters = null;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        FdHeader(int type, int num_elements) {
            this(type);
            this.members = new Address[num_elements];
            this.counters = new long[num_elements];
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_PROB: HEARTBEAT]";
                }
                case 2: {
                    return "[FD_PROB: NOT_MEMBER]";
                }
            }
            return "[FD_PROB: unknown type (" + this.type + ")]";
        }

        public String printDetails() {
            StringBuffer sb = new StringBuffer();
            if (this.members != null && this.counters != null) {
                for (int i = 0; i < this.members.length; ++i) {
                    Address mbr = this.members[i];
                    if (mbr == null) {
                        sb.append("\n<null>");
                    } else {
                        sb.append("\n" + mbr);
                    }
                    sb.append(": " + this.counters[i]);
                }
            }
            return sb.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.members != null) {
                out.writeInt(this.members.length);
                out.writeObject(this.members);
            } else {
                out.writeInt(0);
            }
            if (this.counters != null) {
                out.writeInt(this.counters.length);
                for (int i = 0; i < this.counters.length; ++i) {
                    out.writeLong(this.counters[i]);
                }
            } else {
                out.writeInt(0);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            int num = in.readInt();
            this.members = num == 0 ? null : (Address[])in.readObject();
            num = in.readInt();
            if (num == 0) {
                this.counters = null;
            } else {
                this.counters = new long[num];
                for (int i = 0; i < this.counters.length; ++i) {
                    this.counters[i] = in.readLong();
                }
            }
        }
    }
}

