/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FD_ALL
extends Protocol {
    Map timestamps = new ConcurrentHashMap();
    long interval = 3000L;
    long timeout = 5000L;
    boolean msg_counts_as_heartbeat = true;
    Address local_addr = null;
    final List members = new ArrayList();
    boolean shun = true;
    TimeScheduler timer = null;
    private boolean tasks_running = false;
    protected int num_heartbeats_sent;
    protected int num_heartbeats_received = 0;
    protected int num_suspect_events = 0;
    static final String name = "FD_ALL";
    BoundedList suspect_history = new BoundedList(20);
    final Map invalid_pingers = new HashMap(7);
    final Lock lock = new ReentrantLock();
    private TimeoutChecker timeout_checker;
    private HeartbeatSender heartbeat_sender;

    @Override
    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean flag) {
        this.shun = flag;
    }

    public boolean isRunning() {
        return this.tasks_running;
    }

    public String printSuspectHistory() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    public String printTimestamps() {
        return this.printTimeStamps();
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("msg_counts_as_heartbeat")) != null) {
            this.msg_counts_as_heartbeat = Boolean.valueOf(str);
            props.remove("msg_counts_as_heartbeat");
        }
        if (!props.isEmpty()) {
            this.log.error(JGroupsStrings.FD_ALL_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.removeAll();
    }

    @Override
    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    @Override
    public void stop() {
        this.stopTasks();
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header hdr = (Header)msg.getHeader(name);
                if (this.msg_counts_as_heartbeat) {
                    this.update(msg.getSrc());
                }
                if (hdr == null) break;
                switch (hdr.type) {
                    case 0: {
                        Address sender = msg.getSrc();
                        if (sender.equals(this.local_addr)) break;
                        if (this.shun && this.members != null && !this.members.contains(sender)) {
                            this.shunInvalidHeartbeatSender(sender);
                            break;
                        }
                        this.update(sender);
                        ++this.num_heartbeats_received;
                        break;
                    }
                    case 1: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("[SUSPECT] suspect hdr is " + hdr);
                        }
                        this.down_prot.down(new Event(9, new SuspectMember(msg.getSrc(), hdr.suspected_mbr)));
                        this.up_prot.up(new Event(9, new SuspectMember(msg.getSrc(), hdr.suspected_mbr)));
                        break;
                    }
                    case 2: {
                        if (!this.shun) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.up_prot.up(new Event(46, new ForcedDisconnectException(JGroupsStrings.FD_ALL_THIS_MEMBER_HAS_BEEN_FORCED_OUT_OF_THE_DISTRIBUTED_SYSTEM_PLEASE_CONSULT_GEMFIRE_LOGS_TO_FIND_THE_REASON_FDALL.toLocalizedString())));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return;
            }
        }
        this.passDown(evt);
    }

    private void startTasks() {
        this.startHeartbeatSender();
        this.startTimeoutChecker();
        this.tasks_running = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("started heartbeat sender and timeout checker tasks");
        }
    }

    private void stopTasks() {
        this.stopTimeoutChecker();
        this.stopHeartbeatSender();
        this.tasks_running = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace("stopped heartbeat sender and timeout checker tasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker == null || this.timeout_checker.cancelled()) {
                this.timeout_checker = new TimeoutChecker();
                this.timer.add(this.timeout_checker, true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker != null) {
                this.timeout_checker.stop();
                this.timeout_checker = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender == null || this.heartbeat_sender.cancelled()) {
                this.heartbeat_sender = new HeartbeatSender();
                this.timer.add(this.heartbeat_sender, true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender != null) {
                this.heartbeat_sender.stop();
                this.heartbeat_sender = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void update(Address sender) {
        if (sender != null && !sender.equals(this.local_addr)) {
            this.timestamps.put(sender, System.currentTimeMillis());
        }
    }

    private void handleViewChange(View v) {
        Vector mbrs = v.getMembers();
        this.members.clear();
        this.members.addAll(mbrs);
        Set keys = this.timestamps.keySet();
        keys.retainAll(mbrs);
        for (Address mbr : mbrs) {
            if (mbr.equals(this.local_addr) || this.timestamps.containsKey(mbr)) continue;
            this.timestamps.put(mbr, System.currentTimeMillis());
        }
        this.invalid_pingers.clear();
        if (!this.tasks_running && this.members.size() > 1) {
            this.startTasks();
        } else if (this.tasks_running && this.members.size() < 2) {
            this.stopTasks();
        }
    }

    private void shunInvalidHeartbeatSender(Address sender) {
        int num_pings = 0;
        if (this.invalid_pingers.containsKey(sender)) {
            num_pings = (Integer)this.invalid_pingers.get(sender);
            if (num_pings >= 3) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(sender + " is not in " + this.members + " ! Shunning it");
                }
                Message shun_msg = new Message(sender, null, null);
                shun_msg.putHeader(name, new Header(2));
                this.down_prot.down(new Event(1, shun_msg));
                this.invalid_pingers.remove(sender);
            } else {
                this.invalid_pingers.put(sender, ++num_pings);
            }
        } else {
            this.invalid_pingers.put(sender, ++num_pings);
        }
    }

    protected String printTimeStamps() {
        StringBuffer sb = new StringBuffer();
        long current_time = System.currentTimeMillis();
        for (Map.Entry entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(current_time - (Long)entry.getValue()).append(" ms old\n");
        }
        return sb.toString();
    }

    void suspect(Address mbr) {
        Message suspect_msg = new Message();
        suspect_msg.bundleable = false;
        Header hdr = new Header(1, mbr);
        suspect_msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, suspect_msg));
        ++this.num_suspect_events;
        this.suspect_history.add(mbr);
    }

    class TimeoutChecker
    extends HeartbeatSender {
        TimeoutChecker() {
        }

        @Override
        public void run() {
            if (FD_ALL.this.log.isTraceEnabled()) {
                FD_ALL.this.log.trace("checking for expired senders, table is:\n" + FD_ALL.this.printTimeStamps());
            }
            long current_time = System.currentTimeMillis();
            Iterator it = FD_ALL.this.timestamps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key2 = entry.getKey();
                Long val = (Long)entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                long diff = current_time - val;
                if (diff <= FD_ALL.this.timeout) continue;
                if (FD_ALL.this.log.isTraceEnabled()) {
                    FD_ALL.this.log.trace("haven't received a heartbeat from " + key2 + " for " + diff + " ms, suspecting it");
                }
                FD_ALL.this.suspect((Address)key2);
            }
        }
    }

    class HeartbeatSender
    implements TimeScheduler.Task {
        boolean started = true;

        HeartbeatSender() {
        }

        public void stop() {
            this.started = false;
        }

        @Override
        public boolean cancelled() {
            return !this.started;
        }

        @Override
        public long nextInterval() {
            return FD_ALL.this.timeout;
        }

        @Override
        public void run() {
            Message heartbeat = new Message();
            Header hdr = new Header(0);
            heartbeat.putHeader(FD_ALL.name, hdr);
            FD_ALL.this.down_prot.down(new Event(1, heartbeat));
            ++FD_ALL.this.num_heartbeats_sent;
        }
    }

    public static class Header
    extends com.gemstone.org.jgroups.Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte SUSPECT = 1;
        public static final byte NOT_MEMBER = 2;
        byte type = 0;
        Address suspected_mbr = null;

        public Header() {
        }

        public Header(byte type) {
            this.type = type;
        }

        public Header(byte type, Address suspect) {
            this(type);
            this.suspected_mbr = suspect;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "SUSPECT (suspected_mbr=" + this.suspected_mbr + ")";
                }
                case 2: {
                    return "NOT_MEMBER";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.suspected_mbr);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.suspected_mbr = (Address)in.readObject();
        }

        @Override
        public long size(short version) {
            int retval = 1;
            return retval += Util.size(this.suspected_mbr, version);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.suspected_mbr, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.suspected_mbr = Util.readAddress(in);
        }
    }
}

