/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.CopyOnWriteArrayList;
import com.gemstone.org.jgroups.protocols.FD_SOCK;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.Marshaller;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class FD
extends Protocol {
    volatile Address ping_dest = null;
    Address local_addr = null;
    long timeout = 3000L;
    volatile long last_ack = System.currentTimeMillis();
    volatile int num_tries = 0;
    int max_tries = 2;
    final List members = new CopyOnWriteArrayList();
    Address coordinator;
    final Hashtable invalid_pingers = new Hashtable(7);
    final List pingable_mbrs = new CopyOnWriteArrayList();
    boolean shun = true;
    TimeScheduler timer = null;
    Monitor monitor = null;
    private final Object monitor_mutex = new Object();
    protected int num_heartbeats = 0;
    protected int num_suspect_events = 0;
    final Broadcaster bcast_task = new Broadcaster();
    static final String name = "FD";
    BoundedList suspect_history = new BoundedList(20);
    HeartbeatSender hbsender = null;
    boolean beingSick;
    static boolean DISABLED = Boolean.getBoolean("gemfire.DISABLE_FD");
    private boolean isCoordinator;
    private boolean disconnecting;

    @Override
    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumberOfHeartbeatsSent() {
        return this.num_heartbeats;
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxTries() {
        return this.max_tries;
    }

    public void setMaxTries(int max_tries) {
        this.max_tries = max_tries;
    }

    public int getCurrentNumTries() {
        return this.num_tries;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean flag) {
        this.shun = flag;
    }

    public String printSuspectHistory() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FD_FDSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats = 0;
        this.suspect_history.removeAll();
    }

    @Override
    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception(this.getName() + ".init(): timer cannot be retrieved from protocol stack");
        }
        this.timer = new TimeScheduler(60000L);
    }

    public static void loadEmergencyClasses() {
    }

    public void emergencyClose() {
        HeartbeatSender hb;
        Monitor m = this.monitor;
        if (m != null) {
            m.stop();
        }
        if ((hb = this.hbsender) != null) {
            hb.stop();
        }
    }

    @Override
    public void stop() {
        this.stopMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address getPingDest(List mbrs) {
        Address current_dest = this.ping_dest;
        ArrayList arrayList = mbrs;
        synchronized (arrayList) {
            mbrs = new ArrayList(mbrs);
        }
        if (mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int myIndex = mbrs.indexOf(this.local_addr);
        if (myIndex < 0) {
            return null;
        }
        int neighborIndex = myIndex;
        boolean wrapped = false;
        Address neighborAddr = null;
        do {
            if (++neighborIndex > mbrs.size() - 1) {
                neighborIndex = 0;
                wrapped = true;
            }
            if (!wrapped || neighborIndex != myIndex) continue;
            neighborAddr = null;
            break;
        } while (this.bcast_task.isSuspectedMember(neighborAddr = (Address)mbrs.get(neighborIndex)));
        if (current_dest != null && neighborAddr != null && !current_dest.equals(neighborAddr)) {
            this.last_ack = System.currentTimeMillis();
            this.num_tries = 0;
        }
        return neighborAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address getHeartbeatDest() {
        ArrayList mbrs;
        List list = this.pingable_mbrs;
        synchronized (list) {
            mbrs = new ArrayList(this.pingable_mbrs);
        }
        int myIndex = mbrs.indexOf(this.local_addr);
        if (myIndex == 0) {
            return null;
        }
        int neighborIndex = myIndex;
        boolean wrapped = false;
        Address neighborAddr = null;
        do {
            if (--neighborIndex < 0) {
                neighborIndex = mbrs.size() - 1;
                wrapped = true;
            }
            if (!wrapped || neighborIndex != myIndex) continue;
            neighborAddr = null;
            break;
        } while (this.bcast_task.isSuspectedMember(neighborAddr = (Address)mbrs.get(neighborIndex)));
        return neighborAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor() {
        if (DISABLED || this.disconnecting) {
            return;
        }
        Object object = this.monitor_mutex;
        synchronized (object) {
            if (this.monitor != null && !this.monitor.started) {
                this.monitor = null;
            }
            if (this.monitor == null) {
                this.monitor = new Monitor();
                this.last_ack = System.currentTimeMillis();
                this.num_tries = 0;
                this.timer.add(this.monitor, true);
            }
            if (this.hbsender != null && !this.hbsender.started) {
                this.hbsender = null;
            }
            if (this.hbsender == null) {
                this.hbsender = new HeartbeatSender();
                this.stack.timer.add(this.hbsender, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        Object object = this.monitor_mutex;
        synchronized (object) {
            if (this.monitor != null) {
                this.monitor.stop();
                this.monitor = null;
            }
            if (this.hbsender != null) {
                this.hbsender.stop();
                this.hbsender = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void up(Event evt) {
        block26: {
            pd = this.ping_dest;
            block2 : switch (evt.getType()) {
                case 8: {
                    this.local_addr = (Address)evt.getArg();
                    break;
                }
                case 1: {
                    if (FD.DISABLED || this.disconnecting) break;
                    msg = (Message)evt.getArg();
                    tmphdr = msg.getHeader(this.getName());
                    if (tmphdr == null || !(tmphdr instanceof FdHeader)) {
                        if (pd == null || (sender = msg.getSrc()) == null || !pd.equals(sender)) break;
                        this.last_ack = System.currentTimeMillis();
                        this.num_tries = 0;
                        break;
                    }
                    hdr = (FdHeader)msg.removeHeader(this.getName());
                    switch (hdr.type) {
                        case 0: {
                            if (!this.beingSick) {
                                hb_sender = msg.getSrc();
                                hb_ack = new Message(hb_sender, null, null);
                                hb_ack.isHighPriority = true;
                                tmp_hdr = new FdHeader(1);
                                tmp_hdr.from = this.local_addr;
                                hb_ack.putHeader(this.getName(), tmp_hdr);
                                if (FD.trace) {
                                    this.log.trace(this.getLocalAddress() + ":" + this.getName() + " received heartbeat request from " + hb_sender + ", sending heartbeat");
                                }
                                this.passDown(new Event(1, hb_ack));
                                if (this.shun) {
                                    this.shunInvalidHeartbeatSender(hb_sender);
                                    break block2;
                                }
                            }
                            break block26;
                        }
                        case 1: {
                            if (pd == null || !pd.equals(hdr.from)) ** GOTO lbl40
                            this.last_ack = System.currentTimeMillis();
                            this.num_tries = 0;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.getLocalAddress() + ":" + this.getName() + " received heartbeat from " + hdr.from);
                                break block2;
                            }
                            break block26;
lbl40:
                            // 1 sources

                            this.stop();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.getLocalAddress() + ":" + this.getName() + " received heartbeat from " + hdr.from + " who is not my ping-dest (" + pd + ")");
                            }
                            if ((pd = (this.ping_dest = this.getPingDest(this.pingable_mbrs))) == null) ** GOTO lbl50
                            try {
                                this.startMonitor();
                            }
                            catch (Exception ex) {
                                if (!this.warn) ** GOTO lbl50
                                this.log.warn(JGroupsStrings.FD_EXCEPTION_WHEN_CALLING_STARTMONITOR, ex);
                            }
lbl50:
                            // 4 sources

                            if (this.log.isDebugEnabled()) {
                                this.log.debug(this.getLocalAddress() + ":" + this.getName() + " ping_dest is now " + pd);
                                break block2;
                            }
                            break block26;
                        }
                        case 2: {
                            if (hdr.mbrs == null) break block26;
                            if (FD.trace) {
                                this.log.trace("[SUSPECT] suspect hdr is " + hdr);
                            }
                            if (!this.isInMembership(msg.getSrc())) break block26;
                            for (i = 0; i < hdr.mbrs.size(); ++i) {
                                m = (Address)hdr.mbrs.elementAt(i);
                                if (this.local_addr == null || !m.equals(this.local_addr)) ** GOTO lbl65
                                if (this.warn) {
                                    this.log.warn("I was suspected, but will not remove myself from membership (waiting for EXIT message)");
                                }
                                ** GOTO lbl76
lbl65:
                                // 1 sources

                                this.bcast_task.addSuspectedMember(m);
                                this.ping_dest = this.getPingDest(this.pingable_mbrs);
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Old " + this.getName() + " ping-dest was susepected, so selected new ping-dest " + this.ping_dest);
                                }
                                if ((pd = this.ping_dest) == null) ** GOTO lbl76
                                try {
                                    this.startMonitor();
                                }
                                catch (Exception ex) {
                                    if (!this.warn) ** GOTO lbl76
                                    this.log.warn("exception when calling startMonitor()", ex);
                                }
lbl76:
                                // 5 sources

                                this.passUp(new Event(9, new SuspectMember(msg.getSrc(), m)));
                                this.passDown(new Event(9, new SuspectMember(msg.getSrc(), m)));
                            }
                            break block26;
                        }
                        case 3: {
                            if (this.shun) {
                                this.log.getInternalLogWriter().severe(JGroupsStrings.FD_RECEIVED_NOT_MEMBER_MESSAGE_FROM_0_THIS_VM_IS_NO_LONGER_A_MEMBER_EXITING, msg.getSrc());
                                this.passUp(new Event(46, new ForcedDisconnectException(JGroupsStrings.FD_THIS_MEMBER_HAS_BEEN_FORCED_OUT_OF_THE_DISTRIBUTED_SYSTEM_PLEASE_CONSULT_GEMFIRE_LOGS_TO_FIND_THE_REASON_FD.toLocalizedString())));
                            } else {
                                ** GOTO lbl84
                            }
                        }
                    }
                }
            }
        }
        this.passUp(evt);
    }

    public void beSick() {
        this.beingSick = true;
    }

    public void beHealthy() {
        this.beingSick = false;
    }

    public void messageReceivedFrom(Address sender) {
        if (DISABLED || this.disconnecting) {
            return;
        }
        Address pd = this.ping_dest;
        if (pd != null && pd.equals(sender)) {
            this.last_ack = System.currentTimeMillis();
            this.num_tries = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void down(Event evt) {
        pd = this.ping_dest;
        switch (evt.getType()) {
            case 1: {
                if (FD.DISABLED || this.disconnecting) {
                    this.passDown(evt);
                    break;
                }
                msg = (Message)evt.getArg();
                hdr = (FD_SOCK.FdHeader)msg.getHeader("FD_SOCK");
                if (hdr != null && hdr.type == 10 && hdr.mbrs.contains(pd)) {
                    it = hdr.mbrs.iterator();
                    while (it.hasNext()) {
                        this.bcast_task.addSuspectedMember((Address)it.next());
                    }
                    this.passDown(evt);
                    pd = this.ping_dest = this.getPingDest(this.pingable_mbrs);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.getLocalAddress() + ": " + this.getName() + " ping-dest is now " + pd);
                    }
                    if (pd == null) break;
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.warn) break;
                        this.log.warn(JGroupsStrings.FD_EXCEPTION_WHEN_CALLING_STARTMONITOR, ex);
                    }
                    break;
                }
                this.passDown(evt);
                break;
            }
            case 6: {
                if (FD.DISABLED || this.disconnecting) {
                    this.passDown(evt);
                    break;
                }
                ex = this;
                synchronized (ex) {
                    this.stop();
                    v = (View)evt.getArg();
                    this.coordinator = v.getCreator();
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    var7_10 = this.pingable_mbrs;
                    synchronized (var7_10) {
                        coord = new Membership(v.getMembers()).getCoordinator();
                        this.isCoordinator = this.local_addr != null && coord != null && this.local_addr.equals(coord) != false;
                        this.pingable_mbrs.clear();
                        this.pingable_mbrs.addAll(this.members);
                    }
                    this.passDown(evt);
                    this.ping_dest = this.getPingDest(this.pingable_mbrs);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.getLocalAddress() + ":" + this.getName() + " ping-dest is now " + this.ping_dest + " and coordinator is " + this.coordinator);
                    }
                    if ((pd = this.ping_dest) == null) break;
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.warn) break;
                        this.log.warn("exception when calling startMonitor()", ex);
                    }
                    break;
                }
            }
            case 51: {
                if (FD.DISABLED || this.disconnecting) {
                    this.passDown(evt);
                    break;
                }
                mbr = (Address)evt.getArg();
                if (this.log.isDebugEnabled()) {
                    sb = new StringBuffer(this.getName() + " is unsuspecting ").append(mbr);
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, sb);
                }
                this.unsuspect(mbr);
                this.ping_dest = this.getPingDest(this.pingable_mbrs);
                if (this.log.isDebugEnabled()) {
                    sb = new StringBuffer(this.getLocalAddress() + ":" + this.getName() + " ping-dest is now ").append(this.ping_dest);
                    this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, sb);
                }
                if ((pd = this.ping_dest) == null) ** GOTO lbl87
                try {
                    this.startMonitor();
                }
                catch (Exception ex) {
                    if (!this.warn) ** GOTO lbl87
                    this.log.warn("exception when calling startMonitor()", ex);
                }
lbl87:
                // 4 sources

                this.passDown(evt);
                break;
            }
            case 1007: {
                this.disconnecting = true;
                this.passDown(evt);
                this.stop();
                break;
            }
            case 61: {
                this.disconnecting = false;
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private void unsuspect(Address mbr) {
        this.bcast_task.removeSuspectedMember(mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInMembership(Address sender) {
        if (this.isCoordinator && this.pingable_mbrs != null) {
            List list = this.pingable_mbrs;
            synchronized (list) {
                HashSet m = new HashSet(this.pingable_mbrs);
                return m.contains(sender);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SUSPECT_ALL() {
        this.log.getInternalLogWriter().severe(JGroupsStrings.ONE_ARG, this.getName() + ".SUSPECT_ALL invoked", (Throwable)new Exception("stack trace"));
        List list = this.pingable_mbrs;
        synchronized (list) {
            for (Address mbr : this.pingable_mbrs) {
                if (mbr.equals(this.local_addr)) continue;
                Message msg = new Message();
                FD_SOCK.FdHeader hdr = new FD_SOCK.FdHeader(20, mbr);
                msg.putHeader("FD_SOCK", hdr);
                this.passUp(new Event(1, msg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shunInvalidHeartbeatSender(Address hb_sender) {
        boolean notMember;
        int num_pings = 0;
        FD fD = this;
        synchronized (fD) {
            notMember = hb_sender != null && this.members != null && !this.members.contains(hb_sender);
        }
        if (notMember) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(hb_sender + " is not in " + this.members + " ! Shunning it");
                    }
                    Message shun_msg = new Message(hb_sender, null, null);
                    shun_msg.putHeader(this.getName(), new FdHeader(3));
                    shun_msg.isHighPriority = true;
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, ++num_pings);
                }
            } else {
                this.invalid_pingers.put(hb_sender, ++num_pings);
            }
        }
    }

    protected class Broadcaster {
        private final Vector suspected_mbrs = new Vector(7);

        protected Broadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            Object object = this;
            synchronized (object) {
                if (!FD.this.members.contains(mbr)) {
                    return;
                }
            }
            object = this.suspected_mbrs;
            synchronized (object) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug("removing suspect member " + suspected_mbr);
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isSuspectedMember(Address mbr) {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                return this.suspected_mbrs.contains(mbr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(List new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (FD.this.log.isDebugEnabled()) {
                    sb.append("suspected_mbrs: ").append(this.suspected_mbrs);
                }
                this.suspected_mbrs.retainAll(new_mbrship);
                if (FD.this.log.isDebugEnabled()) {
                    sb.append(", after adjustment: ").append(this.suspected_mbrs);
                }
                FD.this.log.debug(sb.toString());
            }
        }
    }

    protected class Monitor
    implements TimeScheduler.Task {
        volatile boolean started = true;

        protected Monitor() {
        }

        public void stop() {
            this.started = false;
        }

        @Override
        public boolean cancelled() {
            return !this.started;
        }

        @Override
        public long nextInterval() {
            return FD.this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Address pd = FD.this.ping_dest;
            if (FD.this.beingSick) {
                return;
            }
            if (pd == null) {
                if (FD.this.log.isDebugEnabled()) {
                    FD.this.log.debug("ping_dest is null: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr);
                }
                return;
            }
            Message hb_req = new Message(pd, null, null);
            hb_req.putHeader(FD.this.getName(), new FdHeader(0));
            hb_req.isHighPriority = true;
            if (!this.started) {
                return;
            }
            FD.this.passDown(new Event(1, hb_req));
            ++FD.this.num_heartbeats;
            long not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    FD_SOCK fdsock;
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug("[" + FD.this.local_addr + "]:" + FD.this.getName() + " received no heartbeat ack from " + pd + " for " + (FD.this.num_tries + 1) + " times (" + (long)(FD.this.num_tries + 1) * FD.this.timeout + " milliseconds), suspecting it");
                    }
                    if ((fdsock = (FD_SOCK)FD.this.stack.findProtocol("FD_SOCK")) != null && !fdsock.checkSuspect(pd, FD.this.getName() + " heartbeat timeout")) {
                        List list = FD.this.pingable_mbrs;
                        synchronized (list) {
                            FD.this.bcast_task.addSuspectedMember(pd);
                            FD.this.ping_dest = FD.this.getPingDest(FD.this.pingable_mbrs);
                            if (FD.this.log.isDebugEnabled()) {
                                FD.this.log.debug(FD.this.getLocalAddress() + ":" + FD.this.getName() + " ping-dest is now suspect.  new ping-dest is " + FD.this.ping_dest);
                            }
                            if (FD.this.ping_dest == null) {
                                this.stop();
                            }
                        }
                    }
                    FD.this.num_tries = 0;
                    if (FD.this.stats) {
                        ++FD.this.num_suspect_events;
                        FD.this.suspect_history.add(pd);
                    }
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug("heartbeat missing from " + pd + " (number=" + FD.this.num_tries + ')');
                    }
                    ++FD.this.num_tries;
                }
            }
        }

        public String toString() {
            return FD.this.getName() + " heartbeat monitor: " + this.started;
        }
    }

    protected class HeartbeatSender
    implements TimeScheduler.Task {
        volatile boolean started = true;
        long interval;

        protected HeartbeatSender() {
            this.interval = FD.this.timeout * 2L / 3L;
        }

        public void stop() {
            this.started = false;
        }

        @Override
        public boolean cancelled() {
            return !this.started;
        }

        @Override
        public long nextInterval() {
            return this.interval <= 0L ? 25L : this.interval;
        }

        public String toString() {
            return FD.this.getName() + " heartbeat sender: " + this.started;
        }

        @Override
        public void run() {
            if (!FD.this.beingSick) {
                Message msg;
                Address receiver = FD.this.getHeartbeatDest();
                Address coord = FD.this.coordinator;
                if (FD.this.log.isDebugEnabled()) {
                    FD.this.log.debug("sending heartbeat to " + receiver + " and coordinator " + coord);
                }
                if (receiver != null) {
                    msg = new Message();
                    msg.setDest(receiver);
                    msg.putHeader(FD.this.getName(), new FdHeader(1, null, FD.this.local_addr));
                    msg.isHighPriority = true;
                    if (!this.started) {
                        return;
                    }
                    FD.this.passDown(new Event(1, msg));
                }
                if (coord != null) {
                    msg = new Message();
                    msg.setDest(coord);
                    msg.putHeader(FD.this.getName(), new FdHeader(1, null, FD.this.local_addr));
                    msg.isHighPriority = true;
                    if (!this.started) {
                        return;
                    }
                    FD.this.passDown(new Event(1, msg));
                }
            }
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte HEARTBEAT_ACK = 1;
        public static final byte SUSPECT = 2;
        public static final byte NOT_MEMBER = 3;
        byte type = 0;
        Vector mbrs = null;
        Address from = null;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Vector mbrs, Address from) {
            this(type);
            this.mbrs = mbrs;
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "[FD: heartbeat request]";
                }
                case 1: {
                    return "[FD: heartbeat]";
                }
                case 2: {
                    return "[FD: SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")]";
                }
                case 3: {
                    return "[FD: NOT_MEMBER]";
                }
            }
            return "[FD: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                for (Address addr : this.mbrs) {
                    Marshaller.write(addr, out);
                }
            }
            Marshaller.write(this.from, out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector(11);
                for (int i = 0; i < len; ++i) {
                    Address addr = (Address)Marshaller.read(in);
                    this.mbrs.add(addr);
                }
            }
            this.from = (Address)Marshaller.read(in);
        }

        @Override
        public long size(short version) {
            int retval = 1;
            retval = (int)((long)retval + Util.size(this.mbrs, version));
            return retval += Util.size(this.from, version);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddresses(this.mbrs, out);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.mbrs = (Vector)Util.readAddresses(in, Vector.class);
            this.from = Util.readAddress(in);
        }
    }
}

