/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.ConcurrentReaderHashMap;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.Streamable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.Logger;

public class FC
extends Protocol {
    private static final Logger logger = LogService.getLogger();
    final Map sent = new HashMap(11);
    final Map throttle = new HashMap(11);
    final Map received = new ConcurrentReaderHashMap(11);
    final List creditors = new ArrayList(11);
    private long max_credits = 50000L;
    private Long max_credits_constant;
    private long max_block_time = 5000L;
    private double min_threshold = 0.25;
    private long min_credits;
    private boolean running = true;
    private boolean insufficient_credit;
    private long lowest_credit = this.max_credits;
    volatile Object mutex = new Object();
    static final String name = "FC";
    private int num_blockings;
    private int num_credit_requests_received;
    private int num_credit_requests_sent;
    private int num_credit_responses_sent;
    private int num_credit_responses_received;
    private long total_time_blocking;
    private long mcast_throttle_time;
    private Object mcast_throttle_mutex = new Object();
    final BoundedList last_blockings = new BoundedList(50);
    final Map throttledSenders = new HashMap();

    @Override
    public final String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 8;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
        this.total_time_blocking = 0L;
        this.last_blockings.removeAll();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
        this.max_credits_constant = this.max_credits;
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    public boolean isBlocked() {
        return this.insufficient_credit;
    }

    public int getNumberOfBlockings() {
        return this.num_blockings;
    }

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    public long getTotalTimeBlocked() {
        return this.total_time_blocking;
    }

    public double getAverageTimeBlocked() {
        return this.num_blockings == 0 ? 0.0 : (double)this.total_time_blocking / (double)this.num_blockings;
    }

    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    public String printSenderCredits() {
        return FC.printMap(this.sent);
    }

    public String printReceiverCredits() {
        return FC.printMap(this.received);
    }

    public String printCredits() {
        StringBuffer sb = new StringBuffer();
        sb.append("senders:\n").append(FC.printMap(this.sent)).append("\n\nreceivers:\n").append(FC.printMap(this.received));
        return sb.toString();
    }

    @Override
    public Map dumpStats() {
        HashMap<String, String> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, String>();
        }
        retval.put("senders", FC.printMap(this.sent));
        retval.put("receivers", FC.printMap(this.received));
        retval.put("num_blockings", (String)((Object)Integer.valueOf(this.num_blockings)));
        retval.put("avg_time_blocked", (String)((Object)Double.valueOf(this.getAverageTimeBlocked())));
        retval.put("num_replenishments", (String)((Object)Integer.valueOf(this.num_credit_responses_received)));
        retval.put("total_time_blocked", (String)((Object)Long.valueOf(this.total_time_blocking)));
        return retval;
    }

    public String showLastBlockingTimes() {
        return this.last_blockings.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"}, justification="the code is correct")
    public void unblock() {
        Object mux;
        Object object = mux = this.mutex;
        synchronized (object) {
            if (this.mutex != mux) {
                this.unblock();
                return;
            }
            if (trace) {
                this.log.trace("unblocking the sender and replenishing all members, creditors are " + this.creditors);
            }
            for (Map.Entry entry : this.sent.entrySet()) {
                entry.setValue(this.max_credits_constant);
            }
            this.lowest_credit = this.computeLowestCredit(this.sent);
            this.creditors.clear();
            this.insufficient_credit = false;
            mux.notifyAll();
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        boolean min_credits_set = false;
        super.setProperties(props);
        String str = props.getProperty("max_credits");
        if (str != null) {
            this.max_credits = Long.parseLong(str);
            props.remove("max_credits");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Double.parseDouble(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("min_credits")) != null) {
            this.min_credits = Long.parseLong(str);
            props.remove("min_credits");
            min_credits_set = true;
        }
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        if ((str = props.getProperty("max_block_time")) != null) {
            this.max_block_time = Long.parseLong(str);
            props.remove("max_block_time");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FC_FCSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        this.max_credits_constant = this.max_credits;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object mux;
        super.start();
        Object object = mux = this.mutex;
        synchronized (object) {
            if (this.mutex != mux) {
                this.start();
                return;
            }
            this.running = true;
            this.insufficient_credit = false;
            this.lowest_credit = this.max_credits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object mux;
        super.stop();
        Object object = mux = this.mutex;
        synchronized (object) {
            if (this.mutex != mux) {
                this.stop();
                return;
            }
            this.running = false;
            this.mutex.notifyAll();
        }
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.handleDownMessage(evt);
                return;
            }
            case 6: {
                View v = (View)evt.getArg();
                Vector mbrs = v.getMembers();
                this.handleViewChange(mbrs);
            }
        }
        this.passDown(evt);
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FcHeader hdr = (FcHeader)msg.removeHeader(name);
                if (hdr != null) {
                    Address sender = msg.getSrc();
                    switch (hdr.type) {
                        case 1: {
                            if (logger.isTraceEnabled()) {
                                logger.trace("(FC) received REPLENISH from {} with {}", sender, hdr.getBalance());
                            }
                            ++this.num_credit_responses_received;
                            this.handleCredit(msg.getSrc(), hdr.getBalance());
                            break;
                        }
                        case 4: {
                            if (logger.isTraceEnabled()) {
                                logger.trace("(FC) received THROTTLE request from {} with {}", sender, hdr.getBalance());
                            }
                            this.handleThrottleRequest(msg.getSrc(), hdr.getBalance());
                            break;
                        }
                        case 3: {
                            if (logger.isTraceEnabled()) {
                                logger.trace("(FC) received WAIT request from {}. Responding with credit request", sender);
                            }
                            this.sendCreditRequest(msg.getSrc());
                            break;
                        }
                        case 2: {
                            ++this.num_credit_requests_received;
                            long balance = (Long)this.received.get(sender);
                            this.received.put(sender, this.max_credits_constant);
                            if (logger.isTraceEnabled()) {
                                logger.trace("(FC) received credit request from {}: sending {} credits", sender, this.max_credits - balance);
                            }
                            this.sendCredit(sender, this.max_credits - balance);
                            if (this.stack.gemfireStats == null) break;
                            this.stack.gemfireStats.incFlowControlResponses();
                            break;
                        }
                        default: {
                            this.log.error(JGroupsStrings.FC_HEADER_TYPE__0__NOT_KNOWN, hdr.type);
                        }
                    }
                    return;
                }
                this.adjustCredit(msg);
                break;
            }
            case 6: {
                View newView = (View)evt.getArg();
                this.handleViewChange(newView.getMembers());
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="the code is for a hotspot bug")
    private void handleDownMessage(Event evt) {
        boolean requestSent = false;
        Message msg = (Message)evt.getArg();
        if (msg.isHighPriority || Thread.currentThread().getName().startsWith("UDP")) {
            this.passDown(evt);
            return;
        }
        int length = msg.getLength();
        Address dest = msg.getDest();
        long blockStartTime = 0L;
        this.throttleOnReceiver(dest);
        try {
            Object mux;
            Object object = mux = this.mutex;
            synchronized (object) {
                if (mux != this.mutex) {
                    this.passDown(evt);
                    return;
                }
                if (this.lowest_credit <= (long)length) {
                    this.stack.gemfireStats.incJgFCsendBlocks(1L);
                    this.determineCreditors(dest, length);
                    this.insufficient_credit = true;
                    ++this.num_blockings;
                    blockStartTime = this.stack.gemfireStats.startFlowControlWait();
                    long start_blocking = System.currentTimeMillis();
                    boolean warned = false;
                    boolean shunned = false;
                    while (this.insufficient_credit && this.running && this.creditors.size() > 0) {
                        try {
                            mux.wait(this.max_block_time);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        if (!this.insufficient_credit || !this.running) continue;
                        this.stack.gemfireStats.incJgFCautoRequests(1L);
                        int secs = this.stack.jgmm.getDistributionConfig().getAckWaitThreshold();
                        long elapsed = System.currentTimeMillis() - start_blocking;
                        if (elapsed > (long)(secs * 1000)) {
                            if (!warned) {
                                warned = true;
                                this.log.getInternalLogWriter().warning(JGroupsStrings.FC_FLOW_CONTROL_HAS_BLOCKED_FOR_MORE_THAN_0_SECONDS_WAITING_FOR_REPLENISHMENT_FROM_1, new Object[]{elapsed / 1000L, this.creditors});
                            } else {
                                secs = this.stack.jgmm.getDistributionConfig().getAckSevereAlertThreshold();
                                if (secs > 0 && !shunned && elapsed > (long)(secs * 1000)) {
                                    shunned = true;
                                }
                            }
                        }
                        if (requestSent) continue;
                        requestSent = true;
                        for (int i = 0; i < this.creditors.size(); ++i) {
                            this.sendCreditRequest((Address)this.creditors.get(i));
                        }
                    }
                    if (warned) {
                        this.log.getInternalLogWriter().warning(JGroupsStrings.FC_FLOW_CONTROL_WAS_UNBLOCKED_AFTER_WAITING_0_SECONDS, (System.currentTimeMillis() - start_blocking) / 1000L);
                    }
                    this.stack.gemfireStats.endFlowControlWait(blockStartTime);
                } else {
                    long tmp = this.decrementCredit(this.sent, dest, length);
                    if (tmp != -1L) {
                        this.lowest_credit = Math.min(tmp, this.lowest_credit);
                    }
                }
            }
        }
        catch (IllegalMonitorStateException e) {
            this.mutex = new Object();
        }
        this.passDown(evt);
    }

    private void determineCreditors(Address dest, int length) {
        boolean multicast;
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast) {
            for (Map.Entry entry : this.sent.entrySet()) {
                Address mbr = (Address)entry.getKey();
                Long credits = (Long)entry.getValue();
                if (credits > (long)length || this.creditors.contains(mbr)) continue;
                this.creditors.add(mbr);
            }
        } else {
            Long credits = (Long)this.sent.get(dest);
            if (credits != null && credits <= (long)length && !this.creditors.contains(dest)) {
                this.creditors.add(dest);
            }
        }
    }

    private long decrementCredit(Map m, Address dest, long credits) {
        boolean multicast = dest == null || dest.isMulticastAddress();
        long lowest = this.max_credits;
        if (multicast) {
            if (m.size() == 0) {
                return -1L;
            }
            for (Map.Entry entry : m.entrySet()) {
                Long val = (Long)entry.getValue();
                long tmp = val;
                entry.setValue(tmp -= credits);
                lowest = Math.min(tmp, lowest);
            }
            return lowest;
        }
        Long val = (Long)m.get(dest);
        if (val != null) {
            lowest = val;
            m.put(dest, lowest -= credits);
            return lowest;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThrottleRequest(Address sender, long balance) {
        if (sender == null) {
            return;
        }
        Map map = this.throttle;
        synchronized (map) {
            this.throttle.put(sender, balance);
            if (balance > this.mcast_throttle_time) {
                this.mcast_throttle_time = balance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throttleOnReceiver(Address dest) {
        boolean multicast = dest == null || dest.isMulticastAddress();
        int sleep = 0;
        Long p2p_throttle = null;
        long blockStartTime = 0L;
        if (multicast) {
            Object object = this.throttle;
            synchronized (object) {
                if (this.mcast_throttle_time <= 0L) {
                    return;
                }
                sleep = (int)this.mcast_throttle_time;
                this.mcast_throttle_time = 0L;
            }
            object = this.mcast_throttle_mutex;
            synchronized (object) {
                if (trace) {
                    this.log.trace("### throttling for mcast" + sleep);
                }
                blockStartTime = this.stack.gemfireStats.startFlowControlThrottleWait();
                this.throttleSleep(sleep);
                this.stack.gemfireStats.endFlowControlThrottleWait(blockStartTime);
            }
            this.throttle.clear();
        } else {
            p2p_throttle = (Long)this.throttle.get(dest);
            if (p2p_throttle != null) {
                Long l = p2p_throttle;
                synchronized (l) {
                    blockStartTime = this.stack.gemfireStats.startFlowControlThrottleWait();
                    sleep = p2p_throttle.intValue();
                    this.throttleSleep(sleep);
                    this.stack.gemfireStats.endFlowControlThrottleWait(blockStartTime);
                }
                this.throttle.remove(dest);
                if (this.mcast_throttle_time > 0L) {
                    this.mcast_throttle_time -= (long)sleep;
                }
            }
        }
    }

    private void throttleSleep(int sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"}, justification="the code is correct")
    private void handleCredit(Address sender, long balance) {
        if (sender == null) {
            return;
        }
        StringBuffer sb = null;
        Object mux = this.mutex;
        Object object = this.mutex;
        synchronized (object) {
            if (this.mutex != mux) {
                this.handleCredit(sender, balance);
                return;
            }
            Long old_entry = (Long)this.sent.get(sender);
            if (old_entry == null) {
                return;
            }
            long old_credit = old_entry;
            if (this.stack.gemfireStats != null) {
                this.stack.gemfireStats.incJgFCreplenish(1L);
            }
            if (trace) {
                sb = new StringBuffer();
                sb.append("received credit <" + balance + "> from ").append(sender).append(", old credit was ").append(old_credit).append(", new credits are ").append(this.max_credits).append(".\nCreditors before are: ").append(this.creditors);
            }
            if ((old_credit += balance) > this.max_credits) {
                old_credit = this.max_credits;
            }
            this.sent.put(sender, old_credit);
            if (this.creditors.size() > 0) {
                this.creditors.remove(sender);
                if (trace) {
                    sb.append("\nCreditors after removal of ").append(sender).append(" are: ").append(this.creditors);
                    this.log.trace(sb.toString());
                }
            }
            this.lowest_credit = this.computeLowestCredit(this.sent);
            if (this.insufficient_credit && this.lowest_credit > 0L && this.creditors.size() == 0) {
                this.insufficient_credit = false;
                this.mutex.notifyAll();
                if (this.stack.gemfireStats != null) {
                    this.stack.gemfireStats.incJgFCresumes(1L);
                }
            }
        }
    }

    private long computeLowestCredit(Map m) {
        Collection credits = m.values();
        Long retval = (Long)Collections.min(credits);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCredit(Message msg) {
        Address src = msg.getSrc();
        long length = msg.getLength();
        if (src == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.FC_SRC_IS_NULL);
            }
            return;
        }
        if (length == 0L) {
            return;
        }
        long balance = this.decrementCredit(this.received, src, length);
        int throttleTime = 0;
        if (msg.isCacheOperation) {
            boolean check = msg.getDest() == null || msg.getDest().isMulticastAddress();
            boolean bl = check = check || this.stack.jgmm.getDistributionConfig().getDisableTcp();
            if (check) {
                throttleTime = this.stack.jgmm.getSerialQueueThrottleTime(src);
            }
        }
        if (throttleTime > 0) {
            boolean sendMsg = false;
            Map map = this.throttledSenders;
            synchronized (map) {
                Long throttleStart = (Long)this.throttledSenders.get(src);
                long now = System.currentTimeMillis();
                if (throttleStart == null || now - throttleStart > 1000L) {
                    this.throttledSenders.put(src, now);
                    sendMsg = true;
                }
            }
            if (sendMsg) {
                this.sendThrottleRequest(src, throttleTime);
            }
        } else if (balance <= this.min_credits) {
            Map map = this.throttledSenders;
            synchronized (map) {
                this.throttledSenders.remove(src);
            }
            this.received.put(src, this.max_credits_constant);
            if (trace) {
                this.log.trace("sending replenishment message to " + src + " for " + msg);
            }
            this.sendCredit(src, this.max_credits - balance);
        }
    }

    private void sendThrottleRequest(Address dest, long throttleTime) {
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incJgFCsentThrottleRequests(1L);
        }
        Message msg = new Message(dest, null, null);
        msg.putHeader(name, new FcHeader(4, throttleTime));
        msg.isHighPriority = true;
        this.passDown(new Event(1, msg));
    }

    private void sendCredit(Address dest, long credit) {
        if (this.stack.gemfireStats != null) {
            this.stack.gemfireStats.incJgFCsentCredits(1L);
        }
        Message msg = new Message(dest, null, null);
        msg.putHeader(name, new FcHeader(1, credit));
        msg.isHighPriority = true;
        this.passDown(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    private void sendCreditRequest(Address dest) {
        Message msg = new Message(dest, null, null);
        msg.putHeader(name, new FcHeader(2, 0L));
        msg.isHighPriority = true;
        this.passDown(new Event(1, msg));
        ++this.num_credit_requests_sent;
        this.stack.gemfireStats.incFlowControlRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"}, justification="the code is correct")
    private void handleViewChange(Vector mbrs) {
        if (mbrs == null) {
            return;
        }
        Object mux = this.mutex;
        Object object = this.mutex;
        synchronized (object) {
            Address addr;
            if (this.mutex != mux) {
                this.handleViewChange(mbrs);
                return;
            }
            for (int i = 0; i < mbrs.size(); ++i) {
                addr = (Address)mbrs.elementAt(i);
                if (!this.received.containsKey(addr)) {
                    this.received.put(addr, this.max_credits_constant);
                }
                if (this.sent.containsKey(addr)) continue;
                this.sent.put(addr, this.max_credits_constant);
            }
            Iterator it = this.received.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            it = this.sent.keySet().iterator();
            while (it.hasNext()) {
                addr = (Address)it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            for (int i = 0; i < this.creditors.size(); ++i) {
                Address creditor = (Address)this.creditors.get(i);
                if (mbrs.contains(creditor)) continue;
                this.creditors.remove(creditor);
            }
            if (trace) {
                this.log.trace("creditors are " + this.creditors);
            }
            if (this.insufficient_credit && this.creditors.size() == 0) {
                this.lowest_credit = this.computeLowestCredit(this.sent);
                this.insufficient_credit = false;
                this.mutex.notifyAll();
            }
        }
    }

    private static String printMap(Map m) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : m.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class FcHeader
    extends Header
    implements Streamable {
        public static final byte REPLENISH = 1;
        public static final byte CREDIT_REQUEST = 2;
        public static final byte WAIT = 3;
        public static final byte THROTTLE = 4;
        long balance;
        byte type = 1;

        public FcHeader() {
        }

        public FcHeader(byte type, long balance) {
            this.type = type;
            this.balance = balance;
        }

        public long getBalance() {
            return this.balance;
        }

        @Override
        public long size(short version) {
            return 9L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.balance);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.balance = in.readLong();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.balance);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.balance = in.readLong();
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "REPLENISH";
                }
                case 2: {
                    return "CREDIT_REQUEST";
                }
                case 3: {
                    return "WAIT";
                }
                case 4: {
                    return "THROTTLE";
                }
            }
            return "<invalid type>";
        }
    }
}

