/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.stack.Protocol;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class ENCRYPT1_4
extends Protocol {
    Address local_addr = null;
    Address keyServerAddr = null;
    boolean keyServer = false;
    String asymAlgorithm = "RSA";
    String symAlgorithm = "DES/ECB/PKCS5Padding";
    int asymInit = 512;
    int symInit = 56;
    KeyPair Kpair;
    SecretKey desKey = null;
    final PublicKey pubKey = null;
    Cipher cipher;
    Cipher rsa;
    final Vector members = new Vector();
    final Vector notReady = new Vector();

    @Override
    public String getName() {
        return "ENCRYPT1_4";
    }

    private static String getAlgorithm(String s) {
        int index2 = s.indexOf("/");
        if (index2 == -1) {
            return s;
        }
        return s.substring(0, index2);
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("asymInit");
        if (str != null) {
            this.asymInit = Integer.parseInt(str);
            props.remove("asymInit");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT1_4_ASYM_ALGO_BITS_USED_IS__0, this.asymInit);
            }
        }
        if ((str = props.getProperty("symInit")) != null) {
            this.symInit = Integer.parseInt(str);
            props.remove("symInit");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT1_4_SYM_ALGO_BITS_USED_IS__0, this.symInit);
            }
        }
        if ((str = props.getProperty("asymAlgorithm")) != null) {
            this.asymAlgorithm = str;
            props.remove("asymAlgorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT1_4_ASYM_ALGO_USED_IS__0, this.asymAlgorithm);
            }
        }
        if ((str = props.getProperty("symAlgorithm")) != null) {
            this.symAlgorithm = str;
            props.remove("symAlgorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT1_4_SYM_ALGO_USED_IS__0, this.symAlgorithm);
            }
        }
        if (props.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ENCRYPT1_4_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            }
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        KeyPairGenerator KpairGen = KeyPairGenerator.getInstance(ENCRYPT1_4.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        KeyGenerator keyGen = KeyGenerator.getInstance(ENCRYPT1_4.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.desKey = keyGen.generateKey();
        this.rsa = Cipher.getInstance(this.asymAlgorithm);
        this.cipher = Cipher.getInstance(this.symAlgorithm);
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT1_4_BOTH_ASYM_AND_SYM_ALGO_INITIALIZED_WITH_THE_SINGLE_SHARED_KEY);
        }
    }

    public static void reset() {
    }

    @Override
    public void up(Event evt) {
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT1_4_EVENT_GOING_UP_IS__0, evt);
        }
        switch (evt.getType()) {
            case 8: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_SET_ADDRESS_CALL);
                }
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 13: {
                Vector member = (Vector)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_FIND_INIT_MEMBERS_CALL_LEFT_MEMBERS_ARE__0, member.size());
                }
                if (!this.keyServer) {
                    this.keyServer = member.size() <= 0;
                }
                this.keyServerAddr = member != null && member.size() > 0 ? ((PingRsp)member.firstElement()).coord_addr : this.local_addr;
                if (!this.keyServer) {
                    this.desKey = null;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("This is not keyserver, deskey set to null");
                    }
                    Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                    newMsg.putHeader("encrypt", new EncryptHeader(1));
                    this.passDown(new Event(1, newMsg));
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_DONE_PARSING_FOR_ENCRYPT_HEADERS_SENDING_UPWARDS_0, evt);
                }
                this.passUp(evt);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_THIS_IS_A_MESSAGE_FROM_PEER_NOT_CONTROL_HEADER_0, msg);
                }
                if (msg == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Null message");
                    }
                    this.passUp(evt);
                    return;
                }
                Header obj = msg.removeHeader("encrypt");
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_STRIPPING_THE_REQUIRED_PROTOCOL_HEADER);
                }
                if (obj == null || !(obj instanceof EncryptHeader)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.ENCRYPT1_4_DROPPING_PACKAGE_AS_ENCRYPT1_4_PROTOCOL_IS_NOT_BEEN_RECOGNIZED_MSG_WILL_NOT_BE_PASSED_UP);
                    }
                    return;
                }
                EncryptHeader hdr = (EncryptHeader)obj;
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_HEADER_RECEIVED_0_1, new Object[]{hdr, hdr.type});
                }
                switch (hdr.type) {
                    case 1: {
                        try {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Request for key");
                            }
                            this.notReady.addElement(msg.getSrc());
                            PublicKey tmpPubKey = this.generatePubKey(msg.getBuffer());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Generated requestors public key");
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, this.Kpair.getPublic().getEncoded());
                            newMsg.putHeader("encrypt", new EncryptHeader(2));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Encoded servers public key using clients public key, only client can debug it using its private key and sending it back");
                            }
                            this.passDown(new Event(1, newMsg));
                            this.rsa.init(1, tmpPubKey);
                            byte[] encryptedKey = this.rsa.doFinal(this.desKey.getEncoded());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(" Generated encoded key which only client can decode");
                            }
                            newMsg = new Message(msg.getSrc(), this.local_addr, encryptedKey);
                            newMsg.putHeader("encrypt", new EncryptHeader(3));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(" Sending encoded key to client");
                            }
                            this.passDown(new Event(1, newMsg));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e + "0");
                        }
                        return;
                    }
                    case 4: {
                        this.notReady.removeElement(msg.getSrc());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Removed client " + msg.getSrc() + "from notready list");
                        }
                        return;
                    }
                    case 2: {
                        this.generatePubKey(msg.getBuffer());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(" Obtained the servers public key");
                        }
                        return;
                    }
                    case 3: {
                        try {
                            this.rsa.init(2, this.Kpair.getPrivate());
                            byte[] encodedKey = this.rsa.doFinal(msg.getBuffer());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("generating encoded key obtained from server-admin");
                            }
                            this.desKey = this.decodedKey(encodedKey);
                            if (this.desKey == null) {
                                this.log.error(JGroupsStrings.ENCRYPT1_4_OHH_OH__DES_KEY_IS_NULL);
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, null);
                            newMsg.putHeader("encrypt", new EncryptHeader(4));
                            this.passDown(new Event(1, newMsg));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Got the deskey, sending down sec_Ready header");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e + "5");
                        }
                        return;
                    }
                }
                if (hdr.type != 0) {
                    this.log.error(JGroupsStrings.ENCRYPT1_4_ERROR__HEADER_IS_NOT_0);
                }
                if (this.desKey == null) {
                    return;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_STARTING_TO_DECYPHER_MESSAGES);
                }
                if (msg.getBuffer() == null) break;
                try {
                    this.cipher.init(2, this.desKey);
                    msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT1_4_PASSING_UP_EVENT);
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        boolean leave = false;
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT1_4_DOWNEVT_IS_0_1, new Object[]{evt, evt.getType()});
        }
        switch (evt.getType()) {
            case 6: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_VIEW_CHANGE_CALL_NEW_MEMBER_COMING_IN);
                }
                Vector new_members = ((View)evt.getArg()).getMembers();
                if (this.members.size() > new_members.size()) {
                    leave = true;
                }
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members.size() > 0) {
                        for (int i = 0; i < new_members.size(); ++i) {
                            this.members.addElement(new_members.elementAt(i));
                        }
                    }
                }
                if (!leave) break;
                Object obj = this.members.firstElement();
                if (obj.equals(this.local_addr)) {
                    this.keyServer = true;
                    this.keyServerAddr = this.local_addr;
                    this.desKey = null;
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.ENCRYPT1_4_LEAVE_CAUSED_DESKEY_TO_BE_NULL);
                    }
                    try {
                        KeyGenerator keyGen = KeyGenerator.getInstance(ENCRYPT1_4.getAlgorithm(this.symAlgorithm));
                        keyGen.init(this.symInit);
                        this.desKey = keyGen.generateKey();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                this.keyServer = false;
                this.keyServerAddr = (Address)obj;
                this.desKey = null;
                Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                newMsg.putHeader("encrypt", new EncryptHeader(1));
                this.passDown(new Event(1, newMsg));
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Requesting new key to be part of group");
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Its a message call " + msg);
                }
                if (!this.notReady.isEmpty()) {
                    System.out.println("not Ready list  :" + this.notReady.toString());
                    if (msg.getDest() == null) {
                        for (int i = 0; i < this.notReady.size(); ++i) {
                            Message newMsg = new Message((Address)this.notReady.elementAt(i), this.local_addr, msg.getBuffer());
                            this.passDown(new Event(1, newMsg));
                        }
                        break;
                    }
                    for (int i = 0; i < this.notReady.size(); ++i) {
                        if (!msg.getDest().equals(this.notReady.elementAt(i))) continue;
                        this.passDown(evt);
                        return;
                    }
                }
                if (this.desKey == null) break;
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT1_4_DESKEY_IS_NOT_NULL_I_KNOW_IT);
                }
                try {
                    if (msg.getBuffer() != null) {
                        this.cipher.init(1, this.desKey);
                        msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                        msg.putHeader("encrypt", new EncryptHeader(0));
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info(JGroupsStrings.ENCRYPT1_4_HAVE_DES_KEY__PACKAGE_SENT);
                        break;
                    }
                    msg.setBuffer(null);
                    msg.putHeader("encrypt", new EncryptHeader(0));
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info(JGroupsStrings.ENCRYPT1_4_BUFFER_NULL_ADDED_HEADER);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT1_4_PASS_DOWN__0, evt.toString());
        }
        this.passDown(evt);
    }

    private SecretKey decodedKey(byte[] encodedKey) {
        SecretKey key2 = null;
        try {
            SecretKeyFactory KeyFac = SecretKeyFactory.getInstance(ENCRYPT1_4.getAlgorithm(this.symAlgorithm));
            SecretKeySpec desKeySpec = new SecretKeySpec(encodedKey, ENCRYPT1_4.getAlgorithm(this.symAlgorithm));
            key2 = KeyFac.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key2;
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey tmpPubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ENCRYPT1_4.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            tmpPubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpPubKey;
    }

    public static class EncryptHeader
    extends Header {
        int type;
        static final int ENCRYPT = 0;
        static final int KEY_REQUEST = 1;
        static final int SERVER_PUBKEY = 2;
        static final int SECRETKEY = 3;
        static final int SECRETKEY_READY = 4;
        static final String KEY = "encrypt";

        public EncryptHeader() {
        }

        public EncryptHeader(int type) {
            this.type = type;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        @Override
        public String toString() {
            return "[ENCTYPT: <variables> ]";
        }
    }
}

