/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.protocols.PingSender;
import com.gemstone.org.jgroups.protocols.PingWaiter;
import com.gemstone.org.jgroups.stack.Protocol;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Discovery
extends Protocol {
    final Vector members = new Vector(11);
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    int num_initial_members = 2;
    boolean is_server = false;
    PingWaiter ping_waiter;
    int num_ping_requests = 2;
    int num_discovery_requests = 0;

    @Override
    public int getProtocolEnum() {
        return 12;
    }

    public void localAddressSet(Address addr) {
    }

    public abstract void sendGetMembersRequest(AtomicBoolean var1);

    public void handleConnectOK() {
    }

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (this.ping_waiter != null) {
            this.ping_waiter.setTimeout(timeout);
        }
    }

    public int getNumInitialMembers() {
        return this.num_initial_members;
    }

    public void setNumInitialMembers(int num_initial_members) {
        this.num_initial_members = num_initial_members;
        if (this.ping_waiter != null) {
            this.ping_waiter.setNumRsps(num_initial_members);
        }
    }

    public int getNumPingRequests() {
        return this.num_ping_requests;
    }

    public void setNumPingRequests(int num_ping_requests) {
        this.num_ping_requests = num_ping_requests;
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>(1);
        ret.addElement(12);
        return ret;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            if (this.timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.Discovery_TIMEOUT_MUST_BE__0);
                }
                return false;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = Integer.parseInt(str);
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("num_ping_requests")) != null) {
            this.num_ping_requests = Integer.parseInt(str);
            props.remove("num_ping_requests");
            if (this.num_ping_requests < 1) {
                this.num_ping_requests = 1;
            }
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.Discovery_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, sb);
            }
            return false;
        }
        return true;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
        PingSender ping_sender = new PingSender(this.timeout, this.num_ping_requests, this);
        if (this.ping_waiter == null) {
            this.ping_waiter = new PingWaiter(this.timeout, this.num_initial_members, this, ping_sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeWaiter(AtomicBoolean waiter_sync) {
        AtomicBoolean atomicBoolean = waiter_sync;
        synchronized (atomicBoolean) {
            waiter_sync.set(true);
            waiter_sync.notifyAll();
        }
    }

    @Override
    public void stop() {
        this.is_server = false;
        if (this.ping_waiter != null) {
            this.ping_waiter.stop();
        }
    }

    public Vector findInitialMembers() {
        return this.ping_waiter != null ? this.ping_waiter.findInitialMembers() : null;
    }

    public String findInitialMembersAsString() {
        Vector results = this.findInitialMembers();
        if (results == null || results.size() == 0) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer();
        for (PingRsp rsp : results) {
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void up(Event evt) {
        coord = null;
        block2 : switch (evt.getType()) {
            case 1: {
                msg = (Message)evt.getArg();
                hdr = (PingHeader)msg.removeHeader(this.getName());
                if (hdr == null) {
                    this.passUp(evt);
                    return;
                }
                switch (hdr.type) {
                    case 1: {
                        if (this.local_addr != null && msg.getSrc() != null && this.local_addr.equals(msg.getSrc())) {
                            if (Discovery.trace) {
                                this.log.trace("discarded my own discovery request");
                            }
                            return;
                        }
                        var8_5 = this.members;
                        synchronized (var8_5) {
                            if (this.members.size() <= 0) ** GOTO lbl25
                            for (i = 0; i < this.members.size(); ++i) {
                                mbr = (Address)this.members.get(i);
                                if (!mbr.preferredForCoordinator()) continue;
                                coord = mbr;
                                ** GOTO lbl28
                            }
                            ** GOTO lbl28
lbl25:
                            // 1 sources

                            coord = this.ping_waiter.getPossibleCoordinator(this.local_addr);
                            if (coord == null && this.local_addr.preferredForCoordinator()) {
                                coord = this.local_addr;
                            }
lbl28:
                            // 5 sources

                            if (coord == null && msg.getSrc().preferredForCoordinator()) {
                                coord = msg.getSrc();
                            }
                        }
                        if (Discovery.trace) {
                            if (coord != null) {
                                this.log.trace("using " + (coord.equals(this.local_addr) != false ? "myself" : coord.toString()) + " as coordinator response to GET_MBRS_REQ");
                            } else {
                                this.log.trace("unable to determine a potential coordinator in response to GET_MBRS_REQ");
                            }
                        }
                        if (coord == null) break block2;
                        ping_rsp = new PingRsp(this.local_addr, coord, this.is_server);
                        rsp_msg = new Message(msg.getSrc(), null, null);
                        rsp_hdr = new PingHeader(2, ping_rsp);
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (Discovery.trace) {
                            this.log.trace("received GET_MBRS_REQ from " + msg.getSrc() + ", sending response " + rsp_hdr);
                        }
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        rsp = hdr.arg;
                        if (Discovery.trace) {
                            this.log.trace("received GET_MBRS_RSP, rsp=" + rsp);
                        }
                        this.ping_waiter.addResponse(rsp);
                        return;
                    }
                    default: {
                        if (this.warn) {
                            this.log.warn(JGroupsStrings.Discovery_GOT_PING_HEADER_WITH_UNKNOWN_TYPE_0.toLocalizedString(new Object[]{new Byte(hdr.type)}));
                        }
                        return;
                    }
                }
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                this.localAddressSet(this.local_addr);
                break;
            }
            case 3: {
                this.handleConnectOK();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                ++this.num_discovery_requests;
                if (this.ping_waiter == null) break;
                this.ping_waiter.start();
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                this.handleConnect();
                break;
            }
            case 4: {
                this.handleDisconnect();
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    protected View makeView(Vector mbrs) {
        ViewId view_id = new ViewId(this.local_addr);
        Address coord = view_id.getCoordAddress();
        long id = view_id.getId();
        return new View(coord, id, mbrs);
    }
}

