/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Util;
import java.util.Properties;

public class DELAY
extends Protocol {
    int in_delay = 0;
    int out_delay = 0;

    @Override
    public String getName() {
        return "DELAY";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("in_delay");
        if (str != null) {
            this.in_delay = Integer.parseInt(str);
            props.remove("in_delay");
        }
        if ((str = props.getProperty("out_delay")) != null) {
            this.out_delay = Integer.parseInt(str);
            props.remove("out_delay");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.DELAY_DELAYSETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void up(Event evt) {
        int delay = this.in_delay > 0 ? DELAY.computeDelay(this.in_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.DELAY_DELAYING_INCOMING_MESSAGE_FOR__0__MILLISECONDS, delay);
                }
                try {
                    Util.sleep(delay);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        int delay = this.out_delay > 0 ? DELAY.computeDelay(this.out_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.DELAY_DELAYING_OUTGOING_MESSAGE_FOR__0__MILLISECONDS, delay);
                }
                try {
                    Util.sleep(delay);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.passDown(evt);
    }

    static int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }
}

