/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.TransportedVectorTime;
import com.gemstone.org.jgroups.protocols.VectorTime;
import com.gemstone.org.jgroups.stack.Protocol;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class CAUSAL
extends Protocol {
    private VectorTime localVector;
    private LinkedList delayQueue;
    private Address localAddress;

    private void addToDelayQueue(TransportedVectorTime tvt) {
        ListIterator i = this.delayQueue.listIterator(0);
        TransportedVectorTime current = null;
        while (i.hasNext()) {
            current = (TransportedVectorTime)i.next();
            if (!tvt.lessThanOrEqual(current)) continue;
            this.delayQueue.add(i.previousIndex(), tvt);
            return;
        }
        this.delayQueue.add(tvt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                Message causalMsg = new Message(msg.getDest(), msg.getSrc(), msg);
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    this.localVector.increment();
                    causalMsg.putHeader(this.getName(), new CausalHeader(this.localVector.getTransportedVectorTime()));
                }
                this.passDown(new Event(1, causalMsg));
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.localVector = new VectorTime(this.localAddress);
                this.delayQueue = new LinkedList();
                break;
            }
            case 6: {
                Vector newViewMembers = ((View)evt.getArg()).getMembers();
                this.localVector.merge((Vector)newViewMembers.clone());
                this.localVector.reset();
                break;
            }
            case 1: {
                Object obj = null;
                Message msg = (Message)evt.getArg();
                obj = msg.getHeader(this.getName());
                if (!(obj instanceof CausalHeader)) {
                    if ((msg.getDest() == null || msg.getDest().isMulticastAddress()) && this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.CAUSAL_NO_CAUSALHEADER_FOUND);
                    }
                    this.passUp(evt);
                    return;
                }
                CausalHeader header = obj;
                TransportedVectorTime messageVector = header.getVectorTime();
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    if (this.localVector.isCausallyNext(messageVector)) {
                        Message tmp = (Message)msg.getObject();
                        tmp.setSrc(msg.getSrc());
                        this.passUp(new Event(1, tmp));
                        this.localVector.max(messageVector);
                    } else {
                        messageVector.setAssociatedMessage(msg);
                        this.addToDelayQueue(messageVector);
                    }
                    TransportedVectorTime queuedVector = null;
                    while (this.delayQueue.size() > 0 && this.localVector.isCausallyNext(queuedVector = (TransportedVectorTime)this.delayQueue.getFirst())) {
                        this.delayQueue.remove(queuedVector);
                        Object tmp = queuedVector.getAssociatedMessage().getObject();
                        this.passUp(new Event(1, tmp));
                        this.localVector.max(queuedVector);
                    }
                    return;
                }
            }
        }
        this.passUp(evt);
    }

    @Override
    public String getName() {
        return "CAUSAL";
    }

    public static class CausalHeader
    extends Header {
        private TransportedVectorTime t;

        public CausalHeader() {
        }

        public CausalHeader(TransportedVectorTime timeVector) {
            this.t = timeVector;
        }

        public TransportedVectorTime getVectorTime() {
            return this.t;
        }

        @Override
        public long size(short version) {
            return 231 + this.t.size() * 4;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.t);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.t = (TransportedVectorTime)in.readObject();
        }

        @Override
        public String toString() {
            return "[CAUSALHEADER:" + this.t + ']';
        }
    }
}

