/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.util.Streamable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Properties;

public class AuthHeader
extends Header
implements Streamable {
    private static final long serialVersionUID = 1L;
    private byte[] credentials = null;
    public static final String USER_NAME = "security-username";
    public static final String PASSWORD = "security-password";

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        try {
            this.credentials = DataSerializer.readByteArray(in);
        }
        catch (Exception ex) {
            this.credentials = new byte[1];
        }
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.credentials == null) {
            this.credentials = new byte[1];
        }
        DataSerializer.writeByteArray(this.credentials, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.credentials = DataSerializer.readByteArray(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DataSerializer.writeByteArray(this.credentials, out);
    }

    public void setCredentials(Properties credentials) {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream(10000);
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            DataSerializer.writeProperties(credentials, oos);
            oos.flush();
            this.credentials = bas.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Properties getCredentials() {
        Properties retProp = new Properties();
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(this.credentials);
            ObjectInputStream ois = new ObjectInputStream(bas);
            retProp = DataSerializer.readProperties(ois);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retProp;
    }

    @Override
    public long size(short version) {
        return this.credentials == null ? 0L : (long)this.credentials.length;
    }

    @Override
    public String toString() {
        return "[AuthHeader : " + this.getCredentials() + "]";
    }
}

