/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.stack.Protocol;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;

public class AUTOCONF
extends Protocol {
    final HashMap config = new HashMap();
    static int num_iterations = 10;
    static int frag_overhead = 1000;

    @Override
    public String getName() {
        return "AUTOCONF";
    }

    @Override
    public void init() throws Exception {
        this.senseNetworkConfiguration();
        if (this.log.isDebugEnabled()) {
            this.log.debug("configuration is\n" + this.config);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.config != null && this.config.size() > 0) {
            Event config_evt = new Event(56, this.config);
            this.passDown(config_evt);
            this.passUp(config_evt);
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("num_iterations");
        if (str != null) {
            num_iterations = Integer.parseInt(str);
            props.remove("num_iterations");
        }
        if ((str = props.getProperty("frag_overhead")) != null) {
            frag_overhead = Integer.parseInt(str);
            props.remove("frag_overhead");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.AUTOCONF_AUTOCONFSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void startUpHandler() {
    }

    @Override
    public void startDownHandler() {
    }

    void senseNetworkConfiguration() {
        int max_frag_size = this.senseMaxFragSize();
        if (max_frag_size <= 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.AUTOCONF_MAX_FRAG_SIZE_IS_INVALID__0, max_frag_size);
            }
        } else {
            this.config.put("frag_size", max_frag_size);
        }
        this.senseMaxSendBufferSize(this.config);
        this.senseMaxReceiveBufferSize(this.config);
    }

    public static int senseMaxFragSizeStatic() {
        return new AUTOCONF().senseMaxFragSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int senseMaxFragSize() {
        InetAddress local_addr;
        DatagramSocket sock;
        int max_send = 32000;
        int lower = 0;
        int highest_failed = -1;
        try {
            sock = new DatagramSocket();
            local_addr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            if (this.warn) {
                this.log.warn("failed creating DatagramSocket: " + ex);
            }
            return 0;
        }
        try {
            int upper = max_send;
            for (int i = 0; i < num_iterations && lower < upper; ++i) {
                try {
                    byte[] buf = new byte[upper];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, local_addr, 9);
                    sock.send(packet);
                    lower = Math.max(lower, upper);
                    upper *= 2;
                    if (highest_failed <= -1) continue;
                    upper = Math.min(highest_failed, upper);
                    continue;
                }
                catch (IOException io_ex) {
                    highest_failed = highest_failed > -1 ? Math.min(highest_failed, upper) : upper;
                    upper = (upper + lower) / 2;
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (!this.warn) break;
                    this.log.warn("exception=" + ex);
                    break;
                }
            }
            lower -= frag_overhead;
            if (this.log.isDebugEnabled()) {
                this.log.debug("frag_size=" + lower);
            }
            int n = lower;
            return n;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void senseMaxSendBufferSize(HashMap map) {
        int max_size;
        int retval = max_size = 4096;
        if (map != null && map.containsKey("frag_size)")) {
            max_size = (Integer)map.get("frag_size");
        }
        try {
            DatagramSocket sock = new DatagramSocket();
            while (max_size < 1000000) {
                sock.setSendBufferSize(max_size);
                retval = sock.getSendBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error("failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
            }
        }
        finally {
            map.put("send_buf_size", retval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void senseMaxReceiveBufferSize(HashMap map) {
        int max_size;
        int retval = max_size = 4096;
        try {
            DatagramSocket sock = new DatagramSocket();
            while (max_size < 1000000) {
                sock.setReceiveBufferSize(max_size);
                retval = sock.getReceiveBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error("failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
            }
        }
        finally {
            map.put("recv_buf_size", retval);
        }
    }
}

