/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.AuthHeader;
import com.gemstone.org.jgroups.protocols.VIEW_SYNC;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.JoinRsp;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Streamable;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class AUTH
extends Protocol {
    public static final String name = "AUTH";
    private static final int JOIN_REQ_MSG = 1;
    private static final int VIEW_MSG = 2;
    private static final int VIEW_SYNC_MSG = 3;
    private static final int VIEW_CHANGE_EVT = 4;
    private static final int SET_LOCAL_ADDRESS_EVT = 5;
    Address local_addr = null;
    private final Object viewLock = new Object();
    private ViewId vid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        boolean isSecure;
        String authenticator = System.getProperty("gemfire.sys.security-peer-authenticator");
        boolean bl = isSecure = authenticator != null && authenticator.length() != 0;
        if (isSecure) {
            String failMsg = null;
            int hdrType = this.getHeaderType(evt);
            String msgType = null;
            Message msg = null;
            AuthHeader authHeader = null;
            switch (hdrType) {
                case 1: {
                    msgType = "JOIN_REQ";
                    msg = (Message)evt.getArg();
                    authHeader = (AuthHeader)msg.getHeader(name);
                    failMsg = this.verifyCredentials(authenticator, authHeader != null ? authHeader.getCredentials() : null, msg.getSrc(), msgType + " message");
                    break;
                }
                case 2: {
                    msgType = "VIEW";
                    msg = (Message)evt.getArg();
                    View gview = (View)msg.getObject();
                    Object object = this.viewLock;
                    synchronized (object) {
                        if (this.vid != null && this.vid.compareTo(gview.getVid()) >= 0) {
                            break;
                        }
                    }
                    authHeader = (AuthHeader)msg.getHeader(name);
                    failMsg = this.verifyCredentials(authenticator, authHeader != null ? authHeader.getCredentials() : null, msg.getSrc(), msgType + " message");
                    break;
                }
                case 3: {
                    msgType = "VIEW_SYNC";
                    msg = (Message)evt.getArg();
                    View v = (View)msg.getObject();
                    Object object = this.viewLock;
                    synchronized (object) {
                        if (this.vid != null && this.vid.compare(v.getVid()) >= 0) {
                            break;
                        }
                    }
                    authHeader = (AuthHeader)msg.getHeader(name);
                    failMsg = this.verifyCredentials(authenticator, authHeader != null ? authHeader.getCredentials() : null, msg.getSrc(), msgType + " message");
                    break;
                }
                case 4: {
                    Object object = this.viewLock;
                    synchronized (object) {
                        View newView = (View)evt.getArg();
                        this.vid = newView.getVid();
                        Properties credentials = (Properties)newView.getAdditionalData();
                        failMsg = credentials == null ? JGroupsStrings.AUTH_MISSING_CREDENTIALS_IN_MEMBERSHIP_VIEW_CHANGE.toLocalizedString() : this.verifyCredentials(authenticator, credentials, newView.getCreator(), "VIEW_CHANGE event");
                        break;
                    }
                }
                case 5: {
                    this.local_addr = (Address)evt.getArg();
                }
            }
            if (failMsg == null) {
                this.passUp(evt);
            } else {
                this.passDown(this.getFailureEvent(evt, failMsg, hdrType));
            }
        } else {
            this.passUp(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        boolean isSecure;
        String authInit = System.getProperty("gemfire.sys.security-peer-auth-init");
        boolean bl = isSecure = authInit != null && authInit.length() != 0;
        if (isSecure) {
            int hdrType = this.getHeaderType(evt);
            InternalLogWriter securityLogger = this.log.getSecurityInternalLogWriter();
            String msgType = null;
            switch (hdrType) {
                case 1: {
                    msgType = "JOIN_REQ";
                }
                case 2: {
                    if (msgType == null) {
                        msgType = "VIEW";
                    }
                }
                case 3: {
                    Message msg;
                    if (msgType == null) {
                        msgType = "VIEW_SYNC";
                    }
                    Assert.assertTrue((msg = (Message)evt.getArg()) != null);
                    AuthHeader authHeader = new AuthHeader();
                    Properties credentials = this.getCredentials(authInit, msg.getDest(), msgType + " message");
                    if (credentials == null) break;
                    try {
                        authHeader.setCredentials(credentials);
                    }
                    catch (IllegalArgumentException e) {
                        securityLogger.severe(JGroupsStrings.AUTH_SECURITY_CREDENTIALS_ARE_TOO_LARGE_TO_TRANSMIT_0, (Throwable)e);
                    }
                    msg.putHeader(name, authHeader);
                    break;
                }
                case 4: {
                    Object object = this.viewLock;
                    synchronized (object) {
                        View v = (View)evt.getArg();
                        this.vid = v.getVid();
                        Properties credentials = this.getCredentials(authInit, v.getVid().getCoordAddress(), "VIEW_CHANGE message");
                        try {
                            v.setAdditionalData(credentials);
                        }
                        catch (IllegalArgumentException e) {
                            securityLogger.severe(JGroupsStrings.AUTH_CREDENTIALS_TOO_LARGE_TO_TRANSMIT_0, e.getLocalizedMessage());
                        }
                        break;
                    }
                }
            }
        }
        this.passDown(evt);
    }

    @Override
    public final String getName() {
        return name;
    }

    private Properties getSecurityProperties() {
        Properties props = (Properties)System.getProperties().clone();
        Properties securityProps = new Properties();
        String secPrefix = "gemfire.sys.security-";
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            String propKey = (String)propEntry.getKey();
            if (!propKey.startsWith("gemfire.sys.security-")) continue;
            securityProps.setProperty(propKey.substring("gemfire.sys.".length()), (String)propEntry.getValue());
        }
        return securityProps;
    }

    private Properties getCredentials(String authInitMethod, Address dest, String eventStr) {
        Properties credentials = null;
        Properties secProps = this.getSecurityProperties();
        InternalLogWriter securityLogWriter = this.log.getSecurityInternalLogWriter();
        try {
            credentials = HandShake.getCredentials(authInitMethod, secProps, this.createDistributedMember(dest), true, this.log.getInternalLogWriter(), securityLogWriter);
        }
        catch (Exception ex) {
            securityLogWriter.warning(JGroupsStrings.AUTH_FAILED_TO_OBTAIN_CREDENTIALS_IN_0_USING_AUTHINITIALIZE_1_2, new Object[]{eventStr, authInitMethod, ex.getLocalizedMessage()});
        }
        return credentials;
    }

    private String verifyCredentials(String authenticator, Properties credentials, Address src, String eventStr) {
        String failMsg = null;
        InternalLogWriter securityLogWriter = this.log.getSecurityInternalLogWriter();
        if (credentials != null) {
            try {
                DistributedMember id = this.createDistributedMember(src);
                if (id != null) {
                    HandShake.verifyCredentials(authenticator, credentials, this.getSecurityProperties(), this.log.getInternalLogWriter(), securityLogWriter, id);
                }
            }
            catch (Exception ex) {
                securityLogWriter.warning(JGroupsStrings.AUTH_AUTHENTICATION_FAILED_FOR_0_FROM_1_USING_AUTHENTICATOR_2_3, new Object[]{eventStr, src, authenticator, ex.getLocalizedMessage()}, (Throwable)ex);
                failMsg = JGroupsStrings.AUTH_AUTHENTICATION_FAILED_FOR_0_SEE_COORDINATOR_1_LOGS_FOR_DETAILS.toLocalizedString(eventStr, this.local_addr);
            }
        } else {
            securityLogWriter.warning(JGroupsStrings.AUTH_FAILED_TO_FIND_CREDENTIALS_IN_0_FROM_1_USING_AUTHENTICATOR_2, new Object[]{eventStr, src, authenticator});
            failMsg = JGroupsStrings.AUTH_FAILED_TO_FIND_CREDENTIALS_IN_0_SEE_COORDINATOR_1_LOGS_FOR_DETAILS.toLocalizedString(eventStr, this.local_addr);
        }
        return failMsg;
    }

    private int getHeaderType(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                VIEW_SYNC.ViewSyncHeader vsyncHdr = (VIEW_SYNC.ViewSyncHeader)msg.getHeader("VIEW_SYNC");
                if (vsyncHdr != null && vsyncHdr.type == 1) {
                    return 3;
                }
                GMS.GmsHeader gmsHdr = (GMS.GmsHeader)msg.getHeader("GMS");
                if (gmsHdr == null) {
                    return -1;
                }
                switch (gmsHdr.getType()) {
                    case 1: {
                        return 1;
                    }
                    case 5: {
                        return 2;
                    }
                }
                return -1;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return -1;
    }

    private DistributedMember createDistributedMember(Address addr) {
        if (addr == null || addr == this.local_addr) {
            return null;
        }
        IpAddress ipAddr = (IpAddress)addr;
        InternalDistributedMember member = this.stack.jgmm.getMemberFromIpAddress(ipAddr, false);
        if (member == null) {
            JGroupMember jgm = new JGroupMember(ipAddr);
            member = new InternalDistributedMember(jgm);
        }
        return member;
    }

    private Event getFailureEvent(Event evt, String message, int hdrType) {
        Address src = null;
        GMS.GmsHeader gmsHeader = null;
        Streamable messagePayload = null;
        InternalLogWriter securityLogger = this.log.getSecurityInternalLogWriter();
        switch (hdrType) {
            case 1: {
                messagePayload = new JoinRsp(message);
                gmsHeader = new GMS.GmsHeader(2);
                src = ((Message)evt.getArg()).getSrc();
                break;
            }
            case 2: 
            case 3: {
                Message recvMsg = (Message)evt.getArg();
                View recvView = (View)recvMsg.getObject();
                try {
                    recvView.setAdditionalData(message);
                }
                catch (IllegalArgumentException e) {
                    securityLogger.severe(JGroupsStrings.AUTH_CREDENTIALS_TOO_LARGE_TO_TRANSMIT_0, e.getLocalizedMessage());
                }
                gmsHeader = new GMS.GmsHeader(10);
                messagePayload = recvView;
                src = recvMsg.getSrc();
                break;
            }
            case 4: {
                View recvView = (View)evt.getArg();
                recvView.setAdditionalData(message);
                gmsHeader = new GMS.GmsHeader(10);
                messagePayload = recvView;
                src = recvView.getCreator();
            }
        }
        Message msg = new Message(src, this.local_addr, null);
        msg.putHeader("GMS", gmsHeader);
        msg.setObject((Serializable)((Object)messagePayload));
        return new Event(1, msg);
    }
}

