/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.persistence;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.persistence.DBPersistenceManager;
import com.gemstone.org.jgroups.persistence.FilePersistenceManager;
import com.gemstone.org.jgroups.persistence.PersistenceManager;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;

@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GemFire doesn't use this class")
public class PersistenceFactory {
    protected static final GemFireTracer log = GemFireTracer.getLog(PersistenceFactory.class);
    private static PersistenceManager _manager = null;
    private static PersistenceFactory _factory = null;
    static final String propPath = "persist.properties";
    static final String persistProp = "persist";
    static final String filePersistMgr = "filePersistMgr";

    private PersistenceFactory() {
    }

    public static PersistenceFactory getInstance() {
        log.error(JGroupsStrings.PersistenceFactory_GETTING_FACTORY_INSTANCE);
        if (_factory == null) {
            _factory = new PersistenceFactory();
        }
        return _factory;
    }

    public synchronized void registerManager(PersistenceManager manager) {
        _manager = manager;
    }

    public synchronized PersistenceManager createManager() throws Exception {
        if (_manager == null) {
            _manager = this.checkDB() ? this.createManagerDB(propPath) : this.createManagerFile(propPath);
        }
        return _manager;
    }

    public synchronized PersistenceManager createManager(String filePath) throws Exception {
        if (_manager == null) {
            _manager = this.checkDB(filePath) ? this.createManagerDB(filePath) : this.createManagerFile(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerDB(String filePath) throws Exception {
        if (log.isInfoEnabled()) {
            log.info(JGroupsStrings.PersistenceFactory_CALLING_DB_PERSIST_FROM_FACTORY__0, filePath);
        }
        if (_manager == null) {
            _manager = new DBPersistenceManager(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerFile(String filePath) {
        if (log.isInfoEnabled()) {
            log.info(JGroupsStrings.PersistenceFactory_CREATING_FILE_MANAGER__0, filePath);
        }
        try {
            if (_manager == null) {
                Properties props = this.readProps(filePath);
                String classname = props.getProperty(filePersistMgr);
                if (classname != null) {
                    Class cl = Util.loadClass(classname, this.getClass());
                    Constructor ctor = cl.getConstructor(String.class);
                    _manager = (PersistenceManager)ctor.newInstance(filePath);
                } else {
                    _manager = new FilePersistenceManager(filePath);
                }
            }
            return _manager;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            return null;
        }
    }

    private boolean checkDB() throws Exception {
        Properties props = this.readProps(propPath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    private boolean checkDB(String filePath) throws Exception {
        Properties props = this.readProps(filePath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    Properties readProps(String fileName) throws IOException {
        FileInputStream _stream = new FileInputStream(fileName);
        Properties props = new Properties();
        props.load(_stream);
        return props;
    }
}

