/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.persistence;

import com.gemstone.org.jgroups.persistence.CannotPersistException;
import com.gemstone.org.jgroups.persistence.CannotRemoveException;
import com.gemstone.org.jgroups.persistence.CannotRetrieveException;
import com.gemstone.org.jgroups.persistence.PersistenceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FilePersistenceManager
implements PersistenceManager {
    private final File file;

    public FilePersistenceManager(String propertiesFilename) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFilename));
        String path = properties.getProperty("persist");
        this.file = new File(path);
        if (!this.file.createNewFile()) {
            throw new IOException("Unable to create file " + this.file.getAbsolutePath());
        }
    }

    @Override
    public void save(Serializable key2, Serializable val) throws CannotPersistException {
        try {
            Map map = this.retrieveAll();
            map.put(key2, val);
            this.saveAll(map);
        }
        catch (CannotRetrieveException e) {
            throw new CannotPersistException(e, "Unable to pre-load existing store.");
        }
    }

    @Override
    public Serializable remove(Serializable key2) throws CannotRemoveException {
        Object o;
        try {
            Map map = this.retrieveAll();
            o = map.remove(key2);
            this.saveAll(map);
        }
        catch (CannotRetrieveException e) {
            throw new CannotRemoveException(e, "Unable to pre-load existing store.");
        }
        catch (CannotPersistException e) {
            throw new CannotRemoveException(e, "Unable to pre-load existing store.");
        }
        return (Serializable)o;
    }

    @Override
    public void saveAll(Map map) throws CannotPersistException {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            Properties prop = new Properties();
            for (Map.Entry entry : map.entrySet()) {
                prop.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            prop.store(fos, null);
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            throw new CannotPersistException(e, "Cannot save to: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public Map retrieveAll() throws CannotRetrieveException {
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(this.file);
            prop.load(fis);
            fis.close();
            return this.filterLoadedValues(prop);
        }
        catch (IOException e) {
            throw new CannotRetrieveException(e, "Unable to load from file: " + this.file.getAbsolutePath());
        }
    }

    protected Map filterLoadedValues(Map in) {
        HashMap<String, Float> out = new HashMap<String, Float>();
        for (Map.Entry entry : in.entrySet()) {
            out.put(entry.getKey().toString(), Float.valueOf(entry.getValue().toString()));
        }
        return out;
    }

    @Override
    public void clear() throws CannotRemoveException {
        try {
            this.saveAll(Collections.EMPTY_MAP);
        }
        catch (CannotPersistException e) {
            throw new CannotRemoveException(e, "Unable to clear map.");
        }
    }

    @Override
    public void shutDown() {
    }
}

