/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import com.gemstone.org.jgroups.oswego.concurrent.Barrier;
import com.gemstone.org.jgroups.oswego.concurrent.BrokenBarrierException;
import com.gemstone.org.jgroups.oswego.concurrent.Semaphore;
import com.gemstone.org.jgroups.oswego.concurrent.TimeoutException;
import com.gemstone.org.jgroups.oswego.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int parties) {
        this(parties, new Rotator());
    }

    public Rendezvous(int parties, RendezvousFunction function) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = parties;
        this.rendezvousFunction_ = function;
        this.entryGate_ = new WaiterPreferenceSemaphore(parties);
        this.slots_ = new Object[parties];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction function) {
        RendezvousFunction old = this.rendezvousFunction_;
        this.rendezvousFunction_ = function;
        return old;
    }

    @Override
    public int parties() {
        return this.parties_;
    }

    @Override
    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object x) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(x, false, 0L);
    }

    public Object attemptRendezvous(Object x, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(x, true, msecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object x, boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long startTime;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (timed) {
            startTime = System.currentTimeMillis();
            if (!this.entryGate_.attempt(msecs)) {
                throw new TimeoutException(msecs);
            }
        } else {
            startTime = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            int index2;
            Object y;
            block22: {
                block21: {
                    y = null;
                    index2 = this.entries_++;
                    this.slots_[index2] = x;
                    try {
                        if (this.entries_ != this.parties_) break block21;
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        try {
                            if (!this.broken_ && this.rendezvousFunction_ != null) {
                                this.rendezvousFunction_.rendezvousFunction(this.slots_);
                            }
                            break block22;
                        }
                        catch (RuntimeException ex) {
                            this.broken_ = true;
                        }
                        break block22;
                    }
                    catch (Throwable throwable) {
                        y = this.slots_[index2];
                        if (--this.departures_ <= 0L) {
                            for (int i = 0; i < this.slots_.length; ++i) {
                                this.slots_[i] = null;
                            }
                            this.entryGate_.release(this.entries_);
                            this.entries_ = 0;
                        }
                        throw throwable;
                    }
                }
                while (!this.broken_ && this.departures_ < 1L) {
                    long timeLeft = 0L;
                    if (timed && (timeLeft = msecs - (System.currentTimeMillis() - startTime)) <= 0L) {
                        this.broken_ = true;
                        this.departures_ = this.entries_;
                        this.notifyAll();
                        throw new TimeoutException(msecs);
                    }
                    try {
                        this.wait(timeLeft);
                    }
                    catch (InterruptedException ex) {
                        if (!this.broken_ && this.departures_ <= 0L) {
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw ex;
                        }
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            y = this.slots_[index2];
            if (--this.departures_ <= 0L) {
                for (int i = 0; i < this.slots_.length; ++i) {
                    this.slots_[i] = null;
                }
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(index2);
            }
            return y;
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        @Override
        public void rendezvousFunction(Object[] objects) {
            int lastIdx = objects.length - 1;
            Object first = objects[0];
            for (int i = 0; i < lastIdx; ++i) {
                objects[i] = objects[i + 1];
            }
            objects[lastIdx] = first;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

