/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import com.gemstone.org.jgroups.oswego.concurrent.FIFOSemaphore;
import com.gemstone.org.jgroups.oswego.concurrent.ReadWriteLock;
import com.gemstone.org.jgroups.oswego.concurrent.Sync;

public class FIFOReadWriteLock
implements ReadWriteLock {
    protected final FIFOSemaphore entryLock = new FIFOSemaphore(1L);
    protected volatile int readers;
    protected int exreaders;
    protected final Sync readerSync = new ReaderSync();
    protected final Sync writerSync = new WriterSync();

    protected void acquireRead() throws InterruptedException {
        this.entryLock.acquire();
        ++this.readers;
        this.entryLock.release();
    }

    protected synchronized void releaseRead() {
        if (++this.exreaders == this.readers) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireWrite() throws InterruptedException {
        this.entryLock.acquire();
        int r = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                while (this.exreaders != r) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            this.entryLock.release();
            throw ie;
        }
    }

    protected void releaseWrite() {
        this.entryLock.release();
    }

    protected boolean attemptRead(long msecs) throws InterruptedException {
        if (!this.entryLock.attempt(msecs)) {
            return false;
        }
        ++this.readers;
        this.entryLock.release();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attemptWrite(long msecs) throws InterruptedException {
        long startTime;
        long l = startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        if (!this.entryLock.attempt(msecs)) {
            return false;
        }
        int r = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                while (this.exreaders != r) {
                    long timeLeft;
                    long l2 = timeLeft = msecs <= 0L ? 0L : msecs - (System.currentTimeMillis() - startTime);
                    if (timeLeft <= 0L) {
                        this.entryLock.release();
                        return false;
                    }
                    this.wait(timeLeft);
                }
                return true;
            }
        }
        catch (InterruptedException ie) {
            this.entryLock.release();
            throw ie;
        }
    }

    @Override
    public Sync writeLock() {
        return this.writerSync;
    }

    @Override
    public Sync readLock() {
        return this.readerSync;
    }

    protected class WriterSync
    implements Sync {
        protected WriterSync() {
        }

        @Override
        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireWrite();
        }

        @Override
        public void release() {
            FIFOReadWriteLock.this.releaseWrite();
        }

        @Override
        public boolean attempt(long msecs) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptWrite(msecs);
        }
    }

    protected class ReaderSync
    implements Sync {
        protected ReaderSync() {
        }

        @Override
        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireRead();
        }

        @Override
        public void release() {
            FIFOReadWriteLock.this.releaseRead();
        }

        @Override
        public boolean attempt(long msecs) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptRead(msecs);
        }
    }
}

