/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CopyOnWriteArrayList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2838422045950507577L;
    protected transient Object[] array_;

    protected synchronized Object[] array() {
        return this.array_;
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection c) {
        this.array_ = new Object[c.size()];
        Iterator i = c.iterator();
        int size2 = 0;
        while (i.hasNext()) {
            this.array_[size2++] = i.next();
        }
    }

    public CopyOnWriteArrayList(Object[] toCopyIn) {
        this.copyIn(toCopyIn, 0, toCopyIn.length);
    }

    public synchronized void copyIn(Object[] toCopyIn, int first, int n) {
        this.array_ = new Object[n];
        System.arraycopy(toCopyIn, first, this.array_, 0, n);
    }

    @Override
    public int size() {
        return this.array().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object elem) {
        int len;
        Object[] elementData = this.array();
        return CopyOnWriteArrayList.indexOf(elem, elementData, len = elementData.length) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.indexOf(elem, elementData, len);
    }

    protected static int indexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = 0; i < len; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object elem, int index2) {
        Object[] elementData = this.array();
        int elementCount = elementData.length;
        if (elem == null) {
            for (int i = index2; i < elementCount; ++i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index2; i < elementCount; ++i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        Object[] elementData = this.array();
        int len = elementData.length;
        return CopyOnWriteArrayList.lastIndexOf(elem, elementData, len);
    }

    protected static int lastIndexOf(Object elem, Object[] elementData, int len) {
        if (elem == null) {
            for (int i = len - 1; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem, int index2) {
        Object[] elementData = this.array();
        if (elem == null) {
            for (int i = index2; i >= 0; --i) {
                if (elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index2; i >= 0; --i) {
                if (!elem.equals(elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] elementData = this.array();
            CopyOnWriteArrayList v = (CopyOnWriteArrayList)super.clone();
            v.array_ = new Object[elementData.length];
            System.arraycopy(elementData, 0, v.array_, 0, elementData.length);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] elementData = this.array();
        Object[] result = new Object[elementData.length];
        System.arraycopy(elementData, 0, result, 0, elementData.length);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] elementData = this.array();
        if (a.length < elementData.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), elementData.length);
        }
        System.arraycopy(elementData, 0, a, 0, elementData.length);
        if (a.length > elementData.length) {
            a[elementData.length] = null;
        }
        return a;
    }

    public Object get(int index2) {
        Object[] elementData = this.array();
        this.rangeCheck(index2, elementData.length);
        return elementData[index2];
    }

    public synchronized Object set(int index2, Object element) {
        boolean same;
        int len = this.array_.length;
        this.rangeCheck(index2, len);
        Object oldValue = this.array_[index2];
        boolean bl = same = oldValue == element || element != null && element.equals(oldValue);
        if (!same) {
            Object[] newArray = new Object[len];
            System.arraycopy(this.array_, 0, newArray, 0, len);
            newArray[index2] = element;
            this.array_ = newArray;
        }
        return oldValue;
    }

    @Override
    public synchronized boolean add(Object element) {
        int len = this.array_.length;
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        newArray[len] = element;
        this.array_ = newArray;
        return true;
    }

    public synchronized void add(int index2, Object element) {
        int len = this.array_.length;
        if (index2 > len || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        Object[] newArray = new Object[len + 1];
        System.arraycopy(this.array_, 0, newArray, 0, index2);
        newArray[index2] = element;
        System.arraycopy(this.array_, index2, newArray, index2 + 1, len - index2);
        this.array_ = newArray;
    }

    public synchronized Object remove(int index2) {
        int len = this.array_.length;
        this.rangeCheck(index2, len);
        Object oldValue = this.array_[index2];
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.array_, 0, newArray, 0, index2);
        int numMoved = len - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array_, index2 + 1, newArray, index2, numMoved);
        }
        this.array_ = newArray;
        return oldValue;
    }

    @Override
    public synchronized boolean remove(Object element) {
        int len = this.array_.length;
        if (len == 0) {
            return false;
        }
        int newlen = len - 1;
        Object[] newArray = new Object[newlen];
        for (int i = 0; i < newlen; ++i) {
            if (element == this.array_[i] || element != null && element.equals(this.array_[i])) {
                for (int k = i + 1; k < len; ++k) {
                    newArray[k - 1] = this.array_[k];
                }
                this.array_ = newArray;
                return true;
            }
            newArray[i] = this.array_[i];
        }
        if (element == this.array_[newlen] || element != null && element.equals(this.array_[newlen])) {
            this.array_ = newArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int fromIndex, int toIndex) {
        int len = this.array_.length;
        if (fromIndex < 0 || fromIndex >= len || toIndex > len || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        int numMoved = len - toIndex;
        int newlen = len - (toIndex - fromIndex);
        Object[] newArray = new Object[newlen];
        System.arraycopy(this.array_, 0, newArray, 0, fromIndex);
        System.arraycopy(this.array_, toIndex, newArray, fromIndex, numMoved);
        this.array_ = newArray;
    }

    public synchronized boolean addIfAbsent(Object element) {
        int len = this.array_.length;
        Object[] newArray = new Object[len + 1];
        for (int i = 0; i < len; ++i) {
            if (element == this.array_[i] || element != null && element.equals(this.array_[i])) {
                return false;
            }
            newArray[i] = this.array_[i];
        }
        newArray[len] = element;
        this.array_ = newArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection c) {
        Object[] elementData = this.array();
        int len = elementData.length;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(e.next(), elementData, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        Object[] elementData = this.array_;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array_ = newArray;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        Object[] elementData = this.array_;
        int len = elementData.length;
        if (len == 0) {
            return false;
        }
        Object[] temp = new Object[len];
        int newlen = 0;
        for (int i = 0; i < len; ++i) {
            Object element = elementData[i];
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return false;
        }
        Object[] newArray = new Object[newlen];
        System.arraycopy(temp, 0, newArray, 0, newlen);
        this.array_ = newArray;
        return true;
    }

    public synchronized int addAllAbsent(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return 0;
        }
        Object[] elementData = this.array_;
        int len = elementData.length;
        Object[] temp = new Object[numNew];
        int added = 0;
        for (Object element : c) {
            if (CopyOnWriteArrayList.indexOf(element, elementData, len) >= 0 || CopyOnWriteArrayList.indexOf(element, temp, added) >= 0) continue;
            temp[added++] = element;
        }
        if (added == 0) {
            return 0;
        }
        Object[] newArray = new Object[len + added];
        System.arraycopy(elementData, 0, newArray, 0, len);
        System.arraycopy(temp, 0, newArray, len, added);
        this.array_ = newArray;
        return added;
    }

    @Override
    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        int len = this.array_.length;
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            newArray[len++] = e.next();
        }
        this.array_ = newArray;
        return true;
    }

    public synchronized boolean addAll(int index2, Collection c) {
        int len = this.array_.length;
        if (index2 > len || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        Object[] newArray = new Object[len + numNew];
        System.arraycopy(this.array_, 0, newArray, 0, len);
        int numMoved = len - index2;
        if (numMoved > 0) {
            System.arraycopy(this.array_, index2, newArray, index2 + numNew, numMoved);
        }
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            newArray[index2++] = e.next();
        }
        this.array_ = newArray;
        return true;
    }

    protected void rangeCheck(int index2, int length) {
        if (index2 >= length || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + length);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elementData = this.array();
        s.writeInt(elementData.length);
        for (int i = 0; i < elementData.length; ++i) {
            s.writeObject(elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        Object[] elementData = new Object[arrayLength];
        for (int i = 0; i < elementData.length; ++i) {
            elementData[i] = s.readObject();
        }
        this.array_ = elementData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(e.next()));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l2 = (List)o;
        if (this.size() != l2.size()) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = l2.listIterator();
        while (e1.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int index2) {
        Object[] elementData = this.array();
        int len = elementData.length;
        if (index2 < 0 || index2 > len) {
            throw new IndexOutOfBoundsException("Index: " + index2);
        }
        return new COWIterator(this.array(), index2);
    }

    public synchronized List subList(int fromIndex, int toIndex) {
        int len = this.array_.length;
        if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, fromIndex, toIndex);
    }

    protected static class COWSubList
    extends AbstractList {
        protected final CopyOnWriteArrayList l;
        protected final int offset;
        protected int size;
        protected Object[] expectedArray;

        protected COWSubList(CopyOnWriteArrayList list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.array();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int index2) {
            if (index2 < 0 || index2 >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object set(int index2, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index2);
                this.checkForComodification();
                Object x = this.l.set(index2 + this.offset, element);
                this.expectedArray = this.l.array_;
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(int index2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index2);
                this.checkForComodification();
                return this.l.get(index2 + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index2, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index2 < 0 || index2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(index2 + this.offset, element);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object remove(int index2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(index2);
                this.checkForComodification();
                Object result = this.l.remove(index2 + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator listIterator(int index2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (index2 < 0 || index2 > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
                }
                return new COWSubListIterator(index2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List subList(int fromIndex, int toIndex) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, fromIndex + this.offset, toIndex + this.offset);
            }
        }

        protected class COWSubListIterator
        implements ListIterator {
            protected final ListIterator i;
            protected final int index;

            protected COWSubListIterator(int index2) {
                this.index = index2;
                this.i = COWSubList.this.l.listIterator(index2 + COWSubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        protected COWIterator(Object[] elementArray, int initialCursor) {
            this.array = elementArray;
            this.cursor = initialCursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

