/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import com.gemstone.org.jgroups.oswego.concurrent.Sync;

public class CondVar {
    protected final Sync mutex_;

    public CondVar(Sync mutex) {
        this.mutex_ = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                return;
            }
        }
        finally {
            while (true) {
                boolean interrupted = Thread.interrupted();
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean timedwait(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    if (msecs <= 0L) return success;
                    long start = System.currentTimeMillis();
                    this.wait(msecs);
                    success = System.currentTimeMillis() - start <= msecs;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                return success;
            }
        }
        finally {
            while (true) {
                boolean interrupted = Thread.interrupted();
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

