/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.debug;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import java.util.HashMap;
import java.util.Iterator;

public class Simulator {
    private Protocol[] protStack = null;
    private ProtocolAdapter ad = new ProtocolAdapter();
    ProtocolStack prot_stack = null;
    protected Receiver r = null;
    protected Protocol top = null;
    protected Protocol bottom = null;
    protected Queue send_queue = new Queue();
    protected Thread send_thread;
    protected Queue recv_queue = new Queue();
    protected Thread recv_thread;
    protected final HashMap addrTable = new HashMap();
    protected Address local_addr = null;
    private View view;

    public void setProtocolStack(Protocol[] stack) {
        this.protStack = stack;
        this.protStack[0].setUpProtocol(this.ad);
        this.protStack[this.protStack.length - 1].setDownProtocol(this.ad);
        this.top = this.protStack[0];
        this.bottom = this.protStack[this.protStack.length - 1];
        this.prot_stack = new ProtocolStack();
        if (this.protStack.length > 1) {
            for (int i = 0; i < this.protStack.length; ++i) {
                Protocol p2;
                Protocol p1 = this.protStack[i];
                p1.setProtocolStack(this.prot_stack);
                Protocol protocol = p2 = i + 1 >= this.protStack.length ? null : this.protStack[i + 1];
                if (p2 == null) continue;
                p1.setDownProtocol(p2);
                p2.setUpProtocol(p1);
            }
        }
    }

    public String dumpStats() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.protStack.length; ++i) {
            Protocol p1 = this.protStack[i];
            sb.append(p1.getName()).append(":\n").append(p1.dumpStats()).append("\n");
        }
        return sb.toString();
    }

    public void addMember(Address addr) {
        this.addMember(addr, this);
    }

    public void addMember(Address addr, Simulator s) {
        this.addrTable.put(addr, s);
    }

    public void setLocalAddress(Address addr) {
        this.local_addr = addr;
    }

    public void setView(View v) {
        this.view = v;
    }

    public void setReceiver(Receiver r) {
        this.r = r;
    }

    public void send(Event evt) {
        this.top.down(evt);
    }

    public void receive(Event evt) {
        try {
            Event copy = evt.getType() == 1 && evt.getArg() != null ? new Event(1, ((Message)evt.getArg()).copy()) : evt;
            this.recv_queue.add(copy);
        }
        catch (QueueClosedException queueClosedException) {
            // empty catch block
        }
    }

    public synchronized void start() throws Exception {
        Protocol p;
        int i;
        if (this.local_addr == null) {
            throw new Exception("local_addr has to be non-null");
        }
        if (this.protStack == null) {
            throw new Exception("protocol stack is null");
        }
        this.bottom.up(new Event(8, this.local_addr));
        if (this.view != null) {
            Event view_evt = new Event(6, this.view);
            this.bottom.up(view_evt);
            this.top.down(view_evt);
        }
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.setProtocolStack(this.prot_stack);
        }
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.init();
        }
        for (i = 0; i < this.protStack.length; ++i) {
            p = this.protStack[i];
            p.start();
        }
        this.send_thread = new Thread(){

            @Override
            public void run() {
                block3: while (true) {
                    SystemFailure.checkFailure();
                    if (Thread.currentThread().isInterrupted()) break;
                    try {
                        Simulator s;
                        Event evt = (Event)Simulator.this.send_queue.remove();
                        if (evt.getType() != 1) continue;
                        Message msg = (Message)evt.getArg();
                        Address dst = msg.getDest();
                        if (msg.getSrc() == null) {
                            ((Message)evt.getArg()).setSrc(Simulator.this.local_addr);
                        }
                        if (dst == null) {
                            Iterator it = Simulator.this.addrTable.values().iterator();
                            while (true) {
                                if (!it.hasNext()) continue block3;
                                s = (Simulator)it.next();
                                s.receive(evt);
                            }
                        }
                        s = (Simulator)Simulator.this.addrTable.get(dst);
                        if (s == null) continue;
                        s.receive(evt);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    catch (QueueClosedException e) {
                        break;
                    }
                }
            }
        };
        this.send_thread.start();
        this.recv_thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    SystemFailure.checkFailure();
                    if (Thread.currentThread().isInterrupted()) break;
                    try {
                        Event evt = (Event)Simulator.this.recv_queue.remove();
                        Simulator.this.bottom.up(evt);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    catch (QueueClosedException e) {
                        break;
                    }
                }
            }
        };
        this.recv_thread.start();
    }

    public synchronized void stop() {
        if (this.recv_thread != null) {
            this.recv_thread.interrupt();
        }
        this.recv_thread = null;
        this.recv_queue.close(false);
        if (this.send_thread != null) {
            this.send_thread.interrupt();
        }
        this.send_thread = null;
        this.send_queue.close(false);
    }

    class ProtocolAdapter
    extends Protocol {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "ProtocolAdapter";
        }

        @Override
        public void up(Event evt) {
            if (Simulator.this.r != null) {
                Simulator.this.r.receive(evt);
            }
        }

        @Override
        public void down(Event evt) {
            try {
                Simulator.this.send_queue.add(evt);
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
        }
    }

    public static interface Receiver {
        public void receive(Event var1);
    }
}

