/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.conf;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.conf.ClassPathEntityResolver;
import com.gemstone.org.jgroups.conf.ProtocolData;
import com.gemstone.org.jgroups.conf.ProtocolParameter;
import com.gemstone.org.jgroups.conf.ProtocolStackConfigurator;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigurator
implements ProtocolStackConfigurator {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_INHERIT = "inherit";
    public static final String ELMT_PROT_OVERRIDE = "protocol-override";
    public static final String ELMT_PROT = "protocol";
    public static final String ELMT_PROT_NAME = "protocol-name";
    public static final String ELMT_CLASS = "class-name";
    public static final String ELMT_DESCRIPTION = "description";
    public static final String ELMT_PROT_PARAMS = "protocol-params";
    private final ArrayList mProtocolStack = new ArrayList();
    private final String mStackName;
    protected static final GemFireTracer log = GemFireTracer.getLog(XmlConfigurator.class);

    protected XmlConfigurator(String stackName, ProtocolData[] protocols) {
        this.mStackName = stackName;
        for (int i = 0; i < protocols.length; ++i) {
            this.mProtocolStack.add(protocols[i]);
        }
    }

    protected XmlConfigurator(String stackName) {
        this(stackName, new ProtocolData[0]);
    }

    public static XmlConfigurator getInstance(URL url) throws IOException {
        return XmlConfigurator.getInstance(url.openStream());
    }

    public static XmlConfigurator getInstanceOldFormat(URL url) throws IOException {
        return XmlConfigurator.getInstanceOldFormat(url.openStream());
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public static XmlConfigurator getInstanceOldFormat(InputStream stream) throws IOException {
        return XmlConfigurator.parseOldFormat(stream);
    }

    public static XmlConfigurator getInstance(Element el) throws IOException {
        return XmlConfigurator.parse(el);
    }

    public String getProtocolStackString(boolean convert) {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.mProtocolStack.iterator();
        if (convert) {
            buf.append("<config>\n");
        }
        while (it.hasNext()) {
            ProtocolData d = (ProtocolData)it.next();
            if (convert) {
                buf.append("    <");
            }
            buf.append(d.getProtocolString(convert));
            if (convert) {
                buf.append("/>");
            }
            if (!it.hasNext()) continue;
            if (convert) {
                buf.append('\n');
                continue;
            }
            buf.append(':');
        }
        if (convert) {
            buf.append("\n</config>");
        }
        return buf.toString();
    }

    @Override
    public String getProtocolStackString() {
        return this.getProtocolStackString(false);
    }

    @Override
    public ProtocolData[] getProtocolStack() {
        return this.mProtocolStack.toArray(new ProtocolData[this.mProtocolStack.size()]);
    }

    public String getName() {
        return this.mStackName;
    }

    public void override(ProtocolData data) throws IOException {
        int index2 = this.mProtocolStack.indexOf(data);
        if (index2 < 0) {
            throw new IOException("You can not override a protocol that doesn't exist");
        }
        ProtocolData source = (ProtocolData)this.mProtocolStack.get(index2);
        source.override(data.getParametersAsArray());
    }

    public void add(ProtocolData data) {
        this.mProtocolStack.add(data);
    }

    protected static XmlConfigurator parseOldFormat(InputStream stream) throws IOException {
        XmlConfigurator configurator = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClassPathEntityResolver());
            Document document = builder.parse(stream);
            Element root = (Element)document.getElementsByTagName("protocol-stack").item(0);
            root.normalize();
            String stackname = root.getAttribute(ATTR_NAME);
            String inherit = root.getAttribute(ATTR_INHERIT);
            boolean isinherited = inherit != null && inherit.length() > 0;
            NodeList protocol_list = document.getElementsByTagName(isinherited ? ELMT_PROT_OVERRIDE : ELMT_PROT);
            Vector<ProtocolData> v = new Vector<ProtocolData>();
            for (int i = 0; i < protocol_list.getLength(); ++i) {
                if (protocol_list.item(i).getNodeType() != 1) continue;
                v.addElement(XmlConfigurator.parseProtocolData(protocol_list.item(i)));
            }
            Object[] protocols = new ProtocolData[v.size()];
            v.copyInto(protocols);
            if (isinherited) {
                URL inheritURL = new URL(inherit);
                configurator = XmlConfigurator.getInstance(inheritURL);
                for (int i = 0; i < protocols.length; ++i) {
                    configurator.override((ProtocolData)protocols[i]);
                }
            } else {
                configurator = new XmlConfigurator(stackname, (ProtocolData[])protocols);
            }
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
        return configurator;
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClassPathEntityResolver());
            Document document = builder.parse(stream);
            Element configElement = document.getDocumentElement();
            return XmlConfigurator.parse(configElement);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }

    protected static XmlConfigurator parse(Element root_element) throws IOException {
        XmlConfigurator configurator = null;
        LinkedList<ProtocolData> prot_data = new LinkedList<ProtocolData>();
        try {
            Element root = root_element;
            String root_name = root.getNodeName();
            if (!"config".equals(root_name.trim().toLowerCase())) {
                log.fatal("XML protocol stack configuration does not start with a '<config>' element; maybe the XML configuration needs to be converted to the new format ?\nuse 'java org.jgroups.conf.XmlConfigurator <old XML file> -new_format' to do so");
                throw new IOException("invalid XML configuration");
            }
            NodeList prots = root.getChildNodes();
            for (int i = 0; i < prots.getLength(); ++i) {
                Node node = prots.item(i);
                if (node.getNodeType() != 1) continue;
                Element tag = (Element)node;
                String protocol = tag.getTagName();
                LinkedList<ProtocolParameter> tmp = new LinkedList<ProtocolParameter>();
                NamedNodeMap attrs = tag.getAttributes();
                int attrLength = attrs.getLength();
                for (int a = 0; a < attrLength; ++a) {
                    Attr attr = (Attr)attrs.item(a);
                    String name = attr.getName();
                    String value2 = attr.getValue();
                    tmp.add(new ProtocolParameter(name, value2));
                }
                ProtocolParameter[] params = new ProtocolParameter[tmp.size()];
                for (int j = 0; j < tmp.size(); ++j) {
                    params[j] = (ProtocolParameter)tmp.get(j);
                }
                ProtocolData data = new ProtocolData(protocol, "bla", "" + protocol, params);
                prot_data.add(data);
            }
            ProtocolData[] data = new ProtocolData[prot_data.size()];
            for (int k = 0; k < prot_data.size(); ++k) {
                data[k] = (ProtocolData)prot_data.get(k);
            }
            configurator = new XmlConfigurator("bla", data);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
        return configurator;
    }

    protected static ProtocolData parseProtocolData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            boolean isOverride = ELMT_PROT_OVERRIDE.equals(protocol.getNodeName());
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String name = null;
            String clazzname = null;
            String desc = null;
            ProtocolParameter[] plist = null;
            block8: for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                if (isOverride && ++pos == 2) {
                    pos = 4;
                }
                switch (pos) {
                    case 1: {
                        name = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 2: {
                        desc = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 3: {
                        clazzname = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 4: {
                        plist = XmlConfigurator.parseProtocolParameters((Element)children.item(i));
                    }
                }
            }
            if (isOverride) {
                return new ProtocolData(name, plist);
            }
            return new ProtocolData(name, desc, clazzname, plist);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }

    protected static ProtocolParameter[] parseProtocolParameters(Element protparams) throws IOException {
        try {
            Vector<ProtocolParameter> v = new Vector<ProtocolParameter>();
            protparams.normalize();
            NodeList parameters = protparams.getChildNodes();
            for (int i = 0; i < parameters.getLength(); ++i) {
                if (parameters.item(i).getNodeType() != 1) continue;
                String pname = parameters.item(i).getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                String pvalue = parameters.item(i).getAttributes().getNamedItem(ATTR_VALUE).getNodeValue();
                ProtocolParameter p = new ProtocolParameter(pname, pvalue);
                v.addElement(p);
            }
            Object[] result = new ProtocolParameter[v.size()];
            v.copyInto(result);
            return result;
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }

    public static void main(String[] args) throws Exception {
        String input_file = null;
        String output = null;
        boolean new_format = false;
        if (args.length == 0) {
            XmlConfigurator.help();
            return;
        }
        input_file = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (!"-new_format".equals(args[i])) {
                XmlConfigurator.help();
                return;
            }
            new_format = true;
        }
        if (input_file != null) {
            InputStream input = null;
            try {
                input = new FileInputStream(new File(input_file));
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
            if (input == null) {
                try {
                    input = new URL(input_file).openStream();
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                }
            }
            XmlConfigurator conf = XmlConfigurator.getInstanceOldFormat(input);
            output = conf.getProtocolStackString(new_format);
            output = XmlConfigurator.replace(output, "org.jgroups.protocols.", "");
            if (new_format) {
                System.out.println(XmlConfigurator.getTitle(input_file));
            }
            System.out.println('\n' + output);
        } else {
            log.error(JGroupsStrings.XmlConfigurator_NO_INPUT_FILE_GIVEN);
        }
    }

    private static String getTitle(String input) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n<!-- ************ JGroups Protocol Stack Configuration ************** -->\n");
        sb.append("<!-- generated by XmlConfigurator on " + new Date() + " -->\n");
        sb.append("<!-- input file: " + input + " -->");
        return sb.toString();
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuffer sb = new StringBuffer();
        int new_index = 0;
        int index2 = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index2)) == -1) break;
            sb.append(input.substring(index2, new_index));
            sb.append(replacement);
            index2 = new_index + len;
        }
        sb.append(input.substring(index2, input_len));
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator <input XML file> [-new_format]");
        System.out.println("(-new_format: converts old XML format into new format)");
    }
}

