/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.conf;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.conf.PlainConfigurator;
import com.gemstone.org.jgroups.conf.ProtocolStackConfigurator;
import com.gemstone.org.jgroups.conf.XmlConfigurator;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Properties;
import org.w3c.dom.Element;

public class ConfiguratorFactory {
    public static final String JAXP_MISSING_ERROR_MSG = "JAXP Error: the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.";
    static final String FORCE_CONFIGURATION = "force.properties";
    static final GemFireTracer log = GemFireTracer.getLog(ConfiguratorFactory.class);
    static String propertiesOverride = null;

    protected ConfiguratorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtocolStackConfigurator getStackConfigurator(File file) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(file);
            ConfiguratorFactory.checkJAXPAvailability();
            try (FileInputStream fis = new FileInputStream(file);){
                returnValue = XmlConfigurator.getInstance(fis);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(URL url) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(url);
            ConfiguratorFactory.checkJAXPAvailability();
            try {
                returnValue = XmlConfigurator.getInstance(url);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(Element element) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(element);
            try {
                returnValue = XmlConfigurator.getInstance(element);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(String properties) throws ChannelException {
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
        }
        ConfiguratorFactory.checkForNullConfiguration(properties);
        XmlConfigurator configurator = null;
        try {
            configurator = ConfiguratorFactory.getXmlConfigurator(properties);
        }
        catch (IOException ioe) {
            throw ConfiguratorFactory.createChannelConfigurationException(ioe);
        }
        ProtocolStackConfigurator returnValue = configurator != null ? configurator : new PlainConfigurator(properties);
        return returnValue;
    }

    @Deprecated
    public static ProtocolStackConfigurator getStackConfigurator(Object properties) throws IOException {
        InputStream input = null;
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
        }
        if (input == null && properties instanceof String) {
            try {
                input = new URL((String)properties).openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (input == null && ((String)properties).endsWith("xml")) {
                try {
                    input = Util.getResourceAsStream((String)properties, ConfiguratorFactory.class);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ignore) {
                    SystemFailure.checkFailure();
                }
            }
            if (input == null) {
                try {
                    input = new FileInputStream((String)properties);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                }
            }
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
        }
        if (input != null) {
            return XmlConfigurator.getInstance(input);
        }
        if (properties instanceof Element) {
            return XmlConfigurator.getInstance((Element)properties);
        }
        return new PlainConfigurator((String)properties);
    }

    static InputStream getConfigStream(String properties) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new URL(properties).openStream();
        }
        catch (MalformedURLException mre) {
            // empty catch block
        }
        if (configStream == null && properties.endsWith("xml")) {
            configStream = Util.getResourceAsStream(properties, ConfiguratorFactory.class);
        }
        if (configStream == null) {
            try {
                configStream = new FileInputStream(properties);
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return configStream;
    }

    static XmlConfigurator getXmlConfigurator(String properties) throws IOException {
        XmlConfigurator returnValue = null;
        InputStream configStream = ConfiguratorFactory.getConfigStream(properties);
        if (configStream != null) {
            ConfiguratorFactory.checkJAXPAvailability();
            returnValue = XmlConfigurator.getInstance(configStream);
        }
        return returnValue;
    }

    static ChannelException createChannelConfigurationException(Throwable cause) {
        return new ChannelException("unable to load the protocol stack", cause);
    }

    static void checkForNullConfiguration(Object properties) {
        if (properties == null) {
            String msg = "the specifed protocol stack configuration was null.";
            throw new NullPointerException("the specifed protocol stack configuration was null.");
        }
    }

    static void checkJAXPAvailability() {
        try {
            XmlConfigurator.class.getName();
        }
        catch (NoClassDefFoundError error) {
            throw new NoClassDefFoundError(JAXP_MISSING_ERROR_MSG);
        }
    }

    static {
        try {
            Properties properties = System.getProperties();
            propertiesOverride = properties.getProperty(FORCE_CONFIGURATION);
        }
        catch (SecurityException e) {
            propertiesOverride = null;
        }
        if (propertiesOverride != null && log.isInfoEnabled()) {
            log.info(JGroupsStrings.ConfiguratorFactory_USING_PROPERTIES_OVERRIDE__0, propertiesOverride);
        }
    }
}

